import tkinter as tk  # GUI toolkit
from tkinter import messagebox
import config  # The config.py file

class Application (tk.Frame):
    def __init__ (self, master = None):  # Constructor
        tk.Frame.__init__ (self, master)
        self.grid (sticky = tk.N + tk.S + tk.W + tk.E)
        # I'm leaving this here in case I want to draw a background image in the future.
        #self.imgBackground = tk.PhotoImage (file = config.defaultimage0)
        #self.lblBackground = tk.Label (self, image = self.imgBackground)
        #self.lblBackground.place (x = 0, y = 0, relwidth = 1, relheight = 1)
        self.createwidgets()  # Self-explanatory
        self.refreshlist (None)  # Fetch the list of games from the default group as defined in config.py
        self.txtDescription ["state"] = tk.NORMAL
        self.txtDescription.delete ("1.0", tk.END)
        self.txtDescription.insert ("1.0", config.defaultdescription)
        self.txtDescription ["state"] = tk.DISABLED

    def createwidgets (self):
        top = self.winfo_toplevel()
        top.rowconfigure (0, weight = 1)
        top.columnconfigure (0, weight = 1)
        self.rowconfigure (0, weight = 1)
        self.columnconfigure (0, weight = 1)

        self.yScrollList = tk.Scrollbar (self, orient = tk.VERTICAL)  # This is the Scrollbar, which will be used for the game list.
        self.yScrollList.grid (row = 0, column = 5, rowspan = 4, sticky = tk.N + tk.S)  # Setting "sticky" to two opposite directions (N and S in this case) stretches the widget across that axis.  Where not stretched, widgets conform in size to the amount of space they need.
        self.yScrollDesc = tk.Scrollbar (self, orient = tk.VERTICAL)  # Another Scrollbar, which will be used for the description window.
        self.yScrollDesc.grid (row = 1, column = 3, rowspan = 3, sticky = tk.N + tk.S)
        #print ("self.yScrollList: " + self.yScrollList.get())
        #print ("self.yScrollDesc: " + self.yScrollDesc.get())

        # First, we create variable objects.
        self.varGame = tk.StringVar()  # This is a String variable object.  Variables in Python are created implicitly (you do not define or "dimension" them ahead of time).
        self.varGroupName = tk.StringVar()  # Another String variable object, representing the name of the game group
        self.varGroupName.set (config.GroupList ["name"] [config.defaultgroup])  # Which one is the default?
        self.varGroupIndex = tk.IntVar()  # This is an Integer variable object.  It will be used to represent the number of the game group throughout the application.
        # Second, we create the desired widget which is bound to a created variable object.
        self.optGroup = tk.OptionMenu (self, self.varGroupName, *config.GroupList ["name"], command = self.refreshlist)  # Here is our first widget, an OptionMenu, which will display the list of game groups when clicked.
        self.optGroup.config (font = config.font, bg = config.colormenusbg, fg = config.colormenusfg, width = 16)  # Unlike the other widgets, the OptionMenu's style has to be set using the config method, not during instantiation.
        self.optGroup ["menu"].config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)  # This is for the drop-down menu that appears when you click on the widget.
        self.optGroup.grid (row = 3, column = 6, sticky = tk.W + tk.E)  # One of three methods can be used to see the widget we just created.  I'm using the .grid method.

        self.varBasefilename = tk.StringVar()  # Used to fetch all the other relevant files with the same base filename as the ROM image of the selected game
        self.cboGame = tk.Listbox (self, font = config.font, bg = config.colormenusbg, fg = config.colormenusfg, width = config.listwidth, yscrollcommand = self.yScrollList.set, listvariable = self.varGame)  # After creating our variable object, we create the widget we want with all the parameters.
        self.cboGame.grid (row = 0, column = 4, rowspan = 5, sticky = tk.N + tk.S)
        self.yScrollList ["command"] = self.cboGame.yview  # Bind the Listbox widget to the one scrollbar we created.
        self.cboGame.bind ("<<ListboxSelect>>", self.getscreenshot)  # Action to take when a game is selected from the Listbox.  In this case, we call getscreenshot.

        self.imgScreenshot = tk.PhotoImage (file = config.defaultimage1)  # Next is the screenshot preview.  By default, it will display an image that contains text to select a game.
        self.lblScreenshot = tk.Label (self, image = self.imgScreenshot)  # To actually display the image, we have a Label widget set to show a picture instead of text.
        self.lblScreenshot.grid (row = 0, column = 1)

        self.lblPlayers = tk.Label (self, font = config.font, background = config.colormenusbg, foreground = config.colormenusfg, justify = tk.LEFT, borderwidth = 2, relief = "solid", width = 30, anchor = tk.N + tk.W)  # This label widget will display actual text.
        self.lblPlayers.grid (row = 0, column = 2, sticky = tk.N + tk.S + tk.W + tk.E)
        self.lblPlayers.bind ("<Configure>", lambda e: self.lblPlayers.config (wraplength = self.lblPlayers.winfo_width()))  # This line is needed to enable word-wrapping.

        self.txtDescription = tk.Text (self, font = config.font, background = config.colormenusbg, foreground = config.colormenusfg, height = 16, width = config.listwidth, wrap = tk.WORD, yscrollcommand = self.yScrollDesc.set, state = tk.DISABLED)
        self.txtDescription.grid (row = 1, column = 1, rowspan = 3, columnspan = 2, sticky = tk.N + tk.S + tk.W + tk.E)
        self.yScrollDesc ["command"] = self.txtDescription.yview

        # Notice these LabelFrame objects are widgets which can have subwidgets that conform to their own grids.
        self.frameGraphicsOptions = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Display Options", bg = config.colorpanelsbg)  # Setting labelanchor to N centers the label text across the top line of the frame.
        self.frameGraphicsOptions.grid (row = 1, column = 6, rowspan = 2)  # This frame will stretch across three rows so its height will be the combined height of the three frames to the right of it, once we generate them.

        self.frameSoundOptions = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Audio Options", bg = config.colorpanelsbg)
        self.frameSoundOptions.grid (row = 0, column = 6, sticky = tk.W + tk.E)

        self.frameCommands = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Commands", bg = config.colorpanelsbg)  # This frame will contain command buttons.
        self.frameCommands.grid (row = 3, column = 0)  # The height of this frame will match the screenshot preview area to the left of it.

        self.frameSystemOptions = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "System Options", bg = config.colorpanelsbg)
        self.frameSystemOptions.grid (row = 0, column = 0, sticky = tk.N + tk.E + tk.W)

        self.framePeripheralOptions = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Peripheral Options", bg = config.colorpanelsbg)
        self.framePeripheralOptions.grid (row = 1, column = 0, sticky = tk.W + tk.E)

        self.frameGeneralOptions = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Other Options", bg = config.colorpanelsbg)
        self.frameGeneralOptions.grid (row = 2, column = 0, sticky = tk.S + tk.W + tk.E)

        # Here are the first widgets inside one of the frames.  In this case, they're command buttons.
        self.cmdPlay = tk.Button (self.frameCommands, font = config.font, text = "Play", bg = config.colormenusbg, width = 8, disabledforeground = "black", fg = config.colormenusfg, state = tk.DISABLED, command = self.launchjzintv)  # The Play button.  It's initialized to be greyed-out (disabled) until the user selects a game.  Also note its parent (the first parameter) is the frameCommands widget.
        self.cmdPlay.grid (row = 0, column = 1, rowspan = 2, sticky = tk.N + tk.S)  # Because the Button has a different parent than "self", it has its own grid that it will snap in place to.

        self.cmdAbout = tk.Button (self.frameCommands, font = config.font, text = "About", bg = config.colormenusbg, width = 8, fg = config.colormenusfg, command = self.about)  # The About button.
        self.cmdAbout.grid (row = 0, column = 0)

        self.cmdQuit = tk.Button (self.frameCommands, font = config.font, text = "Quit", bg = config.colormenusbg, width = 8, fg = config.colormenusfg, command = self.cancel)  # The Quit button.
        self.cmdQuit.grid (row = 1, column = 0)

        # This block is for a pair of Checkbuttons whose parent is the framePeripheralOptions widget, so they will appear within that frame.
        # First, we create an object that is a variable.
        self.varIntellivoice = tk.IntVar()  # This is an Integer variable.  Its default value is 0.
        # Second, we create the desired widget which is bound to that variable.
        self.chkIntellivoice = tk.Checkbutton (self.framePeripheralOptions, font = config.font, text = "IntelliVoice", bg = config.colorpanelsbg, variable = self.varIntellivoice, offvalue = 0, onvalue = 1)  # This widget has two values: one when checked (onvalue) and one when unchecked (offvalue).
        self.chkIntellivoice.grid (row = 0, sticky = tk.W)  # The "sticky" value is set to W for left-justification.  Otherwise the Checkbuttons and their associated label would all be center-justified within the frame.
        #self.chkIntellivoice.deselect()  # Deselecting the checkbutton here will immediately set the variable's value to that of the offvalue property.

        self.varECS = tk.IntVar()
        self.chkECS = tk.Checkbutton (self.framePeripheralOptions, font = config.font, text = "ECS", bg = config.colorpanelsbg, variable = self.varECS, offvalue = 0, onvalue = 1)
        self.chkECS.grid (row = 1, sticky = tk.W)
        #self.chkECS.deselect()  # This and the other "deselect" line above are commented out now because 0 is the default value anyhow.

        self.varBorderSize = tk.IntVar()
        self.varBorderSize.set (config.defaultbordersize)
        self.validation = self.register (self.onlydigits)  # This code fires the onlydigits function.
        self.lblBorderSize = tk.Label (self.frameGraphicsOptions, font = config.font, text = "Border Size: ", bg = config.colorpanelsbg)  # Notice the space at the end of the label text.  That will provide just the right amount of horizontal "padding" we need.
        self.lblBorderSize.grid (row = 4, column = 0, columnspan = 4, pady = 10, sticky = tk.E + tk.S)  # The label's horizontal "sticky" property is set to E, and the Entry widget's horizontal "sticky" property will be set to W, so they'll be next to each other.  The pady property provides visual distance from the controls that will appear above it.
        # Next is an Entry widget, where the user can type something into a textbox.
        # 'validate = "key"' means that validation happens whenever there's a keystroke while this widget has the focus.
        # After that is the validatecommand option, which binds the onlydigits function.
        # "%P" is the text being inserted to the Entry widget.  The validation needs that to see if it's numeric.
        self.txtBorderSize = tk.Entry (self.frameGraphicsOptions, font = config.font, textvariable = self.varBorderSize, validate = "key", validatecommand = (self.validation, "%P"), width = 2)
        self.txtBorderSize.grid (row = 4, column = 4, columnspan = 2, pady = 10, sticky = tk.W + tk.S)  # There will be a total of 6 columns within the "Graphics Options" frame.

        # Here is our first group of Radiobuttons.  As you may know, radiobuttons are designed to appear in groups, exactly one of which within each group will be checked at all times.
        # Next, we create widgets and bind them to a certain variable object as before.
        self.varDisplayOption = tk.IntVar()
        self.varDisplayOption.set (config.defaultdisplayoption)
        self.chkDisplayOption0 = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "Pre-defined size:", bg = config.colorpanelsbg, variable = self.varDisplayOption, value = 0)  # There is only one value this time, the value when checked, analagous to the checkbutton's onvalue.
        self.chkDisplayOption0.grid (row = 0, column = 0, columnspan = 6, sticky = tk.W)
        self.chkDisplayOption1 = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "Custom size:", bg = config.colorpanelsbg, variable = self.varDisplayOption, value = 1)
        self.chkDisplayOption1.grid (row = 2, column = 0, columnspan = 6, sticky = tk.W)
        # Normally with a group of Radiobuttons all bound to a single variable, the default is the one whose value is 0 if an Integer variable, or an empty string if a String variable.
        # When the user clicks on a Radiobutton, the bound variable changes its value to that of the button clicked.
        # Then, all the Radiobuttons bound to that same variable will either become selected or unselected based on whether their value matches that of the bound variable or not.

        self.varDisplaySize = tk.IntVar()
        self.varDisplaySize.set (config.defaultwindowsize)  # We'll fetch the desired default value from our config file.
        self.varDisplaySizeName = tk.StringVar()
        self.varDisplaySizeName.set (config.DisplaySizeList [config.defaultwindowsize])
        self.optDisplaySize = tk.OptionMenu (self.frameGraphicsOptions, self.varDisplaySizeName, *config.DisplaySizeList, command = self.setdisplaysize)
        self.optDisplaySize.config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optDisplaySize ["menu"].config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optDisplaySize.grid (row = 1, column = 0, columnspan = 6)

        self.varDisplayResX = tk.IntVar()
        self.varDisplayResX.set (config.defaultwindowresx)
        self.lblDisplayResX = tk.Label (self.frameGraphicsOptions, font = config.font, text = "x", bg = config.colorpanelsbg)
        self.lblDisplayResX.grid (row = 3, column = 1, pady = 10, sticky = tk.S)
        self.txtDisplayResX = tk.Entry (self.frameGraphicsOptions, font = config.font, textvariable = self.varDisplayResX, validate = "key", validatecommand = (self.validation, "%P"), width = 4)
        self.txtDisplayResX.grid (row = 3, column = 0, pady = 10, sticky = tk.E + tk.S)
        self.varDisplayResY = tk.IntVar()
        self.varDisplayResY.set (config.defaultwindowresy)
        self.lblDisplayResY = tk.Label (self.frameGraphicsOptions, font = config.font, text = ", ", bg = config.colorpanelsbg)  # Notice the space at the end of the label text.
        self.lblDisplayResY.grid (row = 3, column = 3, pady = 10, sticky = tk.S)
        self.txtDisplayResY = tk.Entry (self.frameGraphicsOptions, font = config.font, textvariable = self.varDisplayResY, validate = "key", validatecommand = (self.validation, "%P"), width = 4)
        self.txtDisplayResY.grid (row = 3, column = 2, pady = 10, sticky = tk.S)

        # Now we have a Spinbox widget, which provides up/down arrows to set a numeric value.
        self.varDisplayBPP = tk.IntVar()
        self.varDisplayBPP.set (config.defaultwindowbitdepth)
        self.lblDisplayBPP = tk.Label (self.frameGraphicsOptions, font = config.font, text = "bpp", bg = config.colorpanelsbg)
        self.lblDisplayBPP.grid (row = 3, column = 5, pady = 10, sticky = tk.W + tk.S)
        self.txtDisplayBPP = tk.Spinbox (self.frameGraphicsOptions, font = config.font, from_= 8, to = 32, increment = 8, bd = 0, relief = tk.SOLID, width = 2, command = self.selectcustom)
        self.txtDisplayBPP.grid (row = 3, column = 4, pady = 10, sticky = tk.S)
        # To set the value of the Spinbox widget, we have to delete its existing value (it's a string) and insert what we want in its place.
        self.txtDisplayBPP.delete (0, "end")
        self.txtDisplayBPP.insert (0, str (config.defaultwindowbitdepth))

        self.varFullscreen = tk.IntVar()
        self.varFullscreen.set (config.defaultfullscreen)
        self.chkWindowed = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "Windowed", bg = config.colorpanelsbg, variable = self.varFullscreen, value = 0)
        self.chkWindowed.grid (row = 5, column = 0, columnspan = 4, sticky = tk.W)
        self.chkFullscreen = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "Full Screen", bg = config.colorpanelsbg, variable = self.varFullscreen, value = 1)
        self.chkFullscreen.grid (row = 6, column = 0, columnspan = 4, sticky = tk.W)

        self.varMode = tk.StringVar()  # Here is our first String variable.  Its default value is an empty string.
        self.varMode.set (config.defaultgraphicsmode)  # Again, we'll look to the config.py file to get the default we want.
        self.chkNTSC = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "NTSC", bg = config.colorpanelsbg, variable = self.varMode, value = " ")  # This Radiobutton's value ought to be an empty string ...
        self.chkNTSC.grid (row = 5, column = 4, columnspan = 2, sticky = tk.W)
        self.chkPAL = tk.Radiobutton (self.frameGraphicsOptions, font = config.font, text = "PAL", bg = config.colorpanelsbg, variable = self.varMode, value = "-P")  # ... but that would cause a cosmetic bug where this Radiobutton would display the wrong graphic when unchecked.
        self.chkPAL.grid (row = 6, column = 4, columnspan = 2, sticky = tk.W)

        self.varAudioRate = tk.IntVar()
        self.varAudioRate.set (config.defaultaudiorate)
        self.chkAudioNone = tk.Radiobutton (self.frameSoundOptions, font = config.font, text = "No sound", bg = config.colorpanelsbg, variable = self.varAudioRate, value = 0)  # Would be checked by default since its value is 0, but we have a "defaultaudiorate" in config.py.
        self.chkAudioNone.grid (row = 0, column = 0, sticky = tk.W)
        self.chkAudioLow = tk.Radiobutton (self.frameSoundOptions, font = config.font, text = "Better performance", bg = config.colorpanelsbg, variable = self.varAudioRate, value = 11025)
        self.chkAudioLow.grid (row = 1, column = 0, sticky = tk.W)
        self.chkAudioHigh = tk.Radiobutton (self.frameSoundOptions, font = config.font, text = "Better quality", bg = config.colorpanelsbg, variable = self.varAudioRate, value = 48000)
        self.chkAudioHigh.grid (row = 2, column = 0, sticky = tk.W)

        self.varExec = tk.StringVar()
        self.varExec.set (config.ExecList [config.defaultexec] [0])
        self.varExecIndex = tk.IntVar()
        self.varExecIndex.set (config.defaultexec)
        self.varExec.set (config.ExecList [self.varExecIndex.get()] [0])  # Name of the Executive ROM to be displayed by default
        self.lblExec = tk.Label (self.frameSystemOptions, font = config.font, text = "Executive ROM:", bg = config.colorpanelsbg)
        self.lblExec.grid (row = 0, sticky = tk.W)
        # We need to build this list before constructing the Exec OptionMenu.
        self.ExecNames = []  # Start with a blank list.
        for Exec in config.ExecList:  # Iterate through the ExecList in config.py.
            self.ExecNames.append (Exec [0])  # Fetch the name, the first element (index 0).
        self.optExec = tk.OptionMenu (self.frameSystemOptions, self.varExec, *self.ExecNames, command = self.setexec)
        self.optExec.config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optExec ["menu"].config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optExec.grid (row = 1, sticky = tk.W + tk.E)

        self.varGROM = tk.StringVar()
        self.varGROM.set (config.GROMList [config.defaultgrom] [0])
        self.varGROMIndex = tk.IntVar()
        self.varGROMIndex.set (config.defaultgrom)
        self.varGROM.set (config.GROMList [self.varGROMIndex.get()] [0])
        self.lblGROM = tk.Label (self.frameSystemOptions, font = config.font, text = "Graphics ROM:", bg = config.colorpanelsbg)
        self.lblGROM.grid (row = 2, sticky = tk.W)
        # Same as with the Exec OptionMenu, we need to build this list.
        self.GROMNames = []
        for GROM in config.GROMList:
            self.GROMNames.append (GROM [0])
        self.optGROM = tk.OptionMenu (self.frameSystemOptions, self.varGROM, *self.GROMNames, command = self.setgrom)
        self.optGROM.config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optGROM ["menu"].config (font = config.fontoptionmenu, bg = config.colormenusbg, fg = config.colormenusfg)
        self.optGROM.grid (row = 3, sticky = tk.W + tk.E)

        self.varGRAM = tk.IntVar()
        self.chkGRAM0 = tk.Radiobutton (self.frameGeneralOptions, font = config.font, text = "Normal GRAM", bg = config.colorpanelsbg, variable = self.varGRAM, value = 0)
        self.chkGRAM0.grid (row = 0, sticky = tk.W)
        self.chkGRAM1 = tk.Radiobutton (self.frameGeneralOptions, font = config.font, text = "Double GRAM", bg = config.colorpanelsbg, variable = self.varGRAM, value = 1, state = tk.DISABLED, command = lambda: self.gramwarning (None))  # The command property calls a procedure when this Radiobutton is checked.
        self.chkGRAM1.grid (row = 1, sticky = tk.W)
        self.chkGRAM2 = tk.Radiobutton (self.frameGeneralOptions, font = config.font, text = "Quadruple GRAM", bg = config.colorpanelsbg, variable = self.varGRAM, value = 2, state = tk.DISABLED, command = lambda: self.gramwarning (None))  # This procedure would throw an exception unless a game is selected first, which is why these two radiobuttons are disabled by defaul, same as with the Play button.
        self.chkGRAM2.grid (row = 2, sticky = tk.W)
        self.chkGRAM0.select()  # The first Radiobutton is the one we want selected by default.

        self.varPalette = tk.StringVar()
        self.varPalette.set (config.defaultpalette)
        self.chkPalette = tk.Checkbutton (self.frameGeneralOptions, font = config.font, text = "Custom palette", bg = config.colorpanelsbg, variable = self.varPalette, offvalue = "", onvalue = "--gfx-palette=\"" + config.workingpath + "intycolors.cfg\"")
        self.chkPalette.grid (row = 3, column = 0, pady = 10, sticky = tk.W + tk.S)

    # Validation for the Entry box.  We want only numeric characters.
    def onlydigits (self, inp):
        if inp == "":
            return True
        return inp.isdigit()

    # This code fires when the user selects a different game group from the group list.
    def refreshlist (self, event):
        self.cboGame.selection_clear (0, tk.END)  # Clear any existing game selection.
        self.cmdPlay.config (state = tk.DISABLED)  # "Grey-out" the Play button again.
        self.chkGRAM0.select()  # Set GRAM to default.
        self.chkGRAM1.config (state = tk.DISABLED)  # "Grey-out" the "extra GRAM" radiobuttons as well.
        self.chkGRAM2.config (state = tk.DISABLED)
        self.imgScreenshot.config (file = config.defaultimage1)  # Revert to the initial dummy screenshot image.
        self.lblPlayers.config (background = config.colormenusbg, text = "")
        self.txtDescription ["state"] = tk.NORMAL
        self.txtDescription.delete ("1.0", tk.END)
        self.txtDescription.insert ("1.0", config.defaultdescription)
        self.txtDescription ["state"] = tk.DISABLED
        for index, string in enumerate (config.GroupList ["name"]):  # Find the group in the list.
            if (self.varGroupName.get() == string):
                self.varGroupIndex.set (index)  # Capture the index since we will refer to it quite a few times.
                self.lblPlayers.config (background = config.GroupList ["colorflash"] [index], foreground = config.GroupList ["foreground"] [index])
                self.txtDescription ["state"] = tk.NORMAL
                self.txtDescription.delete ("1.0", tk.END)
                self.txtDescription.insert ("1.0", config.GroupList ["description"] [index])
                self.txtDescription ["state"] = tk.DISABLED
                self.GameNames = []  # Clear the game list.
                for Game in config.GameList [index]:  # Iterate through the appropriate group in the GameList in config.py.
                    self.GameNames.append (Game ["name"])  # Fetch the name of each game.
        self.varGame.set (self.GameNames)

    # This code fires when the user selects one of the Pre-Defined display sizes from the drop-down menu.
    def setdisplaysize (self, event):
        for index, string in enumerate (config.DisplaySizeList):
            if (self.varDisplaySizeName.get() == string):
                self.varDisplaySize.set (index)
        self.chkDisplayOption0.select()  # Automatically check the "Pre-Defined" radiobutton.

    # This code fires when the user selects a different Executive ROM from the drop-down menu.
    def setexec (self, event):
        for index, string in enumerate (config.ExecList):
            if (self.varExec.get() == string [0]):
                self.varExecIndex.set (index)
                self.chkECS.config (state = tk.NORMAL)
                if self.varExecIndex.get() == 3:  # Tutorvision Exec?
                    self.chkECS.deselect()
                    self.chkECS.config (state = tk.DISABLED)  # Can't use ECS with Tutorvision

    # This code fires when the user selects a different Graphics ROM from the drop-down menu.
    def setgrom (self, event):
        for index, string in enumerate (config.GROMList):
            if (self.varGROM.get() == string [0]):
                self.varGROMIndex.set (index)

    # This code fires when the user changes any of the Custom graphics options.
    def selectcustom (self):
        self.chkDisplayOption1.select()  # Automatically check the "Custom" radiobutton.

    # This code fires when the user selects a game from the game list.
    def getscreenshot (self, event):
        self.cmdPlay.config (state = tk.NORMAL)  # The Play button can now be enabled since a game is selected.
        self.chkGRAM1.config (state = tk.NORMAL)  # Same goes for the "extra GRAM" radiobuttons.
        self.chkGRAM2.config (state = tk.NORMAL)
        try:
            self.lblPlayers.config (text = "Number of players:\n" + config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["players"])  # Change the label text.
            self.txtDescription ["state"] = tk.NORMAL
            self.txtDescription.delete ("1.0", tk.END)
            self.txtDescription.insert ("1.0", config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["description"])
            self.txtDescription ["state"] = tk.DISABLED
            self.varBasefilename.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["filename"])
            self.varBasefilename.set (self.varBasefilename.get() [: self.varBasefilename.get().rfind (".") - len (self.varBasefilename.get())])  # Strip the filename extension.  I'm using rfind in case there's another period within the filename.
            self.varECS.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["ecs"])  # Do we want ECS?
            self.varIntellivoice.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["intellivoice"])  # Do we want IntelliVoice?
            self.varGRAM.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["gram"])  # How much GRAM do we want?
        except:
            self.cmdPlay.config (state = tk.DISABLED)
            self.chkGRAM0.select()
            self.chkGRAM1.config (state = tk.DISABLED)
            self.chkGRAM2.config (state = tk.DISABLED)
            self.txtDescription ["state"] = tk.NORMAL
            self.txtDescription.delete ("1.0", tk.END)
            self.txtDescription.insert ("1.0", config.defaultdescription)
            self.txtDescription ["state"] = tk.DISABLED
            print ("Wake up!")  # There have been instances where the game selection gets cleared after a period of inactivity.  That's why I added an exception handler here.
            #tk.messagebox.showerror ("Wake up!", "Selection lost.")
        try:
            self.imgScreenshot.config (file = config.screenshotpath + self.varBasefilename.get() + ".gif")  # If the screenshot file exists for this game, change to that image.
        except:
            self.imgScreenshot.config (file = config.defaultimage2)  # If not, change to a default image with text that's a little friendlier than "file not found."  Yes, there has to be an exception handler wrapped around this.
        self.chkECS.config (state = tk.NORMAL)  # Re-enable in case it was previously disabled because Tutorvision.
        if self.varGRAM.get() == 1:  # Double Graphics RAM, for modified Intellivision II units
            self.varExecIndex.set (2)  # Change the Executive ROM to Intellivision II.
            self.varExec.set (config.ExecList [2] [0])
            self.varGROMIndex.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["grom"])  # Change the Graphics ROM.
            self.varGROM.set (config.GROMList [self.varGROMIndex.get()] [0])
        elif self.varGRAM.get() == 2:  # Quadruple Graphics RAM, for World Book Tutorvision
            self.varGROMIndex.set (1)  # Change the Graphics ROM to INTV88.
            self.varGROM.set (config.GROMList [1] [0])
            if not self.varECS.get():  # Additional check for ECS and GRAM at the same time for "Tutor Pro" simulation for Chippi
                self.varExecIndex.set (3)  # Change the Executive ROM to World Book Tutorvision.
                self.varExec.set (config.ExecList [3] [0])
                self.chkECS.deselect()
                self.chkECS.config (state = tk.DISABLED)  # Can't use ECS with Tutorvision
        else:
            self.varExecIndex.set (0)  # Change the Executive ROM to Master Component (original Intellivision).
            self.varExec.set (config.ExecList [0] [0])
            self.varGROMIndex.set (config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["grom"])  # Change the Graphics ROM.
            self.varGROM.set (config.GROMList [self.varGROMIndex.get()] [0])
        if self.varGROMIndex.get():  # INTV88 Graphics ROM?
            self.varGROM.set (config.GROMList [1] [0])

    # This code fires when the user selects one of the additional GRAM Radiobuttons.
    def gramwarning (self, event):
        try:  #  I created another exception handler here due to a bug I found on 2021 May 18.  There's no need to disable it though.
            if self.varGRAM.get() > config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["gram"]:  # Does the user want more GRAM than the game supports, per the fifth element in the GameList?
                if not tk.messagebox.askyesno ("Advisory", "Games not made for additional Graphics RAM may have graphical issues.\n\nAre you sure you want to do this?"):  # Pop up a warning message with yes/no buttons.
                    self.chkGRAM0.select()  # Revert to no expanded GRAM if the user selected No.
        except:  # The bug had to do with trying to change the GRAM settings with no game selected.  Proactively selecting the default GRAM and disabling the other radiobuttons is the ideal thing to do.
            tk.messagebox.showerror ("Error", "Select a game before tweaking the GRAM settings.")

    # This code fires when the user clicks the Play button.
    def launchjzintv (self):
        # Write to the temporary batch file.
        file.writelines (["\"" + config.jzintvpath + "jzintv\""
            #["\"" + config.jzintvpath + "jzintv\"" if self.varFullscreen.get() else "\"" + config.jzintvpath + "overlay.py\" | \"" + config.jzintvpath + "jzintv\" --gui-mode",  # Use the Overlay if not in fullscreen.
                         " \"" + config.rompath + config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["filename"] + "\"",  # The ROM image file, encapsulated in quotes.
                         " " + config.globaloptions,  # The global options will come first, so anything game-specific can override them.
                         " " + self.varPalette.get(),  # Default or custom palette?  Note the .get method to fetch the value from the variable objects.
                         " " + self.varMode.get(),  # NTSC or PAL?  It's okay if we end up with an extra space in the case of NTSC.
                         " -s" + str (self.varECS.get()),  # ECS or no?  Starting here, we need to convert numeric values to strings.
                         " -v" + str (self.varIntellivoice.get()),  # IntelliVoice or no?
                         " -G" + str (self.varGRAM.get()),  # The usual amount of GRAM or more for future releases?
                         " --displaysize=" + str (self.varDisplayResX.get()) + "x" + str (self.varDisplayResY.get()) + "," + str (self.varDisplayBPP.get()) if self.varDisplayOption.get() else " -z" + str(self.varDisplaySize.get()),  # Display size and bit depth
                         " -b" + str (self.varBorderSize.get()),  # Border size
                         " -f" + str (self.varFullscreen.get()),  # Fullscreen or windowed?
                         " -a" + str (self.varAudioRate.get()),  # Audio sampling rate
                         " -e " + config.systemrompath + config.ExecList [self.varExecIndex.get()] [1],  # Pointer to selected Executive ROM
                         " -g " + config.systemrompath + config.GROMList [self.varGROMIndex.get()] [1],  # Pointer to selected Graphics ROM
                         " -E " + config.systemrompath + config.ecsrom if self.varECS.get() else "",  # Pointer to ECS ROM image (if applicable)
                         " " + config.GameList [self.varGroupIndex.get()] [self.cboGame.curselection() [0]] ["params"],  # Game-specific parameters
                         "\n"])
        file.write ("play.bat\n")  # Re-launch this application.
        file.close()
        self.quit()  # Because the last line of the temporary batch file re-runs the original batch file to launch this application, we'll close this for now to start the temp script's execution.

    # This code firse when the user clicks the About button.
    def about (self):
        tk.messagebox.showinfo ("About PIDEjL", "PIDEjL - Portable Intellivision Development Environment jzIntv Launcher (Windows port)\n\nWritten by Michael Hayes\n\nDate Of Last Modification:\nApril 20, 2025")

    # This code fires when the user clicks the Quit button.
    def cancel (self):
        file.close()  # When the program is first run, it opens the temporary script file and writes the "hashbang".  That is all the file contains at this point, so nothing else will be executed, ...
        self.quit()  # ... including re-launching this application, as with the Play button.

app = Application()  # Instantiate the Application.
app.master.title ("Portable Intellivision Development Environment jzIntv Launcher")
app.master.geometry (config.geometry)  # Put the window wherever you want it.
app.master.iconphoto (True, tk.PhotoImage (file = config.workingpath + "blueeye.png"))
app.configure (bg = config.colorpanelsbg)  # Color the portions of the window not covered by widgets.
file = open (config.workingpath + "temp.bat", "w")  # Open the temporary batch file we will be using, write-only, replace existing contents.
file.write (config.hashbang + "\n")  # Write the hashbang to the temp batch file.  If the user clicks on the "Quit" button, nothing will happen after this program quits.
app.mainloop()  # Listen for events.  Let the fun begin!

# EOF
