import tkinter as tk  # GUI toolkit
import config  # config.py

class Application (tk.Frame):
    def __init__ (self, master = None):  # Constructor
        tk.Frame.__init__ (self, master)
        self.grid (sticky = tk.N + tk.S + tk.W + tk.E)
        # I'm leaving this here in case I want to draw a background image in the future.
        #self.imgBackground = tk.PhotoImage (file = config.defaultimage0)
        #self.lblBackground = tk.Label (self, image = self.imgBackground)
        #self.lblBackground.place (x = 0, y = 0, relwidth = 1, relheight = 1)
        self.createwidgets()  # Self-explanatory

    def createwidgets (self):
        top = self.winfo_toplevel()
        top.rowconfigure (0, weight = 1)
        top.columnconfigure (0, weight = 1)
        self.rowconfigure (0, weight = 1)
        self.columnconfigure (0, weight = 1)

        self.frameCommands = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Commands", bg = config.colorpanelsbg)  # This frame will contain command buttons.
        self.frameCommands.grid()
        self.btnPause = tk.Button (self.frameCommands, font = config.font, text = "Pause", bg = config.colormenusbg, width = 5, fg = config.colormenusfg, command = self.p)  # The Pause button.
        self.btnPause.grid (row = 0, column = 0)
        self.btnQuit = tk.Button (self.frameCommands, font = config.font, text = "Quit", bg = config.colormenusbg, width = 5, fg = config.colormenusfg, command = self.q)  # The Quit button.
        self.btnQuit.grid (row = 0, column = 1)
        self.btnReset = tk.Button (self.frameCommands, font = config.font, text = "Reset", bg = config.colormenusbg, width = 5, fg = config.colormenusfg, command = self.r)  # The Reset button.
        self.btnReset.grid (row = 0, column = 2)

    # This code fires when the user clicks the Pause button.
    def p (self):
        print ("p")

    # This code fires when the user clicks the Quit button.
    def q (self):
        print ("q")
        self.quit()

    # This code fires when the user clicks the Reset button.
    def r (self):
        print ("r")

app = Application()  # Instantiate the Application.
app.master.title ("jzIntv Overlay")
#app.master.geometry ("+0-0")  # Bottom left corner
app.master.iconphoto (True, tk.PhotoImage (file = config.workingpath + "blueeye.png"))
app.configure (bg = config.colorpanelsbg)
app.mainloop()

# EOF
