# This is what is added at the beginning of temp.bat every time.  The term "hashbang" is a holdover from the original PIDE port.
hashbang = "@echo off"

# Be sure to leave an extra pair of backslashes at the end of the paths.  You should be running "play.bat" from the workingpath.
workingpath = "C:\\pidejl\\"
screenshotpath = workingpath + "Screenshots\\"
boxpath = workingpath + "Boxes\\"
overlaypath = workingpath + "Overlays\\"
jzintvpath = workingpath
rompath = jzintvpath + "Games\\"
systemrompath = jzintvpath
# New in May 2024 - path to Chippi files
chippipath = workingpath + "Extras\\Chippi\\"

# Cosmetic settings
geometry = "+0+0"  # Window will appear in the top left corner.
font = ("Calibri", "18")
fontframeheader = ("Calibri", "16", "bold")
fontoptionmenu = ("Calibri Light", "14", "bold")
defaultimage1 = workingpath + "welcome.png"
defaultimage2 = workingpath + "notfound.png"
colorpanelsbg = "DarkGoldenrod1"
colormenusbg = "#201114"
colormenusfg = "white smoke"
listwidth = 44

# The choices for the following option are 0 for "Pre-Defined" and 1 for "Custom".
defaultdisplayoption = 1
# Leave the DisplaySizeList alone.  Changing it only affects what is displayed in the drop-down menu.  These display options are built in to jzIntv.
DisplaySizeList = ("320x200,8bpp", "640x480,8bpp", "320x240,16bpp", "1024x768,8bpp", "1680x1050,8bpp", "800x400,16bpp", "1600x1200,32bpp", "3280x1200,32bpp")
# The range of window size options is 0-7.  They pertain to the DisplaySizeList above.  Run "jzintv --help | more" for more information.
defaultwindowsize = 6
# The default window resolution and bit depth if the Custom display option is selected.
defaultwindowresx = 800
defaultwindowresy = 600
# The choices for bit depth are: 8, 16, 24, 32.
defaultwindowbitdepth = 24
# Set the border size to this many Intellivision pixels.
defaultbordersize = 6
# 0 if disabled, 1 if enabled.
defaultfullscreen = 0
# " " for NTSC, "-P" for PAL.
defaultgraphicsmode = " "
# 0 for no sound, 11025 for lower-quality audio, 48000 for high-quality audio.
defaultaudiorate = 48000
# " " for default jzIntv palette, "--gfx-palette=\"" + workingpath + "intycolors.cfg\"" for custom palette.
defaultpalette = "--gfx-palette=\"" + workingpath + "intycolors.cfg\""

# Executive ROM and Graphics ROM defaults.  First, there are menu lists.
ExecList = (("Master Component", "exec.bin"), ("Sears Super Video Arcade", "searsexc.bin"), ("Intellivision II", "exec2.bin"), ("World Book Tutorvision", "wbexec.bin"))
GROMList = (("Mattel Electronics", "grom.bin"), ("INTV88", "gromintv.bin"))
# These are the indexes for the menus above.
defaultexec = 0
defaultgrom = 0
ecsrom = "ecs.bin"

# Defaults for all other jzintv parameters.  They can be overriden by parameters in the GameList below.
globaloptions = "-q --kbdhackfile=\"" + workingpath + "hackfile.cfg\" --script=\"" + workingpath + "dbscript.txt\" --debugger"

# Now for the fun part!  Tweak this as appropriate.  Each game in the list contains eight elements:
# 1. The name of the game as it will appear in the list
# 2. Text for the "number of players" window
# 3. Description
# 4. Filename of the ROM image
# 5. 0 if this game does not use ECS, 1 if it does.
# 6. 0 if this game does not use IntelliVoice, 1 if it does.
# 7. 0 if this game should use the standard Intellivision GROM (system font), 1 for the late-release INTV GROM.
# 8. 0 for standard GRAM (all original games), 1 for any indie games that support double GRAM (from modified Intellivision II units), 2 for any indie games that support quadruple GRAM (found in the World Book Tutorvision).
# 9. Any game-specific parameters you want to add.  These will override the global options above.  Look to Vectron for an example.
#    For Vectron, I replaced the standard keyboard hack file with one that allows for the "half-wind" directions on the disc.
GameList = (
    (
        {
            # Group 0, "-1980 Gaming Network"
            "name" : "Horse Racing",
            "players" : "1-6 players place bets.\n" +
                "Up to 2 players can jockey.",
            "description" : "You and up to five friends each have $750.  Pay attention to the weather and get to know the ponies.  If you're feeling confident, place an Exacta Bet for a 15-to-1 payout.\n\n" +
                "This is the perfect kind of game to play on livestream for Chat participation.",
            "filename" : "Horse Racing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Las Vegas Poker & Blackjack",
            "players" : "1 or 2",
            "description" : "Start by choosing how much money to bring with you to Vegas.  Take in the sounds of the shuffling cards and clinking chips.  Play 5-Card Stud, 7-Card Stud, 5-Card Draw, and Blackjack against the shifty-eyed dealer.  Watch out - he might bluff when raising the ante.  Win big and don't go bankrupt.\n\n" +
                "This was the pack-in game for the original Intellivision.",
            "filename" : "Las Vegas Poker & Blackjack.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Las Vegas Roulette",
            "players" : "1 or 2",
            "description" : "Start by choosing how much money to bring with you to Vegas.  Take in the sounds of the roulette wheel and clinking chips.\n\n" +
                "This is a good game to play on livestream for Chat participation.",
            "filename" : "Las Vegas Roulette.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 1, "-1980 Sports Network" 
            "name" : "Auto Racing",
            "players" : "1 or 2\n" +
                "For 1-player, press Enter on the second controller after choosing your car.",
            "description" : "Pick from 5 racing courses and 5 race cars, each with various advantages and disadvantages.  If racing alone, complete 5 laps in the shortest possible time.  If racing with a friend, be the first to get 50 points by outpacing your opponent and by not crashing.\n\n" +
                "This is the more common ROM with Realistic Steering.  Use the west/east sides of the disc to steer left/right.",
            "filename" : "Auto Racing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Boxing",
            "players" : "2 only",
            "description" : "Pick from 6 different boxers, all different.  Can you go 15 rounds with your opponent?",
            "filename" : "Boxing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Major League Baseball",
            "players" : "2 only",
            "description" : "This game was so realistic-looking for its time that George Plimpton appeared in an ad with a side-by-side comparison to Atari Baseball.",
            "filename" : "Baseball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NASL Soccer",
            "players" : "2 only",
            "description" : "",
            "filename" : "Soccer.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NBA Basketball",
            "players" : "2 only",
            "description" : "3-on-3 full-court Basketball.  4 quarters plus possible overtime.\n\n" +
                "There are no 3-point shots in this game.  That's because the 3-point rule didn't exist at the time this game was developed.",
            "filename" : "Basketball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NFL Football",
            "players" : "2 only",
            "description" : "Two Playbooks were included with this game.  Each player uses a Playbook to discreetly enter a numeric sequence corresponding to the desired play.",
            "filename" : "Football.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NHL Hockey",
            "players" : "2 only",
            "description" : "3 periods of Hockey, with features like the Penalty Box.",
            "filename" : "Hockey.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "PBA Bowling",
            "players" : "1-4 players alternating",
            "description" : "Up to 4 people can play together.  Choose your ball weight, slickness of the lanes, and your dominant hand.  Score 200 points or above for a fanfare at the end.\n\n" +
                "There is also an optional game called Pick Up Spares, where you practice knocking down only a few pins in various arrangements such as the 7-10 Split.",
            "filename" : "Bowling.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "PGA Golf",
            "players" : "1-4 players alternating",
            "description" : "Play 9 holes.  Choose from 9 clubs.  Watch out for water hazards, sand traps, and the rough.\n\n" +
                "This game was compared side-by-side to Atari Golf in a commercial because of how realistic it looked.",
            "filename" : "Golf.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tennis",
            "players" : "2 only",
            "description" : "Full game, set, and match.  Realistic sounds for its time.  The audience watches the ball as it travels across the court.",
            "filename" : "Tennis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "U.S. Ski Team Skiing",
            "players" : "1-6 players alternating",
            "description" : "Up to 6 players compete for the fastest time in three heats.  Beautiful snowscape graphics and sounds.  Jump over moguls and turn sharply to avoid trees and not miss the gates.  Play a more casual downhill course and try the more difficult Slalom course when you're ready.",
            "filename" : "Skiing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 2, "-1980 Strategy Network"
            "name" : "ABPA Backgammon",
            "players" : "1 or 2",
            "description" : "ABPA stands for \"American Backgammon Players Association\".  Two computer difficulty levels.  You can see your pip count to know who's winning.",
            "filename" : "Backgammon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Checkers",
            "players" : "1 or 2",
            "description" : "Play against a friend or against one of two computer opponents.  The computer can even suggest a move for you if you need help.\n\n" +
                "There is a rare international version called Draughts.\n\n" +
                "Can you beat the computer?",
            "filename" : "Checkers.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 3, "-1980 Action Network"
            "name" : "Armor Battle",
            "players" : "2 only",
            "description" : "Very impressive visually when compared to Atari Combat.  There are over 240 randomly-selected screens, as advertised on the box.\n\n" +
                "Strategically switch between two tanks in each battlefield.  Quietly drop a mine and hope the opponent runs over it.  Try to avoid terrain that slows you down, such as rivers.",
            "filename" : "Armor Battle Fast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sea Battle",
            "players" : "2 only",
            "description" : "Assemble fleets and invade the opponent's harbor.  Opposing fleets engage in combat, switching to a zoomed-in battle screen.  Impressive sound effects and graphics for its time.\n\n" +
                "The higher complexity level of this game made it necessary for players to consult the instruction manual to understand the various ships.",
            "filename" : "Sea Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Battle",
            "players" : "1 only",
            "description" : "Dispatch three fleets of spaceships to protect your Mothership from five hostile alien forces.  When opposing fleets come into attack range, you can let the computer simulate the battle or manually engage in combat.\n\n" +
                "At the title screen, press:\n" +
                "3 for the easiest difficulty,\n" +
                "2 for the second difficulty,\n" +
                "1 for the third difficulty,\n" +
                "4 for the standard difficulty,\n" +
                "5 for the highest difficulty.\n\n" +
                "If the enemy ships look like Cylon Fighters, that's because they are.  Mattel Electronics had expected to tack the Battlestar Galactica name onto this game, which was available at system launch.",
            "filename" : "Space Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 4, "-1980 Learning Network"
            "name" : "The Electric Company Math Fun",
            "players" : "1 or 2\n" +
                "For 1-player, enter 0 for the second player's Number Of Problems.",
            "description" : "Gorillas confront other animals in the jungle.  Solve math problems to decide who moves out of the way.  Miss one and you're forced to take a detour in the river, which is infested with crocodiles and other dangerous animals.\n\n" +
                "Wide variety of difficulty levels for children of various grade levels.  Enjoy The Electric Company theme at the title.\n\n" +
                "There were two versions of this game.  One version has you enter digits from right to left, the other from left to right.",
            "filename" : "Math Fun.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Electric Company Word Fun",
            "players" : "2 only",
            "description" : "Three games in one.\n\n" +
                "Crosswords: Similar to Scrabble.  Spell words with your letters.  Best score after 20 rounds wins.\n\n" +
                "Word Hunt: Monkeys grab letters to spell words.  Spell 3 words within 3 minutes.  Longer words earn more points.  Best score after 3 rounds wins.\n\n" +
                "Word Rockets: Wagons grab vowels and fire them into the sky to spell words.  First to 50 points wins.",
            "filename" : "Word Fun.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 5, "1981 Strategy Network"
            "name" : "Reversi",
            "players" : "1 or 2",
            "description" : "The original tabletop game is also known as Othello.  Place tokens that entrap opposing tokens and flip them to your color.\n\n" +
                "Three computer difficulty levels.  Three choices of board size.",
            "filename" : "Reversi.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Utopia",
            "players" : "2 only, but that doesn't stop players from playing alone",
            "description" : "Each player governs an island that is inhabited by a thousand people at the onset.  The people look to you for food, housing, jobs, education, healthcare, and defense.  Your population steadily grows in size over time, so you must continually plan accordingly.  Deal with weather patterns, pirates, potential uprisings, and so on.  Cooperate or compete against the other player for a better approval rating.\n\n" +
                "This is a much-celebrated game on the Intellivision.  Players marvel at its tiny ROM size of 4K for all the features that are packed into it.",
            "filename" : "Utopia.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 6, "1981 Action Network"
            "name" : "SNAFU",
            "players" : "Games 4, 8, 12, and 16 are 2-player only.\n" +
                "The other games are up to 2 players.",
            "description" : "Two games in one.\n\n" +
                "In Games 4, 8, 12, and 16, two players control snakes which compete to cut each other down to size by biting their tails.\n\n" +
                "In the other Games, players control \"Tron Light Cycles\" and try to entrap each other without crashing.\n\n" +
                "This is one of the first games to have a soundtrack.  Fun at parties.\n\n" +
                "At the title screen, press:\n" +
                "3 for slowest game speed,\n" +
                "2 for slow game speed,\n" +
                "1 for moderate game speed,\n" +
                "Any other key for fastest game speed.\n\n" +
                "Game 1: two additional CPU-only players.\n" +
                "Game 2: two additional CPU-only players and trails do not disappear when a light cycle crashes.\n" +
                "Game 3: no additional CPU players.\n" +
                "Game 4: 2-player snake tail-biting game.\n" +
                "+4: add obstacles.\n" +
                "+8: add diagonal movement.",
            "filename" : "SNAFU.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sub Hunt",
            "players" : "1 only",
            "description" : "Use your fleet of four submarines to protect your harbor from six enemy convoys.  Engage in combat and look through your periscope as you approach each fleet and launch torpedos at enemy vessels.  If need be, turn off your engines and sonar, dive deep, and wait for danger to pass, hoping to avoid depth charges and mines.\n\n" +
                "Enemy convoys head for the opposing harbor for reinforcements, and then toward your harbor to launch an invasion.  Sink all the ships in six convoys to win.\n\n" +
                "At the title screen, press:\n" +
                "3 for the easiest difficulty,\n" +
                "2 for the second difficulty,\n" +
                "1 for the third difficulty,\n" +
                "4 for the standard difficulty,\n" +
                "5 for the highest difficulty.",
            "filename" : "Sub Hunt.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Triple Action",
            "players" : "Game 1 (Tanks): 2-player only.\n" +
                "Game 2 (Racing Cars): 1 or 2 players.\n" +
                "Game 3 (Biplanes): 2-player only.",
            "description" : "Three games in one.\n\n" +
                "1 - Tanks.  Two players compete to shoot each other's tank.  First to 15 points wins.\n\n" +
                "2 - Racing Cars.  Dodge traffic and drive 100 miles in the shortest time.\n\n" +
                "3 - Biplanes.  Two players compete to shoot each other's plane.  Try to avoid stalling and crashing into the ground or the weather tower, or your opponent gets a free point.  Hide in the clouds for a surprise attack.  Shoot the weather balloon after it launches for a bonus point.  First to 15 points wins.",
            "filename" : "Triple Action.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Deadly Discs",
            "players" : "1 only",
            "description" : "Appeared as Tron I in the Mattel Electronics game catalogs.\n\n" +
                "Play as Tron, fighting off endless waves of Sark's warriors with your Identity Disc.  You can use your Disc as a shield to shatter enemy discs.\n\n" +
                "Jam open the exit doors and perform an Illegal Exit to regain HP and attract the attention of the Recognizer.  Avoid the Paralyzer Probe, and disable the Recognizer by hitting its eye with a skill shot while it's colored white for bonus points.\n\n" +
                "Later on, more difficult and aggressive enemies come after you with more HP and new weapons.  Can you get to 7 figures?",
            "filename" : "Tron Deadly Discs.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 7, "1981 Space Network"
            "name" : "Astrosmash",
            "players" : "1 only",
            "description" : "Shoot the falling rocks that keep coming.  Don't let any spinning bombs touch down.  Use Hyperspace to dodge Guided Missiles that follow you along the ground.  At later levels, UFOs start to appear that shoot back.\n\n" +
                "At the title screen, press:\n" +
                "1 for slow game speed,\n" +
                "2 for slower game speed,\n" +
                "3 for slowest game speed,\n" +
                "Any other key for normal game speed.",
            "filename" : "Astrosmash.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Armada",
            "players" : "1 only",
            "description" : "The classic game Space Invaders with a few twists.  At higher levels, the aliens fire other weapons such as guided missiles and bombs with a bigger blast radius.  Some of them also become invisible at higher levels.  Shoot the fly-by saucers to repair your bunkers for protection.",
            "filename" : "Space Armada.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Battle",
            "players" : "1 only",
            "description" : "With this reissue, a common complaint was addressed that the game was too easy.  The default difficulty level is 4 instead of 1, if you press a key at the title screen other than 1-5.\n\n" +
                "Once again, at the title screen, press:\n" +
                "3 for the easiest difficulty,\n" +
                "2 for the second difficulty,\n" +
                "1 for the third difficulty,\n" +
                "4 for the standard difficulty,\n" +
                "5 for the highest difficulty.",
            "filename" : "Space Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Hawk",
            "players" : "1 only",
            "description" : "Fly endlessly through deep space with your trusty jetpack in hunt of Space Hawks that attack with deadly gas bubbles.  At higher levels, other enemies start to appear, like comets and the invincible Space Amoeba.  Use Hyperspace to teleport out of imminent danger, but watch out for Black Holes.",
            "filename" : "Space Hawk.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Star Strike",
            "players" : "1 only",
            "description" : "Fly through the trench of an enemy base that has weapons powerful enough to destroy a whole planet.  Fight off waves of defensive droids.  Drop bombs on all five targets to save Earth before it orbits into position and becomes vulnerable to destruction.\n\n" +
                "The destruction of Earth became such a selling point that it spawned another commercial featuring George Plimpton.  It also sparked controversy about the glorification of violence in video games.\n\n" +
                "At the title screen, press:\n" +
                "3 for the easiest difficulty,\n" +
                "2 for the second difficulty,\n" +
                "1 for the third difficulty,\n" +
                "4 for the standard difficulty,\n" +
                "5 for a higher difficulty,\n" +
                "6 for the highest difficulty.",
            "filename" : "Star Strike.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 8, "1982 Strategy Network"
            "name" : "Royal Dealer",
            "players" : "1 only",
            "description" : "Play Rummy, Gin Rummy, Hearts, or Spades against up to 3 computer opponents.\n\n" +
                "Despite the 1981 copyright date, this game wasn't released until later.  When it finally was released, Quality Assurance discovered it had a fatal bug that could cause a gap to appear in your hand, preventing you from selecting cards on the other side.  As a result, it started shipping with an errata slip, warning players not to sort their hand while waiting for the computer players to take their turns.",
            "filename" : "Royal Dealer.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "USCF Chess",
            "players" : "Up to 2",
            "description" : "This was an impressive title, double in ROM size from the other Strategy Network games.  It also has additional onboard RAM, which the AI player required.  It's packed with features such as 2-CPU play, pre-arranging the board to study strategies, an optional time clock, and over 6 levels of CPU difficulty.  All the features are here, including Castling, En Passant, Promotion, and so on.\n\n" +
                "USCF stands for United States Chess Federation.  Due to the CPU behavior, an errata slip was included to warn players that at difficulty levels 4 and above, the computer might take hours or even days to make a single move.  Despite the 1981 copyright date, this game wasn't released until later.",
            "filename" : "Chess.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 9, "1982 Action Network"
            "name" : "Frog Bog",
            "players" : "Up to 2",
            "description" : "A simple game with beautiful graphics and sounds.  Control your frog, jump up from your lily pad, and catch bugs with your tongue.  Be careful not to fall into the water and lose time swimming back to dry land.  Earn all the points you can before bedtime.  Play by day or by night.\n\n" +
                "At the title screen, press:\n" +
                "1 for Day,\n" +
                "3 for Night.\n\n" +
                "To change control difficulty, press:\n" +
                "Clear for simple controls,\n" +
                "0 for standard controls,\n" +
                "Enter for standard controls, plus you use the Action Button to control your tongue.",
            "filename" : "Frog Bog.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Night Stalker",
            "players" : "1 only",
            "description" : "Stay alive in a maze against robots that will shoot at you on sight.  Find a gun to arm yourself and fight back against not only the robots but against critters that will bite you, leaving you momentarily paralyzed.  More powerful robots will appear over time, including ones that can destroy your safe house.\n\n" +
                "Use the 2, 4, 6, and 8 keys for shooting in 4 directions, once you have a gun.\n\n" +
                "Can you get to 80,000 points?",
            "filename" : "Night Stalker.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Shark! Shark!",
            "players" : "1 or 2",
            "description" : "Avoid bigger fish and eat smaller fish to survive and grow.  When the shark appears, avoid it or bite its tail repeatedly.  When you're big enough, fight back against the crabs and lobsters at the ocean's floor, but watch out for jellyfish.\n\n" +
                "There is friendly fire in 2-player mode when one player's fish is bigger than the other, so you can play either cooperatively or competitively.  Beautiful graphics and sound effects, and a catchy Game Over tune.\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Shark Shark.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sharp Shot",
            "players" : "Games 1 and 3 are 1 or 2-player alternating.\n" +
                "Games 2 and 4 are 1 or 2-player simultaneous.",
            "description" : "Four single-button games on one cartridge, reminiscent of the \"electronic shooting gallery\" arcade games of the 1970s.  Press key 1-4 at any time to start that game, press the disc to begin, and press any Action Button to fire - that's all you need to know.  You have 60 seconds to score as many points as you can.\n\n" +
                "1 - Football Passing.  Complete passes to one of the blue teammates in the End Zone for 7 points apiece.  Throwing interceptions and incomplete passes wastes time.\n\n" +
                "2 - Space Gunner.  One or two players zap enemy ships as they pass through their crosshairs.\n\n" +
                "3 - Submarine.  Sink oncoming ships by firing torpedoes from your submarine.  Similar to the 1976 arcade game Sea Wolf.\n\n" +
                "4 - Maze Shoot.  One or two players fire arrows that ricochet through the walls of a maze to stop monsters from stealing treasure.  Lose a point for every monster that gets away with your treasure.",
            "filename" : "Sharp Shot.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 10, "1982 Arcade Network"
            "name" : "Vectron",
            "players" : "1 or 2",
            "description" : "Control two objects at the same time, your V-Gun and Energy Block.  Fire Energy Blasts from your V-Gun into your Energy Block, which generates base sections.  Move the Energy Block into a new position, and repeat the process until your base is fully built.\n\n" +
                "E-Paks will occasionally float by, which you can shoot with an Energy Blast to release energy.  Catch the falling energy with your Energy Block to recharge your Energy Meter.\n\n" +
                "Nasties will hinder your progress by destroying your base sections, forcing you to rebuild parts of your base.  They may also drain your energy on contact with your Energy Block or even vaporize your Energy Block altogether.  You start the game with two spare Energy Blocks, but if you run out, it's Game Over.\n\n" +
                "Can you meet the Dare on the back of the box and clear Level 10?",
            "filename" : "Vectron.rom",
            "ecs" : 0, "intellivoice" : 0, "gram" : 0, "params" : "--kbdhackfile=\"" + workingpath + "veckeys.cfg\""
    },), ({  # The extra comma is necessary here because Python is weird about lists with only one game in them.

            # Group 11, "1982 Licensed Games"
            "name" : "Advanced Dungeons & Dragons",
            "players" : "1 only",
            "description" : "Lead a 3-person expedition through wilderness terrain to Cloudy Mountain.  There, parts of the King's Crown are said to be hidden and guarded by legendary Winged Dragons.\n\n" +
                "To get to Cloudy Mountain, you'll need to find quest items for the various terrain: a boat to cross rivers, an axe to clear your way through thick woods, and a key to pass through locked gates.  You'll have to fight monsters along the way with a limited supply of arrows.  Look for more quivers of arrows left behind by previous failed expeditions.  Watch and listen for clues as to where monsters are waiting, and try to take them by surprise.\n\n" +
                "At the title screen, press:\n" +
                "3 for the easiest difficulty (Cloudy Mountain is grey),\n" +
                "2 for the second difficulty (Cloudy Mountain is blue),\n" +
                "1 for the third difficulty (Cloudy Mountain is red),\n" +
                "Any other key for the highest difficulty (Cloudy Mountain is purple).\n\n" +
                "Work your way up from the easiest difficulty.  Can you win on the highest difficulty with no casualties?",
            "filename" : "Advanced Dungeons & Dragons Cloudy Mountain.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Lock 'N' Chase",
            "players" : "1 or 2",
            "description" : "A port of the popular arcade game.  You play as Lupin the thief.  Run through the bank vault and steal all the coins, then get out.  Steal moneybags and merchandise as they appear for bonus points.  Watch out for the cops: Stiffy, Smarty, Scaredy, and Silly.  Lock doors to trap the cops temporarily and earn more bonus points.\n\n" +
                "Can you discover all 10 merchandise items?\n\n" +
                "Standard title screen speed control applies here.  The color of the dot in the top right corner indicates your speed.  At 100,000 points, the speed reverts to fastest if you're playing at a lower speed.",
            "filename" : "Lock & Chase.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Lock 'N' Chase (8K version)",
            "players" : "1 or 2",
            "description" : "This version features a modified title screen with an actual copyright symbol and reference to Data East.  There is also a death animation when Lupin is caught.  Lupin is also supposed to be easier to control.",
            "filename" : "Lock & Chase (8K).rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Maze-a-Tron",
            "players" : "1 only",
            "description" : "Appeared as Tron II in the Mattel Electronics game catalogs.\n\n" +
                "Play as Kevin Flynn, zapped into a giant computer, trying to find the RAM chips and freeze them all to Logical Zero.  Build up your Force Shield to protect you from Force Fields and Recognizers that seek to destroy you.  Beware of Zaps that drain your Force Shield.\n\n" +
                "Eventually you will meet the Master Control Program face-to-face.  Play in first-person perspective, using your Bit Gun to zap bits in the Bit Stream whose pattern matches the one at the top of the Stack.  Use your Force Shield whenever the MCP tries to attack you.",
            "filename" : "Tron Maze-A-Tron.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 12, "Third Party - Imagic"
            "name" : "Atlantis",
            "players" : "1 or 2",
            "description" : "The Gorgons have launched an invasion against the fabled underwater city.  Protect Atlantis for as many days and nights as you can before Atlantis becomes only a legend.\n\n" +
                "Use your antiaircraft guns to shoot down the enemy Gorgon ships.  Dispatch your Sentinel Saucer when the fighting gets too tough, but be sure to recharge at the docking station before it runs out of power.\n\n" +
                "Can you survive 11 days?",
            "filename" : "Atlantis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Beauty & the Beast",
            "players" : "1 only",
            "description" : "Trouble in Lambville Falls - Horrible Hank has kidnapped Tiny Mabel.  Guide Bashful Buford up the Mutton Building toward Horrible Hank to force him ever higher until he falls from the top.\n\n" +
                "Climb open windows, jump over and dodge boulders and critters, and catch Mabel's hearts for a quick courage boost.  Don't fall overboard, or you'll have to start from the bottom.\n\n" +
                "Can you complete 5 buildings?",
            "filename" : "Beauty & the Beast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Demon Attack",
            "players" : "1 or 2\n" +
                "Read the Description below for more information.",
            "description" : "Protect Moon Station Tranquility against the Demon Armada.  Fight off the enemy ships, and then go on the offensive against Flagship Pandemonium.\n\n" +
                "Press any key to start the game:\n\n" +
                "Left column: 1-player game.\n" +
                "Middle column: 2-player game.\n" +
                "Right column: 2-player cooperative game.\n" +
                "Top row: Normal speed.\n" +
                "2nd row: Faster speed.\n" +
                "3rd row: Normal speed with Tracer Shots.\n" +
                "Bottom row: Faster speed with Tracer Shots.\n\n" +
                "Press any key during game for Auto Fire.\n" +
                "Press any action button for Single Fire.",
            "filename" : "Demon Attack.itv",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Dracula",
            "players" : "1 or 2",
            "description" : "Play as Dracula, who rises from his grave every night to terrorize the village.  You must drink your quota of blood before sunrise.\n\n" +
                "Knock on doors where you see eyes peering from the windows.  Catch up to the fleeing villagers and either drink their blood or turn them into zombies which you can use to fight back against the constables who throw wooden stakes at you.  When the White Wolf appears, it's time to return to your grave.  Watch out for the White Wolf while on foot.  Turn into a bat at will to escape the wolf and to fly faster than walking, but don't get abducted by the vulture.\n\n" +
                "To start the game, press:\n" +
                "1 - 1-player game,\n" +
                "2 - 2-player alternating,\n" +
                "3 - 2-player simultaneous,\n" +
                "4 - Easy difficulty,\n" +
                "5 - Medium difficulty,\n" +
                "6 - Hard difficulty,\n" +
                "8 - Start game.\n\n" +
                "Use the Bottom Left action button to bite people to fulfill your blood quota.\n" +
                "Use the Bottom Right action button to turn people into zombies that you control with the second disc to fight back against the constables.\n" +
                "Use the Top action buttons to switch between vampire and bat form, to escape from the White Wolf and the Vulture.",
            "filename" : "Dracula.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Dragonfire",
            "players" : "1 or 2",
            "description" : "The Prince must recover treasure stolen by dragons so the King can raise an army to drive the dragons away.  Cross bridges and dodge fireballs and arrows.  Steal all the treasure from the storeroom, dodging more dragonfire, and move on.\n\n" +
                "Will you survive long enough to face the invisible dragon?",
            "filename" : "Dragonfire.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Fathom",
            "players" : "1 only",
            "description" : "Play as Proteus, who takes the form of a seagull and a dolphin, to recover the lost pieces of Neptune's Trident and shatter the cage at the bottom of each sea where one of Neptune's daughters is trapped.  Free the mermaid, then fly across to the next sea and repeat the process.  Recover all 8 daughters to win.\n\n" +
                "Fly upward in each of the two places where the clouds are.  Avoid the black birds, and touch all the clouds to find a star which becomes a piece of the Trident.  On higher levels, you must fly higher to find the stars.\n\n" +
                "Once you have the Dolphin token, switch to the dolphin and swim to the bottom of the sea, catching all the seahorses.  Eat schools of fish for more energy, and avoid the coral and larger fish.  With the fully-assembled Trident, shatter the cage at the sea floor and free Neptina.  Return to the surface, change back into seagull form, and fly eastward over the now-dormant volcano to the next sea.\n\n" +
                "Can you complete all 8 seas?",
            "filename" : "Fathom.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Ice Trek",
            "players" : "1 only",
            "description" : "Relive the saga of Vali the Avenger, who melted the Ice Palace of Kaltkron the Terrible and prevented a new Ice Age from beginning.  Hike across the wilderness and face a caribou stampede, then build a makeshift ice bridge across the frigid river to reach the Ice Palace.\n\n" +
                "Use your axe to cut down the caribou if need be, but beware the wrath of the Wildlife Goddess.  Master the use of your grappling hook to capture ice floes and pull them toward you to build an ice bridge.  Use your torch to melt other ice floes that threaten to collide with your bridge and break it away.  Don't fall into the river or take too long, or you'll die of hypothermia.  Once at the Ice Palace, slide across the ice and hurl torch flames at the parapets.  Beware the black crystals of Kaltkron's Fiends.\n\n" +
                "How many times can you complete the quest?",
            "filename" : "Ice Trek.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Microsurgeon",
            "players" : "1 or 2",
            "description" : "A patient has been brought to the Xenon Medical Center with a host of life-threatening ailments.  Dr. Weissblut controls the Robot Probe that enters the patient's body and remotely fights all the disease, then escapes out the patient's nose before running out of power.\n\n" +
                "Stay within the blood vessels to avoid attack from white blood cells that mistake you for foreign matter.  Zap bacteria with antibiotics, viruses with Aspirin, and everything else with your ultrasonic ray.  Travel to each vital organ to handle: cholesterol build-up, gallstones, kidney stones, tapeworms, tar deposits, and brain tumors.  Keep an eye on the patient's status as you go, and quickly determine which organs require your immediate attention.  Save the patient and collect your fee at the end of the day.",
            "filename" : "Microsurgeon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Nova Blast",
            "players" : "1 only",
            "description" : "Pilot Nova 1 over Water Planet Hydron and protect the four remaining Capsuled Cities against Orion Fighters, Gravitines, Water Walkers, and other enemies.\n\n" +
                "Attack flying enemies with lasers and Water Walkers with bombs.  Use your radar to assess which city is in the most immediate peril.  Each city is protected by a barrier.  You can expend fuel to beam down a temporary barrier if one is lost, but be sure to beam up more fuel from a fuel tank for yourself.\n\n" +
                "How many waves can you and the Capsuled Cities survive?",
            "filename" : "Nova Blast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Safecracker",
            "players" : "1 only",
            "description" : "Prove yourself to be one of the country's greatest spies.  Drive through a foreign city and infiltrate embassies, stealing secrets and merchandise.  Engage in gunfights with the Secret Police when they show up.  Get the full combination to the Treasury safe and crack it before time runs out, then return to your Hideout.\n\n" +
                "Use the radar to determine the general direction of your next destination.  Shoot from your car when you meet resistance on the road.  Decide whether to crack the combination of each safe or blow it up with your limited supply of TNT.  Take your stolen merchandise back to your Hideout.\n\n" +
                "How many Treasury safes can you crack?",
            "filename" : "Safecracker.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Swords & Serpents",
            "players" : "1 or 2",
            "description" : "The Warrior Prince and Nilrem the Wizard venture through the Fortress of the Sinister Serpent to reclaim the conquered Kingdom.\n\n" +
                "Collect treasure and bring it to your chest for valor.  Defend yourselves against Phantom Knights and Red Sorcerers.  Utilize magical scrolls to maneuver your way around the Fortress.\n\n" +
                "What will happen if you come face-to-face with the Sinister Serpent?",
            "filename" : "Swords & Serpents.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tropical Trouble",
            "players" : "1 or 2",
            "description" : "Trouble in paradise - Beach Bruiser has kidnapped Darlin' Doris.  Guide Clumsy Clarence across the island and catch up to Doris, traveling across the beach, the jungle, and the volcano.  Finally at the bridge, send Beach Bruiser plunging into the river below.\n\n" +
                "Stay ahead of snakes and monkeys, jump over and dodge clams and ferns, and catch Doris' hankies for a quick courage boost.\n\n" +
                "Can you complete 5 islands?",
            "filename" : "Tropical Trouble.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Truckin'",
            "players" : "1 or 2",
            "description" : "Two games on one cartridge.\n" +
                "Game 1 - race to visit 8 cities in one of 60 tracks.\n" +
                "Game 2 - earn money delivering goods from one city to another.\n\n" +
                "Fuel up before you begin.  Spend your money wisely so you don't end up stranded with no gas.  Consult the Road Map and know the routes.  Learn to make turns in an 18-wheeler.  Watch out for Large Marge and oncoming traffic.  Don't get too tired, and find places to take rest stops when needed.",
            "filename" : "Truckin'.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "White Water",
            "players" : "1 only",
            "description" : "Multiple games in one.  Race to the end of the river, race to collect treasure, or collect all the treasure you can for points.  When collecting treasure, obey the rules of the land, or face the wrath of Big Kahuna - if those tomahawks don't finish you off, the raging current will.\n\n" +
                "First, reunite with the other kayakers to the east, before you get lost in the woods.  Jump in the kayak, and take off downstream.  Stay away from rocks, or somebody might go overboard.  Stop at the beaches and jump out if you're collecting treasure.  Go west into the woods and get what you can.  Return to safety and continue.\n\n" +
                "To begin, press Clear to go to the Game Selection screen.  Then press:\n\n" +
                "1 - Game 1.  Race to the end of the river with a slower current.  Nobody falls out of the kayak.\n\n" +
                "4 - Game 2.  Race to the end of the river with a faster current.  Nobody falls out of the kayak.\n\n" +
                "7 - Game 3.  Race to the end of the river with a slower current.  Going forward, somebody will fall out of the kayak if you hit a rock.\n\n" +
                "2 - Game 4.  Race to the end of the river with a faster current.\n\n" +
                "3 - Game 5.  Race to get 3 urns and a treasure chest in the shortest time possible.  Slower river current.\n\n" +
                "6 - Game 6.  Race to get 3 urns and a treasure chest in the shortest time possible.  Faster river current.\n\n" +
                "9 - Game 7.  Earn points by collecting treasure.  River current starts slow and gets progressively faster.\n\n" +
                "Press Enter to begin the game.",
            "filename" : "White Water.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 13, "Third Party - Activision"
            "name" : "Beamrider",
            "players" : "1-4 alternating\n" +
                "Press the number of players at the title screen.",
            "description" : "Pilot the Beamrider across 99 sectors to clear the Restrictor Shield that surrounds Earth.\n\n" +
                "Fire laser lariats at 15 enemy saucers in each sector, then use your limited supply of torpedoes to shoot the Sector Sentinel for bonus points.  Catch the Yellow Rejuvenator for an extra ship, but be careful not to shoot it.  Newer enemies appear on higher sectors.\n\n" +
                "To earn the Activision Beamriders badge, reach Sector 20 and earn 60,000 points or more.",
            "filename" : "Beamrider.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Dreadnaught Factor",
            "players" : "1 only",
            "description" : "Zorban Dreadnaughts are flying through deep space toward planet Terra and threaten to destroy it.  You have a fleet of ten Novaray Hyperfighters dispatched to protect Terra.\n\n" +
                "Fly into the stargate and approach each dreadnaught.  Fire Laser Bolts to weaken the dreadnaught's defenses and avoid counterattacks.  Drop Strontium bombs onto the surface targets.  Bomb all the Energy Vents to destroy the massive dreadnaught.  On higher levels, face more dreadnaughts of different varieties.  Don't let the dreadnaught get too close to the stargate, or it may fire its planet-destroying missiles.\n\n" +
                "To earn the Activision \"Dreadnaught Destroyer\" Club badge, complete the game at difficulty 4 or higher.",
            "filename" : "Dreadnaught Factor.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Happy Trails",
            "players" : "1 or 2",
            "description" : "Navigate through the Badlands and recover the moneybags stolen by Black Bart.\n\n" +
                "Rearrange the panels to create an unbroken path to the moneybags.  If you encounter Black Bart, get the Sheriff's Badge to become deputized and make the arrest.\n\n" +
                "To earn the Activision Trailblazers badge, score 40,000 points or more.",
            "filename" : "Happy Trails.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pitfall!",
            "players" : "1 only",
            "description" : "Lead Pitfall Harry through the jungle and collect all 32 treasures within 20 minutes.\n\n" +
                "Jump over logs, scorpions, snakes, and fires.  Jump across crocodile-infested swamps and use swinging vines to your advantage.  Use timing to safely pass across quicksand patches.  Learn how to navigate the underground tunnels to reach all the treasure before time runs out.\n\n" +
                "To join Pitfall Harry's Explorers' Club, score 20,000 points or more.  Perfect score is 114,000.",
            "filename" : "Pitfall.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "River Raid",
            "players" : "1 or 2",
            "description" : "Fly your squadron of Jet Fighters down the River of No Return, shooting everything in sight.\n\n" +
                "Fly over fuel depots to keep your fuel gauge up.  Shoot everything you see and avoid collisions.  In the Intellivision port, you can fly over land where there are no trees.  Use it to your advantage.\n\n" +
                "To join the Activision River Raiders, score 35,000 points or more.",
            "filename" : "River Raid.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Stampede",
            "players" : "1 only",
            "description" : "Round up all the cattle and don't let any of them stray.\n\n" +
                "Use your lasso to rope the cows.  Nudge the cows to scare them farther ahead, but beware the Black Angus.  Avoid skidding on the skulls.\n\n" +
                "To earn the Activision Trail Drive badge, score 3,000 points or more.",
            "filename" : "Stampede.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Worm Whomper",
            "players" : "1 or 2",
            "description" : "Felton Pinkerton's corn is in jeopardy by endless waves of hungry pests of all kinds.\n\n" +
                "Keep firing Formula B*U*G pesticide at the bugs as they approach.  Use your limited supply of Plough Balls to bulldoze over large groups of bugs as well as slime trails.  Avoid contact with the bugs, or they will ruin your Spray Gun.  Run to the Tool Shed for a replacement gun.\n\n" +
                "To earn the Activision Worm Whompers badge, score 75,000 points or more.",
            "filename" : "Worm Whomper.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 14, "Third Party - Coleco"
            "name" : "Carnival",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Sega.  Shoot all the targets before you run out of bullets.\n\n" +
                "Start with the pipes; the sooner you shoot them, the higher their point value.  Spell BONUS late in the round to build up the bonus value, but be careful not to shoot the letters out of order.  Shoot the Plus-Minus Target panel and Extra-Bullet Targets to earn more bullets.  Ducks may fly down toward your bullet supply.  Shoot them before they eat your bullets.  Shoot the Musical Note to spare your eardrums from the music.  Clear the gallery to enter the bonus stage.",
            "filename" : "Carnival.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Donkey Kong",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Nintendo.  Donkey Kong has captured Jumpman's friend Pauline and is holding her hostage.\n\n" +
                "Climb your way to the top of the scaffolding.  Dodge or jump over barrels that get in your way, or grab a hammer and smash the barrels.  Reach Pauline and go to a second stage, where you must remove all the Rivets to send Donkey Kong plunging to his demise.",
            "filename" : "Donkey Kong.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Donkey Kong Jr.",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Nintendo.  Play as Donkey Kong Junior and rescue your father who was captured by Mario.\n\n" +
                "Make your way through the jungle.  Avoid Snapjaws or drop fruit on them for points.  Get the Key to unlock the cage and try to set Donkey Kong free.  Mario moves the cage to other places, where you will face Nitpicker Birds.  Push all the keys into position before time runs out.",
            "filename" : "Donkey Kong Jr.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Ladybug",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Universal.  Eat all the flowers and avoid capture by the other insects.\n\n" +
                "Eat hearts when they're blue to increase the point multiplier.  Eat letters when they're yellow to spell EXTRA for an extra life, or eat the letters when they're red for big points.  The insects will pursue you to no end, but you can use the turnstiles to keep yourself safe.  Lure enemies into the pesticides, and eat the vegetables for bonus points.",
            "filename" : "Ladybug.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Mousetrap",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Exidy.  Guide the mouse through the maze and eat all the cheeses.\n\n" +
                "You're outnumbered by hungry cats, but you can swing the doors to protect yourself from danger.  Collect dog biscuits and activate one at will to temporarily become a dog and turn the tables on the cats.  At difficulty level 2 and above, a hawk will also appear that is unfazed by the dog.  The arcade game had instructions to \"Enter IN to make hawk stupid.\"  Collect prizes for bonus points.  Press the Clear key to spare your eardrums from the music.",
            "filename" : "Mousetrap.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Turbo",
            "players" : "1 only",
            "description" : "Based on the arcade game by Sega.  Race down city, country, and mountain roads.\n\n" +
                "Pass 30 cars before time runs out for extended play.  Avoid collisions with other cars.  Watch out for ambulances and oil slicks.\n\n" +
                "This game uses the second controller only.  Rotate the disc to steer.",
            "filename" : "Turbo.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Venture",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Exidy.  Guide Winky through chambers full of treasure.\n\n" +
                "Fire arrows at monsters in each chamber, collect the treasure, and get out before the invincible Hallmonsters chase you down.  Collect all the treasure and move on to another level full of new surprises.",
            "filename" : "Venture.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Zaxxon",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Sega.  Fly through the asteroid fortress in pursuit of the evil robot Zaxxon.\n\n" +
                "Use the colors of objects to determine their height and navigate through the 3-D fortress.  Shoot Fuel Tanks to keep your fuel gauge up.  Avoid collisions and don't get shot.  Face-to-face with Zaxxon itself, shoot its missiles before they fire to destroy the evil robot.",
            "filename" : "Zaxxon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 15, "Third Party - Parker Brothers"
            "name" : "Frogger",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Sega.  Get all the frogs to their homes, across a dangerous highway and equally dangerous river.\n\n" +
                "Weave through traffic.  Hop on logs and turtle backs as you cross the river.  Avoid snakes, crocodiles, and otters on higher levels.  Escort the pink lady frogs home for a bonus.  Catch flies for an additional bonus.",
            "filename" : "Frogger.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Popeye",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Nintendo.  Rescue Olive Oyl from Brutus.\n\n" +
                "Catch Olive Oyl's hearts, musical notes, or cries for Help in each of three stages.  Punch bottles thrown at you by Brutus and the Sea Hags.  Use the punching bag to try to drop a bucket on Brutus' head for a bonus.  Eat the can of spinach and send Brutus flying into the water below.",
            "filename" : "Popeye.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Q*Bert",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Based on the arcade game by Gottlieb.  Hop on all the cubes to change their color to the Target Color.\n\n" +
                "Move diagonally to jump from one cube to the next.  Avoid red and purple balls, Ugg & Wrong Way, and Coily.  Hop on the multicolored Flying Discs to lure Coily overboard for bonus points.  Catch the green Slick, who tries to undo your work by changing the cube colors.  Catch the green ball to freeze the enemies for a short time.  On higher levels, jump on each cube twice, and then an odd number of times or even number of times.",
            "filename" : "Q-Bert.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Star Wars: the Empire Strikes Back",
            "players" : "1 or 2",
            "description" : "Fly your Snowspeeder through the Ice Planet Hoth, fighting against an endless wave of Imperial Walkers that threaten the Rebel Base's power generator.\n\n" +
                "Keep shooting at the nearest Imperial Walker until it is destroyed.  Watch out, because it will fire back with missiles and bombs.  Place a well-timed shot into the bomb hatch to destroy the Walker instantly.  If you're damaged by Walker fire, you can land up to two times for repairs, or take a chance and wait for The Force to be with you.",
            "filename" : "Star Wars.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Cobra",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Konami.  Fly your helicopter on a surveillance mission through 11,000 miles of hostile terrain.\n\n" +
                "Fire chopper bullets and drop bombs on all the enemy targets that stand in your way.  Destroy fuel tanks to keep your fuel gauge up.  Avoid all collisions.  Collect the booty at the end for a bonus.",
            "filename" : "Super Cobra.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tutankham",
            "players" : "1 or 2",
            "description" : "Based on the arcade game by Konami.  Enter the tomb of the fabled King Tut and make out with all the treasure you can.\n\n" +
                "Fire your laser gun left and right at creatures.  Collect a key to unlock a door.  Use secret tunnels to teleport your way to temporary safety.  Use your Flash Bomb to eliminate all enemies when things get too scary.  Try to get the treasure in all four chambers.",
            "filename" : "Tutankham.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 16, "Third Party - Atarisoft"
            "name" : "Centipede",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Based on the arcade game by Atari.  Shoot all the sections of the Centipede and stay alive.\n\n" +
                "Shoot mushrooms that are in your way.  Watch out for spiders and fleas, in addition to the Centipede.  Scorpions appear at higher levels and poison the mushrooms, causing the centipede to dart straight down toward you.\n\n" +
                "After the game starts, you can press the keypad for auto fire.  Score as many points as you can.",
            "filename" : "Centipede.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Defender",
            "players" : "1 only",
            "description" : "Protect the Humanoids on the planet Humanis against the aliens.\n\n" +
                "Landers will abduct the Humanoids and try to turn them into killer Mutants.  Shoot the Landers and catch the Humanoids before they fall to their death.  If all the Humanoids die, Humanis will explode.  Use your Hyperspace to teleport out of danger, and use your limited supply of Smart Bombs to clear out large numbers of aliens.",
            "filename" : "Defender.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pac-Man",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Based on the arcade game by Atari.  Eat all the dots in the maze and avoid the monsters.\n\n" +
                "Pass over the dots to eat them.  Eat a flashing Power Pellet to turn the monsters blue and turn the tables on them for a short time.  Eat Fruit Prizes as they appear for bonus points.  Eat all the dots to clear the maze.  Clear so many mazes and be treated to a short cartoon sequence.",
            "filename" : "Pac-Man.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 17, "Third Party - Interphase"
            "name" : "Blockade Runner",
            "players" : "1 only",
            "description" : "Fly your fleet of four space freighters 10,000 miles through an asteroid belt to carry vital supplies to Earth.  Enemies lie in wait for you and have dropped space mines as well.\n\n" +
                "Dodge asteroids.  Shoot space mines with your limited missiles before they explode.  Catch Ice Crystals to fill your fuel gauge and cool down your shields.  Take evasive maneuvers to trick enemy ships into attack position, then shoot them with three missiles to destroy them.",
            "filename" : "Blockade Runner.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sewer Sam",
            "players" : "1 only",
            "description" : "Sewer Sam is a troubleshooter for the City Works Department.  He's been called to investigate a disturbance in the city sewers.  Three submarines have invaded the sewer system and are threatening the city.\n\n" +
                "Travel down 3-D tunnelways, shooting creatures with your revolver.  When your ammo is gone, wait for your gun to reload.  Scale walls to avoid trouble.  Duck into a side tunnel in search of the submarines.  When your progress gauge changes color from white to red, travel to the end of the tunnel to face a submarine.  Shoot three missiles before they launch to sink the submarine.  Sink 3 submarines to win.",
            "filename" : "Sewer Sam.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 18, "Third Party - Sega"
            "name" : "Congo Bongo",
            "players" : "1 or 2",
            "description" : "Get revenge on the mischievous gorilla that set fire to your tent while you were sleeping.  Chase him through the jungle until you catch him sleeping and set his feet on fire.\n\n" +
                "Make your way through the jungle and dodge falling coconuts.  Keep the monkeys off your back and jump over the river.  At the second screen, catch a ride on turtles and hippos to get across the river.  Dodge the rhinocerous herd as you make your way toward the goal.",
            "filename" : "Congo Bongo.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    },), ({  # Again, this extra comma is necessary because Python is weird about lists with only one game in them.

            # Group 19, "[1983,] Mattel Electronics, No Network"
            "name" : "Buzz Bombers",
            "players" : "1 only",
            "description" : "Spray all the bees with your bug spray before they pollinate too many flowers in the flower bed and crowd you out.\n\n" +
                "Spraying a bee with your limited bug spray turns it into a honeycomb, which impedes the other bees.  Let the hummingbird suckle the honeycombs for bonus points.  If a bee gets trapped, it forms a beehive.  You get bonus points for beehives at level's end.\n\n" +
                "Complete so many levels and enjoy up to four cutscenes.",
            "filename" : "Buzz Bombers.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Motocross",
            "players" : "Up to 2",
            "description" : "Race in one of three closed-circuit racetracks on your motorbike, or create your own track.  Don't crash into the hay bales or spectators as you race.  Race for the best time or against a computer or human opponent.",
            "filename" : "Motocross.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pinball",
            "players" : "1 or 2",
            "description" : "Three-tiered pinball action.  Complete objectives and make your way from the Green table to the heart-shaped Red table and finally to the Blue table.\n\n" +
                "Complete the Gold Mine in the Green table for double point values.  Activate the Moving Target in the Red table and hit it for a huge bonus.  Keep hitting the yellow drop targets in the Blue table until the White Cup appears and enter it for an extra ball.\n\n" +
                "Enjoy the sights of the various animals, and the special effects of such targets as the Uranium Bumper.  Can you get to 6 figures?",
            "filename" : "Pinball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 20, "1983 Licensed Games"
            "name" : "Advanced Dungeons & Dragons: Treasure of Tarmin",
            "players" : "1 only",
            "description" : "You have a rough map of the underground network beneath the castle, which leads to the Treasure of Tarmin, guarded by a fierce Minotaur.  Along the way, there are ever-stronger monsters that you'll fight for survival.  Find stronger weapons to help you, along with defensive equipment and magic books of all kinds.  Stop to eat whenever you need to replenish yourself.  Collect treasure for points.  Continue downward, but know that you can't turn back until you've either found the Treasure of Tarmin or died trying.",
            "filename" : "Advanced Dungeons & Dragons Treasure of Tarmin.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Bump & Jump",
            "players" : "1 or 2",
            "description" : "A port of the arcade game by Data East.  Drive through 32 levels, bumping other vehicles off the road and jumping over water hazards.\n\n" +
                "Get your speed up to 100 mph to enable your hydraulics and jump when needed.  Watch out for dump trucks that might drop a load onto the highway.  When you see the flashing warning sign, get ready to jump over a water hazard.  Land onto an island for a bonus.  Avoid getting knocked off the road.\n\n" +
                "Can you make it to Level 8?",
            "filename" : "Bump & Jump.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "BurgerTime!",
            "players" : "1 or 2",
            "description" : "A port of the popular arcade game.  Walk across parts of hamburgers to drop them in cascading fashion onto plates below.  Use your limited supply of pepper to stun enemies as they come after you.  Collect prizes such as french fries to replenish your supply of pepper.\n\n" +
                "A commercial for this game ended with a man in a hot dog costume announcing, \"We are closed now!\"  That catch phrase became as popular among Intellivision fans as \"Where's the beef!\"  It also was bundled with the Intellivision II due to its popularity.\n\n" +
                "Standard title screen speed control applies here.  A pattern of dots in the top right corner indicates your speed.",
            "filename" : "Burgertime.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Kool-Aid Man",
            "players" : "1 only",
            "description" : "Two children were exploring a haunted house when the Thirsties appeared to ruin their fun.  If they catch the kids, they'll give them such a fright that they'll go catatonic.  Hurry - make a pitcher of Kool-Aid to summon Kool-Aid Man!\n\n" +
                "You'll need a packet of Kool-Aid, a bowl of sugar, and an empty pitcher.  To reach the sugar bowl, you'll need a stepping stool.  Bring the three items to the kitchen sink to complete your task.  Each of the kids can carry one item at a time, so it will take a minimum of two trips.  When Kool-Aid Man appears, fly around the haunted house, catch Phantom Flavors for bonus points, and beat up the Thirsties before time runs out.\n\n" +
                "At the title screen, press:\n" +
                "3 for \"Kid Stuff\" difficulty (timer is blue),\n" +
                "2 to start on Level 1 (timer is red),\n" +
                "1 to start on Level 3 (timer is dark green),\n" +
                "Any other key to start on Level 7 (timer is grey).",
            "filename" : "Kool-Aid Man.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Loco-Motion",
            "players" : "1 or 2",
            "description" : "A port of the Konami arcade game.  Rearrange the railroad tracks and get all the waiting passengers onto the train before you are too late.  Don't allow the train to derail.",
            "filename" : "Locomotion.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Masters of the Universe: The Power of He-Man",
            "players" : "1 only",
            "description" : "Skeletor is heading for Gastle Greyskull.  He-Man gets into the Wind Raider and takes off after him.\n\n" +
                "Fly 30 miles east, as far as you can travel by air.  Shoot fireballs before you collide with any of them.  Drop bombs to slow down Skeletor for extra points.  Don't fly back to the west for too long, because you have a limited supply of fuel.\n\n" +
                "On foot, you'll pursue Skeletor through mountain terrain, then through woods, and finally in the parapets of Castle Greyskull.  Raise your shield to protect yourself against lightning balls and power bolts.  Collect Magic Sword icons for extra time.  Catch up to Skeletor three times to send him running away from Castle Greyskull.",
            "filename" : "Masters of the Universe.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Mission-X",
            "players" : "1 or 2",
            "description" : "A port of the Data East arcade game.  Fly over enemy territory and drop bombs on everything you see.  Shoot down any enemy plane that appears and shoots back at you.  Touch down onto the occasional runway for bonus points.  Continue throughout the day and into the night.",
            "filename" : "Mission-X.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 21, "Intellivoice"
            "name" : "Space Spartans",
            "players" : "1 only",
            "description" : "Relive the Battle of Thermopylae, in which a small Spartan force held off Xerxes and the entire Persian army, only now in Outer Space.  You have similar odds; it's just your one ship and three starbases against multiple waves of enemies.\n\n" +
                "Start off by placing your starbases anywhere in the Sector Grid.  Use your ship's Hyper Drive to travel to another sector, and switch to Battle View to engage in combat against alien forces.  Protect your starbases against alien invasions.  Listen to your crew members as they keep you informed of the Status of your ship and your Energy Level.\n\n" +
                "Return to one of your starbases to recharge your Energy Level and for repairs after your various systems are damaged by alien fire.  Go on the offensive and attack the enemy starbases to prevent them from building more alien ships.  Destroy all the alien forces and earn a bonus and continue play into another round.",
            "filename" : "Space Spartans.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "B-17 Bomber",
            "players" : "1 only",
            "description" : "Fly the USAAF B-17 over \"Fortress Europe\" and drop heavy explosives over factories, refineries, and enemy warships, in addition to enemy airfields and antiaircraft batteries.  Return to England to refuel and re-arm, and for repairs.  Fly as many missions as you can for the highest score.\n\n" +
                "Select a target on the map, and your pilot will automatically chart a course toward it.  Decide before takeoff the size of your bomb load.  Take off when ready.\n\n" +
                "As you enter hostile territory, you will come under fire.  Control the various machine guns as verbally indicated and shoot down enemy planes.  Prepare to drop bombs when you get close to your desired target.  Do what it takes to conserve fuel and maintain airspeed so you can make it back to England.  Live to fly another day.",
            "filename" : "B-17 Bomber.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Bomb Squad",
            "players" : "1 only",
            "description" : "Negotiations with Boris the terrorist have failed.  He has planted a time bomb in the heart of the metropolis.  By the time you and your colleague, Frank the demolition expert, arrive on the scene, there are 30 minutes left.\n\n" +
                "To disarm the bomb, you need to figure out the code.  For each digit, there are 20 LED cells.  Pick a cell and proceed to rewire it.  If successful, that cell will either light up or go dark, revealing part of the number.  If you mess up, the cell will burn out, or worse, the bomb will explode.\n\n" +
                "Frank will guide you in the rewiring phase.  There are various wiring components over a circuit board.  You have a boneyard of spare parts, and various tools handy to do the job.  Listen to Frank tell you the order in which components need to be swapped out, and whether to cut each one out and swap in a gray wire, or to replace it with a different component of the same shape or color.  If you make a mistake, the time clock will speed up until you correct it, or you'll have a few seconds to correct your mistake before the circuit burns out.\n\n" +
                "Guess the digit when you think you know what it is.  The bomb will be disarmed if you correctly guess all the digits.  If you guess wrong, the bomb explodes.  No pressure.",
            "filename" : "Bomb Squad.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Solar Sailer",
            "players" : "1 only",
            "description" : "Flynn pilots the Solar Sailer in pursuit of the Master Control Program.  Beat the MCP and Flynn can return to the real world.\n\n" +
                "Start at Track 7 and work your way past Track 0.  An onscreen display will show you which Sector's I/O Beam is currently active to get you to the next Track, but you'll have to rely on the voice of Alan for the Access Code.\n\n" +
                "The voices of Tron and Yori will guide you.  You can control the speed of the Solar Sailer and change course at intersections.  Fire in all directions at Grid Bugs as well as enemy tanks that will fire back.  Continue to the target sector's I/O Beam and enter the Access Code to progress.  Recognizers will start to appear to carry the Solar Sailer away from the MCP.  Shoot them before they get you.  If you forget the Access Code, return to the Sector 0 I/O Beam for a reminder.\n\n" +
                "When you reach your destination, play as Bit and capture flying digits and enter them into indicated positions to gradually overload the MCP.  You only have so much time to complete the task.  If you succeed, you have an opportunity to continue in Overtime for extra points before declaring victory against the MCP.",
            "filename" : "Tron Solar Sailer.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 22, "Entertainment Computer System"
            "name" : "Mind Strike",
            "players" : "Up to 2\n" +
                "Speed Strike is 2-player only.\n" +
                "Press Return on the ECS Computer Keyboard to begin.",
            "description" : "Two players compete to invade each other's castle with numbered pieces.  Mind Strike is turn-based, whereas in Speed Strike, players move continuously.\n\n" +
                "Higher numbers can attack the same or lower-numbered opposing pieces, but lower numbers can move faster and farther in one turn.  Pieces can \"Meld\" into one another at a cost of 1, to form larger numbers up to a #7, or can \"Split\" when a lower number is needed to travel farther.  Although lower numbers are lost to larger numbers, a #1 can \"Dink\" a #7 to reduce it to a #6.\n\n" +
                "There are 50 pre-made boards to choose from, or you can create your own.  You can also reprogram one or both computer players, named Max and Gus, and try playing against one of them, or have two players reprogram each one and have them compete against each other.",
            "filename" : "Mind Strike.itv",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "Scooby Doo's Maze Chase",
            "players" : "1 only\n" +
                "Press Return on the ECS Computer Keyboard to begin.",
            "description" : "Chase down the three ghosts and avoid the skull.  After you catch all the ghosts, catch a runaway submarine sandwich in time to earn an extra bone.  Play on one of 10 pre-defined mazes, or create your own maze to play on.\n\n" +
                "Drop one of your bones when you need to stop the skull, which will be vital at later hours when the skull is faster than you.  Don't take too long, or the ghosts will regenerate.  Every 2,000 points, the hour advances and the skull gets faster and the ghosts get more evasive.  Time may rewind if you lose a life.\n\n" +
                "Can you get to 25,000 points?",
            "filename" : "Scooby Doo's Maze Chase.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "The Jetsons' Ways With Words",
            "players" : "1 only",
            "description" : "Have fun building your vocabulary with George Jetson.  Play through 8 words, capturing all the letters that are travelling along a multi-tiered highway throughout the night and day.  Play at one of three vocabulary levels with pre-defined words, or create your own word list.  You can save your word list to tape for future re-use.\n\n" +
                "Letters will try to evade capture by utilizing the teleport ramps when you get too close, but you can do the same.  Watch out for other traffic as well as robots and flying saucers at higher levels.  Colliding with an obstacle will cost you points, as well as colliding with a letter that's not part of your word.  Catch all the letters in sequence for the highest score.  Earn a bonus for perfect performance.",
            "filename" : "The Jetsons' Ways With Words.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--ecs-tape=\"" + jzintvpath + "ecs_tape_jwww.ecs\""
        }, {
            "name" : "Mr. BASIC Meets Bits & Bytes",
            "players" : "Game 1 (Vampire Bats): 1-player only.\n" +
                "Game 2 (Cannon): 1 or 2 players.\n" +
                "Game 3 (Mr. BASIC): 1-player only.",
            "description" : "Three games on one cartridge, each of which use only half the screen while the BASIC interpreter appears in the other half.  Try reprogramming each of the games and have fun learning to write BASIC code.\n\n" +
                "1 - Vampire Bats.  You're trapped on the rooftop of an old barn with a colony of bats coming after you.  Drop bombs to fight back against the bats.  Don't fall off the roof, and don't blow up the Bomb Stack.\n\n" +
                "2 - Cannon.  One player has a cannon, and an optional second player has a missile launcher.  Shoot the other player to move a wall toward the opposing player's side.  The game is over when the wall moves far enough to either side.  Highest score wins.\n\n" +
                "3 - Mr. BASIC.  You're trapped in a computer room with Bits and Bytes flying all over the place.  Grab the pieces and throw them back into the computer terminal.  Get hit in the head and you'll suffer a concussion.  Game is over after three concussions.\n\n" +
                "As part of the standard BASIC interpreter, you can save your programs to tape for future re-use and also print a listing of your programs.  There are a few sample programs for each game in the instruction manual to help you get started.\n\n" +
                "For the '+' key, press Shift+5.  For '?', press Shift+down.  Some keys were never available on the ECS Computer Keyboard:\n" +
                "~ ! ^ _ [ ] \\\n\n" +
                "This game does not bypass the standard ECS menu.  To start the game, select option 2 for \"cartridge\" in the ECS menu.",
            "filename" : "Mr BASIC Meets Bits & Bytes.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Melody Blaster",
            "players" : "1 only",
            "description" : "Have fun learning to play music.  Use the Music Synthesizer to zap falling notes in one of 11 songs.  The Aquarius Data Recorder is supported so extra songs can be loaded into the Computer Adaptor's memory.\n\n" +
                "There are a wide variety of play options to help you.  Allow the computer to play one or both hands.  Slow down the tempo as you learn each song.  You can also create your own melodies and practice playing them back, or splice portions of existing songs for further practice.\n\n" +
                "A built-in Help feature will explain all the various modes, and the instruction manual teaches you the basics of reading sheet music.\n\n" +
                "This game does not bypass the standard ECS menu.  To start the game, select option 2 for \"cartridge\" in the ECS menu.",
            "filename" : "Melody Blaster.itv",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--ecs-tape=\""+ jzintvpath + "ecs_tape_mb.ecs\""
        }, {
            "name" : "World Series Major League Baseball",
            "players" : "Up to 2",
            "description" : "The most sophisticated Baseball game you'd see on a game console for years to come.\n\n" +
                "Use the Intellivoice to hear a full play-by-play announcer, years ahead of Joe Montana Sports Talk Football.  See the action from various camera angles, years ahead of Bases Loaded.  All the players have fictitious names but are based on players in real life, with actual Batter and Pitching stats, and even the same skin color - true Baseball fans will quickly recognize who's who.  Change your lineup if you choose and save it to tape for future re-use.  Visit the pitcher's mound and bring in a reliever when he gets too tired.\n\n" +
                "Try watching a 2-CPU demo first by pressing C on the Computer Keyboard at the title screen followed by Return (press F7 in jzIntv to switch to Keyboard controls, and press F5 to revert to default controls).  Then try practicing all the aspects of the game, both at bat and in the outfield, until you're comfortable going a full 9 innings.\n\n" +
                "At the title screen press:\n" +
                "C - 2-CPU demo,\n" +
                "A - Play as American League,\n" +
                "N - Play as National League,\n" +
                "Space - 2-player game\n" +
                "Then press Return to begin.",
            "filename" : "World Series Major League Baseball.bin",
            "ecs" : 1, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : "-m2 --ecs-tape=\"" + jzintvpath + "ecs_tape_wmlb.ecs\""
    }), ({

            # Group 23, "Third Party? - Dextell Ltd."
            "name" : "Championship Tennis",
            "players" : "Up to 2\n" +
                "Read the Description below for more information.",
            "description" : "A completely different game from the original Mattel Electronics Tennis.\n\n" +
                "Choose any of three different locations, each with different ground types which affect the behavior of the ball.  Play singles or doubles, with the option of two players teamed up against two computer players.\n\n" +
                "When the first player arrives on the court, do the following:\n" +
                "For a 2-CPU demo, press Clear.\n" +
                "To play alone against the computer, press Enter to position the blue player (you), and then press Clear.\n" +
                "To play a Singles game against another player, press Enter to position the blue player, press Enter to position the red player on the other side of the court, and then press Clear to dismiss the third player.\n" +
                "To play a Doubles game against another player, press Enter to position the blue player, press Enter to position the red player on the other side of the court, and then press 0.\n" +
                "To play a Doubles game with both players against two CPU players, press Enter to position the blue player, press Enter to position the red player on the same side of the court, and then press 0.",
            "filename" : "Championship Tennis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "World Cup Soccer",
            "players" : "Up to 4 (up to 2 players per team)",
            "description" : "The original NASL Soccer is back with some improvements.  Up to 4 people can play together, and the computer can play one or both teams.  The camera angle changes during penalty kicks, and you can choose to practice penalty kicks - either as the kicker or the goalkeeper - rather than play a full game.",
            "filename" : "World Cup Soccer.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 24, "INTV Corporation - Remakes & Reissues"
            "name" : "Learning Fun I",
            "players" : "1 or 2",
            "description" : "Two games in one.\n\n" +
                "1 - Math Master.  An enhanced version of Math Fun from the old Learning Network.\n\n" +
                "2 - Factor Fun.  Each player is a gorilla sitting at an adding machine.  Figure out the correct sequence of numbers presented to you and math operations to reach the Target Number.",
            "filename" : "Learning Fun 1.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Learning Fun II",
            "players" : "Game 1 (Word Rockets): 1 or 2 players.\n" +
                "Game 2 (Word Hunt): 1 or 2 players.\n" +
                "Game 3 (Crosswords): 2-player only.\n" +
                "Game 4 (Memory Fun): 1 or 2 players.",
            "description" : "Enhanced versions of the three games from Word Fun, plus a new fourth game.  The new game, Memory Fun, is a memory game where one or two players uncover two tiles at a time to try to match letters.",
            "filename" : "Learning Fun 2.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Mountain Madness Super Pro Skiing",
            "players" : "1-6 players alternating",
            "description" : "All the fun of the original Skiing game, with a few new terrain types and features.\n\n" +
                "There are now ice patches, dry spots, and areas of unpacked powdery snow.  The same two difficulty choices are available, plus a third option to ski with no flags.  Choose from one of 32 courses, create your own course, or be \"helicoptered\" onto uncharted terrain.\n\n" +
                "As before, the best of three heats is your final record.  Best time wins.",
            "filename" : "Mountain Madness Super Pro Skiing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Pac-Man",
            "players" : "1 or 2",
            "description" : "A re-release of the popular game, now without the Atari logo.",
            "filename" : "Pac-Man (INTV).rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Slam Dunk Super Pro Basketball",
            "players" : "Up to 2",
            "description" : "A wonderfully updated version of the original Basketball game.\n\n" +
                "In addition to computer play, there are now 3-point shots, and some new features.  You can manage your team with a certain starting budget, and draft players who all have various stats, from a draft roster randomly generated out of a larger player pool.  Run out of money and you'll be assigned Free Agents who didn't make the draft roster.  During play, watch for players to get tired, and swap them out when needed.  Keep an eye on the opposing team's substitutions as well.",
            "filename" : "Slam Dunk Super Pro Basketball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Slap Shot Super Pro Hockey",
            "players" : "Up to 2",
            "description" : "A graphically updated version of the original Hockey game, now with computer play.\n\n" +
                "You can set one or both computer teams to any of four difficulty levels.  Performing illegal actions only carries a penalty if you get caught.",
            "filename" : "Slap Shot Super Pro Hockey.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Pro Football",
            "players" : "Up to 2",
            "description" : "The earliest of the \"Super Pro\" sports updates, which is why it has a simplified title.\n\n" +
                "Computer play is now available, and players can set a handicap - any of 9 skill levels.  You can now see menus on-screen to choose your plays instead of consulting a physical Playbook.  There is also a Pressbox which appears every time a team scores and after each quarter, displaying various game stats.",
            "filename" : "Super Pro Football.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Triple Challenge",
            "players" : "Game 1 (Chess): Up to 2 players.\n" +
                "Game 2 (Checkers): 1 or 2 players.\n" +
                "Game 3 (Backgammon): 1 or 2 players.",
            "description" : "A no-frills multicart containing Chess, Checkers, and Backgammon from the old Strategy Network.",
            "filename" : "Triple Challenge.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "World Championship Baseball",
            "players" : "Up to 2",
            "description" : "Completed by Mattel Electronics just before they went out of business, it was originally titled \"All-Star Major League Baseball\".\n\n" +
                "The computer can play as one or both teams, and each team can be set to any of 5 skill levels.  Players can now visibly slide to base.  The ball's shadow can be seen, so you no longer have to rely on an audible cue to know how high the ball is in the air.  The camera pans slightly when a ball is hit deep into the outfield, to heighten the suspense of a possible Homerun.",
            "filename" : "World Championship Baseball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
    }), ({

            # Group 25, "INTV Corporation - New Original Games"
            "name" : "Hover Force",
            "players" : "1 only",
            "description" : "Take off in the top secret JAF-3000 helicopter and stop the terrorist forces that are beseiging the city of New Seeburg.\n\n" +
                "Use your radar to see where the enemies are at, along with any fires burning.  Fire your laser cannons at enemy choppers, and use your water cannons to put out fires.  Don't shoot randomly and damage the buildings - that dollar figure is millions of dollars in damage done to the city; a higher amount is not good.\n\n" +
                "Keep an eye on your various systems as you take damage from enemy fire.  You can land on your helipad up to two times per mission for repairs and to replenish your laser and water cannons.\n\n" +
                "Only one life.  How many mission points can you rack up?",
            "filename" : "Hover Force.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Thin Ice",
            "players" : "1 or 2",
            "description" : "Duncan is a mischievous penguin who likes to skate in loops around other penguins and dunk them into the pond.  The equally mischievous seal likes to bounce Duncan on her nose and chases him down.  Polar bears also will join in the fun and try to bat Duncan around.\n\n" +
                "Eat a shrimp cocktail for a temporary speed boost.  Skate in a loop around another character and dunk that character into the water.  Collect lobsters and activate them later to freeze the polar bears when you're in trouble.  Dunk all the penguins to complete a level and ride your Zamboni all over Saskatchewan to restore the pond.\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Thin Ice.itv",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Thunder Castle",
            "players" : "1 or 2",
            "description" : "You're the knight in shining armor on three quests for survival.  Start in the enchanted forest, where you must slay three dragons.  Then enter the castle maze, where a pair of angry wizards chases you down.  Finally you enter the dungeon and face a group of demons.\n\n" +
                "Catch items that will allow you to turn the tables on the evil guardians.  Find treasure that you can use for an advantage, but avoid the hair comb which will cost you half your points.  Use the shifting maze to your advantage.  Slay all the guardians and move on to your next quest.",
            "filename" : "Thunder Castle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Tower of Doom",
            "players" : "1 only",
            "description" : "An early Roguelike game.  Escape the Tower of Doom.\n\n" +
                "Choose from 10 characters, each with their own strengths and weaknesses.  There are 10 challenges to choose from as well.\n\n" +
                "Explore hallways and fill out your magic map.  Collect treasure which you can keep for points or barter with monsters for peace.  Equip m\xeal\xe9e and ranged weapons.  Find magic potions and other equipment to evade traps.  Eat food when you're hungry and your life force is low.  Get to the staircase and continue downward to find the way out.",
            "filename" : "Tower of Doom.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
    }), ({

            # Group 26, "INTV Corporation - Licensed Games"
            "name" : "Commando",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.\n" +
                "Use the 3-4 keys to play a 1- or 2-player game at a higher difficulty if the game seems too easy.",
            "description" : "Based on the arcade game by Capcom.  Storm the gates of each enemy stronghold.\n\n" +
                "Shoot enemies with your machine gun, and use your limited supply of grenades when necessary.  Rescue any hostages you find.  Collect more grenades for the challenges ahead.  Keep marching north toward the enemy gates and shoot everybody in the stronghold.\n\n" +
                "Can you complete 3 levels?",
            "filename" : "Commando.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Dig Dug",
            "players" : "1 only",
            "description" : "Based on the arcade game by Namco.  Fight or chase away all the underground monsters until they're all gone.\n\n" +
                "Dig tunnels toward the subterranean monster lairs.  Pump the Pookas and Fygars full of air until they burst like balloons, or drop rocks on them.  Fygar can breathe fire, so be careful.  Eat your vegetables for bonus points.",
            "filename" : "Dig Dug.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Diner",
            "players" : "1 or 2",
            "description" : "An unofficial sequel to Burgertime.  This time, you're trapped in Ray's Diner, kicking balls of rolled-up food down toward the giant plate at the bottom of each level.  Kick food balls into the enemies for extra points: red meatballs, green heads of lettuce, yellow macaroni, white rice, and tan mashed potatoes.\n\n" +
                "The hot dogs are back, along with new enemies: Mugsy the Mug o' Root Beer, Bad Bananas, and Cheap Cherries.  New \"Side Order\" prizes are available to earn extra peppers: coffee, sundaes, malts, and sodas.  Surprising new terrain elements, such as elevators and deadly pitfall traps, appear on higher levels.  The \"Blue Plate Special\" bonus stage happens after every four stages - catch the rolling food balls and avoid the deadly flashing food balls.\n\n" +
                "Can you get to 6 figures on the first stage?  Can you clear 15 levels?",
            "filename" : "Diner.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Pole Position",
            "players" : "1 only",
            "description" : "Based on the arcade game by Namco.  The classic racetrack is available, along with three new tracks to choose from.\n\n" +
                "Take off at the green light, get into high gear, and complete the Qualifying Lap in 75 seconds or less.  The faster you qualify, the better your starting position in the big race.  Complete laps in the big race to earn extra time.  Rack up as many points as you can before time is up.\n\n" +
                "Can you get to 50,000 points?",
            "filename" : "Pole Position.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
    }), ({

            # Group 27, "INTV Corporation - New Sports Titles"
            "name" : "Chip Shot Super Pro Golf",
            "players" : "1 or 2",
            "description" : "A beautiful new Golf game, written from the ground up.  This game was particularly hyped in the INTV catalogs, advertised as \"two years in development by a team of golfers and programmers\" and \"the most sophisticated video game yet.\"\n\n" +
                "Play 9 or 18 holes.  Select a pre-determined course, or create your own course from a selection of 99 holes.  Deal with new factors such as the wind and the direction of the grass blades on the Green.  See a close-up of each Green for precise putting aim.\n\n" +
                "Can you make the player faint by sinking a long putt?",
            "filename" : "Chip Shot Super Pro Golf.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Pro Decathlon",
            "players" : "1-4 players alternating",
            "description" : "Ten full events: 100-Meter Dash, Hurdles, Long Jump, High Jump, Pole Vault, Discus, Shot Put, Javelin, Triple Jump, and 400-Meter Run.  Three difficulty levels.  Practice individual events, or compete in the full Decathlon.  Up to 4 players can compete.",
            "filename" : "Super Pro Decathlon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Body Slam Super Pro Wrestling",
            "players" : "Up to 2",
            "description" : "Finally the Intellivision gets a wild Pro Wrestling game.  Anything goes in the ring, or outside of it.\n\n" +
                "Play one-on-one or Tag Team, against the computer or with the computer against a friend, etc.  6 difficulty levels.  12 characters to choose from.  26 crazy moves.  One hot Round Number Girl.",
            "filename" : "Body Slam Super Pro Wrestling.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Stadium Mud Buggies",
            "players" : "Up to 2",
            "description" : "Nine different events to race in, ranging from donuts to drag racing, from tug-o-war to car crush.  Race alone, against a computer opponent, or against another player.",
            "filename" : "Stadium Mud Buggies.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Spiker Super Pro Volleyball",
            "players" : "Up to 2",
            "description" : "Play 2-on-2 Beach Volleyball or with 6-player teams in the gymnasium.  The computer can play one or both teams.  6 difficulty levels to choose from.\n\n" +
                "Serve the ball.  Set, bump, spike.  Dive for the ball if need be.  Don't get violations and make the referee whistle blow at you.",
            "filename" : "Spiker Super Pro Volleyball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
    }), ({

            # Group 28, "Commercial Games (all)"
            "name" : "ABPA Backgammon",
            "players" : "1 or 2",
            "description" : "You can press the action button to see the total Pip Count for both players, to get a quick idea as to who's winning.\n\n" +
                "Can you beat the computer at both difficulty levels?",
            "filename" : "Backgammon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Advanced Dungeons & Dragons [Cloudy Mountain]",
            "players" : "1 only",
            "description" : "Here's a pro tip: you can move and fire at the same time if you use the disc on one controller and the keypad on another controller.\n\n" +
                "Once again, at the title screen, press:\n" +
                "3 for the easiest difficulty (Cloudy Mountain is grey),\n" +
                "2 for the second difficulty (Cloudy Mountain is blue),\n" +
                "1 for the third difficulty (Cloudy Mountain is red),\n" +
                "Any other key for the highest difficulty (Cloudy Mountain is purple).\n\n" +
                "Work your way up from the easiest difficulty.  Can you win on the highest difficulty with no casualties?",
            "filename" : "Advanced Dungeons & Dragons Cloudy Mountain.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Advanced Dungeons & Dragons: Treasure of Tarmin",
            "players" : "1 only",
            "description" : "The eyeball murals in the outer hallway always point to a maze entrance.  If there is no visible door, press the Open key anyhow to search for a hidden door.\n\n" +
                "Keep the instruction manual handy and get to know the various items and monsters.  Know which monsters you should approach and fight, and which ones you might want to leave alone.\n\n" +
                "Passing through teleport gates in the outer hallway can halve one of your Max HP stats and double the other one if it's green or blue.\n\n" +
                "Watch out for the doors that are enchanted by an ominous spell - fighting them can be as dangerous as the Minotaur himself.  But a powerful spell book is your reward for defeating it and turning it back into an ordinary door.\n\n" +
                "You can continue downward below the lowest level and fight the Minotaur somewhere even deeper, trying for a higher Treasure Score\n\n" +
                "Can you beat the Minotaur on the highest difficulty?",
            "filename" : "Advanced Dungeons & Dragons Treasure of Tarmin.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Armor Battle",
            "players" : "2 only",
            "description" : "Tip: make good use of your land mines.  Each player can lay one mine per round, and there's a 5-second delay before it activates.  Be sure to move out of the way in time so you don't blow up your own tank.",
            "filename" : "Armor Battle Fast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Astrosmash",
            "players" : "1 only",
            "description" : "Can you get to a half million points?  The game gets quite difficult at 300,000 points.",
            "filename" : "Astrosmash.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Atlantis",
            "players" : "1 or 2",
            "description" : "Press 1 to Start.\n" +
                "Use the 7 key for 1-player, or the 9 key for 2-player.\n" +
                "Use the 4, 5, 6 keys for Easy, Medium, Hard difficulty.\n\n" +
                "The top action buttons fire left, and the bottom action buttons fire right.  Use the 0 key to deploy the Sentinel Saucer.  Don't forget to dock it again before you run out of power, and don't collide with anything.\n\n" +
                "Can you survive 11 days?",
            "filename" : "Atlantis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Auto Racing",
            "players" : "1 or 2\n" +
                "For 1-player, press Enter on the second controller after choosing your car.",
            "description" : "The five available cars are:\n" +
                "1 - White.  Best handling but slowest top speed.\n" +
                "2 - Green.  Fastest acceleration.  Slightly faster top speed but slightly less control.\n" +
                "3 - Red.  All-around average car.\n" +
                "4 and 5 - Tan and Blue.  These cars are identical in all aspects for a balanced 2-player game.  They have the fastest top speed but the worst handling.\n\n" +
                "Can you complete 5 laps in all five courses without crashing?\n\n" +
                "How many hidden drag strips can you find?",
            "filename" : "Auto Racing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "B-17 Bomber",
            "players" : "1 only",
            "description" : "It should go without saying that you lose a lot of points if you drop a bomb while still flying over England.\n\n" +
                "Fuel consumption is an issue on higher difficulty levels.  Take time to decide how many bombs to put into your payload.  After takeoff, reduce your engine power if you want to have enough fuel to make it home after bombing your targets.\n\n" +
                "Can you complete a successul bomb run on the factories and warships on the highest difficulty?",
            "filename" : "B-17 Bomber.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Beamrider",
            "players" : "1-4 alternating\n" +
                "Press the number of players at the title screen.",
            "description" : "Watch for the Yellow Rejuvenators and be careful not to shoot them.  You'll need all the extra lives you can get when you get into the double-digit Sectors.\n\n" +
                "Get to know the various enemy behaviors.  You'll have to think fast to evade collisions without wasting your precious missiles.\n\n" +
                "To earn the Activision Beamriders badge, reach Sector 20 and earn 60,000 points or more.",
            "filename" : "Beamrider.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Beauty & the Beast",
            "players" : "1 only",
            "description" : "Know where the safe places to stand are when a bird or bat flies by.  A lot of players like to fall off the edge at the highest story to avoid ramping up the difficulty for a higher score, but I've found that doesn't work.  The difficulty still increases, but you don't get credit for clearing a building.\n\n" +
                "Can you complete 5 buildings?  10 buildings?",
            "filename" : "Beauty & the Beast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Blockade Runner",
            "players" : "1 only",
            "description" : "Remember to accelerate as soon as you begin.  I prefer to play with default controls by pressing Enter at the title screen:\n" +
                "Bottom right button to accelerate,\n" +
                "Bottom left button to decelerate,\n" +
                "Top buttons to fire a missile.\n\n" +
                "It's easy to run out of missiles.  You will get an extra 5 missiles every so often to a maximum of 15, but not often enough.  Get good at shooting the space mines without missing.  Fire when the mine is between your reticules, and the missile will home in and destroy the mine.\n\n" +
                "Above all else, don't ever miss the Ice Crystals.  When you hear the alert and your reticules flash blue, stay in position to catch the Ice Crystals.  In addition to cooling down your shields, this is how you regain fuel.\n\n" +
                "When your distance is below 5,000, enemy ships start to appear.  They require 3 missiles to destroy, and their color indicates their status:\n" +
                "Grey - normal,\n" +
                "Yellow - hit once,\n" +
                "Purple - hit twice.\n" +\
                "If you ignore them and keep dodging their fire, they will eventually turn light blue, which indicates they are charging up a weapon that will destroy you without even seeing what hit you.  They also deftly stay just out of your missiles' range, so this is the one time you will want to decelerate.  Slow down to make the enemy ship slow down, and then accelerate and attack while you have a window of opportunity.\n\n" +
                "Can you make it back to Earth without losing a ship?  Can you make it back to Earth more than once?",
            "filename" : "Blockade Runner.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Body Slam Super Pro Wrestling",
            "players" : "Up to 2",
            "description" : "Can you find the Easter Egg message?",
            "filename" : "Body Slam Super Pro Wrestling.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Bomb Squad",
            "players" : "1 only",
            "description" : "Remember to keep the instruction manual handy so you know what all the digits look like.  The game is pretty much unplayable without the manual.\n\n" +
                "When Frank tells you to \"cut out\" each component, remember that you only have to swap them out with the box-shaped grey wire at the end of the boneyard.  If you have to \"replace\" each component, you will swap in either the same-colored component or the same-shaped component for the entire rewiring of that circuit board.\n\n" +
                "More often than not, your boneyard will have more than one choice for a replacement component, especially when replacing the first component and you don't yet know whether to exchange by color or by shape.  The time clock speeds up if you guess wrong, and you also have to start over by swapping it out with another one from the boneyard.  Get used to it.\n\n" +
                "Also, do not forget what the original component looked like, because when it disappears off the screen, it's gone.\n\n" +
                "Starting on Level 2, components will sporadically overheat, setting off the alarm that the circuit board is about to burn out.  Stop what you're doing and use your Fire Extinguisher ('7' key) before it's too late.\n\n" +
                "On Level 3, the nearby emergency vehicle will cause a slight tremor, which may knock a spare component from your boneyard onto the circuit board.  Components dropped into random places on the circuit board also cause the time clock to speed up, so stop what you're doing and use your pliers to get rid of it.\n\n" +
                "You are only allowed to guess the digit after you have successfully rewired two circuit boards or when the time clock is down to 15 seconds.  Use the 1, 2, 3 keys to move the cursor to the desired digit if necessary, press Enter (\"The code, the code, ...\"), press the number of your guess (\"Are you sure?\"), and press Enter again.\n\n" +
                "Can you defuse the bomb on the highest difficulty and/or with 3 digits?",
            "filename" : "Bomb Squad.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Boxing",
            "players" : "2 only",
            "description" : "Can you go 15 rounds with your opponent?",
            "filename" : "Boxing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Bump & Jump",
            "players" : "1 or 2",
            "description" : "There's a 50,000-point bonus if you make it through a level without destroying any enemy cars.  If you think that defeats the purpose of the game, bear in mind that's the way it was in the arcade port.  There's also a 1,000-point bonus if you jump onto an island in the middle of a water hazard.  Dump trucks explode if you merely touch them, and on some levels they do not drop any loads.\n\n" +
                "Give my level editor a try.  Enter command \"bnjedit\" at the command prompt.",
            "filename" : "Bump & Jump.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "BurgerTime",
            "players" : "1 or 2",
            "description" : "Learn the pattern of the different enemies.  While on the same tier as you, Mr. Egg will always go up the nearest ladder, and the hot dogs will always go down.  Use that to out-maneuver the enemies and you will often escape when they're all closing in on you.\n\n" +
                "Get good at maneuvering all the enemies into each other to form a tight \"conga line\" (my own words) and drop them all down for a large bonus.\n\n" +
                "Save up your peppers for Level 7.  You are usually better off losing a life than using more than one pepper to escape.\n\n" +
                "Can you clear all 7 levels more than once?",
            "filename" : "Burgertime.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Buzz Bombers",
            "players" : "1 only",
            "description" : "Be quick to decide whether to shoot a honeycomb that is in a popular flight path, or whether to leave it for the hummingbird for extra points.  Remember that bees turn into beehives if they are blocked, which disappear at the end of each level for bonus points.  Also, Killer Bees form red honeycombs when sprayed.  Letting the hummingbird suckle the red ones has the highest point value in the game, so try to avoid shooting them.\n\n" +
                "Don't get into the habit of shooting the hummingbird to get it out of your way.  It takes several sprays to get rid of it, and you will often find yourself running out of spray, which costs you a life, on higher levels.\n\n" +
                "If the flower bed gets completely full, you not only lose a life, but you have to start the level over from scratch.  If you run out of spray just before that happens, that's two lives lost.\n\n" +
                "How many of the four cutscenes have you seen?",
            "filename" : "Buzz Bombers.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Carnival",
            "players" : "1 or 2",
            "description" : "This game does not work with Intellivision II.\n\n" +
                "Remember to shoot the pipes on the pipe wheel early on, because their point value decreases every time you shoot and don't hit a pipe.  Also, the bonus value stops increasing when you start shooting the BONUS letters, and you forfeit the bonus by shooting the letters out of order, so be careful around those letters and save them for last if you can.\n\n" +
                "When a duck comes to life, shoot it right away, because it will fly toward your ammo and eat up 10 bullets.  Anticipate when a Plus-Minus target will appear, and stay away from there when possible so you don't accidentally incur a large penalty.",
            "filename" : "Carnival.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Centipede",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Remember, you can press the '1' key for auto-fire.  All the standard strategies from the arcade game apply here.\n\n" +
                "Can you get to 50,000 points?",
            "filename" : "Centipede.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Championship Tennis",
            "players" : "Up to 2\n" +
                "Read the Description below for more information.",
            "description" : "When the first player arrives on the court, do the following:\n" +
                "For a 2-CPU demo, press Clear.\n" +
                "To play alone against the computer, press Enter to position the blue player (you), and then press Clear.\n" +
                "To play a Singles game against another player, press Enter to position the blue player, press Enter to position the red player on the other side of the court, and then press Clear to dismiss the tan player.\n" +
                "To play a Doubles game against another player, press Enter to position the blue player, press Enter to position the red player on the other side of the court, and then press 0.\n" +
                "To play a Doubles game with both players against two CPU players, press Enter to position the blue player, press Enter to position the red player on the same side of the court, and then press 0.",
            "filename" : "Championship Tennis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Checkers",
            "players" : "1 or 2",
            "description" : "Can you beat the computer at both difficulty levels?  There is a nice musical fanfare if you do.",
            "filename" : "Checkers.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Chip Shot Super Pro Golf",
            "players" : "1 or 2",
            "description" : "Can you make the player faint by sinking a long putt?",
            "filename" : "Chip Shot Super Pro Golf.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Commando",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.\n" +
                "Use the 3-4 keys to play a 1- or 2-player game at a higher difficulty if the game seems too easy.",
            "description" : "Can you complete 3 levels?",
            "filename" : "Commando.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Congo Bongo",
            "players" : "1 or 2",
            "description" : "On the second screen, jump onto a turtleback, then a hippo, then an island.  Once you land on one of the islands, fish will appear to carry you the rest of the way across the lake.  Don't stay on a fish too long, or it will eventually change color and finally snap at you.\n\n" +
                "Can you clear two game loops?  Can you find the Easter Egg message?",
            "filename" : "Congo Bongo.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Defender",
            "players" : "1 only",
            "description" : "Get to know from what height humans can survive a fall, so you can save time by not having to catch them and deposit them on the ground.  Don't take too long, or Baiters will start to spawn.  Humans repopulate the planet after every 4 waves.\n\n" +
                "Can you get to 50,000 points?",
            "filename" : "Defender.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Demon Attack",
            "players" : "1 or 2\n" +
                "Read the Description below for more information.",
            "description" : "Press any key to start the game:\n\n" +
                "Left column: 1-player game.\n" +
                "Middle column: 2-player game.\n" +
                "Right column: 2-player cooperative game.\n" +
                "Top row: Normal speed.\n" +
                "2nd row: Faster speed.\n" +
                "3rd row: Normal speed with Tracer Shots.\n" +
                "Bottom row: Faster speed with Tracer Shots.\n\n" +
                "Press any key during game for Auto Fire.\n" +
                "Press any action button for Single Fire.",
            "filename" : "Demon Attack.itv",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Dig Dug",
            "players" : "1 only",
            "description" : "A vegetable will appear after you've dropped the second rock on each level.  Get into the habit of going after vegetables, so you can earn a lot of points on the higher levels.\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Dig Dug.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Diner",
            "players" : "1 or 2",
            "description" : "Get to know where the Side Order prizes appear, and after how many kicks.  You will need to save up your peppers for the 15th level.  It's relatively easy to get all the enemies clustered together and to keep kicking food balls into them for a high score, and with that, plenty of extra lives.\n\n" +
                "Can you get to 6 figures on the first stage?  Can you clear all 15 levels?",
            "filename" : "Diner.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Donkey Kong",
            "players" : "1 or 2",
            "description" : "This game does not work with Intellivision II.\n\n" +
                "If you think this port is terrible, buy the indie game DK Arcade by Carl Mueller Jr.  He proved to the world that Donkey Kong for Intellivision didn't have to suck.",
            "filename" : "Donkey Kong.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Donkey Kong Jr.",
            "players" : "1 or 2",
            "description" : "Same as with Donkey Kong, there's an indie port of this game which is far superior to this one.\n\n" +
                "Can you rescue Donkey Kong twice on the highest difficulty?",
            "filename" : "Donkey Kong Jr.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Dracula",
            "players" : "1 or 2",
            "description" : "This game is quite fun with 2 players.  Remember that turning a denizen into a zombie is the way to fight back against the constables.",
            "filename" : "Dracula.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Dragonfire",
            "players" : "1 or 2",
            "description" : "Will you survive long enough to face the invisible dragon?",
            "filename" : "Dragonfire.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Dreadnaught Factor",
            "players" : "1 only",
            "description" : "To earn the Activision \"Dreadnaught Destroyer\" Club badge, complete the game at difficulty 4 or higher.",
            "filename" : "Dreadnaught Factor.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Electric Company Math Fun",
            "players" : "1 or 2\n" +
                "For 1-player, enter 0 for the second player's Number Of Problems.",
            "description" : "There were two versions of this game.  One version has you enter digits from right to left, the other from left to right.",
            "filename" : "Math Fun.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Electric Company Word Fun",
            "players" : "2 only",
            "description" : "This game does not work with Intellivision II.",
            "filename" : "Word Fun.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Fathom",
            "players" : "1 only",
            "description" : "The key is to master flying in seagull form.  Remember, you do not need to fly higher than one screen into the clouds on the first stage.  Only on higher stages do you need to fly ever higher to find the stars.\n\n" +
                "In dolphin form, remember to eat schools of the tiny purple fish to replenish your energy.  More energy means more points when you free Neptina.\n\n" +
                "Can you clear all 8 seas?",
            "filename" : "Fathom.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Frog Bog",
            "players" : "Up to 2",
            "description" : "Remember, use the bottom row of keys to set the complexity of the controls.  Try pressing '3' at the title screen to play at night for an added challenge.\n\n" +
                "Can you get 300 points?\n\n" +
                "There is an Atari VCS (2600) port of this game called Frogs And Flies.  I suggest you visit the history of this game's development at https://history.blueskyrangers.com/mnetwork/frogsflies.html and read the Fun Fact.  It would only take a minute of your time, but you'll probably be too busy laughing all the way through.",
            "filename" : "Frog Bog.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Frogger",
            "players" : "1 or 2",
            "description" : "Can you get to 5 figures on the highest difficulty?",
            "filename" : "Frogger.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Happy Trails",
            "players" : "1 or 2",
            "description" : "To earn the Activision Trailblazers badge, score 40,000 points or more.",
            "filename" : "Happy Trails.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Horse Racing",
            "players" : "1-6 players place bets.\n" +
                "Up to 2 players can jockey.",
            "description" : "This is the perfect kind of game to play on livestream for Chat participation.",
            "filename" : "Horse Racing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Hover Force",
            "players" : "1 only",
            "description" : "Remember, you can only land twice per level for repairs.  If you can't see enemies on the radar, it might be too heavily damaged.\n\n" +
                "How many mission points can you rack up?",
            "filename" : "Hover Force.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Ice Trek",
            "players" : "1 only",
            "description" : "Remember, raising your axe at the caribou stampede costs you points.  Master the grappling mechanic when building the ice bridge.\n\n" +
                "How many times can you complete the quest?",
            "filename" : "Ice Trek.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Jetsons' Ways With Words",
            "players" : "1 only",
            "description" : "Game 1 is Normal.\n\n" +
                "Game 2 gives you only some letters, leaving you with the word's synonym/antonym as the clue.  Only catch the missing letters.\n\n" +
                "Game 3 suppresses the synonym/antonym for each word.",
            "filename" : "The Jetsons' Ways With Words.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--ecs-tape=\"" + jzintvpath + "ecs_tape_jwww.ecs\""
        }, {
            "name" : "Kool-Aid Man",
            "players" : "1 only",
            "description" : "Reminder - at the title screen, press:\n" +
                "3 for \"Kid Stuff\" difficulty (timer is blue),\n" +
                "2 to start on Level 1 (timer is red),\n" +
                "1 to start on Level 3 (timer is dark green),\n" +
                "Any other key to start on Level 7 (timer is grey).\n\n" +
                "Use the keypad to switch which kid takes the lead.  The kid in the lead is the one who picks up and drops an item, and each kid can only carry one item at a time, so use this feature to carry two items to the sink at a time.  When the kids are caught, they become separated.  Going forward, you can only control one kid at a time, and the kids will scream and go catatonic if they are caught a second time.\n\n" +
                "On higher levels, the Thirsties are faster and can see you from a greater distance.  Your look-ahead distance is also diminished.\n\n" +
                "Can you get to Level 13?",
            "filename" : "Kool-Aid Man.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Ladybug",
            "players" : "1 or 2",
            "description" : "A vegetable will appear in the monster pen when 4 enemies are in play.  If you eat it, the enemies freeze for a time while a tune plays, but they will still hurt you.  Also be careful not to get trapped while going after the vegetable - the enemies tend to guard it closely.\n\n" +
                "Decide at the beginning of the level which letters you need (eat them when yellow) and don't need (eat them when red for the most points).  The first thing you should always do though is go after the hearts and eat them when they're blue to max out the point multiplier.",
            "filename" : "Ladybug.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Las Vegas Poker & Blackjack",
            "players" : "1 or 2",
            "description" : "This was the pack-in game for the original Intellivision.",
            "filename" : "Las Vegas Poker & Blackjack.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Las Vegas Roulette",
            "players" : "1 or 2",
            "description" : "This is a good game to play on livestream for Chat participation.\n\n" +
                "Can you find the Easter Egg message?",
            "filename" : "Las Vegas Roulette.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Learning Fun I",
            "players" : "1 or 2",
            "description" : "Can you solve a single problem in Factor Fun?",
            "filename" : "Learning Fun 1.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Learning Fun II",
            "players" : "Game 1 (Word Rockets): 1 or 2 players.\n" +
                "Game 2 (Word Hunt): 1 or 2 players.\n" +
                "Game 3 (Crosswords): 2-player only.\n" +
                "Game 4 (Memory Fun): 1 or 2 players.",
            "description" : "The new game, Memory Fun, is a memory game where one or two players uncover two tiles at a time to try to match letters.",
            "filename" : "Learning Fun 2.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Lock 'N' Chase",
            "players" : "1 or 2",
            "description" : "Don't be discouraged if you can't get very far.  This game is not easy.  On higher levels, merchandise items disappear very quickly.\n\n" +
                "Can you discover all 10 merchandise items?",
            "filename" : "Lock & Chase.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Lock 'N' Chase (8K version)",
            "players" : "1 or 2",
            "description" : "This version features a modified title screen with an actual copyright symbol and reference to Data East.  There is also a death animation when Lupin is caught.  Lupin is also supposed to be easier to control.",
            "filename" : "Lock & Chase (8K).rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Loco-Motion",
            "players" : "1 or 2",
            "description" : "How many levels can you clear?",
            "filename" : "Locomotion.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Major League Baseball",
            "players" : "2 only",
            "description" : "\"Yer out!\"",
            "filename" : "Baseball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Masters of the Universe: The Power of He-Man",
            "players" : "1 only",
            "description" : "On lower levels, try reaching Skeletor without using your shield, because there's a 10,000-point bonus every time you succeed.\n\n" +
                "Can you get to 6 figures?\n\n" +
                "This game was advertised as having SuperGraphics, years ahead of Sega's Blast Processing.",
            "filename" : "Masters of the Universe.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Melody Blaster",
            "players" : "1 only",
            "description" : "I have a new version of this game with all-new music.\n\n" +
                "Other software was intended for the Music Synthesizer, but was never developed:\n\n" +
                "Melody Maker:\n" +
                "Create your own music.  Save your songs to tape for future re-use.\n\n" +
                "Music Conductor:\n" +
                "A series of minigames designed to make music lessons fun.\n\n" +
                "Songwriter:\n" +
                "Create your own sheet music, and print them using the Aquarius Printer.",
            "filename" : "Melody Blaster.itv",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--ecs-tape=\"" + jzintvpath + "ecs_tape_mb.ecs\""
        }, {
            "name" : "Microsurgeon",
            "players" : "1 or 2",
            "description" : "Remember to stay inside the bloodstream to avoid being attacked by white blood cells.  Know which weapons to use against which enemies.\n\n" +
                "Can you save the patient on the third difficulty?  Can you find the programmer's name?",
            "filename" : "Microsurgeon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Mind Strike",
            "players" : "Up to 2\n" +
                "Speed Strike is 2-player only.\n" +
                "Press Enter on the ECS Computer Keyboard to begin.",
            "description" : "You might have noticed the word Dave in the screenshot.  That is the design for Board 47.  Dave Warhol is the programmer of this game.  The number 47 is a recurring Easter Egg throughout the Intellivision's history, same as in Star Trek.  It also appears in the box art for Super Pro Football and Stadium Mud Buggies.  If you look carefully, the grass in the background of Factor Fun (Learning Fun I) is also a repeating pattern of 47's.",
            "filename" : "Mind Strike.itv",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "Mission-X",
            "players" : "1 or 2",
            "description" : "Remember, skid on the runway at the lowest altitude for points.  Bombing the runway at a high altitude costs points.  Bombing the runway at a low altitude costs you a life.\n\n" +
                "Can you survive 3 nights?",
            "filename" : "Mission-X.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Motocross",
            "players" : "Up to 2",
            "description" : "Making your own racetrack is fun, and so is watching 2 CPU players race and crash all over your racetrack.\n\n" +
                "Those are spectators and bales of hay you see in the grass, not flowers.",
            "filename" : "Motocross.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Mountain Madness Super Pro Skiing",
            "players" : "1-6 players alternating",
            "description" : "The \"Helicopter Skiing\" mode is very enjoyable.  So is creating your own tracks.  This is a nice upgrade over the original Skiing game.",
            "filename" : "Mountain Madness Super Pro Skiing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Mousetrap",
            "players" : "1 or 2",
            "description" : "Remember, the hawk only appears at difficulty level 2 and above.\n\n" +
                "I have a new version of this game with a lot of features to make it closer to the arcade port.",
            "filename" : "Mousetrap.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Mr. BASIC Meets Bits & Bytes",
            "players" : "Game 1 (Vampire Bats): 1-player only.\n" +
                "Game 2 (Cannon): 1 or 2 players.\n" +
                "Game 3 (Mr. BASIC): 1-player only.",
            "description" : "You can press Clear to freeze the action while you write BASIC code.  I have a small program saved which gives you homing bombs in Vampire Bats.\n\n" +
                "Once again, here is a description of each game:\n\n" +
                "1 - Vampire Bats.  You're trapped on the rooftop of an old barn with a colony of bats coming after you.  Drop bombs to fight back against the bats.  Don't fall off the roof, and don't blow up the remaining bombs.\n\n" +
                "2 - Cannon.  One player has a cannon, and an optional second player has a missile launcher.  Shoot the other player to move a wall toward the opposing player's side.  The game is over when the wall moves far enough to either side.  Highest score wins.\n\n" +
                "3 - Mr. BASIC.  You're trapped in a computer room with Bits and Bytes flying all over the place.  Grab the pieces and throw them back into the computer terminal.  Get hit in the head and you'll suffer a concussion.  Game is over after three concussions.\n\n" +
                "As part of the standard BASIC interpreter, you can save your programs to tape for future re-use and also print a listing of your programs.  There are a few sample programs for each game in the instruction manual to help you get started.",
            "filename" : "Mr BASIC Meets Bits & Bytes.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NASL Soccer",
            "players" : "2 only",
            "description" : "",
            "filename" : "Soccer.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NBA Basketball",
            "players" : "2 only",
            "description" : "",
            "filename" : "Basketball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NFL Football",
            "players" : "2 only",
            "description" : "",
            "filename" : "Football.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "NHL Hockey",
            "players" : "2 only",
            "description" : "",
            "filename" : "Hockey.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Night Stalker",
            "players" : "1 only",
            "description" : "Bats are replaced by grey robots when your score reaches 5,000.  They can also be destroyed by robot fire, so manipulate the robot not to shoot where it will endanger the bats.\n\n" +
                "Here's a pro tip: you can move and fire at the same time if you use the disc on one controller and the keypad on another controller.\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Night Stalker.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Nova Blast",
            "players" : "1 only",
            "description" : "How many waves can you and the Capsuled Cities survive?",
            "filename" : "Nova Blast.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pac-Man",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Can you make it to the fourth cutscene in this version?",
            "filename" : "Pac-Man.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pac-Man (INTV)",
            "players" : "1 or 2",
            "description" : "Can you make it to the fourth cutscene in this version?",
            "filename" : "Pac-Man (INTV).rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "PBA Bowling",
            "players" : "1-4 players alternating",
            "description" : "Remember to hold the Aim button until the white spotter is lined up with the direction you want the ball to travel.  While walking forward, tap the disc east for no spin, south for maximum spin, or any direction counter-clockwise from east to south for a certain amount of spin.\n\n" +
                "Can you bowl a 200 or better?  300?",
            "filename" : "Bowling.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "PGA Golf",
            "players" : "1-4 players alternating",
            "description" : "How many times can you make Par?",
            "filename" : "Golf.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pinball",
            "players" : "1 or 2",
            "description" : "Don't get discouraged; this game is not easy.  Don't forget to use the top edge of the disc for nudging, but don't overdo it if you don't want to Tilt.\n\n" +
                "To graduate to the next table, you have to make the White Cup appear and sink the ball into it.  For the Green Table, touch the two dots near the top, between each pair of purple bumpers, to change their color from light blue to white.  For the Red Table, hit the two drop targets to make the Polar Bear temporarily appear.\n\n" +
                "Can you get the Gold Rush?\n\n" +
                "Can you hit the Moving Target?\n\n" +
                "Can you get an extra ball?\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Pinball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pitfall!",
            "players" : "1 only",
            "description" : "Learn how navigation works between ground level and below-ground, then make a map.  That's the only way you're going to collect all the treasures within 20 minutes.\n\n" +
                "To join Pitfall Harry's Explorers' Club, score 20,000 points or more.  Perfect score is 114,000.",
            "filename" : "Pitfall.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pole Position",
            "players" : "1 only",
            "description" : "Practice making turns until you can finish the Qualifying Lap.  It's not easy.\n\n" +
                "Can you get to 50,000 points?",
            "filename" : "Pole Position.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Popeye",
            "players" : "1 or 2",
            "description" : "Can you rescue Olive Oyl on all three stages at each difficulty level?",
            "filename" : "Popeye.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Q*Bert",
            "players" : "1 or 2\n" +
                "Press the number of players at the title screen.",
            "description" : "Learn how Ugg and Wrong Way move on the board whenever they appear.  The point value for making Coily jump overboard is greater than the end-of-level bonus for having unutilized discs.\n\n" +
                "Can you reach Stage 5-1?",
            "filename" : "Q-Bert.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Reversi",
            "players" : "1 or 2",
            "description" : "Can you beat the CPU on all three difficulty levels?",
            "filename" : "Reversi.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "River Raid",
            "players" : "1 or 2",
            "description" : "This is the one port where you can fly over land.  Just avoid the trees, and use that to your advantage.\n\n" +
                "To join the Activision River Raiders, score 35,000 points or more.",
            "filename" : "River Raid.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Royal Dealer",
            "players" : "1 only",
            "description" : "Despite the 1981 copyright date, this game wasn't released until later.  When it finally was released, Quality Assurance discovered it had a fatal bug that could cause a gap to appear in your hand, preventing you from selecting cards on the other side.  As a result, it started shipping with an errata slip, warning players not to sort their hand while waiting for the computer players to take their turns.",
            "filename" : "Royal Dealer.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Safecracker",
            "players" : "1 only",
            "description" : "Remember, the color of the border indicates the direction you're supposed to go.  The overlay shows you those colors in the four corners.\n\n" +
                "How many Treasury safes can you crack?",
            "filename" : "Safecracker.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Scooby Doo's Maze Chase",
            "players" : "1 only\n" +
                "Press Enter on the ECS Computer Keyboard to begin.",
            "description" : "The faster you catch the last two ghosts, the more time you have to chase the submarine sandwich.  Hoard your bones, because you'll need them when the skull becomes faster than you.\n\n" +
                "Can you get to 25,000 points?",
            "filename" : "Scooby Doo's Maze Chase.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "Sea Battle",
            "players" : "2 only",
            "description" : "Keep the instruction manual handy.  Get to know the different vessels and the best fleets to assemble.  You can stop in your harbor a limited number of times to recall your ships for repairs.  You'll probably want to have a Minesweeper along with a Troop Transport when you're ready to invade the other harbor.",
            "filename" : "Sea Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sewer Sam",
            "players" : "1 only",
            "description" : "When the progress indicator turns red, there is a submarine at the end of the tunnel you're in.  Shoot the missiles before they launch from the submarine.\n\n" +
                "Can you sink 3 submarines without losing a life?",
            "filename" : "Sewer Sam.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Shark! Shark!",
            "players" : "1 or 2",
            "description" : "To kill the crabs and lobsters, wait until you're really big.  Then go all the way to the ocean floor, lurk underneath, wait for them to jump, and swim up to catch them on the way back down.\n\n" +
                "When you reach the maximum size and jellyfish start to appear, you gain an extra life every 1,000 points.  You'll need as many lives as you can get by the time you reach 90,000 points and the shark becomes really aggressive.\n\n" +
                "Can you get to 6 figures?",
            "filename" : "Shark Shark.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sharp Shot",
            "players" : "Games 1 and 3 are 1 or 2-player alternating.\n" +
                "Games 2 and 4 are 1 or 2-player simultaneous.",
            "description" : "1 - Football Passing.  Complete passes into the End Zone for 7 points apiece.  Throwing interceptions and incomplete passes wastes time.\n\n" +
                "2 - Space Gunner.  One or two players zap enemy ships as they pass through their crosshairs.\n\n" +
                "3 - Submarine.  Sink oncoming ships by firing torpedoes from your submarine.  Similar to the 1976 arcade game Sea Wolf.\n\n" +
                "4 - Maze Shoot.  One or two players fire arrows that ricochet through the walls of a maze to stop monsters from stealing treasure.  Lose a point for every monster that gets away with your treasure.",
            "filename" : "Sharp Shot.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Slam Dunk Super Pro Basketball",
            "players" : "Up to 2",
            "description" : "",
            "filename" : "Slam Dunk Super Pro Basketball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Slap Shot Super Pro Hockey",
            "players" : "Up to 2",
            "description" : "",
            "filename" : "Slap Shot Super Pro Hockey.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "SNAFU",
            "players" : "Games 4, 8, 12, and 16 are 2-player only.\n" +
                "The other games are up to 2 players.",
            "description" : "Game 1: two additional CPU-only players.\n" +
                "Game 2: two additional CPU-only players and trails do not disappear when a light cycle crashes.\n" +
                "Game 3: no additional CPU players.\n" +
                "Game 4: 2-player snake tail-biting game.\n" +
                "+4: add obstacles.\n" +
                "+8: add diagonal movement.",
            "filename" : "SNAFU.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Armada",
            "players" : "1 only",
            "description" : "Remember to clear the waves one column at a time.  You'll need all the time you can get on the higher levels to shoot the invaders before they land.  Starting on Level 5, when some of them are cloaked, memorize which ones you've shot.\n\n" +
                "Can you get to Level 12 in Game mode?",
            "filename" : "Space Armada.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Battle",
            "players" : "1 only",
            "description" : "Can you get All Clear at difficulty 4 or 5?\n\n" +
                "You'll need to choose when to Go To Battle and when to let the computer simulate the battle for you, because the alien squadrons continue to advance toward your Mothership at the higher levels while you're fighting an enemy fleet.",
            "filename" : "Space Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Hawk",
            "players" : "1 only",
            "description" : "Can you get to 200,000 points?\n\n" +
                "Fun fact: the \"black hole\" is actually a bug that causes the game to misread your controller input and send you into Hyperspace.",
            "filename" : "Space Hawk.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Spartans",
            "players" : "1 only",
            "description" : "Can you get to the final level?",
            "filename" : "Space Spartans.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Spiker Super Pro Volleyball",
            "players" : "Up to 2",
            "description" : "Although this was the last commercially-released Intellivision game, it was also a historic first.  This is the first game known to have a Baby Announcement easter egg.",
            "filename" : "Spiker Super Pro Volleyball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Stadium Mud Buggies",
            "players" : "Up to 2",
            "description" : "Fun fact: this game was renamed to Stadium Mud Buggies because INTV thought it would hurt sales of NES Monster Truck Rally if people knew it was based on an Intellivision game.",
            "filename" : "Stadium Mud Buggies.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Stampede",
            "players" : "1 only",
            "description" : "To earn the Activision Trail Drive badge, score 3,000 points or more.",
            "filename" : "Stampede.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Star Strike",
            "players" : "1 only",
            "description" : "Can you clear difficulty 5?  Can you get to 4 figures in difficulty 6?",
            "filename" : "Star Strike.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Star Wars: the Empire Strikes Back",
            "players" : "1 or 2",
            "description" : "",
            "filename" : "Star Wars.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sub Hunt",
            "players" : "1 only",
            "description" : "When you get close to the enemy convoy, the Destroyer will break rank and come after you.  Be sure to sink it before it disappears from your periscope view.  Otherwise, you'll have to cut your engine and sonar, dive deep, and wait for danger to pass, hoping not to get hit with a depth charge.\n\n" +
                "On higher difficulty levels, there will be two Destroyers to deal with in each convoy.  If a convoy reaches the enemy's harbor, it will pick up three more Destroyers for reinforcements.\n\n" +
                "Can you sink all 6 enemy fleets at all 5 difficulty levels?",
            "filename" : "Sub Hunt.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Cobra",
            "players" : "1 or 2",
            "description" : "Can you make off with the booty?",
            "filename" : "Super Cobra.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Pro Decathlon",
            "players" : "1-4 players alternating",
            "description" : "Can you earn a medal in all 10 events?",
            "filename" : "Super Pro Decathlon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Pro Football",
            "players" : "Up to 2",
            "description" : "Can you beat the CPU team at difficulty level 6 and up?",
            "filename" : "Super Pro Football.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Swords & Serpents",
            "players" : "1 or 2",
            "description" : "What will happen if you come face-to-face with the Sinister Serpent?",
            "filename" : "Swords & Serpents.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tennis",
            "players" : "2 only",
            "description" : "",
            "filename" : "Tennis.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Thin Ice",
            "players" : "1 or 2",
            "description" : "Don't forget to catch the lobsters when they appear.  You can press the Action button to use a lobster to stun the polar bears.  You'll need them on higher levels, especially when the lobsters get so fast, you can forget about catching any more of them.\n\n" +
                "You'll want to get the hang of knowing what causes cracks to disappear and when.  Use it to your advantage to confuse the seal when she's following the cracks:\n\n" +
                "If the third crack \"overbites\" past where the first crack started, the first crack will disappear.\n\n" +
                "If you turn away from the first crack after the second crack, the first crack will disappear.  If you turn away from the second crack after the third crack, both the first and second cracks will disappear.  You can quickly get rid of old cracks to confuse the seal by \"zigzagging\".\n\n" +
                "All cracks will disappear if:\n" +
                "You swim in the water,\n" +
                "A penguin or polar bear steps on a crack,\n" +
                "You complete a loop but there is nobody to dunk.\n\n" +
                "You can stop moving by trying to move in the direction opposite your current direction.  You can also turn around at the exact moment the cracks disappear, or when you're swimming.\n\n" +
                "Can you get to 300,000 points?",
            "filename" : "Thin Ice.itv",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Thunder Castle",
            "players" : "1 or 2",
            "description" : "Can you clear all the stages twice?\n\n" +
                "Here is the list of items:\n\n" +
                "Pile of coins: 500 points.\n" +
                "Candlestick: Extra life.\n" +
                "Hair comb: lose half your points.\n" +
                "(The following you can only have one at a time.)\n" +
                "Grail: invincibility when activated.\n" +
                "Crown: freeze enemies when activated.\n" +
                "Necklace: temporarily speed up when activated.\n" +
                "Lantern: double invincibility time.\n" +
                "Key: move into a gate or window.\n" +
                "Ring: teleport to random location when activated.",
            "filename" : "Thunder Castle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Tower of Doom",
            "players" : "1 only",
            "description" : "This game was designed to be an action-based roguelike, and so it uses only the disc and three unique Action Buttons - no keypad.  Your controls are:\n\n" +
                "Top Buttons - Use the equipped item,\n" +
                "Bottom Buttons - Switch to Inventory Mode.\n\n" +
                "While in Inventory Mode:\n" +
                "Top Buttons - Use the selected item,\n" +
                "Bottom Right Button - Equip the selected item,\n" +
                "Bottom Left Button - Drop the selected item (will give it to the enemy during a fight - if accepted, enemy goes away and your Diplomacy stat increases).\n" +
                "The '?' icon cycles through your stats.\n\n" +
                "You can only carry 8 items at a time, including the equipped item.  That means there will always be one gap in your inventory when an item is equipped.  If you pass over an item and can't pick it up, you have to use up an item or drop one first.\n\n" +
                "You can't drop items while standing near some walls.  If you're trying to drop an item and can't, move to an open area and try again.\n\n" +
                "Get to know the various traps.\n" +
                "Teleport Trap (orange, looks like \"TV snow\"),\n" +
                "Halt Trap (white and round), keep moving until you're past the trap.\n" +
                "Confusion Trap (orange and round), all disc input is scrambled for a period of time.  Get off the trap, open your Inventory, and move the hand cursor until the confusion wears off.\n" +
                "Other traps, like fire and gas clouds, will reduce your HP, reduce your Strength, or reduce your Life Force.\n\n" +
                "Life Force is the inverse of how hungry you are.  You'll get two warnings that you're hungry: \"Life Force is low\" and \"Life Force critical\".  After that, your HP will start to drain.  That's the time to eat a chicken wing to replenish your Life Force.  Your HP does not replenish from eating.  Food is scarce on harder quests, so hoard it when you can.\n\n" +
                "Some weapons are m\xeal\xe9e-only, some are ranged-only, and some can be used both ways.  You can tell whether or not a weapon can be used in m\xeal\xe9e combat by the presence or absence of a sword in your character's hand in the gameplay window.  Ranged weapons change in color as their number of uses diminishes.  If you're using a powerful ranged weapon, beware of backflash.  Try playing as the Warlock if you want to try such weapons.  You have to equip one from your inventory first.\n\n" +
                "Can you complete the Wizard Hunt and Grail Quest?",
            "filename" : "Tower of Doom.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Triple Action",
            "players" : "Game 1 (Tanks): 2-player only.\n" +
                "Game 2 (Racing Cars): 1 or 2 players.\n" +
                "Game 3 (Biplanes): 2-player only.",
            "description" : "Options for Game 1:\n\n" +
                "1 - Long-range bouncing shells.\n" +
                "2 - Short-range bouncing shells.\n" +
                "3 - Long-range shells.\n" +
                "4 - Short range shells.\n\n" +
                "Options for Game 2:\n\n" +
                "1 - Normal traffic.\n" +
                "2 - Heavier traffic.\n\n" +
                "Options for Game 3:\n\n" +
                "1 - Short-range rounds.\n" +
                "2 - Long-range rounds.",
            "filename" : "Triple Action.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Triple Challenge",
            "players" : "Game 1 (Chess): Up to 2 players.\n" +
                "Game 2 (Checkers): 1 or 2 players.\n" +
                "Game 3 (Backgammon): 1 or 2 players.",
            "description" : "In Checkers, the victory fanfare was replaced with something shorter.  INTV cannibalized the original music to make room for the main menu.\n\n" +
                "INTV was on the fence whether or not to include Reversi.  They decided to leave it out, but there is still code in the menu to look for Reversi and add it as a fourth option if found.  As a result, some of us created a ROM hack and called it \"Quad Challenge\".\n\n" +
                "Another fun fact: you might recall that Chess requires 2K of additional onboard RAM for the CPU players.  INTV happened to find a company that wanted to unload a batch of defective 4K RAM chips, bought the chips \"for a song\", and enabled only the half that worked fine.",
            "filename" : "Triple Challenge.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Deadly Discs",
            "players" : "1 only",
            "description" : "There is a bonus for derezzing all three enemies before one of them respawns, so attack quickly.\n\n" +
                "Doors are blue when enemies appear, and will turn green if you jam them open.  You jam open doors by walking into them or by throwing your disc at them.  The more doors that are jammed open, the longer it will take the Recognizer to repair them all, giving you more time to disable the Recognizer for another bonus.\n\n" +
                "You start with 3 HP.  Max HP goes to 4 when your score reaches 5 figures, and to 5 when your score reaches 6 figures.  Your HP recovers over time, and you can recover it immediately by performing Illegal Exits between opposite doors that are jammed open.  Your only indicator of low HP is how slow you're moving.\n\n" +
                "Get to know the different enemy and disc colors:\n\n" +
                "Warriors are light blue and have only one HP.\n\n" +
                "Bulldogs are purple and have two HP.  They appear when your score gets to 5 figures.\n\n" +
                "Leaders are dark blue and have only one HP, but the other enemies are more difficult in their presence.  They may also carry the other disc types.  At 6 figures, the original Warriors no longer appear.\n\n" +
                "Guards are orange and have four HP.  They appear when your score gets to 7 figures.  Instead of discs, they carry paralyzer sticks that will end the game immediately.\n\n" +
                "Blue discs are standard enemy discs.\n" +
                "Brown discs do double damage.\n" +
                "White discs home in on you.  You might want to use your disc as a shield to shatter these ones.\n\n" +
                "Pressing the 5 key raises your disc as a shield.  Pressing the 5 key a second time makes you duck.  You can press any key while your disc is traveling to recall it.\n\n" +
                "Here's a pro tip: you can move and fire at the same time if you use the disc on one controller and the keypad on another controller.\n\n" +
                "Can you get to 7 figures?",
            "filename" : "Tron Deadly Discs.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Maze-a-Tron",
            "players" : "1 only",
            "description" : "The standard title screen speed controls apply here, so if the screen is panning too fast for you, try pressing 1, 2, or 3 at the title screen.  Press Enter at the \"Practice?\" prompt to try playing against the MCP at Difficulty 0.\n\n" +
                "The three numbers that appear before the action begins are:\n" +
                "Your shield strength (purple is weak, yellow is average, red is strong),\n" +
                "number of Zeroes you've collected,\n" +
                "number of lives remaining.\n\n" +
                "Standing in a Transformer charges up your Force Shield a little at a time.  Remember to use your Force Shield (bottom Action Buttons) to disable the Recognizer and when passing through Force Fields between the ROM chips.  Also use your Force Shield when the MCP fires at you from its eyes.\n\n" +
                "There are four maps in total.  The RAM chips which you are looking for are on two of those maps, but the starting map is not one of them.  Use the large I/O Interface to teleport to a random location on a random map.  There is Redundancy between the two sets of RAM chips, so you only need to zero out one set.\n\n" +
                "The number of Zeroes you collected from the Latches (they look like padlocks) carries from one level to the next, in case you're wondering why you would need to collect so many of them.  Use a Zero (Top Action buttons) if you accidentally freeze one of the RAM bits to a 1 instead of a 0.  Also, put the Flip Flops to use (they contain a pair of arrows pointing in opposite directions) to make more than one sweep across the RAM chips.  If need be, use the Stop button (key 0) to stop the screen panning for two seconds at the expense of 30 Force Shield energy units.\n\n" +
                "You earn more bonus points based on how long it takes you to zero out the RAM chips.\n\n" +
                "When you reach the MCP, you're supposed to compare each pair of bits in the Bit Stream (the two columns closer to the middle) with the pair of bits at the top of the Stack (the top two corners of the screen).  If there's a match, zap that pair of bits with your Bit Gun to turn them black.  When they go off the top of the screen, you earn points if the pattern matches and both bits are turned black.  If the pattern matches and at least one bit is not turned black, the Stack pops (both columns at the far edges of the screen move up one position).  The MCP round ends when the Stack is emptied or you get zapped three times.  After that, start over at a higher difficulty level.\n\n" +
                "Can you get to 20,000 points?",
            "filename" : "Tron Maze-A-Tron.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tron Solar Sailer",
            "players" : "1 only",
            "description" : "Use the keypad to change direction at the next intersection when your energy gets low.  How much energy you'll have when you change lanes has to do with the number of Grid Bugs in that lane.  Use the disc to shoot at the red tanks that shoot back at you.  You'll have to switch lanes at least two times to get fully up to speed.\n\n" +
                "Here's a tip: the first digit of the Access Code is always the Track Number.  The second digit is always the Target Sector.  That leaves you only having to remember 3 digits.\n\n" +
                "Can you find the Easter Egg message?  Can you beat the MCP?",
            "filename" : "Tron Solar Sailer.rom",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tropical Trouble",
            "players" : "1 or 2",
            "description" : "To begin, press:\n" +
                "4 - 1-player Easy,\n" +
                "5 - 1-player Medium,\n" +
                "6 - 1-player Hard,\n" +
                "7 - 2-player Easy,\n" +
                "8 - 2-player Medium,\n" +
                "9 - 2-player Hard.\n\n" +
                "To restart, press Enter.\n\n" +
                "Can you complete 5 islands?",
            "filename" : "Tropical Trouble.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Truckin'",
            "players" : "1 or 2",
            "description" : "Remember to keep the Road Map handy.  Download a picture of it and print it off if need be.\n\n" +
                "This game has perhaps the steepest learning curve of all the original Intellivision games.  Figuring this game out is a very rewarding endeavor.  Start with Game 1, which is just the Road Race, and then move on to Game 2.\n\n" +
                "The first thing you have to do is get gas.  Press the 8 key once you start the game and wait until your tank is full.  The cost of gas changes based on where you are.  It's cheapest in oil fields (where the ground is brown).\n\n" +
                "Perhaps the hardest thing to master is making turns.  You will crash unless your speed is below 24 MPH.  When the ground turns grey, you're at a set of highway exits.  Slow down and move your cab close to the edge of the road.  Press the top of the disc to straighten out the wheel, because you'll lose all your speed if you collide with the road's edge before you're at the exit, and then you're likely to speed up too much to compensate and end up missing your turn.  As soon as the highway exit is next to your cab, that's the moment you want to move to the edge.\n\n" +
                "Speed down the highway if you want to catch up, but watch out for a traffic cop to appear in your rear-view mirror.  You will still get a speeding ticket if you're driving exactly the speed limit.  Yep.\n\n" +
                "In case you're wondering why I mentioned Large Marge, it's because the instruction manual documented a bug as a feature, called \"Ghost Trucks\" which suddenly disappear from the road on occasion.\n\n" +
                "Can you find Imagic Headquarters?",
            "filename" : "Truckin'.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Turbo",
            "players" : "1 only",
            "description" : "This game uses the second controller only.  Rotate the disc to steer.\n\n" +
                "Can you complete 2 levels?",
            "filename" : "Turbo.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Tutankham",
            "players" : "1 or 2",
            "description" : "Remember to use the Bottom Action keys to shoot, because the Top Action keys are to activate the Flash Bomb.  You get one Flash Bomb per life.  You can also use the 4 and 6 keys to shoot, if that seems more intuitive.\n\n" +
                "Can you get the treasure in all four chambers?",
            "filename" : "Tutankham.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "USCF Chess",
            "players" : "Up to 2",
            "description" : "Due to the CPU behavior, an errata slip was included to warn players that at difficulty levels 4 and above, the computer might take hours or even days to make a single move.",
            "filename" : "Chess.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "U.S. Ski Team Skiing",
            "players" : "1-6 players alternating",
            "description" : "Can you find the Easter Egg message?",
            "filename" : "Skiing.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Utopia",
            "players" : "2 only, but that doesn't stop players from playing alone",
            "description" : "\"Term of Office\" is the number of rounds, and can range from 1-50.  \"Turn length\" is the number of seconds in each round, range 30-120.\n\n" +
                "Both islands are the same size - 29 Hectares.  They also tend to get the same amount of weather activity, although most people assume Player 1 has the weather advantage since all weather originates from the Northwest, and due to the peninsula on that island.\n\n" +
                "Forts' (key 1, cost 50 GB) only purpose is to protect adjacent buildings from occupied invasions.  They will also protect your fishing vessels from pirates and your opponent's PT Boats, as long as they are docked.\n\n" +
                "You earn 10 Gold Bars in base tax revenue after each round, but Factories (key 2, cost 40 GB) earn you a minimum of 4 additional Gold Bars apiece in tax revenue.  They also increase your population's mortality rate, slowing down population growth.\n\n" +
                "A hectare of crops (key 3, cost 3 GB) feeds 500 people until it disappears, and earns you money when rained on.  Insufficient food is the most surefire way to get Occupied Zones on your island, which you don't want.\n\n" +
                "Indoctrination clinics (key 4, cost 35 GB) lower your island's fertility rate, further slowing down population growth.\n\n" +
                "Hospitals (key 5, cost 75 GB) are something your people want for healthcare infrastructure.  They also lower mortality rate, increasing the rate of population growth.\n\n" +
                "Residential housing (key 6, cost 60 GB) is another thing your people want, so provide that as soon as you have the means to.\n\n" +
                "Mercenaries (key 7, cost 30 GB) attack your opponent by establishing an Occupied Zone, which may wipe out something important and disrupt production, affecting your opponent's approval rating.\n\n" +
                "PT Boats (key 8, cost 40 GB) halt pirate ships and sink your opponent's fishing vessels unless docked next to a Fort.\n\n" +
                "Fishing vessels (key 9, cost 25 GB) feeds 500 people and earns you money by passing over schools of fish.  When you're done spending money at the beginning of the round, you'll spend your time fishing.  Remember to avoid pirates and your opponent's PT boats, not to mention bad weather.\n\n" +
                "Remember that the object of the game is to outscore your opponent.  Your approval rating is added to your score at the end of each round, so know what your people want and provide it for them.",
            "filename" : "Utopia.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Vectron",
            "players" : "1 or 2",
            "description" : "I have a Playthrough video on my YouTube channel, where I also explain the gameplay.  Try watching the video if you need more help understanding what you're supposed to do in this game.\n\n" +
                "Can you meet the Dare on the back of the box and clear Level 10?",
            "filename" : "Vectron.rom",
            "ecs" : 0, "intellivoice" : 0, "gram" : 0, "params" : "--kbdhackfile=\"" + workingpath + "veckeys.cfg\""
        }, {
            "name" : "Venture",
            "players" : "1 or 2",
            "description" : "Can you fill up the Treasure chamber at all difficulty levels?",
            "filename" : "Venture.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "White Water",
            "players" : "1 only",
            "description" : "To begin, press Clear to go to the Game Selection screen.  Then press:\n\n" +
                "1 - Game 1.  Race to the end of the river with a slower current.  Nobody falls out of the kayak.\n\n" +
                "4 - Game 2.  Race to the end of the river with a faster current.  Nobody falls out of the kayak.\n\n" +
                "7 - Game 3.  Race to the end of the river with a slower current.  Going forward, somebody will fall out of the kayak if you hit a rock.\n\n" +
                "2 - Game 4.  Race to the end of the river with a faster current.\n\n" +
                "3 - Game 5.  Race to get 3 urns and a treasure chest in the shortest time possible.  Slower river current.\n\n" +
                "6 - Game 6.  Race to get 3 urns and a treasure chest in the shortest time possible.  Faster river current.\n\n" +
                "9 - Game 7.  Earn points by collecting treasure.  River current starts slow and gets progressively faster.\n\n" +
                "Press Enter to begin the game.\n\n" +
                "Can you get to 5,000 points in Game 7?  Can you find the Easter Egg message?",
            "filename" : "White Water.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "World Championship Baseball",
            "players" : "Up to 2",
            "description" : "For your amusement, read the disclaimer on the back of the instruction manual.",
            "filename" : "World Championship Baseball.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "World Cup Soccer",
            "players" : "Up to 4 (up to 2 players per team)",
            "description" : "",
            "filename" : "World Cup Soccer.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "World Series Major League Baseball",
            "players" : "Up to 2",
            "description" : "At the title screen press:\n" +
                "C - 2-CPU demo,\n" +
                "A - Play as American League,\n" +
                "N - Play as National League,\n" +
                "Space - 2-player game\n" +
                "Then press Return to begin.",
            "filename" : "World Series Major League Baseball.bin",
            "ecs" : 1, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : "-m2 --ecs-tape=\"" + jzintvpath + "ecs_tape_wmlb.ecs\""
        }, {
            "name" : "Worm Whomper",
            "players" : "1 or 2",
            "description" : "To earn the Activision Worm Whompers badge, score 75,000 points or more.",
            "filename" : "Worm Whomper.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Zaxxon",
            "players" : "1 or 2",
            "description" : "",
            "filename" : "Zaxxon.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 29, "Unreleased"
            "name" : "Adventures of Tron",
            "players" : "1 only",
            "description" : "Tron rides the I/O Beam in to the arena.  Jump up to collect all the Bits, and then ride the I/O Beam up to the next level.\n\n" +
                "Ride the lifts up to the second tier.  From there, you have to jump across the I/O Beam to enable the lifts to ride one more tier at a time.  Jump over Recognizers and tanks that may fire back.  Fall through the floor to a lower tier if you need to duck out of trouble.  On the third tier, you can grab the Solar Sailer to ride over the enemies.\n\n" +
                "Can you get to 5 figures?",
            "filename" : "Adventures of TRON.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Astrosmash Competition",
            "players" : "1 only",
            "description" : "A special edition of Astrosmash with a user-defined time limit.  Mattel Electronics created this for their \"Astrosmash Shootoff\" contest.",
            "filename" : "Astrosmash Competition.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Brickout",
            "players" : "1 only",
            "description" : "An extra game that was to have been included into Triple Action, back when it was going to be called \"5-in-1 Arcade\".  It was abandoned probably because Mattel Electronics was afraid of a lawsuit from Atari.",
            "filename" : "Brickout.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Deep Pockets Super Pro Billiards",
            "players" : "1 or 2",
            "description" : "This is the other game that INTV Corporation wanted to release after Stadium Mud Buggies and Spiker Super Pro Volleyball.",
            "filename" : "Deep Pockets.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Duncan's Thin Ice",
            "players" : "1 or 2",
            "description" : "This is the version of Thin Ice that Mattel Electronics had completed and was about to release before the industry crash.  It includes an attract-mode cutscene with a close-up picture of Duncan the Penguin, and adds names to the other penguins.\n\n" +
                "It was also meant to be a cross-promotion for the 1984 Winter Olympic Games.  If you hold the Enter key on the left controller and the Clear key on the right controller and Reset, you will activate an Easter Egg to play as (it's pronounced \"Voochko\") Vu" + "\u010d" + "ko the Wolf, the 1984 Winter Olympic Games' official mascot.  This changes the attract mode screens as well.  Vu" + "\u010d" + "ko is spelled phoenetically in this game for reasons you can probably guess.\n\n" +
                "The music for Thin Ice was composed by none other than George \"The Fat Man\" Sanger, who went on to become known as the father of MIDI music.",
            "filename" : "Thin Ice (16K).rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "The Flintstones' Keyboard Fun (ECS)",
            "players" : "1 only",
            "description" : "Two games in one, which use only the ECS Computer Keyboard:\n\n" +
                "Games 1-3.  Help Fred Flintstone at the Rock Quarry by entering the keys at the appropriate time.\n\n" +
                "Games 4-5.  Guide Pebbles through the hedge maze.  Press the appropriate letter to move Pebbles from one node to the next.  Collect flowers for points.  Reach the end of each maze and press Escape to move on to the next maze.  If you collect the requisite number of letters along the way, you will earn bonus time.  In Game 5, letters disappear when you collect them, preventing you from backtracking.",
            "filename" : "Flintstones Keyboard Fun.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Game Factory (ECS)",
            "players" : "1 only",
            "description" : "Make your own games without having to learn to write code!  A full library of ready-made graphics and background scenes is available, plus a demo game ready to play.  Save your games to tape for future re-use.",
            "filename" : "Game Factory.itv",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "Go For The Gold",
            "players" : "Game 1 (Skiing): 1-6 players alternating.\n" +
                "Game 2 (Hockey): 2-player only.\n" +
                "Game 3 (Boxing): 2-player only.\n" +
                "Game 4 (Basketball): 2-player only.",
            "description" : "A sports multicart intended to be a cross-promotion for the 1984 Winter Olympic Games.  The music was recycled into Super Pro Decathlon.",
            "filename" : "Go For The Gold.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Illusions",
            "players" : "1 only",
            "description" : "You have been split into multiple images.  Reunite the images before time runs out.\n\n" +
                "The Colecovision port was released by Coleco.",
            "filename" : "Illusions.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Land Battle",
            "players" : "2 only",
            "description" : "A 2-player combat simulation that combines action and strategy.  Capture the opponent's flag first.\n\n" +
                "This game has a greater amount of complexity, like Sea Battle.  You'll want to keep the instructions handy as you learn the various aspects of the game.",
            "filename" : "Land Battle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Magic Carousel (Intellivoice)",
            "players" : "1 only",
            "description" : "An educational title to teach children to follow vocal instructions.\n\n" +
                "Start by tapping the disc when the indicated animal on the carousel is right in front of you.  Then answer the telephone (press the 0 key) and do the various things you are instructed to do, like blowing up balloons, playing a record, and so on.\n\n" +
                "A number in the corner of the screen tells you which key to press for each command.",
            "filename" : "Magic Carousel.itv",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Map Mazes (Tutorvision)",
            "players" : "1 only",
            "description" : "INTV Corporation was working on a proprietary Intellivision console that would have been licensed to World Book Encyclopedia, getting in at the forefront of the Edutainment industry.  16 games were developed and debuted at the Summer 1989 Consumer Electronics Show, 8 in each of two children's age groups.  Among those games, this is one of only two that have been discovered and made widely available to date.  The \"Level 1\" games featured a mascot named Tutor Tiger.\n\n" +
                "Learn to obey road signs and follow directions as you: make your way home, deliver pizzas, or find a lost zoo animal.",
            "filename" : "Map Mazes.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 2, "params" : ""
        }, {
            "name" : "Meteor",
            "players" : "1 only",
            "description" : "This was the first idea Mattel Electronics had for Astrosmash.  But they were worried Atari would sue for copyright infringement because it too closely resembled Asteroids, so they went back to the drawing board.  This game was later re-developed into Space Hawk.\n\n" +
                "As it turns out, this game is still buried inside Astrosmash.  There is even a menu to select Game 1 (Astrosmash) or Game 2 (Meteor), but there is no way to access it without a ROM hack.",
            "filename" : "Meteor.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Number Jumble (ECS)",
            "players" : "1 only",
            "description" : "Three out of four vehicles are offered to you.  Choose one and take off into various places, firing up, down, or straight at enemies, which then turn into numbers.  Solve math problems when two numbers appear and earn bonus points.  Continue until the portal appears to return home.\n\n" +
                "Use of the ECS in this game is optional.  It only uses the Computer Keyboard to allow you to \"show your work\" on the screen.",
            "filename" : "Number Jumble.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Party Line",
            "players" : "Two teams",
            "description" : "Guests at a party are divided into two teams.  Enter the number of players on each team, the number of rounds, and round length, and the game begins.  Two players, one from each team, compete until a timer runs out, at which point the controllers are handed off to the next person on each team.  These games are colorful, simple, and feature loud, nonstop music.\n\n" +
                "Blow Out:\n" +
                "Two roller-skating dancers drop darts from a scaffold onto rising balloons.  Try to knock each other off the scaffold.  When the music stops, that's the signal for the next players to take the controllers.\n\n" +
                "Hard Hat:\n" +
                "Each team is building a skyscraper.  Climb the plumbing and time your fall onto the center platform, which is stacked with glass panes.  Use the Action Button to grab a pane, carry it to your building, and use the Action Button again to set the pane.  Try to throw the platform off balance to slow down the other player.  First team to complete their skyscraper wins.\n\n" +
                "Space Cadet:\n" +
                "Grab stars with your flying saucer to hurl at the opponent's planet.  Knock the opposing player into the orbiting moon for interference.",
            "filename" : "Party Line.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Shapes In Space (Tutorvision)",
            "players" : "1 only",
            "description" : "INTV Corporation was working on a proprietary Intellivision console that would have been licensed to World Book Encyclopedia, getting in at the forefront of the Edutainment industry.  16 games were developed and debuted at the Summer 1989 Consumer Electronics Show, 8 in each of two children's age groups.  Among those games, this is one of only two that have been discovered and made widely available to date.  The \"Level 1\" games featured a mascot named Tutor Tiger.\n\n" +
                "Learn fractions as you enjoy space-themed animations.",
            "filename" : "Shapes In Space.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 2, "params" : ""
        }, {
            "name" : "Soccer 2 (ECS)",
            "players" : "Up to 4 (up to 2 players per team)",
            "description" : "One of two discovered World Cup Soccer prototypes.  This one includes actual product placement.",
            "filename" : "Soccer 2.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Spina the Bee",
            "players" : "1 only",
            "description" : "Spina the Bee was a cartoon character in Europe.  This game was developed at the Mattel Electronics office in Nice, France, which also developed World Cup Soccer and Championship Tennis, and later became Dextell, Ltd.\n\n" +
                "Collect pollen for points.  Watch out for raindrops, and don't get trapped and go off screen.",
            "filename" : "Spina the Bee.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super NFL Football (ECS)",
            "players" : "Up to 2",
            "description" : "An updated football game which displays the field at an angle and includes computer play.  It also adds features like creating your own custom playbook and saving it to tape for future re-use.",
            "filename" : "Super NFL Football.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "-m2"
        }, {
            "name" : "Super Soccer (ECS)",
            "players" : "Up to 4 (up to 2 players per team)",
            "description" : "One of two discovered World Cup Soccer prototypes.  The other Dextell game, Championship Tennis, is rumored to have a prototype version called Doubles Tennis with 4-player support, but no ROM image has ever turned up to my knowledge.",
            "filename" : "Super Soccer.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Takeover",
            "players" : "2 only",
            "description" : "Mattel Electronics' take on the board game Risk.\n\n" +
                "At the title screen, press key 1-4 to select a board.  Board 1 is the default if you press any other key.",
            "filename" : "Takeover.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Yogi's Frustration",
            "players" : "1 only",
            "description" : "Yogi Bear is under punishment for accidentally grabbing Ranger Smith's hat while fishing for picnic baskets from a tree branch.  Play as BooBoo, delivering picnic baskets full of goodies to the top of a conveyor belt system to keep Yogi busy.\n\n" +
                "This was originally called Modern Times and was loosely based on a Charlie Chapman skit of the same name.  It was near completion when the Marketing Department decided to tack Yogi Bear onto the project to fulfill a Hanna Barbera license agreement.  The same thing had happened with Scooby Doo's Maze Chase, which was originally called Three Blond Mice (that's not a typo).",
            "filename" : "Yogi's Frustration.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 30, "Unfinished"
            "name" : "Air Strike",
            "players" : "1 only",
            "description" : "An extra game that was to have been included into Triple Action, back when it was going to be called \"5-in-1 Arcade\".  This game is similar to the arcade game Scramble, but with the flying mechanic from Triple Action's Biplanes.  I listed it as Unfinished because there is no challenge once you reach a certain altitude.",
            "filename" : "Air Strike.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Choplifter",
            "players" : "1 only",
            "description" : "Based on the arcade game by Sega.  The sound engine hadn't been developed yet, and so subtitles appear in lieu of actual sound effects, but the game is playable enough.",
            "filename" : "Choplifter.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : "Crazy Clones",
            "players" : "1 only",
            "description" : "Touch the other running men but avoid that red thing.",
            "filename" : "Crazy Clones.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "King of the Mountain",
            "players" : "1 only",
            "description" : "Make your way to the top of each mountain.  Plan your trip carefully with your limited funds.  You'll need food, water, camping gear, ammo for your gun, and so on.  Prepare for changes in the weather, wildlife encounters, and rockslides.\n\n" +
                "This version has no sound and doesn't continue past the first mountain.  Dave Harley completed it later on, and the Blue Sky Rangers listed it as a finished product for sale.",
            "filename" : "King of the Mountain.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "League of Light (Activision)",
            "players" : "1 only",
            "description" : "Similar to the game Master of the Lamps on the Commodore 64.  Fly your magic carpet between the gates in 3-D space and don't miss.",
            "filename" : "League of Light.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Quest (Intellivoice)",
            "players" : "1 only",
            "description" : "Another game that was meant to have a Dungeons & Dragons license.",
            "filename" : "Quest.bin",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Robot Rubble (Activision)",
            "players" : "1 only",
            "description" : "Throw grenades from the foreground to the background to blow the evil robot's head off, and lob another grenade to finish it off before it reassembles itself.  Watch out for that laser fire.",
            "filename" : "Robot Rubble.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Rocky & Bullwinkle",
            "players" : "1 only",
            "description" : "Boris has delevoped \"Upsidasium\" to float items up from a train.  Natasha flies a helicopter overhead to catch the items.  Fly Rocky through the sky to recapture the items and deliver them to Bullwinkle.",
            "filename" : "Rocky & Bullwinkle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Scarfinger",
            "players" : "1 only",
            "description" : "Inspired by James Bond films.  Drive your Spycycle up the twisty mountain road.  Don't crash, and watch out for enemy missiles.",
            "filename" : "Scarfinger.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space C@nt (Intellivoice)",
            "players" : "1 only",
            "description" : "Yes, this is real!  No, it was never intended for release.  It was discovered among source code from other unfinished projects.\n\n" +
                "While Tron Solar Sailer was in development, the programmers realized the phrase \"I can't allow this\" sounded a little different when downsampled for the Intellivoice.  As a joke, they took the game Astrosmash and gave it X-rated graphics.  Use the Intellivoice to hear a variation of the Space Spartans title with the word Spartans spliced out and replaced out with that other word which is supposed to be Can't but sounds like something else.\n\n" +
                "Not all the graphics were updated.  The falling rocks were replaced with Recognizers, for example.  There is a bootleg release which replaces the falling rocks once again with something resembling a graphic from a PC-DOS game called Astrotit.  You can probably guess what it is.",
            "filename" : "Space Cunt.bin",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Shuttle (Intellivoice)",
            "players" : "1 only",
            "description" : "Blast off and orbit around Earth as you perform various tasks like repairing satellites.  Be sure to refuel during orbits.  Multiple views and voices help you to accomplish your mission and make a safe landing.",
            "filename" : "Space Shuttle.bin",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Masters of the Universe",
            "players" : "1 only",
            "description" : "He-Man returns to battle Skeletor once again.\n\n" +
                "As you might have noticed, the rooms were recycled into the levels of Diner.",
            "filename" : "Super Masters.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 31, "Demos & Utilities"
            "name" : "1978 Demo",
            "players" : "None",
            "description" : "There were multiple versions of this original store demonstration cartridge.  This one advertises the Keyboard Component.",
            "filename" : "1978 Demo.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Demo Cart Int'l",
            "players" : "None",
            "description" : "The cartridge for this store demo had a red label and a 1982 copyright date.",
            "filename" : "Demo Cart International.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Demo Cart '83 (Intellivoice)",
            "players" : "None",
            "description" : "The cartridge for this store demo had an olive green label with a font resembling Century Gothic.\n\n" +
                "The title \"Intellivision still the Intelligent Choice\" is in response to the release of the Colecovision.  B-17 Bomber is one of the games on this demo, and so it uses the Intellivoice.",
            "filename" : "Demo Cart 83'.bin",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Easter Eggcitement (Happy Holidays)",
            "players" : "1 only",
            "description" : "Happy Holidays was to have been a demo of multiple games' being bundled into a single album.  None of these games were finished.",
            "filename" : "Easter Eggcitement.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Grid Shock",
            "players" : "1 only",
            "description" : "Mattel Electronics was working on an Intellivision III console to compete with Colecovision.  Not to be confused with the Intellivision III console released by INTV Corporation, this would have been an entirely new console.  It didn't get past the concept phase.\n\n" +
                "Grid Shock was made to be visually impressive.  It was demoed at the 1983 Consumer Electronics Show, and Mattel Electronics told the public it was an Intellivision III tech demo.  There was one other title, Treasure of the Yucat\xe1n, which was nothing more than an impressive-looking still image.\n\n" +
                "Shoot the spinning tile to color squares into the grid.  Try making shots bounce off the moving wall.",
            "filename" : "Grid Shock.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Hypnotic Lights",
            "players" : "1 only?",
            "description" : "A demo of a kaleidoscopic effect.  There's a game in there somewhere ...",
            "filename" : "Hypnotic Lights.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Killer Bees (Debugger)",
            "players" : "1 only",
            "description" : "A debug program with a sort of game wrapped around it.",
            "filename" : "killerbees.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Killer Songs!!",
            "players" : "1 only",
            "description" : "Press 1-6 to hear some tunes.  Pressing any other key crashes the program.\n\n" +
                "To close jzIntv following an Intellivision crash, Type 'q' and press Enter in the terminal window.  I disabled displaying jzIntv messages in the Windows port of PIDEjL because it takes an abnormally long time to draw text, contrast Linux which is almost instantaneous.",
            "filename" : "Killer Songs.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Santa's Helper (Happy Holidays)",
            "players" : "1 only",
            "description" : "Happy Holidays was to have been a demo of multiple games' being bundled into a single album.  None of these games were finished.",
            "filename" : "Santa's Helper.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Trick or Treat (Happy Holidays)",
            "players" : "1 only",
            "description" : "Happy Holidays was to have been a demo of multiple games' being bundled into a single album.  None of these games were finished.",
            "filename" : "Trick or Treat.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Freewheel Diagnostics",
            "players" : "1 only",
            "description" : "This was created by the indie studio Freewheel Games to autodetect all your Intellivision hardware and perform various hardware tests.\n\n" +
                "In case you were wondering this whole time about the GRAM options, now is a good time for me to explain:\n\n" +
                "The Intellivision II was discovered to have double the regular amount of Graphics RAM (GRAM), but the GRAM chips are wired to disable the extra amount, ostensibly for compatibility reasons.  With a little rewiring, the extra Graphics RAM can be enabled.  To date, no software has been made to utilize Double GRAM, which is why I enabled it here for demonstration purposes.\n\n" +
                "The World Book Tutorvision has quadruple the Graphics RAM of the original Intellivision.  As it turns out, the Intellivision's original memory mapping allows for the full amount of Graphics RAM that the Tutorvision has.  Perhaps it would have cost that much more to have had the full amount in 1979.  The Intellivision was already $100 more expensive than the Atari VCS, in 1979 dollars.",
            "filename" : "FW Diagnostics.rom",
            "ecs" : 1, "intellivoice" : 1, "grom" : 0, "gram" : 1, "params" : ""
        }, {
            "name" : "Spirit Demo",
            "players" : "None",
            "description" : "There are essentially two demos here.  Press any key to change from the first demo to the second one.\n\n" +
                "This was created by Arnauld Chevallier all the way back when the indie scene was still in its infancy, and is still one of the most beloved \"demo scene\" Intellivision titles.",
            "filename" : "Spirit Demo.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Castle Trailer",
            "players" : "None",
            "description" : "After the release of Spirit Demo, Arnauld Chevallier released this trailer.  The actual game never came to be.",
            "filename" : "Castle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Bad Apple",
            "players" : "None",
            "description" : "Decle wrote this at a time when people were porting Bad Apple to every classic game console.  The extra sound chip of the ECS Computer Adaptor is put to use here to enhance the music.",
            "filename" : "badApple.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }), ({

            # Group 32, "Indie Games"
            "name" : "4-Tris",
            "players" : "1 only",
            "description" : "A port of Tetris, by Joseph Zbiciak.  Excellent Nutcracker soundtrack and arcade-style sound effects.\n\n" +
                "Press 4 to enable the Next feature, and press 7 to pause the game.\n\n" +
                "Can you find the Pong Easter Egg?",
            "filename" : "4-Tris.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Stonix",
            "players" : "1 or 2",
            "description" : "A clone of Arkanoid, by Arnauld Chevallier.  A password feature saves your progress after every 5 levels completed.  Bonus life every 500 points.  Excellent soundtrack, fluid animation, and responsive controls.\n\n" +
                "Can you clear all 100 levels?\n\n" +
                "The powerups are:\n" +
                "B (Bonus) - bonus life,\n" +
                "50 (50 points),\n" +
                "D (slow Down),\n" +
                "L (Large paddle),\n" +
                "S (Strong ball) - pass through breakable bricks,\n" +
                "M (Multiball) - ball splits in two,\n" +
                "Z (Zapper) - use the Action button to shoot lasers at the bricks,\n" +
                "E (Energize) - catch the ball.  Yep.",
            "filename" : "stonix.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Minehunter",
            "players" : "1 only",
            "description" : "A clone of Minesweeper by Ryan Kinnen.",
            "filename" : "Minehunter.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "SameGame & Robots",
            "players" : "1 only",
            "description" : "Two games in one, both written by Michael Hayes and enhanced by David Harley.\n\n" +
                "SameGame:\n" +
                "Select a cluster of two or more identical shapes to remove from the board.  When pieces disappear, higher pieces fall down, and columns squeeze together when one column is emptied.  Earn more points for eliminating larger clusters in a single move.  Removing a single piece costs 100 points.\n\n" +
                "SameGame Pro:\n" +
                "Removing a single piece is disallowed.  Earn 500 bonus points for clearing the board.  Can you get 3,000 points?\n\n" +
                "Robots:\n" +
                "A turn-based game where you must out-maneuver the Daleks which are coming after you.  You get only one life.  Cause the Daleks to collide with each other, destroying them and leaving an X-shaped piece of scrap metal behind, which can destroy even more Daleks.  Step on the bomb to destroy all Daleks within a 2-space radius, but be aware it doesn't go off until the Daleks also move.\n" +
                "Use the keypad to make your moves:\n" +
                "1-9 - Move one space (5 to wait one turn),\n" +
                "Clear - Teleport.  You can teleport as much as you want, but possibly into harm's way,\n" +
                "0 - Activate the Sonic Screwdriver to destroy all the Daleks next to you.  You earn two weapon charges per level.  Charges can be stored up to 9,\n" +
                "Enter - Keep passing until the level ends.",
            "filename" : "SameGame & Robots.bin",
            "ecs" : 0, "intellivoice" : 1, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Patrol",
            "players" : "1 only",
            "description" : "A clone of Moon Patrol, by Joseph Zbiciak.  All the levels from the original game, plus new levels in three additional locations.  Simulated parallax scrolling effect.  Soundtrack and sound effects identical to the original arcade game, but the extra sound chip of the ECS Computer Adaptor is needed for the music percussion track and the full jumping sound.\n\n" +
                "Can you find the Easter Eggs?",
            "filename" : "Space Patrol.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "DK Arcade",
            "players" : "1 or 2",
            "description" : "An indie port of Donkey Kong by Carl Mueller, Jr., which proved to the world that the original Coleco port of Donkey Kong didn't have to suck.\n\n" +
                "This has all four original stages, including the so-called \"Pie Factory\".  It includes a feature to play as two additional characters; one can climb ladders while holding a hammer, and the other can jump while holding a hammer.\n\n" +
                "The final version of this game includes more features, such as a code to unlock the inaccessible Pauline voice sample, and two choices of level progression, based on the North American and Japanese releases.  Other final releases of this game exist which provide new levels.\n\n" +
                "This ROM image was downloaded from intellivision.us.  More ROM images are available, some free, some to purchase.",
            "filename" : "DK Arcade.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Christmas Carol Vs. the Ghost of Christmas Presents",
            "players" : "1 only",
            "description" : "An original game by James Pujals.  Carol Greenleaf must gather all the Christmas Presents before the Evil Snowman appears.  A mischievous ghost will cause you to drop all your presents, forcing you to gather them again.\n\n" +
                "This game was recently voted Best Indie Game Of All Time on the Intellivision forum on AtariAge.  Fun original soundtrack.  Plenty of fun cutscenes.  Fluid controls and animation.  Annual high score challenge every Christmas, but this game is a blast to play year-round.\n\n" +
                "Visit the website carolvsghost.com and order the storybook.  Makes a great Christmas present.",
            "filename" : "Christmas Carol and the Ghost of Christmas Presents.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Super Chef BT",
            "players" : "1 or 2",
            "description" : "An enhanced version of Burgertime by Dave Harley, making an already great port of a great arcade game even better.\n\n" +
                "In 2011, Arnauld Chevallier released a level editor after reverse engineering the level data.  This game contains a new first stage, followed by dozens of fan-created levels, selected at random.  There are new prizes to collect as well.\n\n" +
                "This ROM image was downloaded from intellivision.us.  More ROM images are available, some free, some to purchase.",
            "filename" : "Super Chef BT.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Space Raid",
            "players" : "1 only",
            "description" : "A game by \xd3scar Toledo G. similar to Zaxxon.",
            "filename" : "Space Raid.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Princess Quest",
            "players" : "1 only",
            "description" : "A game by \xd3scar Toledo G. similar to Ghosts & Goblins, and just as challenging.  Play as the brave knight who must vanquish monsters to rescue the princess from an evil king.\n\n" +
                "This game has been distributed on the Intellivision Flashback console and the Evercade.  Fun challenging gameplay.  Full soundtrack.  Multiple stages with boss fights.\n\n" +
                "Can you rescue the princess?",
            "filename" : "Princess Quest.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Ms. Pac-Man",
            "players" : "1 or 2",
            "description" : "The classic arcade game, ported to Intellivision by Carl Mueller, Jr.  This game features goodies such as extra mazes, difficulty selection, the ability to play as Pac-Man or Jr. Pac-Man, and more.  Very addictive gameplay, excellent graphics, and all the original cutscenes.\n\n" +
                "This ROM image was downloaded from intellivision.us.  More ROM images are available, some free, some to purchase.",
            "filename" : "Ms Pac-Man.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Desert Bus",
            "players" : "1 only",
            "description" : "Because of course somebody had to port the infamous Sega CD classic.  Freewheel Games made this freely available once all the physical copies sold out.\n\n" +
                "The physical edition included an air freshner - if you know, you know.  There is also a Cascadia Edition which has you driving from Portland to Vancouver.\n\n" +
                "There are a couple bonus games included.  Your scores are saved to Flash.\n\n" +
                "Proceeds from the sale of this port went to the Child's Play Charity, which provides therapeutic games for pediatric hospitals.  Find out more at childsplaycharity.org",
            "filename" : "Desert Bus.rom",
            "ecs" : 1, "intellivoice" : 1, "grom" : 1, "gram" : 0, "params" : "--jlp-savegame=\"" + rompath + "Desert Bus.sav\" -r1"
        }, {
            "name" : "Ultimate Pong",
            "players" : "1 to 4",
            "description" : "Pong for your Mattel Intellivision!  Enjoy 15 different modes of play with up to 4 players and select various options for a total customized experience.  Includes classic pong levels and new challenges, play against a friend or the computer!\n\n" +
                "The physical release included a booklet titled \"Avoid missing ball for high score\" which were the terse instructions on the original arcade cabinet.  This booklet featured an extensive history of Pong's evolution.",
            "filename" : "Ultimate Pong.rom",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sydney Hunter and the Sacred Tribe",
            "players" : "1 only",
            "description" : "You are Sydney Hunter, the great adventurer.  You've been exploring the Yucat\xe1n Peninsula, seeking treasures.  As you traveled, you were captured in the night by a mysterious tribe.  Although they claim they won't hurt you, you are still their prisoner.\n\n" +
                "Over 100 unique screens.\n" +
                "9 unique songs.\n" +
                "10 different types of enemies.\n" +
                "Treasures & secrets.\n" +
                "Great replay value.\n\n" +
                "This ROM image was made freely available on AtariAge after all the physical copies had sold out.  Enjoy.",
            "filename" : "Sydney Hunter and the Sacred Tribe.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Gosub",
            "players" : "1 only",
            "description" : "An original game developed by Chris Read, originally published by IntellivisionRevolution.\n\n" +
                "Your sub moves continuously in a series of underwater rooms.  Get the key if there is one, and get to the treasure chest.  Don't collide with the octopus or any coral.  You have three torpedos per ship per level to shoot the octopus if it gets in your way.\n\n" +
                "Fun simple gameplay.  Multiple endings.  Your high score (\"OctoBounty Best\" - number of octopus shot) is saved to Flash.\n\n" +
                "Disregard the \"not for distribution\" message at the menu.  This game was released for free on AtariAge with a requested donation to the Kanaloa Octopus Research Center.  Find out more at kanaloaoctopus.com/",
            "filename" : "Gosub.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--jlp-savegame=\"" + rompath + "gosub.sav\""
        }, {
            "name" : "Meteors",
            "players" : "1 only",
            "description" : "A clone of the arcade game Asteroids, by \xd3scar Toledo G.  He released this game for free after his wife succumbed to lung cancer in 2020.",
            "filename" : "Meteors.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Aardvark",
            "players" : "1 only",
            "description" : "A clone of the arcade game Anteater, by \xd3scar Toledo G.  He released this game for free after his wife succumbed to lung cancer in 2020.",
            "filename" : "Aardvark.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Maria",
            "players" : "1 only",
            "description" : "An action RPG by C\xf4t\xe9 Gamers.\n\n" +
                "Guide Maria through the forest to an ancient temple, which is rumored to have an entrance back to her homeland in Hell.\n\n" +
                "The physical release was in a wider box with extra feelies, such as a poster and a 3D print.  The box and instruction manual were French-bilingual.\n\n" +
                "Inventory management might take a while to figure out.  Press the Bottom Left Button to open your inventory.  From there, you can use the Top and Bottom Right Buttons to cycle through your three Equip slots.  To select an item, press 1-9 on the keypad.  To use or equip that item, press Enter.",
            "filename" : "Maria.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--jlp-savegame=\"" + rompath + "Maria.sav\""
        }, {
            "name" : "Super Pro King of the Mountain",
            "players" : "1 only",
            "description" : "A completed and enhanced version of King of the Mountain, by Dave Harley.  The Blue Sky Rangers sell this as a completed product.\n\n" +
                "This ROM image was downloaded from intellivision.us.  More ROM images are available, some free, some to purchase.",
            "filename" : "Super Pro King of the Mountain.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Fantasy Puzzle",
            "players" : "1 only",
            "description" : "A puzzle game similar to Puyo Puyo by C\xf4t\xe9 Gamers.\n\n" +
                "Includes several modes of play.  Large colorful graphics and fluid controls.  High scores saved to Flash.",
            "filename" : "FantasyPuzzle.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--jlp-savegame=\"" + rompath + "FantasyPuzzle.sav\""
        }, {
            "name" : "Antarctic Tales",
            "players" : "1 only",
            "description" : "A port of the game Antarctic Adventure, by Carlos Madruga.",
            "filename" : "Antarctic Tales.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Onion",
            "players" : "1 only",
            "description" : "An unpublished free tabletop-style RPG by C\xf4t\xe9 Gamers.",
            "filename" : "Onion.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : "--jlp-savegame=\"" + rompath + "Onion.sav\""
        }, {
            "name" : "The Gooninuff",
            "players" : "1 only",
            "description" : "An adventure game based on The Goonies, by Carlos Madruga.",
            "filename" : "Gooninuff.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Little Man Computer (Tutorvision)",
            "players" : "1 only",
            "description" : "An unpublished free new Tutorvision title by Michael Hayes.\n\n" +
                "This is a simulation of Little Man Computer, a theoretical computer model conceived in 1965 to teach Computer Science and still used today.  It draws on the analogy of a little man in a mail room.\n\n" +
                "Follow along with the included instructions and learn the fundamentals of computer programming.  Full classical music soundtrack.  Save your work for future re-use.  Tutorvision-enhanced hardware features put to very good use.  Addendums included with additional programming exercises.\n\n" +
                "Visit http://www.midnightblueinternational.com/ and see what else I've been up to.  Have A Nice Day.",
            "filename" : "lmc.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 2, "params" : "--jlp-savegame=\"" + rompath + "lmc.sav\""
    }), ({

            # Group 33, "IntyBASIC Contest [2024] - Tiny"
            "name" : "The Blob!",
            "players" : "1 only",
            "description" : "A strategy game for 1 player, by Peripheral.  You are a blob, trying to engulf the entire playfield of pixels.  Your sentience is in the top left corner.  Press a keypad key to change to the specified color and assimilate all the pixels of that color touching you.\n\n" +
                "If you win the game, press 0 to try a bonus game.",
            "filename" : "blob.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Canyon Escape",
            "players" : "1 only",
            "description" : "An action game by YannAros.  Drive through the canyon and survive.  Dodge arrows, shoot rocks, and collect fuel.",
            "filename" : "CanyonEscape.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Chippi (Tutor Pro + ECS)",
            "players" : "Varies",
            "description" : "An emulator for Chip-8, written by Decle.  This program uses ECS + extra Graphics RAM.\n\n" +
                "The ECS keyboard is enabled by default.  Type the 4-character name of the desired Aquarius tape to load it.  If the program is found, it will load automatically.  If not found, it will wait indefinitely with the message \"Press Play\".\n\n" +
                "Check the folder Extras\Chippi for the README file and a list of games readily available.  The filenames are:\n" +
                "BLNK\n" +
                "BRIX\n" +
                "INVD\n" +
                "PIIP\n" +
                "PONG\n" +
                "PUZZ\n" +
                "SYZY\n" +
                "TETR\n" +
                "UFOO",
            "filename" : "chippi.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 2, "params" : "-m2 --ecs-tape=\"" + chippipath + "ecs_tape#.ecs\""
        }, {
            "name" : "Kart-Tag!",
            "players" : "1 only",
            "description" : "An action game by Harvey.  Accelerate and collect the green tags in the shortest possible time.  Colliding with any other object slows you down.",
            "filename" : "kart.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Max-It!",
            "players" : "1 or 2",
            "description" : "A strategy game for 2 players, by Sergio Vares.  Play against the computer or a friend.\n\n" +
                "Player 1 moves left/right, and Player 2 moves up/down.  Choose a green piece to gain points.  Red pieces deduct points.  There are also wild tiles that can add or deduct a random number of points.  Play ends when either player is unable to make a move.  Highest score wins.",
            "filename" : "Maxit.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Ms. Pacu-Pacu",
            "players" : "1 only",
            "description" : "A 1-dimensional variation of Pac-Man by Brian's Man Cave, based on the Pac-Line and Paku Paku games.  Press a button to change direction.\n\n" +
                "Spell BONUS and eat the ghost while blue to earn bonus points.",
            "filename" : "paku.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Pensate",
            "players" : "1 only",
            "description" : "A turn-based strategy game for 1 player, by Michael Hayes.  Walk across a chessboard without colliding with other objects.",
            "filename" : "pensate.bin",
            "ecs" : 0, "intellivoice" : 0, "grom" : 1, "gram" : 0, "params" : ""
        }, {
            "name" : chr(960) + "nty (ECS)",  # chr(960) Displays the pi symbol, which is part of the game title, Pinty.
            "players" : "None",
            "description" : "A demo by Decle that calculates pi to a user-specified number of places.  The more digits you specify, the longer it will take to compute.",
            "filename" : "pinty.bin",
            "ecs" : 1, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
        }, {
            "name" : "Sheep It Up!",
            "players" : "1 only",
            "description" : "A port of an indie Game Boy game, by Dr. Ludos.  Jump from one flying Velcro strap to another.  Get as high as you can without falling.",
            "filename" : "sheepitup.rom",
            "ecs" : 0, "intellivoice" : 0, "grom" : 0, "gram" : 0, "params" : ""
    }))

GroupList = {
    # All of these are grouped together like this because of the way Python grabs all of the games within a group and refreshes the GameList every time you select a new group.
    "name" : (
        " -1980 \n Gaming Network ",  # 0
        " -1980 \n Sports Network ",  # 1
        " -1980 \n Strategy Network ",  # 2
        " -1980 \n Action Network ",  # 3
        " -1980 \n Learning Network ",  # 4
        " 1981 \n Strategy Network ",  # 5
        " 1981 \n Action Network ",  # 6
        " 1981 \n Space Network ",  # 7
        " 1982 \n Strategy Network ",  # 8
        " 1982 \n Action Network ",  # 9
        " 1982 \n Arcade Network ",  # 10
        " 1982 \n Licensed Games ",  # 11
        # All third-party commercial games were released between 1982 and 1983, so I lumped them all together here.
        " Third Party \n Imagic ",  # 12
        " Third Party \n Activision ",  # 13
        " Third Party \n Coleco ",  # 14
        " Third Party \n Parker Brothers ",  # 15
        " Third Party \n Atarisoft ",  # 16
        " Third Party \n Interphase ",  # 17
        " Third Party \n Sega ",  # 18
        # That's it for the third-party titles.  Back to Mattel Electronics, 1983.
        " Mattel Electronics \n No Network ",  # 19
        " 1983 \n Licensed Games ",  # 20
        " 1983 \n IntelliVoice ",  # 21
        " 1983 Entertainment \n Computer System ",  # 22
        # This is where the North American industry Crash happened.  Dextell, Ltd. has a '?' after "Third Party" because it was a distributor for games that were developed at Mattel Electronics' France HQ during the Crash.
        " Third Party? \n Dextell ",  # 23
        " INTV Corporation \n Remakes & Reissues ",  # 24
        " INTV Corporation \n New Original Games ",  # 25
        " INTV Corporation \n Licensed Games ",  # 26
        " INTV Corporation \n New Sports Titles ",  # 27
        " Commercial Games \n (all) ",  # 28
        "Unreleased",  # 29
        "Unfinished",  # 30
        "Demos & Utilities",  # 31
        "Indie Games",  # 32
        " IntyBASIC Contest \n 2024 - \"Tiny\" "),  # 33

    "colorflash" : (
        "green",  # 0, Gaming Network
        "blue",  # 1, Sports Network
        "#430e5e",  # 2, Strategy Network (purple color)
        "red",  # 3, Action Network
        "#e86521",  # 4, Learning Network (orange color)
        "#430e5e",  # 5, Strategy Network (1981, purple color)
        "red",  # 6, Action Network (1981)
        "navy blue",  # 7, Space Network
        "#430e5e",  # 8, Strategy Network (1982, purple color)
        "red",  # 9, Action Network (1982)
        "#5f0028",  # 10, Arcade Network (burgundy color)
        "red",  # 11, Licensed games (1982, used the red Action Network color)
        "silver",  # 12, Imagic
        "teal",  # 13, Activision (Each game had a different color flash.  I went with teal from Beamrider because it was distinct from the other colors in use.  In a future release, I plan to allow individual games to have an overriding color flash within a group.)
        "deep sky blue",  # 14, Coleco
        "dark goldenrod",  # 15, Parker Brothers
        "deep pink",  # 16, Atarisoft
        "#e5311a",  # 17, Interphase (The boxes were black, but the cartridges were red.  I went with the cartridge color to differentiate from the black ECS color flash, as well as the standard red color from the Action Network.)
        "#db4f2e",  # 18, Sega (The front of the box was a line-art drawing of the characters against an isometric jungle maze in the backdrop, and the back was half black and half orange.  I went with the orange part of the box back to differentiate from the black ECS color flash, as well as the orange color from the Learning Network.)
        "chartreuse3",  # 19, Mattel Electronics post-network 1983 releases that were not licensed games and were not Intellivoice or ECS titles.  This was the color of the Buzz Bombers and Motocross boxes (Pinball was a purple color, too similar to the Strategy Network.)
        "medium blue",  # 20, Some of the licensed Mattel Electronics games post-network.  Bump & Jump, Mission-X, and Kool-Aid Man all used a Royal Blue color flash, making it the majority.  Some copies of Masters of the Universe came in a deep-blue box instead of black.
        "tan",  # 21, Intellivoice boxes and overlays
        "black",  # 22, Entertainment Computer System (ECS)
        "#f87024",  # 23, Dextell, Ltd.  The two games were released in different-colored boxes.  I went with the pale orange color from Championship Tennis because World Cup Soccer's aqua color made it too close to the Coleco boxes.
        "dim gray",  # 24, INTV Corporation, remakes & reissues.  None of the boxes had any consistency anymore.  This gray color resembles the silver trim on the Intellivision III consoles which replaced the brass color from the original Intellivision.
        "firebrick",  # 25, INTV Corporation, new original games.  Hover Force was in a black box, Thin Ice and Thunder Castle were in red boxes, and Tower of Doom was in a maroon box.
        "hot pink",  # 26, INTV Corporation, licensed games.  Commando was in a black box, Dig Dug was in a tri-color box which resembled the game's dirt colors at various depths, Diner was in a solid neon-pink box, and Pole Position was in a white box.
        "white",  # 27, INTV Corporation, new sports games.  Chip Shot Super Pro Golf's box art was a photograph of a waterfront golf course, Stadium Mud Buggies was in a yellow box, and the other games were all in white boxes.
        "#201114",  # From here on out, I went with the sepia color that matches the moulding of the original Intellivision consoles.  It's the same color I used for many of the GUI controls.
        "#201114",
        "#201114",
        "#201114",
        "#201114",
        "#201114"),

    "foreground" : (
        "white smoke",  # In most cases, I went with an off-white color for the text, except when the contrast was too low against the background color.
        "white smoke",
        "white smoke",
        "white smoke",
        "#201114",  # 4, Learning Network.  This is the sepia color that matches the moulding of the original Intellivision consoles, and which I also use for many of the GUI controls.  It's a nice dark color that contrasts better against the orange background than the standard off-white color.
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "#201114",  #12, Imagic.  The silver color is too light for the off-white text color.
        "white smoke",
        "#201114",  # 14, Coleco.  The aqua color is too pale.
        "#201114",  # 15, Parker Brothers.  The coppery color surprisingly looked better with dark text than light.
        "white smoke",
        "white smoke",
        "#201114",  # 18, Sega.  Same as with the Learning Network, the orange color didn't look very good with light text.
        "#201114",  # 19, Mattel Electronics post-network 1983 releases.  Chartreuse is a light yellow-green color.
        "white smoke",
        "#201114",  # 21, Intellivoice, which had gold cartridge labels but tan boxes and overlays.
        "white smoke",
        "#201114",  # 23, Dextell, Ltd.  The two game boxes had different colors, both pale.
        "white smoke",
        "white smoke",
        "#201114",  # 26, INTV Corporation licensed games.  The hot pink color of Diner's box is a little paler than the shocking pink color of the Atarisoft boxes.
        "#201114",  # 27, INTV Corporation new sports games.  The majority of these games were in white boxes.
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke",
        "white smoke"),

    "description" : (
        "The Gaming Network was for games involving \"simulated money wagers.\"  The verbiage was cautious, because Mattel Electronics didn't want anybody to think they were promoting gambling.\n\n" +
            "I listed the Gaming Network first because Las Vegas Poker & Blackjack was the pack-in game.",
        "The Sports Network had an impressive library of 11 games.  Many of them had official league endorsements.  This was what best distinguished Intellivision from Atari.",
        "Most of the Strategy Network games were tabletop games.  The idea of playing a board game against a computer opponent was a new concept at the time.  Mattel Electronics' Marketing department boasted that this was the \"Intelligent\" part of \"Intelligent Television.\"",
        "This is the Action Network, which should be self-explanatory.  At the onset, there are only a handful of games in this Network, to promote a well-rounded software library.",
        "Mattel Electronics' Marketing department was hard at work procuring licenses for cross-promotion, in an effort to get the video game industry off the ground.  As a result, the Learning Network games had The Electric Company label, which also appeared on the cartridge labels.",
        "More games were added to the Strategy Network in 1981, the most impressive of which was Utopia, which went on to be regarded as the father of all Sim titles.",
        "In 1981, competition with Atari was in full swing.  Intellivision already established itself with its Sports and Strategy titles, but Mattel Electronics realized that they needed to compete with more Action Network titles.\n\n" +
            "They acquired the rights to develop games based on the upcoming movie Tron, and had counted on the the movie's being a bigger hit than it turned out to be.",
        "The Space Race has begun.  Mattel Electronics didn't want the Intellivision library to become lopsided with too many Action Network games, so a new Network was created for action games that took place in Outer Space.\n\n" +
            "Space Battle was reissued as part of this Network.  As a result, the cartridge labels were red, although the boxes were navy blue.",
        "A couple more Strategy Network games that were intended for release in 1981, but weren't released until 1982.\n\n" +
            "Royal Dealer was released in a green box, though the cartridge label was purple.  Apparently somebody didn't realize there were no simulated money wagers in that game.",
        "The Action Network continued to grow in 1982, in hopes that Mattel Electronics could capture some of the market that preferred the simplicity of Atari games.",
        "Mattel Electronics realized that the Intellivision was at a competitive disadvantage: all the arcade licenses were being snapped up by Atari.  So they decided on a reverse strategy: create games that would then be ported to the arcade.\n\n" +
            "Vectron ended up being the only game released under the Arcade Network, because Marketing finally struck a deal with Data East to port some of their games to the Intellivision.",
        "Finally, arcade ports were coming to the Intellivision, starting with Lock & Chase.  In addition, Mattel Electronics procured a license from TSR Hobbies to create Advanced Dungeons & Dragons games.  These were all released as part of the Action Network, but I wanted to separate these from the other Action Network titles.",
        "Third-party development studios got in on the action in 1982 and 1983.  I'm starting with Imagic because they developed the most Intellivision games out of them all.\n\n" +
            "Imagic had quite a few memorable hits.  Their early games also featured a large centerfold picture in the instruction manual.",
        "Intellivision fans consider the Activision games to be the best among the third-party games.  That's because they were created by developers who had already proven their talent and who welcomed the change in corporate atmosphere and personal recognition for their work.\n\n" +
            "Each of the Activision games had a different color flash, which included all the materials: the box, instruction manual, overlays, and cartridge label.  The boxes had an inner portion which slid upward from the top only so far, just enough to reveal the cartridge and overlays.",
        "Coleco had just released their own console, Colecovision, and were now porting some of their games to Intellivision and Atari.  Their flagship game, Donkey Kong, was particularly bad, giving rise to rumors that it was deliberately bad to promote their own console as superior to the competition.\n\n" +
            "In response, Mattel Electronics created the Intellivision II console, which was designed to lock out the Coleco games.  It didn't take long for Coleco to bypass the lockout and reissue their games in white-shelled cartridges to demonstrate compatibility.  (The Intellivision II had a light grey color as opposed to the dark brown color of the original Intellivision.)\n\n" +
            "The boxes were aqua-colored and the top flap was glued shut.  Only one game, Mousetrap, included overlays.  Instruction manuals were of conspicuously inferior quality.  All games except Turbo were 1- or 2-player and had 4 difficulty levels.\n\n" +
            "CBS Electronics later got in on the action, but merely reissued some of the Coleco games rather than create games of their own, as for the Atari consoles.",
        "The same vendor who developed the Coleco games also developed these games released by Parker Brothers.  This was discovered when Decle performed an analysis of the respective games' object code and discovered significant similarities.  This disproved the rumor that Coleco games were inferior on purpose.  It also explains why these games tended to vary in quality.\n\n" +
            "The boxes were copper-colored and had separate front and back parts, so they opened like miniature board games.  Super Cobra and Tutankham were only released in Europe and therefore only had multilingual instruction manuals.",
        "Finally, Pac-Man makes its way onto the Intellivision to meet customer demand.  That and a couple other popular Atari arcade ports.\n\n" +
            "The boxes were neon pink, the cartridges were box-shaped, and there were no overlays included.",
        "Interphase was a one-man operation that created a few games for Colecovision, two of which were ported to Intellivision.  The boxes were black, and the cartridges had red shells and a unique shape.  Overlays were included, and each manual was in fold-out style with an advertisement for the game itself.",
        "Sega itself finally got in on the action with a port of its own arcade game, Congo Bongo.  The included game catalog advertised two other games in development, which included a Buck Rogers game.\n\n" +
            "The box was half black and half orange in the back.  The front of the box displayed a line-art illustration of some of the game characters, with an isometric jungle maze in the background.  The cartridge looked like an Imagic cartridge but without the embossed Imagic logo.  No overlays were included.",
        "Getting back to Mattel Electronics, they faced new challenges in 1983.  Coleco had released the technologically-superior Colecovision, bringing stiff competition to the console war.  Consumers were getting increasingly frustrated over the continued delay of the promised computer expansion module.\n\n" +
            "These were the games that weren't arcade ports or promotional tie-ins.  They were all released in 1983, despite their copyright dates.\n\n" +
            "At this point, Mattel Electronics realized there was no point in continuing the Networks concept.  There weren't going to be any more games in the Learning Network, for example, and just about every new game going forward would be action-based.\n\n" +
            "As a result, there is no consistency to the boxes any more.  Buzz Bombers and Motocross were released in chartreuse boxes and had red cartridge labels.  Pinball was released in a purple box and had a purple cartridge label.",
        "Mattel Electronics put out more licensed games in 1983, among them another AD&D game and more arcade ports.  A number of them have 1982 copyrights, but they were released in 1983.\n\n" +
            "Bump & Jump was developed by two engineers at Jerauld, which was the vendor that created the PlayCable, a device that connected to the cartridge slot and allowed Cable TV subscribers to access up to 24 Intellivision games per month for a monthly fee, similar to Sega Channel.\n\n" +
            "Burgertime was released in a box with the same burgundy color as the Arcade Network, though with a yellow cartridge label, because Mattel Electronics was just abandoning the Networks concept at the time of its release.  Bump & Jump, Kool-Aid Man, and Mission-X were released in a royal blue box with a red cartridge label.  Locomotion, a Konami arcade game, and Advanced Dungeons & Dragons: Treasure of Tarmin were released in a red box with different title fonts than usual, and a red cartridge label.  Masters of the Universe: The Power of He-Man was released in a black box and had an orange cartridge label.",
        "To compete against Colecovision, Mattel Electronics innovated a lot of new hardware for the Intellivision.  One accessory was the IntelliVoice, which connected to the cartridge slot and had a cartridge slot of its own, and added voice synthesis to select games.\n\n" +
            "The boxes and overlays were tan, and the cartridge labels were gold-colored.  All the games were single-player and had a higher complexity level than usual, to highlight the need for such an accessory.\n\n" +
            "This time, I didn't list the games in alphabetical order.  This is the order in which they appeared in the 1983 Mattel Electronics game catalogs.  Space Spartans was the IntelliVoice's pack-in title.",
        "The Keyboard Component was to have been the realization of Mattel Electronics' promise from the very beginning to fully expand the Intellivision into a home computer.  That is why the original Intellivision console was nicknamed \"Master Component\" in early literature, catalogs, and instruction manuals.  The Keyboard Component was never publicly released because it cost too much, and because the tape drives kept failing.  As a result of a monthly fine levied by the Federal Trade Commission for further delay of its launch, Mattel Electronics released a lower-cost alternative and debuted it at the January 1983 Consumer Electronics Show, to everybody's satisfaction.\n\n" +
            "\"Entertainment Computer System\" is a collective term referring to all the Intellivision computer hardware components (including the System Changer, an adaptor for the Intellivision II to play Atari 2600 games).  At its core is the Computer Adaptor, which people often colloquially call \"ECS.\"\n\n" +
            "The Computer Adaptor connects to the cartridge slot and has a cartridge slot of its own, same as the IntelliVoice, which completes the \"Sega Tower of Power\" but by sprawling sideways.  It has 2K of 8-bit RAM, same as in the USCF Chess cartridge, as well as an on-board BASIC language interpreter and an extra sound chip.  An extra pair of controller ports allow you to connect either a pair of Intellivision II controllers for 4-player action, or the bundled Computer Keyboard or the Music Synthesizer.  Additional jacks in the rear allow you to connect the Aquarius Printer and Data Recorder.  The Data Recorder is a tape drive for the Aquarius, a standalone computer to which Mattel Electronics had just purchased distribution rights.\n\n" +
            "Boxes were black, and each title had a different foreground color flash.  Mr. BASIC Meets Bits & Bytes had a red cartridge label, but the other cartridges had a black label with the outline and title in their respective color.\n\n" +
            "Once again, I listed the released games in a different order than alphabetically.  I chose to list them by level of hardware support.  Mind Strike and Scooby Doo's Maze Chase put none of the ECS capabilities to use save for the Computer Keyboard to start the game, whereas World Series Major League Baseball utilizes the IntelliVoice, Computer Keyboard, and Aquarius Data Recorder.\n\n" +
            "Most games required you to use the Keyboard to start the game.  Press F7 to switch to Keyboard controls and F5 to revert to standard controls.  Some keys were not available on the ECS Computer Keyboard.",
        "In January 1984, Mattel Electronics went out of business due to the North American industry crash.  One of their offices in France, called Nice Ideas, was developing software at the time that would have utilized the 4-player capability of the ECS.  These games were sold in Europe through a company called Dextell Ltd.  For the next year and a half, Mattel Electronics inventory would be sold through an entity known as Intellivision Inc.\n\n" +
            "Championship Tennis was sold in a light orange box, and World Cup Soccer in a pale blue box.  Both games included overlays.",
        "In 1985, a former Mattel Electronics executive bought out Intellivision Inc. and renamed it INTV Corporation.  He sold copies of the Dextell games and also released a couple other games that were completed by Mattel Electronics just before they closed, to the delight of diehard Intellivision fans.  In addition, INTV Corporation had the mailing list of registered Intellivision owners and started sending out mail-order catalogs.\n\n" +
            "Operating on a shoestring budget, INTV Corporation managed to stay in business through the remainder of the decade.  As a result, instruction manuals were printed in black toner on cheap paper, and there were no overlays.  Cartridge labels were white with black foregrounds, including re-releases of popular Mattel Electronics games as they sold out.  There was no consistency to the color of the boxes or even their overall design.\n\n" +
            "Among the more than 20 new releases, a good percentage of them were updated versions of the original Network games, mostly the Sports Network games that originally required 2 players.  Pac-Man was so popular that INTV Corporation re-released that game as well, changing the cartridge style and in-game copyright info from Atarisoft.\n\n" +
            "INTV Corporation released an Intellivision III console, which was just the original Intellivision console with a power LED and a black & silver color scheme.  Later units were labeled \"INTV Super Pro System\" and had a newer CPU which could be overclocked, a newer Graphics ROM (system font), and a slight change to the title screen text.",
        "INTV Corporation put out over a dozen new titles throughout its existence.  These games fell into three categories:\n\n" +
            "1 - Games completed or nearly completed by Mattel Electronics that were never-before released,\n\n" +
            "2 - Arcade ports (or arcade-adjacent, in the case of Diner),\n\n" +
            "3 - New Sports titles.\n\n" +
            "First, we'll look at the games that would have been released in 1984.",
        "Arcade ports were necessary to try to keep Intellivision competitive, now that Nintendo was on the scene and eating everybody else's lunch.\n\n" +
            "Dig Dug and Pole Position were started by Atarisoft, but INTV Corporation only picked up the code for Dig Dug and started on Pole Position from scratch.",
        "Finally, we look at the new Sports games that INTV Corporation developed.  The last two INTV games, the last of the \"original 125\" commercial games, both fall into this category.  That is why I saved these for last.  That is also why I chose to list these games chronologically instead of alphabetically.\n\n" +
            "Stadium Mud Buggies and Spiker Super Pro Volleyball were part of a batch of three games that INTV Corporation wanted to release together, but were running out of money.  To raise funds, INTV Corporation ported Stadium Mud Buggies to NES under its original working title, Monster Truck Rally.  The Intellivision game was renamed, because INTV Corporation thought that association between an Intellivision and NES title would hurt sales.\n\n" +
            "INTV Corporation, and the Intellivision as a commercially-available game console, finally went out with the '80s.  These last two games are the rarest of the Original 125, and they fetch a very high price these days.  Blue Sky Rangers, Inc. created a new batch of these games and sells them on eBay, along with a couple other games that were never officially released.",
        "Now you've seen all the original 125 games.  Here is an alphabetical list of them all.\n\n" +
            "I'll explain each game in a little more detail now that you've probably played it at least once.",
        "A collection of games that were finished but never released.",
        "A collection of games that were never finished but that deserve mention.",
        "Various demos, debuggers, and diagnostic utilities.  I listed the store demos first, and the indie \"demo scene\" titles last.\n\n" +
            "We indie developers have created no shortage of demos and standalone tunes.  I selected only a handful for this list.",
        "Finally, we have a selection of indie games that are freely available.  I cherry-picked only certain games for this list, but there are plenty more to be found.  They are in chronological order by release date.\n\n" +
            "Joseph Zbiciak, the author of the emulator jzIntv as well as the first released indie game 4-Tris, credited me with helping to get the indie scene going in the late 1990s.  Four games were initially released by the end of 2005, among them my very own SameGame & Robots.\n\n" +
            "But the Intellivision was a \"late bloomer\" among classic game consoles, and only a handful of indie games were released before 2014, when \xd3scar Toledo G. created IntyBASIC, which allowed developers to write games without requiring proficiency in CP-1610 Assembly Language and intimate knowledge of the Intellivision's internal architecture.",
        "In April 2024, the fourth IntyBASIC Development Competition was run.  This time, there was a theme: \"Tiny.\"  All entries had to fit within 8K of address space (16 kilobytes, because indie games are 16-bit), and use of Assembly Language was not allowed."
    )}

defaultgroup = 1  # Index of the group to display at startup.  Set this to 28 to display all the original games, when you're done with the Chronological Tour.  I set it to 1 at the onset for the Sports Network because of the impressive size of that library, though I listed the Gaming Network first due to Las Vegas Poker & Blackjack's being the pack-in title at launch.
defaultdescription = "Welcome to PIDEjL, the jzIntv Launcher originally written for my Portable Intellivision Development Environment.\n\nTo begin, select a game category by clicking on the brown box in the lower-right corner.  I organized all the games into groups and sorted the groups to provide a virtual \"chronological tour\" of the Intellivision's history.\n\nThe site history.blueskyrangers.com has a very fascinating history of the Intellivision that you can read at your leisure, though you may want to take a little time sooner to watch the two videos at the top of that page.\n\nMost games can be paused by pressing the 1 & 9 keys together.  To quit a game, press F1.  To soft-reset, press F12.\n\nMany games allow you to set the speed or difficulty by pressing certain keys at the title screen:\n1 - slow or easy,\n2 - slower or easier,\n3 - slowest or easiest,\nAny other key - standard speed or difficulty."

# EOF
