import tkinter as tk
from tkinter import messagebox
import config

class Application (tk.Frame):
	def __init__(self, master = None):
		tk.Frame.__init__(self, master)
		self.grid (sticky = tk.N + tk.S + tk.E + tk.W)
		self.createWidgets()

	def createWidgets (self):
		top = self.winfo_toplevel()
		top.rowconfigure (0, weight = 1)
		top.columnconfigure (0, weight = 1)
		self.rowconfigure (0, weight = 1)
		self.columnconfigure (0, weight = 1)

		# "Explicit" variable declarations
		self.varScore = tk.IntVar()
		self.varAttack = tk.IntVar()
		self.varShield = tk.IntVar()
		self.varBurstRate = tk.IntVar()
		self.varHeartMax = tk.IntVar()
		self.varRedLanders = tk.IntVar()
		self.varEEs = tk.IntVar()
		self.varLocY = tk.IntVar()
		self.varLocYOld = tk.IntVar()
		self.varLocX = tk.IntVar()
		self.varLocXOld = tk.IntVar()
		self.varKeys = tk.IntVar()
		self.varWeapons = tk.IntVar()
		self.varCorridors = tk.IntVar()
		self.varMinibosses = tk.IntVar()
		self.varFree = tk.IntVar()
		self.varShops = tk.IntVar()
		self.varTriShops = tk.IntVar()
		self.varPassword = tk.StringVar()

		# Image objects
		self.imgMap = tk.PhotoImage (file = config.assets ["map"])
		self.imgMiria = tk.PhotoImage (file = config.assets ["miria"])
		self.imgGun = tk.PhotoImage (file = config.assets ["gun"])
		self.imgShield = tk.PhotoImage (file = config.assets ["shield"])
		self.imgBurstRate = tk.PhotoImage (file = config.assets ["burst-rate"])
		self.imgHeartMax = tk.PhotoImage (file = config.assets ["blue-lander"])
		self.imgRedLanders = tk.PhotoImage (file = config.assets ["red-lander"])
		self.imgEEs = tk.PhotoImage (file = config.assets ["enemy-erasers"])

		self.imgKey0 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey1 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey2 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey3 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey4 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey5 = tk.PhotoImage (file = config.assets ["no-key"])
		self.imgKey6 = tk.PhotoImage (file = config.assets ["no-key"])

		self.imgWeapon00 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon02 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon04 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon06 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon08 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon10 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon12 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon14 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon16 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon18 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon20 = tk.PhotoImage (file = config.assets ["no-weapon"])
		self.imgWeapon22 = tk.PhotoImage (file = config.assets ["no-weapon"])

		self.imgCorridor1 = tk.PhotoImage (file = config.assets ["corridor-01"])
		self.imgCorridor2 = tk.PhotoImage (file = config.assets ["corridor-02"])
		self.imgCorridor3 = tk.PhotoImage (file = config.assets ["corridor-03"])
		self.imgCorridor4 = tk.PhotoImage (file = config.assets ["corridor-04"])
		self.imgCorridor5 = tk.PhotoImage (file = config.assets ["corridor-05"])
		self.imgCorridor6 = tk.PhotoImage (file = config.assets ["corridor-06"])
		self.imgCorridor7 = tk.PhotoImage (file = config.assets ["corridor-07"])
		self.imgCorridor8 = tk.PhotoImage (file = config.assets ["corridor-08"])
		self.imgCorridor9 = tk.PhotoImage (file = config.assets ["corridor-09"])
		self.imgCorridor10 = tk.PhotoImage (file = config.assets ["corridor-10"])
		self.imgCorridor11 = tk.PhotoImage (file = config.assets ["corridor-11"])
		self.imgCorridor12 = tk.PhotoImage (file = config.assets ["corridor-12"])
		self.imgCorridor13 = tk.PhotoImage (file = config.assets ["corridor-13"])
		self.imgCorridor14 = tk.PhotoImage (file = config.assets ["corridor-14"])
		self.imgCorridor15 = tk.PhotoImage (file = config.assets ["corridor-15"])
		self.imgCorridor16 = tk.PhotoImage (file = config.assets ["corridor-16"])
		self.imgCorridor17 = tk.PhotoImage (file = config.assets ["corridor-17"])
		self.imgCorridor18 = tk.PhotoImage (file = config.assets ["corridor-18"])
		self.imgCorridor19 = tk.PhotoImage (file = config.assets ["corridor-19"])
		self.imgCorridor20 = tk.PhotoImage (file = config.assets ["corridor-20"])

		self.imgB21_4 = tk.PhotoImage (file = config.assets ["tri-shop-x23-y21"])
		self.imgB21_5 = tk.PhotoImage (file = config.assets ["tri-shop-x18-y0"])
		self.imgB21_6 = tk.PhotoImage (file = config.assets ["tri-shop-x15-y12"])
		self.imgB21_7 = tk.PhotoImage (file = config.assets ["tri-shop-x12-y5"])
		self.imgB22_0 = tk.PhotoImage (file = config.assets ["free-hyper-laser"])
		self.imgB22_1 = tk.PhotoImage (file = config.assets ["free-saber-laser"])
		self.imgB22_2 = tk.PhotoImage (file = config.assets ["shop-wave-attack"])
		self.imgB22_3 = tk.PhotoImage (file = config.assets ["shop-area-blaster"])
		self.imgB22_4 = tk.PhotoImage (file = config.assets ["shop-back-fire"])
		self.imgB22_5 = tk.PhotoImage (file = config.assets ["shop-repeller"])
		self.imgB22_6 = tk.PhotoImage (file = config.assets ["shop-hyper-laser"])
		self.imgB22_7 = tk.PhotoImage (file = config.assets ["tri-shop-x1-y18"])
		self.imgB23_0 = tk.PhotoImage (file = config.assets ["free-shield"])
		self.imgB23_1 = tk.PhotoImage (file = config.assets ["free-energy-tank"])
		self.imgB23_2 = tk.PhotoImage (file = config.assets ["free-enemy-erasers"])
		self.imgB23_3 = tk.PhotoImage (file = config.assets ["free-blue-lander"])
		self.imgB23_4 = tk.PhotoImage (file = config.assets ["free-red-lander"])
		self.imgB23_5 = tk.PhotoImage (file = config.assets ["free-burst-rate"])
		self.imgB23_6 = tk.PhotoImage (file = config.assets ["free-burst-rate"])
		self.imgB23_7 = tk.PhotoImage (file = config.assets ["free-burst-rate"])
		self.imgB24_0 = tk.PhotoImage (file = config.assets ["free-red-lander"])
		self.imgB24_1 = tk.PhotoImage (file = config.assets ["free-blue-lander"])
		self.imgB24_2 = tk.PhotoImage (file = config.assets ["free-cutter-laser"])
		self.imgB24_3 = tk.PhotoImage (file = config.assets ["free-bullet-shield"])
		self.imgB24_4 = tk.PhotoImage (file = config.assets ["free-grenade"])
		self.imgB24_5 = tk.PhotoImage (file = config.assets ["free-multibullets"])
		self.imgB24_6 = tk.PhotoImage (file = config.assets ["free-fireball"])
		self.imgB24_7 = tk.PhotoImage (file = config.assets ["free-repeller"])
		self.imgB25_0 = tk.PhotoImage (file = config.assets ["miniboss-enemy-erasers"])
		self.imgB25_1 = tk.PhotoImage (file = config.assets ["free-multibullets"])
		self.imgB25_3 = tk.PhotoImage (file = config.assets ["free-cutter-laser"])
		self.imgB25_4 = tk.PhotoImage (file = config.assets ["free-back-fire"])
		self.imgB25_5 = tk.PhotoImage (file = config.assets ["free-blue-lander"])
		self.imgB25_6 = tk.PhotoImage (file = config.assets ["free-energy-tank"])
		self.imgB25_7 = tk.PhotoImage (file = config.assets ["free-burst-rate"])
		self.imgB26_0 = tk.PhotoImage (file = config.assets ["miniboss-red-lander"])
		self.imgB26_1 = tk.PhotoImage (file = config.assets ["miniboss-grenade"])
		self.imgB26_2 = tk.PhotoImage (file = config.assets ["miniboss-shield"])
		self.imgB26_3 = tk.PhotoImage (file = config.assets ["miniboss-red-lander"])
		self.imgB26_4 = tk.PhotoImage (file = config.assets ["miniboss-enemy-erasers"])
		self.imgB26_5 = tk.PhotoImage (file = config.assets ["miniboss-wave-attack"])
		self.imgB26_6 = tk.PhotoImage (file = config.assets ["miniboss-blue-lander"])
		self.imgB26_7 = tk.PhotoImage (file = config.assets ["miniboss-shield"])
		self.imgB27_0 = tk.PhotoImage (file = config.assets ["miniboss-red-lander"])
		self.imgB27_1 = tk.PhotoImage (file = config.assets ["miniboss-enemy-erasers"])
		self.imgB27_2 = tk.PhotoImage (file = config.assets ["miniboss-shield"])
		self.imgB27_3 = tk.PhotoImage (file = config.assets ["miniboss-multibullets"])
		self.imgB27_4 = tk.PhotoImage (file = config.assets ["miniboss-gun"])
		self.imgB27_5 = tk.PhotoImage (file = config.assets ["miniboss-wave-attack"])
		self.imgB27_6 = tk.PhotoImage (file = config.assets ["miniboss-shield"])
		self.imgB27_7 = tk.PhotoImage (file = config.assets ["miniboss-shield"])
		self.imgB28_0 = tk.PhotoImage (file = config.assets ["free-enemy-erasers"])
		self.imgB28_1 = tk.PhotoImage (file = config.assets ["free-energy-tank"])
		self.imgB28_2 = tk.PhotoImage (file = config.assets ["free-energy-tank"])
		self.imgB28_3 = tk.PhotoImage (file = config.assets ["miniboss-bullet-shield"])
		self.imgB28_4 = tk.PhotoImage (file = config.assets ["miniboss-blue-lander"])
		self.imgB28_5 = tk.PhotoImage (file = config.assets ["miniboss-fireball"])
		self.imgB28_6 = tk.PhotoImage (file = config.assets ["miniboss-red-lander"])
		self.imgB28_7 = tk.PhotoImage (file = config.assets ["miniboss-gun"])
		self.imgB29_1 = tk.PhotoImage (file = config.assets ["free-blue-lander"])
		self.imgB29_2 = tk.PhotoImage (file = config.assets ["free-enemy-erasers"])
		self.imgB29_3 = tk.PhotoImage (file = config.assets ["free-enemy-erasers"])
		self.imgB29_4 = tk.PhotoImage (file = config.assets ["free-blue-lander"])
		self.imgB29_5 = tk.PhotoImage (file = config.assets ["free-red-lander"])
		self.imgB29_6 = tk.PhotoImage (file = config.assets ["free-shield"])
		self.imgB29_7 = tk.PhotoImage (file = config.assets ["free-energy-tank"])

		# Scrollbars
		self.xScrollMap = tk.Scrollbar (self, orient = tk.HORIZONTAL)
		self.xScrollMap.grid (row = 4, column = 0, sticky = tk.W + tk.E)
		self.yScrollMap = tk.Scrollbar (self, orient = tk.VERTICAL)
		self.yScrollMap.grid (row = 0, column = 1, rowspan = 4, sticky = tk.N + tk.S)

		# Frames
		self.frameMap = tk.Frame (self, bg = config.windowbgcolor)
		self.frameMap.grid (row = 0, column = 0, rowspan = 4)
		self.frameOutput = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Password", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameOutput.grid (row = 0, column = 2)
		self.frameCommands = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Commands", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameCommands.grid (row = 0, column = 3)
		self.frameValues = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Quantities", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameValues.grid (row = 1, column = 2, rowspan = 4, sticky = tk.N)
		self.frameLocation = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Location", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameLocation.grid (row = 1, column = 3, sticky = tk.N)
		self.frameKeys = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Keys", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameKeys.grid (row = 2, column = 3, sticky = tk.N)
		self.frameWeapons = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Optional Weapons", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.frameWeapons.grid (row = 3, column = 3, rowspan = 2, sticky = tk.N)

		# Canvas to display the map
		self.canvasMap = tk.Canvas (self.frameMap, bg = config.canvasbgcolor, height = min (config.canvasheight, 912), width = min (config.canvaswidth, 912), scrollregion = (0, 0, 911, 911), xscrollcommand = self.xScrollMap.set, yscrollcommand = self.yScrollMap.set)
		self.canvasMap.grid()
		self.xScrollMap ["command"] = self.canvasMap.xview  # Needed to make the scrollbars moveable
		self.yScrollMap ["command"] = self.canvasMap.yview

		# Command buttons
		self.btnHelp = tk.Button (self.frameCommands, font = config.font, text = "Instructions", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpGeneral)
		self.btnHelp.grid (row = 0, column = 0, columnspan = 2, sticky = tk.N + tk.S + tk.E + tk.W)
		self.btnOutput = tk.Button (self.frameCommands, font = config.font, text = "Get Password", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.outputpassword)
		self.btnOutput.grid (row = 1, column = 0, columnspan = 2, sticky = tk.N + tk.S + tk.E + tk.W)
		self.btnAbout = tk.Button (self.frameCommands, font = config.font, text = "About", width = 5, bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.doabout)
		self.btnAbout.grid (row = 2, column = 0, sticky = tk.N + tk.S + tk.E + tk.W)
		self.btnQuit = tk.Button (self.frameCommands, font = config.font, text = "Quit", width = 5, bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.quit)
		self.btnQuit.grid (row = 2, column = 1, sticky = tk.N + tk.S + tk.E + tk.W)

		# Everything for the frameMap Frame
		self.canvasMap.create_image (0, 0, anchor = tk.N + tk.W, image = self.imgMap)

		self.btnCorridor1 = tk.Button (self.frameMap, image = self.imgCorridor1, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor1)
		self.canvasMap.create_window (228, 380, anchor = tk.N + tk.W, window = self.btnCorridor1)
		self.btnCorridor2 = tk.Button (self.frameMap, image = self.imgCorridor2, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor2)
		self.canvasMap.create_window (76, 608, anchor = tk.N + tk.W, window = self.btnCorridor2)
		self.btnCorridor3 = tk.Button (self.frameMap, image = self.imgCorridor3, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor3)
		self.canvasMap.create_window (152, 760, anchor = tk.N + tk.W, window = self.btnCorridor3)
		self.btnCorridor4 = tk.Button (self.frameMap, image = self.imgCorridor4, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor4)
		self.canvasMap.create_window (760, 0, anchor = tk.N + tk.W, window = self.btnCorridor4)
		self.btnCorridor5 = tk.Button (self.frameMap, image = self.imgCorridor5, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor5)
		self.canvasMap.create_window (874, 152, anchor = tk.N + tk.W, window = self.btnCorridor5)
		self.btnCorridor6 = tk.Button (self.frameMap, image = self.imgCorridor6, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor6)
		self.canvasMap.create_window (608, 418, anchor = tk.N + tk.W, window = self.btnCorridor6)
		self.btnCorridor7 = tk.Button (self.frameMap, image = self.imgCorridor7, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor7)
		self.canvasMap.create_window (722, 874, anchor = tk.N + tk.W, window = self.btnCorridor7)
		self.btnCorridor8 = tk.Button (self.frameMap, image = self.imgCorridor8, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor8)
		self.canvasMap.create_window (380, 608, anchor = tk.N + tk.W, window = self.btnCorridor8)
		self.btnCorridor9 = tk.Button (self.frameMap, image = self.imgCorridor9, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor9)
		self.canvasMap.create_window (76, 76, anchor = tk.N + tk.W, window = self.btnCorridor9)
		self.btnCorridor10 = tk.Button (self.frameMap, image = self.imgCorridor10, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor10)
		self.canvasMap.create_window (418, 0, anchor = tk.N + tk.W, window = self.btnCorridor10)
		self.btnCorridor11 = tk.Button (self.frameMap, image = self.imgCorridor11, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor11)
		self.canvasMap.create_window (38, 304, anchor = tk.N + tk.W, window = self.btnCorridor11)
		self.btnCorridor12 = tk.Button (self.frameMap, image = self.imgCorridor12, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor12)
		self.canvasMap.create_window (152, 570, anchor = tk.N + tk.W, window = self.btnCorridor12)
		self.btnCorridor13 = tk.Button (self.frameMap, image = self.imgCorridor13, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor13)
		self.canvasMap.create_window (190, 760, anchor = tk.N + tk.W, window = self.btnCorridor13)
		self.btnCorridor14 = tk.Button (self.frameMap, image = self.imgCorridor14, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor14)
		self.canvasMap.create_window (646, 152, anchor = tk.N + tk.W, window = self.btnCorridor14)
		self.btnCorridor15 = tk.Button (self.frameMap, image = self.imgCorridor15, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor15)
		self.canvasMap.create_window (798, 304, anchor = tk.N + tk.W, window = self.btnCorridor15)
		self.btnCorridor16 = tk.Button (self.frameMap, image = self.imgCorridor16, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor16)
		self.canvasMap.create_window (684, 494, anchor = tk.N + tk.W, window = self.btnCorridor16)
		self.btnCorridor17 = tk.Button (self.frameMap, image = self.imgCorridor17, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor17)
		self.canvasMap.create_window (684, 722, anchor = tk.N + tk.W, window = self.btnCorridor17)
		self.btnCorridor18 = tk.Button (self.frameMap, image = self.imgCorridor18, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor18)
		self.canvasMap.create_window (418, 722, anchor = tk.N + tk.W, window = self.btnCorridor18)
		self.btnCorridor19 = tk.Button (self.frameMap, image = self.imgCorridor19, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor19)
		self.canvasMap.create_window (152, 152, anchor = tk.N + tk.W, window = self.btnCorridor19)
		self.btnCorridor20 = tk.Button (self.frameMap, image = self.imgCorridor20, height = 32, width = 32, bg = "black", command = self.dotoggleCorridor20)
		self.canvasMap.create_window (418, 190, anchor = tk.N + tk.W, window = self.btnCorridor20)

		self.btnB21_4 = tk.Button (self.frameMap, image = self.imgB21_4, height = 32, width = 32, bg = "black", command = self.dotoggleB21_4)
		self.canvasMap.create_window (874, 798, anchor = tk.N + tk.W, window = self.btnB21_4)
		self.btnB21_5 = tk.Button (self.frameMap, image = self.imgB21_5, height = 32, width = 32, bg = "black", command = self.dotoggleB21_5)
		self.canvasMap.create_window (684, 0, anchor = tk.N + tk.W, window = self.btnB21_5)
		self.btnB21_6 = tk.Button (self.frameMap, image = self.imgB21_6, height = 32, width = 32, bg = "black", command = self.dotoggleB21_6)
		self.canvasMap.create_window (570, 456, anchor = tk.N + tk.W, window = self.btnB21_6)
		self.btnB21_7 = tk.Button (self.frameMap, image = self.imgB21_7, height = 32, width = 32, bg = "black", command = self.dotoggleB21_7)
		self.canvasMap.create_window (456, 190, anchor = tk.N + tk.W, window = self.btnB21_7)
		self.btnB22_7 = tk.Button (self.frameMap, image = self.imgB22_7, height = 32, width = 32, bg = "black", command = self.dotoggleB22_7)
		self.canvasMap.create_window (38, 684, anchor = tk.N + tk.W, window = self.btnB22_7)

		self.btnB22_2 = tk.Button (self.frameMap, image = self.imgB22_2, height = 32, width = 32, bg = "black", command = self.dotoggleB22_2)
		self.canvasMap.create_window (494, 418, anchor = tk.N + tk.W, window = self.btnB22_2)
		self.btnB22_3 = tk.Button (self.frameMap, image = self.imgB22_3, height = 32, width = 32, bg = "black", command = self.dotoggleB22_3)
		self.canvasMap.create_window (494, 380, anchor = tk.N + tk.W, window = self.btnB22_3)
		self.btnB22_4 = tk.Button (self.frameMap, image = self.imgB22_4, height = 32, width = 32, bg = "black", command = self.dotoggleB22_4)
		self.canvasMap.create_window (456, 380, anchor = tk.N + tk.W, window = self.btnB22_4)
		self.btnB22_5 = tk.Button (self.frameMap, image = self.imgB22_5, height = 32, width = 32, bg = "black", command = self.dotoggleB22_5)
		self.canvasMap.create_window (380, 380, anchor = tk.N + tk.W, window = self.btnB22_5)
		self.btnB22_6 = tk.Button (self.frameMap, image = self.imgB22_6, height = 32, width = 32, bg = "black", command = self.dotoggleB22_6)
		self.canvasMap.create_window (380, 418, anchor = tk.N + tk.W, window = self.btnB22_6)

		self.btnB22_0 = tk.Button (self.frameMap, image = self.imgB22_0, height = 32, width = 32, bg = "black", command = self.dotoggleB22_0)
		self.canvasMap.create_window (342, 722, anchor = tk.N + tk.W, window = self.btnB22_0)
		self.btnB22_1 = tk.Button (self.frameMap, image = self.imgB22_1, height = 32, width = 32, bg = "black", command = self.dotoggleB22_1)
		self.canvasMap.create_window (342, 532, anchor = tk.N + tk.W, window = self.btnB22_1)
		self.btnB23_0 = tk.Button (self.frameMap, image = self.imgB23_0, height = 32, width = 32, bg = "black", command = self.dotoggleB23_0)
		self.canvasMap.create_window (836, 874, anchor = tk.N + tk.W, window = self.btnB23_0)
		self.btnB23_1 = tk.Button (self.frameMap, image = self.imgB23_1, height = 32, width = 32, bg = "black", command = self.dotoggleB23_1)
		self.canvasMap.create_window (380, 684, anchor = tk.N + tk.W, window = self.btnB23_1)
		self.btnB23_2 = tk.Button (self.frameMap, image = self.imgB23_2, height = 32, width = 32, bg = "black", command = self.dotoggleB23_2)
		self.canvasMap.create_window (532, 760, anchor = tk.N + tk.W, window = self.btnB23_2)
		self.btnB23_3 = tk.Button (self.frameMap, image = self.imgB23_3, height = 32, width = 32, bg = "black", command = self.dotoggleB23_3)
		self.canvasMap.create_window (114, 228, anchor = tk.N + tk.W, window = self.btnB23_3)
		self.btnB23_4 = tk.Button (self.frameMap, image = self.imgB23_4, height = 32, width = 32, bg = "black", command = self.dotoggleB23_4)
		self.canvasMap.create_window (114, 114, anchor = tk.N + tk.W, window = self.btnB23_4)
		self.btnB23_5 = tk.Button (self.frameMap, image = self.imgB23_5, height = 32, width = 32, bg = "black", command = self.dotoggleB23_5)
		self.canvasMap.create_window (456, 456, anchor = tk.N + tk.W, window = self.btnB23_5)
		self.btnB23_6 = tk.Button (self.frameMap, image = self.imgB23_6, height = 32, width = 32, bg = "black", command = self.dotoggleB23_6)
		self.canvasMap.create_window (76, 646, anchor = tk.N + tk.W, window = self.btnB23_6)
		self.btnB23_7 = tk.Button (self.frameMap, image = self.imgB23_7, height = 32, width = 32, bg = "black", command = self.dotoggleB23_7)
		self.canvasMap.create_window (608, 0, anchor = tk.N + tk.W, window = self.btnB23_7)
		self.btnB24_0 = tk.Button (self.frameMap, image = self.imgB24_0, height = 32, width = 32, bg = "black", command = self.dotoggleB24_0)
		self.canvasMap.create_window (228, 836, anchor = tk.N + tk.W, window = self.btnB24_0)
		self.btnB24_1 = tk.Button (self.frameMap, image = self.imgB24_1, height = 32, width = 32, bg = "black", command = self.dotoggleB24_1)
		self.canvasMap.create_window (722, 228, anchor = tk.N + tk.W, window = self.btnB24_1)
		self.btnB24_2 = tk.Button (self.frameMap, image = self.imgB24_2, height = 32, width = 32, bg = "black", command = self.dotoggleB24_2)
		self.canvasMap.create_window (646, 76, anchor = tk.N + tk.W, window = self.btnB24_2)
		self.btnB24_3 = tk.Button (self.frameMap, image = self.imgB24_3, height = 32, width = 32, bg = "black", command = self.dotoggleB24_3)
		self.canvasMap.create_window (874, 228, anchor = tk.N + tk.W, window = self.btnB24_3)
		self.btnB24_4 = tk.Button (self.frameMap, image = self.imgB24_4, height = 32, width = 32, bg = "black", command = self.dotoggleB24_4)
		self.canvasMap.create_window (874, 114, anchor = tk.N + tk.W, window = self.btnB24_4)
		self.btnB24_5 = tk.Button (self.frameMap, image = self.imgB24_5, height = 32, width = 32, bg = "black", command = self.dotoggleB24_5)
		self.canvasMap.create_window (684, 456, anchor = tk.N + tk.W, window = self.btnB24_5)
		self.btnB24_6 = tk.Button (self.frameMap, image = self.imgB24_6, height = 32, width = 32, bg = "black", command = self.dotoggleB24_6)
		self.canvasMap.create_window (760, 380, anchor = tk.N + tk.W, window = self.btnB24_6)
		self.btnB24_7 = tk.Button (self.frameMap, image = self.imgB24_7, height = 32, width = 32, bg = "black", command = self.dotoggleB24_7)
		self.canvasMap.create_window (722, 722, anchor = tk.N + tk.W, window = self.btnB24_7)
		self.btnB25_1 = tk.Button (self.frameMap, image = self.imgB25_1, height = 32, width = 32, bg = "black", command = self.dotoggleB25_1)
		self.canvasMap.create_window (304, 342, anchor = tk.N + tk.W, window = self.btnB25_1)
		self.btnB25_3 = tk.Button (self.frameMap, image = self.imgB25_3, height = 32, width = 32, bg = "black", command = self.dotoggleB25_3)
		self.canvasMap.create_window (152, 456, anchor = tk.N + tk.W, window = self.btnB25_3)
		self.btnB25_4 = tk.Button (self.frameMap, image = self.imgB25_4, height = 32, width = 32, bg = "black", command = self.dotoggleB25_4)
		self.canvasMap.create_window (114, 380, anchor = tk.N + tk.W, window = self.btnB25_4)
		self.btnB25_5 = tk.Button (self.frameMap, image = self.imgB25_5, height = 32, width = 32, bg = "black", command = self.dotoggleB25_5)
		self.canvasMap.create_window (114, 532, anchor = tk.N + tk.W, window = self.btnB25_5)
		self.btnB25_6 = tk.Button (self.frameMap, image = self.imgB25_6, height = 32, width = 32, bg = "black", command = self.dotoggleB25_6)
		self.canvasMap.create_window (0, 342, anchor = tk.N + tk.W, window = self.btnB25_6)
		self.btnB25_7 = tk.Button (self.frameMap, image = self.imgB25_7, height = 32, width = 32, bg = "black", command = self.dotoggleB25_7)
		self.canvasMap.create_window (0, 836, anchor = tk.N + tk.W, window = self.btnB25_7)
		self.btnB28_0 = tk.Button (self.frameMap, image = self.imgB28_0, height = 32, width = 32, bg = "black", command = self.dotoggleB28_0)
		self.canvasMap.create_window (38, 0, anchor = tk.N + tk.W, window = self.btnB28_0)
		self.btnB28_1 = tk.Button (self.frameMap, image = self.imgB28_1, height = 32, width = 32, bg = "black", command = self.dotoggleB28_1)
		self.canvasMap.create_window (456, 152, anchor = tk.N + tk.W, window = self.btnB28_1)
		self.btnB28_2 = tk.Button (self.frameMap, image = self.imgB28_2, height = 32, width = 32, bg = "black", command = self.dotoggleB28_2)
		self.canvasMap.create_window (608, 456, anchor = tk.N + tk.W, window = self.btnB28_2)
		self.btnB29_1 = tk.Button (self.frameMap, image = self.imgB29_1, height = 32, width = 32, bg = "black", command = self.dotoggleB29_1)
		self.canvasMap.create_window (874, 304, anchor = tk.N + tk.W, window = self.btnB29_1)
		self.btnB29_2 = tk.Button (self.frameMap, image = self.imgB29_2, height = 32, width = 32, bg = "black", command = self.dotoggleB29_2)
		self.canvasMap.create_window (798, 494, anchor = tk.N + tk.W, window = self.btnB29_2)
		self.btnB29_3 = tk.Button (self.frameMap, image = self.imgB29_3, height = 32, width = 32, bg = "black", command = self.dotoggleB29_3)
		self.canvasMap.create_window (646, 874, anchor = tk.N + tk.W, window = self.btnB29_3)
		self.btnB29_4 = tk.Button (self.frameMap, image = self.imgB29_4, height = 32, width = 32, bg = "black", command = self.dotoggleB29_4)
		self.canvasMap.create_window (456, 874, anchor = tk.N + tk.W, window = self.btnB29_4)
		self.btnB29_5 = tk.Button (self.frameMap, image = self.imgB29_5, height = 32, width = 32, bg = "black", command = self.dotoggleB29_5)
		self.canvasMap.create_window (304, 418, anchor = tk.N + tk.W, window = self.btnB29_5)
		self.btnB29_6 = tk.Button (self.frameMap, image = self.imgB29_6, height = 32, width = 32, bg = "black", command = self.dotoggleB29_6)
		self.canvasMap.create_window (228, 114, anchor = tk.N + tk.W, window = self.btnB29_6)
		self.btnB29_7 = tk.Button (self.frameMap, image = self.imgB29_7, height = 32, width = 32, bg = "black", command = self.dotoggleB29_7)
		self.canvasMap.create_window (0, 114, anchor = tk.N + tk.W, window = self.btnB29_7)

		self.btnB25_0 = tk.Button (self.frameMap, image = self.imgB25_0, height = 32, width = 32, bg = "black", command = self.dotoggleB25_0)
		self.canvasMap.create_window (456, 0, anchor = tk.N + tk.W, window = self.btnB25_0)
		self.btnB26_0 = tk.Button (self.frameMap, image = self.imgB26_0, height = 32, width = 32, bg = "black", command = self.dotoggleB26_0)
		self.canvasMap.create_window (646, 608, anchor = tk.N + tk.W, window = self.btnB26_0)
		self.btnB26_1 = tk.Button (self.frameMap, image = self.imgB26_1, height = 32, width = 32, bg = "black", command = self.dotoggleB26_1)
		self.canvasMap.create_window (608, 684, anchor = tk.N + tk.W, window = self.btnB26_1)
		self.btnB26_2 = tk.Button (self.frameMap, image = self.imgB26_2, height = 32, width = 32, bg = "black", command = self.dotoggleB26_2)
		self.canvasMap.create_window (836, 760, anchor = tk.N + tk.W, window = self.btnB26_2)
		self.btnB26_3 = tk.Button (self.frameMap, image = self.imgB26_3, height = 32, width = 32, bg = "black", command = self.dotoggleB26_3)
		self.canvasMap.create_window (456, 684, anchor = tk.N + tk.W, window = self.btnB26_3)
		self.btnB26_4 = tk.Button (self.frameMap, image = self.imgB26_4, height = 32, width = 32, bg = "black", command = self.dotoggleB26_4)
		self.canvasMap.create_window (456, 836, anchor = tk.N + tk.W, window = self.btnB26_4)
		self.btnB26_5 = tk.Button (self.frameMap, image = self.imgB26_5, height = 32, width = 32, bg = "black", command = self.dotoggleB26_5)
		self.canvasMap.create_window (190, 114, anchor = tk.N + tk.W, window = self.btnB26_5)
		self.btnB26_6 = tk.Button (self.frameMap, image = self.imgB26_6, height = 32, width = 32, bg = "black", command = self.dotoggleB26_6)
		self.canvasMap.create_window (76, 0, anchor = tk.N + tk.W, window = self.btnB26_6)
		self.btnB26_7 = tk.Button (self.frameMap, image = self.imgB26_7, height = 32, width = 32, bg = "black", command = self.dotoggleB26_7)
		self.canvasMap.create_window (416, 114, anchor = tk.N + tk.W, window = self.btnB26_7)
		self.btnB27_0 = tk.Button (self.frameMap, image = self.imgB27_0, height = 32, width = 32, bg = "black", command = self.dotoggleB27_0)
		self.canvasMap.create_window (38, 532, anchor = tk.N + tk.W, window = self.btnB27_0)
		self.btnB27_1 = tk.Button (self.frameMap, image = self.imgB27_1, height = 32, width = 32, bg = "black", command = self.dotoggleB27_1)
		self.canvasMap.create_window (38, 760, anchor = tk.N + tk.W, window = self.btnB27_1)
		self.btnB27_2 = tk.Button (self.frameMap, image = self.imgB27_2, height = 32, width = 32, bg = "black", command = self.dotoggleB27_2)
		self.canvasMap.create_window (228, 874, anchor = tk.N + tk.W, window = self.btnB27_2)
		self.btnB27_3 = tk.Button (self.frameMap, image = self.imgB27_3, height = 32, width = 32, bg = "black", command = self.dotoggleB27_3)
		self.canvasMap.create_window (608, 114, anchor = tk.N + tk.W, window = self.btnB27_3)
		self.btnB27_4 = tk.Button (self.frameMap, image = self.imgB27_4, height = 32, width = 32, bg = "black", command = self.dotoggleB27_4)
		self.canvasMap.create_window (684, 38, anchor = tk.N + tk.W, window = self.btnB27_4)
		self.btnB27_5 = tk.Button (self.frameMap, image = self.imgB27_5, height = 32, width = 32, bg = "black", command = self.dotoggleB27_5)
		self.canvasMap.create_window (722, 304, anchor = tk.N + tk.W, window = self.btnB27_5)
		self.btnB27_6 = tk.Button (self.frameMap, image = self.imgB27_6, height = 32, width = 32, bg = "black", command = self.dotoggleB27_6)
		self.canvasMap.create_window (798, 152, anchor = tk.N + tk.W, window = self.btnB27_6)
		self.btnB27_7 = tk.Button (self.frameMap, image = self.imgB27_7, height = 32, width = 32, bg = "black", command = self.dotoggleB27_7)
		self.canvasMap.create_window (684, 380, anchor = tk.N + tk.W, window = self.btnB27_7)
		self.btnB28_3 = tk.Button (self.frameMap, image = self.imgB28_3, height = 32, width = 32, bg = "black", command = self.dotoggleB28_3)
		self.canvasMap.create_window (304, 494, anchor = tk.N + tk.W, window = self.btnB28_3)
		self.btnB28_4 = tk.Button (self.frameMap, image = self.imgB28_4, height = 32, width = 32, bg = "black", command = self.dotoggleB28_4)
		self.canvasMap.create_window (532, 342, anchor = tk.N + tk.W, window = self.btnB28_4)
		self.btnB28_5 = tk.Button (self.frameMap, image = self.imgB28_5, height = 32, width = 32, bg = "black", command = self.dotoggleB28_5)
		self.canvasMap.create_window (152, 418, anchor = tk.N + tk.W, window = self.btnB28_5)
		self.btnB28_6 = tk.Button (self.frameMap, image = self.imgB28_6, height = 32, width = 32, bg = "black", command = self.dotoggleB28_6)
		self.canvasMap.create_window (0, 228, anchor = tk.N + tk.W, window = self.btnB28_6)
		self.btnB28_7 = tk.Button (self.frameMap, image = self.imgB28_7, height = 32, width = 32, bg = "black", command = self.dotoggleB28_7)
		self.canvasMap.create_window (190, 646, anchor = tk.N + tk.W, window = self.btnB28_7)

		self.canvasMap.create_image (429, 464, anchor = tk.N + tk.W, image = self.imgMiria, tags = "Miria")
		self.varLocXOld.set (11)
		self.varLocYOld.set (12)

		# The password is displayed in the frameOutput Frame.
		self.lblPassword = tk.Label (self.frameOutput, font = config.fontpassword, textvariable = self.varPassword, bg = config.passwordbgcolor, fg = config.passwordfgcolor, width = 19, height = 2)
		self.lblPassword.grid (row = 0, column = 0)

		# Everything for the frameValues Frame
		self.lblScore = tk.Label (self.frameValues, font = config.font, text = "Score:", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.lblScore.grid (row = 0, column = 1)
		self.valScore = tk.Spinbox (self.frameValues, font = config.font, bg = config.windowbgcolor, fg = config.windowfgcolor, from_= 0, to = 9999990, increment = 10, width = 7, textvariable = self.varScore, wrap = True)
		self.valScore.grid (row = 0, column = 2)
		self.btnHelpScore = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpScore)
		self.btnHelpScore.grid (row = 0, column = 3)

		self.picGun = tk.Label (self.frameValues, image = self.imgGun)
		self.picGun.grid (row = 1, column = 0)
		self.valAttack = tk.Scale (self.frameValues, font = config.font, label = "Attack Power:", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.SOLID, length = 144, orient = tk.HORIZONTAL, from_= 1, to = 8, resolution = 1, tickinterval = 1, variable = self.varAttack)
		self.valAttack.grid (row = 1, column = 1, columnspan = 2, sticky = None)
		self.btnHelpAttack = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpAttack)
		self.btnHelpAttack.grid (row = 1, column = 3)

		self.picShield = tk.Label (self.frameValues, image = self.imgShield)
		self.picShield.grid (row = 2, column = 0)
		self.valShield = tk.Scale (self.frameValues, font = config.font, label = "Shield Power:", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.SOLID, length = 144, orient = tk.HORIZONTAL, from_= 0, to = 7, resolution = 1, tickinterval = 1, variable = self.varShield)
		self.valShield.set (1)  # Default value
		self.valShield.grid (row = 2, column = 1, columnspan = 2, sticky = None)
		self.btnHelpShield = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpShield)
		self.btnHelpShield.grid (row = 2, column = 3)

		self.picBurstRate = tk.Label (self.frameValues, image = self.imgBurstRate)
		self.picBurstRate.grid (row = 3, column = 0)
		self.valBurstRate = tk.Scale (self.frameValues, font = config.font, label = "Burst Rate:", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.SOLID, length = 144, orient = tk.HORIZONTAL, from_= 0, to = 7, resolution = 1, tickinterval = 1, variable = self.varBurstRate)
		self.valBurstRate.grid (row = 3, column = 1, columnspan = 2, sticky = None)
		self.btnHelpBurstRate = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpBurstRate)
		self.btnHelpBurstRate.grid (row = 3, column = 3)

		self.picHeartMax = tk.Label (self.frameValues, image = self.imgHeartMax)
		self.picHeartMax.grid (row = 4, column = 0)
		self.valHeartMax = tk.Scale (self.frameValues, font = config.font, label = "Heart Max:", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.SOLID, length = 144, orient = tk.HORIZONTAL, from_= 1, to = 32, resolution = 1, tickinterval = 7, variable = self.varHeartMax)
		self.valHeartMax.set (8)  # Default value
		self.valHeartMax.grid (row = 4, column = 1, columnspan = 2, sticky = None)

		self.picRedLanders = tk.Label (self.frameValues, image = self.imgRedLanders)
		self.picRedLanders.grid (row = 5, column = 0)
		self.valRedLanders = tk.Scale (self.frameValues, font = config.font, label = "Red Landers:", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.SOLID, length = 144, orient = tk.HORIZONTAL, from_= 0, to = 15, resolution = 1, tickinterval = 3, variable = self.varRedLanders)
		self.valRedLanders.grid (row = 5, column = 1, columnspan = 2, sticky = None)
		self.btnHelpRedLanders = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpRedLanders)
		self.btnHelpRedLanders.grid (row = 5, column = 3)

		self.picEEs = tk.Label (self.frameValues, image = self.imgEEs)
		self.picEEs.grid (row = 6, column = 0)
		self.lblEEs = tk.Label (self.frameValues, font = config.font, text = "Enemy\nErasers:", bg = config.windowbgcolor, fg = config.windowfgcolor)
		self.lblEEs.grid (row = 6, column = 1)
		self.valEEs = tk.Spinbox (self.frameValues, font = config.font, bg = config.windowbgcolor, fg = config.windowfgcolor, from_= 0, to = 255, increment = 1, width = 3, textvariable = self.varEEs, wrap = True)
		self.valEEs.grid (row = 6, column = 2)
		self.btnHelpEEs = tk.Button (self.frameValues, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpEEs)
		self.btnHelpEEs.grid (row = 6, column = 3)

		# Everything for the frameLocation Frame
		self.btnHelpLocation = tk.Button (self.frameLocation, font = config.font, text = "?", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelpLocation)
		self.btnHelpLocation.grid (row = 0, column = 1, sticky = tk.S + tk.W)
		self.valLocY = tk.Scale (self.frameLocation, font = config.font, label = "Y", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.FLAT, length = 200, orient = tk.VERTICAL, from_= 0, to = 31, resolution = 1, tickinterval = 3, variable = self.varLocY)
		self.valLocY.set (12)  # Starting location
		self.valLocY.grid (row = 0, column = 0, sticky = None)
		self.valLocX = tk.Scale (self.frameLocation, font = config.font, label = "X", bg = config.windowbgcolor, fg = config.windowfgcolor, troughcolor = config.buttonbgcolor, relief = tk.FLAT, length = 180, orient = tk.HORIZONTAL, from_= 0, to = 31, resolution = 1, tickinterval = 5, variable = self.varLocX)
		self.valLocX.set (11)  # Starting location
		self.valLocX.grid (row = 1, column = 0, columnspan = 2, sticky = None)

		# Everything for the frameKeys Frame
		self.btnKey0 = tk.Button (self.frameKeys, image = self.imgKey0, height = 16, width = 16, bg = "black", command = self.dotoggleKey0)
		self.btnKey0.grid (row = 0, column = 0)
		self.btnKey1 = tk.Button (self.frameKeys, image = self.imgKey1, height = 16, width = 16, bg = "black", command = self.dotoggleKey1)
		self.btnKey1.grid (row = 0, column = 1)
		self.btnKey2 = tk.Button (self.frameKeys, image = self.imgKey2, height = 16, width = 16, bg = "black", command = self.dotoggleKey2)
		self.btnKey2.grid (row = 0, column = 2)
		self.btnKey3 = tk.Button (self.frameKeys, image = self.imgKey3, height = 16, width = 16, bg = "black", command = self.dotoggleKey3)
		self.btnKey3.grid (row = 0, column = 3)
		self.btnKey4 = tk.Button (self.frameKeys, image = self.imgKey4, height = 16, width = 16, bg = "black", command = self.dotoggleKey4)
		self.btnKey4.grid (row = 0, column = 4)
		self.btnKey5 = tk.Button (self.frameKeys, image = self.imgKey5, height = 16, width = 16, bg = "black", command = self.dotoggleKey5)
		self.btnKey5.grid (row = 0, column = 5)
		self.btnKey6 = tk.Button (self.frameKeys, image = self.imgKey6, height = 16, width = 16, bg = "black", command = self.dotoggleKey6)
		self.btnKey6.grid (row = 0, column = 6)

		# Everything for the frameWeapons Frame
		self.btnWeapon00 = tk.Button (self.frameWeapons, image = self.imgWeapon00, height = 32, width = 32, bg = "black", command = self.docycleWeapon00)
		self.btnWeapon00.grid (row = 0, column = 1)
		self.btnWeapon02 = tk.Button (self.frameWeapons, image = self.imgWeapon02, height = 32, width = 32, bg = "black", command = self.docycleWeapon02)
		self.btnWeapon02.grid (row = 0, column = 2)
		self.btnWeapon04 = tk.Button (self.frameWeapons, image = self.imgWeapon04, height = 32, width = 32, bg = "black", command = self.docycleWeapon04)
		self.btnWeapon04.grid (row = 0, column = 3)
		self.btnWeapon06 = tk.Button (self.frameWeapons, image = self.imgWeapon06, height = 32, width = 32, bg = "black", command = self.docycleWeapon06)
		self.btnWeapon06.grid (row = 0, column = 4)
		self.btnWeapon08 = tk.Button (self.frameWeapons, image = self.imgWeapon08, height = 32, width = 32, bg = "black", command = self.docycleWeapon08)
		self.btnWeapon08.grid (row = 1, column = 0)
		self.btnWeapon10 = tk.Button (self.frameWeapons, image = self.imgWeapon10, height = 32, width = 32, bg = "black", command = self.docycleWeapon10)
		self.btnWeapon10.grid (row = 1, column = 1)
		self.btnWeapon12 = tk.Button (self.frameWeapons, image = self.imgWeapon12, height = 32, width = 32, bg = "black", command = self.docycleWeapon12)
		self.btnWeapon12.grid (row = 1, column = 2)
		self.btnWeapon14 = tk.Button (self.frameWeapons, image = self.imgWeapon14, height = 32, width = 32, bg = "black", command = self.docycleWeapon14)
		self.btnWeapon14.grid (row = 1, column = 3)
		self.btnWeapon16 = tk.Button (self.frameWeapons, image = self.imgWeapon16, height = 32, width = 32, bg = "black", command = self.docycleWeapon16)
		self.btnWeapon16.grid (row = 1, column = 4)
		self.btnWeapon18 = tk.Button (self.frameWeapons, image = self.imgWeapon18, height = 32, width = 32, bg = "black", command = self.docycleWeapon18)
		self.btnWeapon18.grid (row = 2, column = 0)
		self.btnWeapon20 = tk.Button (self.frameWeapons, image = self.imgWeapon20, height = 32, width = 32, bg = "black", command = self.docycleWeapon20)
		self.btnWeapon20.grid (row = 2, column = 1)
		self.btnWeapon22 = tk.Button (self.frameWeapons, image = self.imgWeapon22, height = 32, width = 32, bg = "black", command = self.dotoggleWeapon22)
		self.btnWeapon22.grid (row = 2, column = 2)

	# This code is fired when the "Get Password" button is clicked.
	def outputpassword (self):
		# Validate the Spinbox values: Score and Enemy Erasers.
		if (self.varScore.get() % 10):  # Nonzero digit at end of score?
			self.varScore.set (self.varScore.get() // 10 * 10)  # Replace the last digit with a 0.
		if (self.varEEs.get() > 255):
			self.varEEs.set (255)  # Set the Enemy Erasers count to max if above max.

		# Move Miria.
		self.canvasMap.move ("Miria", -11 - 38 * self.varLocXOld.get(), -8 - 38 * self.varLocYOld.get())
		self.varLocXOld.set (self.varLocX.get())
		self.varLocYOld.set (self.varLocY.get())
		self.canvasMap.move ("Miria", self.varLocX.get() * 38 + 11, self.varLocY.get() * 38 + 8)

		# Get the values of all the Bytes.
		Byte0 = 0
		Byte8 = ((self.varScore.get() // 10) % 1000) & 255
		Byte9 = (self.varScore.get() // 10000) & 255
		Byte10 = (self.varShield.get() & 4) // 4 + (self.varShield.get() & 2) + (self.varShield.get() & 1) * 4 + self.varLocY.get() * 8
		Byte11 = ((self.varAttack.get() - 1) & 4) // 4 + ((self.varAttack.get() - 1) & 2) + ((self.varAttack.get() - 1) & 1) * 4 + self.varLocX.get() * 8
		Byte12 = (self.varHeartMax.get() & 31) * 8 + self.varBurstRate.get()
		Byte13 = self.varKeys.get()
		Byte14 = self.varEEs.get()
		Byte15 = self.varWeapons.get() // 65536
		Byte16 = (self.varWeapons.get() // 256) & 255
		Byte17 = self.varWeapons.get() & 255
		Byte18 = (((self.varScore.get() // 10) % 1000) & 768) // 256 + ((self.varScore.get() // 10000) & 768) // 64 + (self.varCorridors.get() & 983040) // 4096
		Byte19 = (self.varCorridors.get() & 65280) // 256
		Byte20 = self.varCorridors.get() & 255
		Byte21 = (self.varRedLanders.get() & 8) // 8 + (self.varRedLanders.get() & 4) // 2 + (self.varRedLanders.get() & 2) * 2 + (self.varRedLanders.get() & 1) * 8 + (self.varTriShops.get() & 15) * 16
		Byte22 = (self.varFree.get() & 3) + (self.varShops.get() * 4) + (self.varTriShops.get() & 16) * 8
		Byte23 = (self.varFree.get() & 1020) // 4
		Byte24 = (self.varFree.get() & 261120) // 1024
		Byte25 = (self.varMinibosses.get() & 1) + (self.varFree.get() & 262144) // 131072 + (self.varFree.get() & 16252928) // 65536
		Byte26 = (self.varMinibosses.get() & 510) // 2
		Byte27 = (self.varMinibosses.get() & 130560) // 512
		Byte28 = (self.varFree.get() & 117440512) // 16777216 + (self.varMinibosses.get() & 4063232) // 16384
		Byte29 = (self.varFree.get() & 17045651456) // 67108864
		Byte7 = Byte8 + Byte9 + Byte10 + Byte11 + Byte12 + Byte13 + Byte14 + Byte15 + Byte16 + Byte17 + Byte18 + Byte19 + Byte20 + Byte21 + Byte22 + Byte23 + Byte24 + Byte25 + Byte26 + Byte27 + Byte28 + Byte29
		Byte7 = ((Byte7 & 255) + (Byte7 // 256)) % 256

		# Debug
		#print ("Byte7: " + str (Byte7))
		#print ("Byte8: " + str (Byte8))
		#print ("Byte9: " + str (Byte9))
		#print ("Byte10: " + str (Byte10))
		#print ("Byte11: " + str (Byte11))
		#print ("Byte12: " + str (Byte12))
		#print ("Byte13: " + str (Byte13))
		#print ("Byte14: " + str (Byte14))
		#print ("Byte15: " + str (Byte15))
		#print ("Byte16: " + str (Byte16))
		#print ("Byte17: " + str (Byte17))
		#print ("Byte18: " + str (Byte18))
		#print ("Byte19: " + str (Byte19))
		#print ("Byte20: " + str (Byte20))
		#print ("Byte21: " + str (Byte21))
		#print ("Byte22: " + str (Byte22))
		#print ("Byte23: " + str (Byte23))
		#print ("Byte24: " + str (Byte24))
		#print ("Byte25: " + str (Byte25))
		#print ("Byte26: " + str (Byte26))
		#print ("Byte27: " + str (Byte27))
		#print ("Byte28: " + str (Byte28))
		#print ("Byte29: " + str (Byte29))

		# Encrypt all the Byte values.
		Byte7 = Byte7 ^ 7
		Byte8 = Byte8 ^ 8
		Byte9 = Byte9 ^ 9
		Byte10 = Byte10 ^ 10
		Byte11 = Byte11 ^ 11
		Byte12 = Byte12 ^ 12
		Byte13 = Byte13 ^ 13
		Byte14 = Byte14 ^ 14
		Byte15 = Byte15 ^ 15
		Byte16 = Byte16 ^ 16
		Byte17 = Byte17 ^ 17
		Byte18 = Byte18 ^ 18
		Byte19 = Byte19 ^ 19
		Byte20 = Byte20 ^ 20
		Byte21 = Byte21 ^ 21
		Byte22 = Byte22 ^ 22
		Byte23 = Byte23 ^ 23
		Byte24 = Byte24 ^ 24
		Byte25 = Byte25 ^ 25
		Byte26 = Byte26 ^ 26
		Byte27 = Byte27 ^ 27
		Byte28 = Byte28 ^ 28
		Byte29 = Byte29 ^ 29

		# Regroup the bits from 8 to 6.
		Char31 = (Byte0 & 252) // 4
		Char30 = (Byte0 & 3) * 16 + (Byte7 & 240) // 16
		Char29 = (Byte7 & 15) * 4 + (Byte8 & 192) // 64
		Char28 = Byte8 & 63
		Char27 = (Byte9 & 252) // 4
		Char26 = (Byte9 & 3) * 16 + (Byte10 & 240) // 16
		Char25 = (Byte10 & 15) * 4 + (Byte11 & 192) // 64
		Char24 = Byte11 & 63
		Char23 = (Byte12 & 252) // 4
		Char22 = (Byte12 & 3) * 16 + (Byte13 & 240) // 16
		Char21 = (Byte13 & 15) * 4 + (Byte14 & 192) // 64
		Char20 = Byte14 & 63
		Char19 = (Byte15 & 252) // 4
		Char18 = (Byte15 & 3) * 16 + (Byte16 & 240) // 16
		Char17 = (Byte16 & 15) * 4 + (Byte17 & 192) // 64
		Char16 = Byte17 & 63
		Char15 = (Byte18 & 252) // 4
		Char14 = (Byte18 & 3) * 16 + (Byte19 & 240) // 16
		Char13 = (Byte19 & 15) * 4 + (Byte20 & 192) // 64
		Char12 = Byte20 & 63
		Char11 = (Byte21 & 252) // 4
		Char10 = (Byte21 & 3) * 16 + (Byte22 & 240) // 16
		Char9 = (Byte22 & 15) * 4 + (Byte23 & 192) // 64
		Char8 = Byte23 & 63
		Char7 = (Byte24 & 252) // 4
		Char6 = (Byte24 & 3) * 16 + (Byte25 & 240) // 16
		Char5 = (Byte25 & 15) * 4 + (Byte26 & 192) // 64
		Char4 = Byte26 & 63
		Char3 = (Byte27 & 252) // 4
		Char2 = (Byte27 & 3) * 16 + (Byte28 & 240) // 16
		Char1 = (Byte28 & 15) * 4 + (Byte29 & 192) // 64
		Char0 = Byte29 & 63

		# Get the actual characters.
		Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123abcdefghijklmnopqrstuvwxyz456789!?"
		self.varPassword.set (Alphabet [Char0] + Alphabet [Char1] + Alphabet [Char2] + Alphabet [Char3] + " " + Alphabet [Char4] + Alphabet [Char5] + Alphabet [Char6] + Alphabet [Char7] + " " + Alphabet [Char8] + Alphabet [Char9] + Alphabet [Char10] + Alphabet [Char11] + " " + Alphabet [Char12] + Alphabet [Char13] + Alphabet [Char14] + Alphabet [Char15] + "\n" + Alphabet [Char16] + Alphabet [Char17] + Alphabet [Char18] + Alphabet [Char19] + " " + Alphabet [Char20] + Alphabet [Char21] + Alphabet [Char22] + Alphabet [Char23] + " " + Alphabet [Char24] + Alphabet [Char25] + Alphabet [Char26] + Alphabet [Char27] + " " + Alphabet [Char28] + Alphabet [Char29] + Alphabet [Char30] + Alphabet [Char31])

	# One of these code blocks fires when one of the Miniboss buttons is clicked on the Map.
	def dotoggleB25_0 (self):
		if (self.varMinibosses.get() & 1):
			self.varMinibosses.set (self.varMinibosses.get() - 1)
			self.imgB25_0.config (file = config.assets ["miniboss-enemy-erasers"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 1)
			self.imgB25_0.config (file = config.assets ["miniboss-enemy-erasers-taken"])
	def dotoggleB26_0 (self):
		if (self.varMinibosses.get() & 2):
			self.varMinibosses.set (self.varMinibosses.get() - 2)
			self.imgB26_0.config (file = config.assets ["miniboss-red-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 2)
			self.imgB26_0.config (file = config.assets ["miniboss-red-lander-taken"])
	def dotoggleB26_1 (self):
		if (self.varMinibosses.get() & 4):
			self.varMinibosses.set (self.varMinibosses.get() - 4)
			self.imgB26_1.config (file = config.assets ["miniboss-grenade"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 4)
			self.imgB26_1.config (file = config.assets ["miniboss-grenade-taken"])
	def dotoggleB26_2 (self):
		if (self.varMinibosses.get() & 8):
			self.varMinibosses.set (self.varMinibosses.get() - 8)
			self.imgB26_2.config (file = config.assets ["miniboss-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 8)
			self.imgB26_2.config (file = config.assets ["miniboss-shield-taken"])
	def dotoggleB26_3 (self):
		if (self.varMinibosses.get() & 16):
			self.varMinibosses.set (self.varMinibosses.get() - 16)
			self.imgB26_3.config (file = config.assets ["miniboss-red-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 16)
			self.imgB26_3.config (file = config.assets ["miniboss-red-lander-taken"])
	def dotoggleB26_4 (self):
		if (self.varMinibosses.get() & 32):
			self.varMinibosses.set (self.varMinibosses.get() - 32)
			self.imgB26_4.config (file = config.assets ["miniboss-enemy-erasers"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 32)
			self.imgB26_4.config (file = config.assets ["miniboss-enemy-erasers-taken"])
	def dotoggleB26_5 (self):
		if (self.varMinibosses.get() & 64):
			self.varMinibosses.set (self.varMinibosses.get() - 64)
			self.imgB26_5.config (file = config.assets ["miniboss-wave-attack"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 64)
			self.imgB26_5.config (file = config.assets ["miniboss-wave-attack-taken"])
	def dotoggleB26_6 (self):
		if (self.varMinibosses.get() & 128):
			self.varMinibosses.set (self.varMinibosses.get() - 128)
			self.imgB26_6.config (file = config.assets ["miniboss-blue-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 128)
			self.imgB26_6.config (file = config.assets ["miniboss-blue-lander-taken"])
	def dotoggleB26_7 (self):
		if (self.varMinibosses.get() & 256):
			self.varMinibosses.set (self.varMinibosses.get() - 256)
			self.imgB26_7.config (file = config.assets ["miniboss-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 256)
			self.imgB26_7.config (file = config.assets ["miniboss-shield-taken"])

	def dotoggleB27_0 (self):
		if (self.varMinibosses.get() & 512):
			self.varMinibosses.set (self.varMinibosses.get() - 512)
			self.imgB27_0.config (file = config.assets ["miniboss-red-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 512)
			self.imgB27_0.config (file = config.assets ["miniboss-red-lander-taken"])
	def dotoggleB27_1 (self):
		if (self.varMinibosses.get() & 1024):
			self.varMinibosses.set (self.varMinibosses.get() - 1024)
			self.imgB27_1.config (file = config.assets ["miniboss-enemy-erasers"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 1024)
			self.imgB27_1.config (file = config.assets ["miniboss-enemy-erasers-taken"])
	def dotoggleB27_2 (self):
		if (self.varMinibosses.get() & 2048):
			self.varMinibosses.set (self.varMinibosses.get() - 2048)
			self.imgB27_2.config (file = config.assets ["miniboss-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 2048)
			self.imgB27_2.config (file = config.assets ["miniboss-shield-taken"])
	def dotoggleB27_3 (self):
		if (self.varMinibosses.get() & 4096):
			self.varMinibosses.set (self.varMinibosses.get() - 4096)
			self.imgB27_3.config (file = config.assets ["miniboss-multibullets"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 4096)
			self.imgB27_3.config (file = config.assets ["miniboss-multibullets-taken"])
	def dotoggleB27_4 (self):
		if (self.varMinibosses.get() & 8192):
			self.varMinibosses.set (self.varMinibosses.get() - 8192)
			self.imgB27_4.config (file = config.assets ["miniboss-gun"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 8192)
			self.imgB27_4.config (file = config.assets ["miniboss-gun-taken"])
	def dotoggleB27_5 (self):
		if (self.varMinibosses.get() & 16384):
			self.varMinibosses.set (self.varMinibosses.get() - 16384)
			self.imgB27_5.config (file = config.assets ["miniboss-wave-attack"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 16384)
			self.imgB27_5.config (file = config.assets ["miniboss-wave-attack-taken"])
	def dotoggleB27_6 (self):
		if (self.varMinibosses.get() & 32768):
			self.varMinibosses.set (self.varMinibosses.get() - 32768)
			self.imgB27_6.config (file = config.assets ["miniboss-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 32768)
			self.imgB27_6.config (file = config.assets ["miniboss-shield-taken"])
	def dotoggleB27_7 (self):
		if (self.varMinibosses.get() & 65536):
			self.varMinibosses.set (self.varMinibosses.get() - 65536)
			self.imgB27_7.config (file = config.assets ["miniboss-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 65536)
			self.imgB27_7.config (file = config.assets ["miniboss-shield-taken"])
	def dotoggleB28_3 (self):
		if (self.varMinibosses.get() & 131072):
			self.varMinibosses.set (self.varMinibosses.get() - 131072)
			self.imgB28_3.config (file = config.assets ["miniboss-bullet-shield"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 131072)
			self.imgB28_3.config (file = config.assets ["miniboss-bullet-shield-taken"])
	def dotoggleB28_4 (self):
		if (self.varMinibosses.get() & 262144):
			self.varMinibosses.set (self.varMinibosses.get() - 262144)
			self.imgB28_4.config (file = config.assets ["miniboss-blue-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 262144)
			self.imgB28_4.config (file = config.assets ["miniboss-blue-lander-taken"])
	def dotoggleB28_5 (self):
		if (self.varMinibosses.get() & 524288):
			self.varMinibosses.set (self.varMinibosses.get() - 524288)
			self.imgB28_5.config (file = config.assets ["miniboss-fireball"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 524288)
			self.imgB28_5.config (file = config.assets ["miniboss-fireball-taken"])
	def dotoggleB28_6 (self):
		if (self.varMinibosses.get() & 1048576):
			self.varMinibosses.set (self.varMinibosses.get() - 1048576)
			self.imgB28_6.config (file = config.assets ["miniboss-red-lander"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 1048576)
			self.imgB28_6.config (file = config.assets ["miniboss-red-lander-taken"])
	def dotoggleB28_7 (self):
		if (self.varMinibosses.get() & 2097152):
			self.varMinibosses.set (self.varMinibosses.get() - 2097152)
			self.imgB28_7.config (file = config.assets ["miniboss-gun"])
		else:
			self.varMinibosses.set (self.varMinibosses.get() + 2097152)
			self.imgB28_7.config (file = config.assets ["miniboss-gun-taken"])

	# One of these code blocks fires when one of the Corridor buttons is clicked on the Map.
	def dotoggleCorridor1 (self):
		if (self.varCorridors.get() & 1):
			self.varCorridors.set (self.varCorridors.get() - 1)
			self.imgCorridor1.config (file = config.assets ["corridor-01"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 1)
			self.imgCorridor1.config (file = config.assets ["corridor-01-done"])
	def dotoggleCorridor2 (self):
		if (self.varCorridors.get() & 2):
			self.varCorridors.set (self.varCorridors.get() - 2)
			self.imgCorridor2.config (file = config.assets ["corridor-02"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 2)
			self.imgCorridor2.config (file = config.assets ["corridor-02-done"])
	def dotoggleCorridor3 (self):
		if (self.varCorridors.get() & 4):
			self.varCorridors.set (self.varCorridors.get() - 4)
			self.imgCorridor3.config (file = config.assets ["corridor-03"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 4)
			self.imgCorridor3.config (file = config.assets ["corridor-03-done"])
	def dotoggleCorridor4 (self):
		if (self.varCorridors.get() & 8):
			self.varCorridors.set (self.varCorridors.get() - 8)
			self.imgCorridor4.config (file = config.assets ["corridor-04"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 8)
			self.imgCorridor4.config (file = config.assets ["corridor-04-done"])
	def dotoggleCorridor5 (self):
		if (self.varCorridors.get() & 16):
			self.varCorridors.set (self.varCorridors.get() - 16)
			self.imgCorridor5.config (file = config.assets ["corridor-05"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 16)
			self.imgCorridor5.config (file = config.assets ["corridor-05-done"])
	def dotoggleCorridor6 (self):
		if (self.varCorridors.get() & 32):
			self.varCorridors.set (self.varCorridors.get() - 32)
			self.imgCorridor6.config (file = config.assets ["corridor-06"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 32)
			self.imgCorridor6.config (file = config.assets ["corridor-06-done"])
	def dotoggleCorridor7 (self):
		if (self.varCorridors.get() & 64):
			self.varCorridors.set (self.varCorridors.get() - 64)
			self.imgCorridor7.config (file = config.assets ["corridor-07"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 64)
			self.imgCorridor7.config (file = config.assets ["corridor-07-done"])
	def dotoggleCorridor8 (self):
		if (self.varCorridors.get() & 128):
			self.varCorridors.set (self.varCorridors.get() - 128)
			self.imgCorridor8.config (file = config.assets ["corridor-08"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 128)
			self.imgCorridor8.config (file = config.assets ["corridor-08-done"])
	def dotoggleCorridor9 (self):
		if (self.varCorridors.get() & 256):
			self.varCorridors.set (self.varCorridors.get() - 256)
			self.imgCorridor9.config (file = config.assets ["corridor-09"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 256)
			self.imgCorridor9.config (file = config.assets ["corridor-09-done"])
	def dotoggleCorridor10 (self):
		if (self.varCorridors.get() & 512):
			self.varCorridors.set (self.varCorridors.get() - 512)
			self.imgCorridor10.config (file = config.assets ["corridor-10"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 512)
			self.imgCorridor10.config (file = config.assets ["corridor-10-done"])

	def dotoggleCorridor11 (self):
		if (self.varCorridors.get() & 1024):
			self.varCorridors.set (self.varCorridors.get() - 1024)
			self.imgCorridor11.config (file = config.assets ["corridor-11"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 1024)
			self.imgCorridor11.config (file = config.assets ["corridor-11-done"])
	def dotoggleCorridor12 (self):
		if (self.varCorridors.get() & 2048):
			self.varCorridors.set (self.varCorridors.get() - 2048)
			self.imgCorridor12.config (file = config.assets ["corridor-12"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 2048)
			self.imgCorridor12.config (file = config.assets ["corridor-12-done"])
	def dotoggleCorridor13 (self):
		if (self.varCorridors.get() & 4096):
			self.varCorridors.set (self.varCorridors.get() - 4096)
			self.imgCorridor13.config (file = config.assets ["corridor-13"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 4096)
			self.imgCorridor13.config (file = config.assets ["corridor-13-done"])
	def dotoggleCorridor14 (self):
		if (self.varCorridors.get() & 8192):
			self.varCorridors.set (self.varCorridors.get() - 8192)
			self.imgCorridor14.config (file = config.assets ["corridor-14"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 8192)
			self.imgCorridor14.config (file = config.assets ["corridor-14-done"])
	def dotoggleCorridor15 (self):
		if (self.varCorridors.get() & 16384):
			self.varCorridors.set (self.varCorridors.get() - 16384)
			self.imgCorridor15.config (file = config.assets ["corridor-15"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 16384)
			self.imgCorridor15.config (file = config.assets ["corridor-15-done"])
	def dotoggleCorridor16 (self):
		if (self.varCorridors.get() & 32768):
			self.varCorridors.set (self.varCorridors.get() - 32768)
			self.imgCorridor16.config (file = config.assets ["corridor-16"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 32768)
			self.imgCorridor16.config (file = config.assets ["corridor-16-done"])
	def dotoggleCorridor17 (self):
		if (self.varCorridors.get() & 65536):
			self.varCorridors.set (self.varCorridors.get() - 65536)
			self.imgCorridor17.config (file = config.assets ["corridor-17"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 65536)
			self.imgCorridor17.config (file = config.assets ["corridor-17-done"])
	def dotoggleCorridor18 (self):
		if (self.varCorridors.get() & 131072):
			self.varCorridors.set (self.varCorridors.get() - 131072)
			self.imgCorridor18.config (file = config.assets ["corridor-18"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 131072)
			self.imgCorridor18.config (file = config.assets ["corridor-18-done"])
	def dotoggleCorridor19 (self):
		if (self.varCorridors.get() & 262144):
			self.varCorridors.set (self.varCorridors.get() - 262144)
			self.imgCorridor19.config (file = config.assets ["corridor-19"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 262144)
			self.imgCorridor19.config (file = config.assets ["corridor-19-done"])
	def dotoggleCorridor20 (self):
		if (self.varCorridors.get() & 524288):
			self.varCorridors.set (self.varCorridors.get() - 524288)
			self.imgCorridor20.config (file = config.assets ["corridor-20"])
		else:
			self.varCorridors.set (self.varCorridors.get() + 524288)
			self.imgCorridor20.config (file = config.assets ["corridor-20-done"])

	# One of these code blocks fires when one of the Shop buttons is clicked on the Map.
	def dotoggleB22_2 (self):
		if (self.varShops.get() & 1):
			self.varShops.set (self.varShops.get() - 1)
			self.imgB22_2.config (file = config.assets ["shop-wave-attack"])
		else:
			self.varShops.set (self.varShops.get() + 1)
			self.imgB22_2.config (file = config.assets ["shop-wave-attack-bought"])
	def dotoggleB22_3 (self):
		if (self.varShops.get() & 2):
			self.varShops.set (self.varShops.get() - 2)
			self.imgB22_3.config (file = config.assets ["shop-area-blaster"])
		else:
			self.varShops.set (self.varShops.get() + 2)
			self.imgB22_3.config (file = config.assets ["shop-area-blaster-bought"])
	def dotoggleB22_4 (self):
		if (self.varShops.get() & 4):
			self.varShops.set (self.varShops.get() - 4)
			self.imgB22_4.config (file = config.assets ["shop-back-fire"])
		else:
			self.varShops.set (self.varShops.get() + 4)
			self.imgB22_4.config (file = config.assets ["shop-back-fire-bought"])
	def dotoggleB22_5 (self):
		if (self.varShops.get() & 8):
			self.varShops.set (self.varShops.get() - 8)
			self.imgB22_5.config (file = config.assets ["shop-repeller"])
		else:
			self.varShops.set (self.varShops.get() + 8)
			self.imgB22_5.config (file = config.assets ["shop-repeller-bought"])
	def dotoggleB22_6 (self):
		if (self.varShops.get() & 16):
			self.varShops.set (self.varShops.get() - 16)
			self.imgB22_6.config (file = config.assets ["shop-hyper-laser"])
		else:
			self.varShops.set (self.varShops.get() + 16)
			self.imgB22_6.config (file = config.assets ["shop-hyper-laser-bought"])

	# One of these code blocks fires when one of the Tri-Shop buttons is clicked on the Map.
	def dotoggleB21_4 (self):
		if (self.varTriShops.get() & 1):
			self.varTriShops.set (self.varTriShops.get() - 1)
			self.imgB21_4.config (file = config.assets ["tri-shop-x23-y21"])
		else:
			self.varTriShops.set (self.varTriShops.get() + 1)
			self.imgB21_4.config (file = config.assets ["tri-shop-x23-y21-bought"])
	def dotoggleB21_5 (self):
		if (self.varTriShops.get() & 2):
			self.varTriShops.set (self.varTriShops.get() - 2)
			self.imgB21_5.config (file = config.assets ["tri-shop-x18-y0"])
		else:
			self.varTriShops.set (self.varTriShops.get() + 2)
			self.imgB21_5.config (file = config.assets ["tri-shop-x18-y0-bought"])
	def dotoggleB21_6 (self):
		if (self.varTriShops.get() & 4):
			self.varTriShops.set (self.varTriShops.get() - 4)
			self.imgB21_6.config (file = config.assets ["tri-shop-x15-y12"])
		else:
			self.varTriShops.set (self.varTriShops.get() + 4)
			self.imgB21_6.config (file = config.assets ["tri-shop-x15-y12-bought"])
	def dotoggleB21_7 (self):
		if (self.varTriShops.get() & 8):
			self.varTriShops.set (self.varTriShops.get() - 8)
			self.imgB21_7.config (file = config.assets ["tri-shop-x12-y5"])
		else:
			self.varTriShops.set (self.varTriShops.get() + 8)
			self.imgB21_7.config (file = config.assets ["tri-shop-x12-y5-bought"])
	def dotoggleB22_7 (self):
		if (self.varTriShops.get() & 16):
			self.varTriShops.set (self.varTriShops.get() - 16)
			self.imgB22_7.config (file = config.assets ["tri-shop-x1-y18"])
		else:
			self.varTriShops.set (self.varTriShops.get() + 16)
			self.imgB22_7.config (file = config.assets ["tri-shop-x1-y18-bought"])

	# One of these code blocks fires when one of the Free buttons is clicked on the Map.
	def dotoggleB22_0 (self):
		if (self.varFree.get() & 1):
			self.varFree.set (self.varFree.get() - 1)
			self.imgB22_0.config (file = config.assets ["free-hyper-laser"])
		else:
			self.varFree.set (self.varFree.get() + 1)
			self.imgB22_0.config (file = config.assets ["free-hyper-laser-taken"])
	def dotoggleB22_1 (self):
		if (self.varFree.get() & 2):
			self.varFree.set (self.varFree.get() - 2)
			self.imgB22_1.config (file = config.assets ["free-saber-laser"])
		else:
			self.varFree.set (self.varFree.get() + 2)
			self.imgB22_1.config (file = config.assets ["free-saber-laser-taken"])

	def dotoggleB23_0 (self):
		if (self.varFree.get() & 4):
			self.varFree.set (self.varFree.get() - 4)
			self.imgB23_0.config (file = config.assets ["free-shield"])
		else:
			self.varFree.set (self.varFree.get() + 4)
			self.imgB23_0.config (file = config.assets ["free-shield-taken"])
	def dotoggleB23_1 (self):
		if (self.varFree.get() & 8):
			self.varFree.set (self.varFree.get() - 8)
			self.imgB23_1.config (file = config.assets ["free-energy-tank"])
		else:
			self.varFree.set (self.varFree.get() + 8)
			self.imgB23_1.config (file = config.assets ["free-energy-tank-taken"])
	def dotoggleB23_2 (self):
		if (self.varFree.get() & 16):
			self.varFree.set (self.varFree.get() - 16)
			self.imgB23_2.config (file = config.assets ["free-enemy-erasers"])
		else:
			self.varFree.set (self.varFree.get() + 16)
			self.imgB23_2.config (file = config.assets ["free-enemy-erasers-taken"])
	def dotoggleB23_3 (self):
		if (self.varFree.get() & 32):
			self.varFree.set (self.varFree.get() - 32)
			self.imgB23_3.config (file = config.assets ["free-blue-lander"])
		else:
			self.varFree.set (self.varFree.get() + 32)
			self.imgB23_3.config (file = config.assets ["free-blue-lander-taken"])
	def dotoggleB23_4 (self):
		if (self.varFree.get() & 64):
			self.varFree.set (self.varFree.get() - 64)
			self.imgB23_4.config (file = config.assets ["free-red-lander"])
		else:
			self.varFree.set (self.varFree.get() + 64)
			self.imgB23_4.config (file = config.assets ["free-red-lander-taken"])
	def dotoggleB23_5 (self):
		if (self.varFree.get() & 128):
			self.varFree.set (self.varFree.get() - 128)
			self.imgB23_5.config (file = config.assets ["free-burst-rate"])
		else:
			self.varFree.set (self.varFree.get() + 128)
			self.imgB23_5.config (file = config.assets ["free-burst-rate-taken"])
	def dotoggleB23_6 (self):
		if (self.varFree.get() & 256):
			self.varFree.set (self.varFree.get() - 256)
			self.imgB23_6.config (file = config.assets ["free-burst-rate"])
		else:
			self.varFree.set (self.varFree.get() + 256)
			self.imgB23_6.config (file = config.assets ["free-burst-rate-taken"])
	def dotoggleB23_7 (self):
		if (self.varFree.get() & 512):
			self.varFree.set (self.varFree.get() - 512)
			self.imgB23_7.config (file = config.assets ["free-burst-rate"])
		else:
			self.varFree.set (self.varFree.get() + 512)
			self.imgB23_7.config (file = config.assets ["free-burst-rate-taken"])

	def dotoggleB24_0 (self):
		if (self.varFree.get() & 1024):
			self.varFree.set (self.varFree.get() - 1024)
			self.imgB24_0.config (file = config.assets ["free-red-lander"])
		else:
			self.varFree.set (self.varFree.get() + 1024)
			self.imgB24_0.config (file = config.assets ["free-red-lander-taken"])
	def dotoggleB24_1 (self):
		if (self.varFree.get() & 2048):
			self.varFree.set (self.varFree.get() - 2048)
			self.imgB24_1.config (file = config.assets ["free-blue-lander"])
		else:
			self.varFree.set (self.varFree.get() + 2048)
			self.imgB24_1.config (file = config.assets ["free-blue-lander-taken"])
	def dotoggleB24_2 (self):
		if (self.varFree.get() & 4096):
			self.varFree.set (self.varFree.get() - 4096)
			self.imgB24_2.config (file = config.assets ["free-cutter-laser"])
		else:
			self.varFree.set (self.varFree.get() + 4096)
			self.imgB24_2.config (file = config.assets ["free-cutter-laser-taken"])
	def dotoggleB24_3 (self):
		if (self.varFree.get() & 8192):
			self.varFree.set (self.varFree.get() - 8192)
			self.imgB24_3.config (file = config.assets ["free-bullet-shield"])
		else:
			self.varFree.set (self.varFree.get() + 8192)
			self.imgB24_3.config (file = config.assets ["free-bullet-shield-taken"])
	def dotoggleB24_4 (self):
		if (self.varFree.get() & 16384):
			self.varFree.set (self.varFree.get() - 16384)
			self.imgB24_4.config (file = config.assets ["free-grenade"])
		else:
			self.varFree.set (self.varFree.get() + 16384)
			self.imgB24_4.config (file = config.assets ["free-grenade-taken"])
	def dotoggleB24_5 (self):
		if (self.varFree.get() & 32768):
			self.varFree.set (self.varFree.get() - 32768)
			self.imgB24_5.config (file = config.assets ["free-multibullets"])
		else:
			self.varFree.set (self.varFree.get() + 32768)
			self.imgB24_5.config (file = config.assets ["free-multibullets-taken"])
	def dotoggleB24_6 (self):
		if (self.varFree.get() & 65536):
			self.varFree.set (self.varFree.get() - 65536)
			self.imgB24_6.config (file = config.assets ["free-fireball"])
		else:
			self.varFree.set (self.varFree.get() + 65536)
			self.imgB24_6.config (file = config.assets ["free-fireball-taken"])
	def dotoggleB24_7 (self):
		if (self.varFree.get() & 131072):
			self.varFree.set (self.varFree.get() - 131072)
			self.imgB24_7.config (file = config.assets ["free-repeller"])
		else:
			self.varFree.set (self.varFree.get() + 131072)
			self.imgB24_7.config (file = config.assets ["free-repeller-taken"])

	def dotoggleB25_1 (self):
		if (self.varFree.get() & 262144):
			self.varFree.set (self.varFree.get() - 262144)
			self.imgB25_1.config (file = config.assets ["free-multibullets"])
		else:
			self.varFree.set (self.varFree.get() + 262144)
			self.imgB25_1.config (file = config.assets ["free-multibullets-taken"])
	def dotoggleB25_3 (self):
		if (self.varFree.get() & 524288):
			self.varFree.set (self.varFree.get() - 524288)
			self.imgB25_3.config (file = config.assets ["free-cutter-laser"])
		else:
			self.varFree.set (self.varFree.get() + 524288)
			self.imgB25_3.config (file = config.assets ["free-cutter-laser-taken"])
	def dotoggleB25_4 (self):
		if (self.varFree.get() & 1048576):
			self.varFree.set (self.varFree.get() - 1048576)
			self.imgB25_4.config (file = config.assets ["free-back-fire"])
		else:
			self.varFree.set (self.varFree.get() + 1048576)
			self.imgB25_4.config (file = config.assets ["free-back-fire-taken"])
	def dotoggleB25_5 (self):
		if (self.varFree.get() & 2097152):
			self.varFree.set (self.varFree.get() - 2097152)
			self.imgB25_5.config (file = config.assets ["free-blue-lander"])
		else:
			self.varFree.set (self.varFree.get() + 2097152)
			self.imgB25_5.config (file = config.assets ["free-blue-lander-taken"])
	def dotoggleB25_6 (self):
		if (self.varFree.get() & 4194304):
			self.varFree.set (self.varFree.get() - 4194304)
			self.imgB25_6.config (file = config.assets ["free-energy-tank"])
		else:
			self.varFree.set (self.varFree.get() + 4194304)
			self.imgB25_6.config (file = config.assets ["free-energy-tank-taken"])
	def dotoggleB25_7 (self):
		if (self.varFree.get() & 8388608):
			self.varFree.set (self.varFree.get() - 8388608)
			self.imgB25_7.config (file = config.assets ["free-burst-rate"])
		else:
			self.varFree.set (self.varFree.get() + 8388608)
			self.imgB25_7.config (file = config.assets ["free-burst-rate-taken"])

	def dotoggleB28_0 (self):
		if (self.varFree.get() & 16777216):
			self.varFree.set (self.varFree.get() - 16777216)
			self.imgB28_0.config (file = config.assets ["free-enemy-erasers"])
		else:
			self.varFree.set (self.varFree.get() + 16777216)
			self.imgB28_0.config (file = config.assets ["free-enemy-erasers-taken"])
	def dotoggleB28_1 (self):
		if (self.varFree.get() & 33554432):
			self.varFree.set (self.varFree.get() - 33554432)
			self.imgB28_1.config (file = config.assets ["free-energy-tank"])
		else:
			self.varFree.set (self.varFree.get() + 33554432)
			self.imgB28_1.config (file = config.assets ["free-energy-tank-taken"])
	def dotoggleB28_2 (self):
		if (self.varFree.get() & 67108864):
			self.varFree.set (self.varFree.get() - 67108864)
			self.imgB28_2.config (file = config.assets ["free-energy-tank"])
		else:
			self.varFree.set (self.varFree.get() + 67108864)
			self.imgB28_2.config (file = config.assets ["free-energy-tank-taken"])

	def dotoggleB29_1 (self):
		if (self.varFree.get() & 134217728):
			self.varFree.set (self.varFree.get() - 134217728)
			self.imgB29_1.config (file = config.assets ["free-blue-lander"])
		else:
			self.varFree.set (self.varFree.get() + 134217728)
			self.imgB29_1.config (file = config.assets ["free-blue-lander-taken"])
	def dotoggleB29_2 (self):
		if (self.varFree.get() & 268435456):
			self.varFree.set (self.varFree.get() - 268435456)
			self.imgB29_2.config (file = config.assets ["free-enemy-erasers"])
		else:
			self.varFree.set (self.varFree.get() + 268435456)
			self.imgB29_2.config (file = config.assets ["free-enemy-erasers-taken"])
	def dotoggleB29_3 (self):
		if (self.varFree.get() & 536870912):
			self.varFree.set (self.varFree.get() - 536870912)
			self.imgB29_3.config (file = config.assets ["free-enemy-erasers"])
		else:
			self.varFree.set (self.varFree.get() + 536870912)
			self.imgB29_3.config (file = config.assets ["free-enemy-erasers-taken"])
	def dotoggleB29_4 (self):
		if (self.varFree.get() & 1073741824):
			self.varFree.set (self.varFree.get() - 1073741824)
			self.imgB29_4.config (file = config.assets ["free-blue-lander"])
		else:
			self.varFree.set (self.varFree.get() + 1073741824)
			self.imgB29_4.config (file = config.assets ["free-blue-lander-taken"])
	def dotoggleB29_5 (self):
		if (self.varFree.get() & 2147483648):
			self.varFree.set (self.varFree.get() - 2147483648)
			self.imgB29_5.config (file = config.assets ["free-red-lander"])
		else:
			self.varFree.set (self.varFree.get() + 2147483648)
			self.imgB29_5.config (file = config.assets ["free-red-lander-taken"])
	def dotoggleB29_6 (self):
		if (self.varFree.get() & 4294967296):
			self.varFree.set (self.varFree.get() - 4294967296)
			self.imgB29_6.config (file = config.assets ["free-shield"])
		else:
			self.varFree.set (self.varFree.get() + 4294967296)
			self.imgB29_6.config (file = config.assets ["free-shield-taken"])
	def dotoggleB29_7 (self):
		if (self.varFree.get() & 8589934592):
			self.varFree.set (self.varFree.get() - 8589934592)
			self.imgB29_7.config (file = config.assets ["free-energy-tank"])
		else:
			self.varFree.set (self.varFree.get() + 8589934592)
			self.imgB29_7.config (file = config.assets ["free-energy-tank-taken"])

	# One of these code blocks fires when one of the Keys buttons is clicked.
	def dotoggleKey0 (self):
		if (self.varKeys.get() & 1):
			self.varKeys.set (self.varKeys.get() - 1)
			self.imgKey0.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 1)
			self.imgKey0.config (file = config.assets ["first-key"])
	def dotoggleKey1 (self):
		if (self.varKeys.get() & 2):
			self.varKeys.set (self.varKeys.get() - 2)
			self.imgKey1.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 2)
			self.imgKey1.config (file = config.assets ["second-key"])
	def dotoggleKey2 (self):
		if (self.varKeys.get() & 4):
			self.varKeys.set (self.varKeys.get() - 4)
			self.imgKey2.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 4)
			self.imgKey2.config (file = config.assets ["third-key"])
	def dotoggleKey3 (self):
		if (self.varKeys.get() & 8):
			self.varKeys.set (self.varKeys.get() - 8)
			self.imgKey3.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 8)
			self.imgKey3.config (file = config.assets ["fourth-key"])
	def dotoggleKey4 (self):
		if (self.varKeys.get() & 16):
			self.varKeys.set (self.varKeys.get() - 16)
			self.imgKey4.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 16)
			self.imgKey4.config (file = config.assets ["fifth-key"])
	def dotoggleKey5 (self):
		if (self.varKeys.get() & 32):
			self.varKeys.set (self.varKeys.get() - 32)
			self.imgKey5.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 32)
			self.imgKey5.config (file = config.assets ["sixth-key"])
	def dotoggleKey6 (self):
		if (self.varKeys.get() & 64):
			self.varKeys.set (self.varKeys.get() - 64)
			self.imgKey6.config (file = config.assets ["no-key"])
		else:
			self.varKeys.set (self.varKeys.get() + 64)
			self.imgKey6.config (file = config.assets ["seventh-key"])

	# One of these code blocks fires when one of the Weapons buttons is clicked.
	def docycleWeapon00 (self):
		if ((self.varWeapons.get() & 3) == 3):
			self.varWeapons.set (self.varWeapons.get() - 3)
			self.imgWeapon00.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 1)
			if ((self.varWeapons.get() & 3) == 1):
				self.imgWeapon00.config (file = config.assets ["multibullets-blue"])
			elif ((self.varWeapons.get() & 3) == 2):
				self.imgWeapon00.config (file = config.assets ["multibullets-green"])
			else:
				self.imgWeapon00.config (file = config.assets ["multibullets-pink"])
	def docycleWeapon02 (self):
		if ((self.varWeapons.get() & 12) == 12):
			self.varWeapons.set (self.varWeapons.get() - 12)
			self.imgWeapon02.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 4)
			if ((self.varWeapons.get() & 12) == 4):
				self.imgWeapon02.config (file = config.assets ["back-fire-blue"])
			elif ((self.varWeapons.get() & 12) == 8):
				self.imgWeapon02.config (file = config.assets ["back-fire-green"])
			else:
				self.imgWeapon02.config (file = config.assets ["back-fire-pink"])
	def docycleWeapon04 (self):
		if ((self.varWeapons.get() & 48) == 48):
			self.varWeapons.set (self.varWeapons.get() - 48)
			self.imgWeapon04.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 16)
			if ((self.varWeapons.get() & 48) == 16):
				self.imgWeapon04.config (file = config.assets ["wave-attack-blue"])
			elif ((self.varWeapons.get() & 48) == 32):
				self.imgWeapon04.config (file = config.assets ["wave-attack-green"])
			else:
				self.imgWeapon04.config (file = config.assets ["wave-attack-pink"])
	def docycleWeapon06 (self):
		if ((self.varWeapons.get() & 192) == 192):
			self.varWeapons.set (self.varWeapons.get() - 192)
			self.imgWeapon06.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 64)
			if ((self.varWeapons.get() & 192) == 64):
				self.imgWeapon06.config (file = config.assets ["bullet-shield-blue"])
			elif ((self.varWeapons.get() & 192) == 128):
				self.imgWeapon06.config (file = config.assets ["bullet-shield-green"])
			else:
				self.imgWeapon06.config (file = config.assets ["bullet-shield-pink"])
	def docycleWeapon08 (self):
		if ((self.varWeapons.get() & 768) == 768):
			self.varWeapons.set (self.varWeapons.get() - 768)
			self.imgWeapon08.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 256)
			if ((self.varWeapons.get() & 768) == 256):
				self.imgWeapon08.config (file = config.assets ["grenade-blue"])
			elif ((self.varWeapons.get() & 768) == 512):
				self.imgWeapon08.config (file = config.assets ["grenade-green"])
			else:
				self.imgWeapon08.config (file = config.assets ["grenade-pink"])
	def docycleWeapon10 (self):
		if ((self.varWeapons.get() & 3072) == 3072):
			self.varWeapons.set (self.varWeapons.get() - 3072)
			self.imgWeapon10.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 1024)
			if ((self.varWeapons.get() & 3072) == 1024):
				self.imgWeapon10.config (file = config.assets ["fireball-blue"])
			elif ((self.varWeapons.get() & 3072) == 2048):
				self.imgWeapon10.config (file = config.assets ["fireball-green"])
			else:
				self.imgWeapon10.config (file = config.assets ["fireball-pink"])
	def docycleWeapon12 (self):
		if ((self.varWeapons.get() & 12288) == 12288):
			self.varWeapons.set (self.varWeapons.get() - 12288)
			self.imgWeapon12.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 4096)
			if ((self.varWeapons.get() & 12288) == 4096):
				self.imgWeapon12.config (file = config.assets ["area-blaster-blue"])
			elif ((self.varWeapons.get() & 12288) == 8192):
				self.imgWeapon12.config (file = config.assets ["area-blaster-green"])
			else:
				self.imgWeapon12.config (file = config.assets ["area-blaster-pink"])
	def docycleWeapon14 (self):
		if ((self.varWeapons.get() & 49152) == 49152):
			self.varWeapons.set (self.varWeapons.get() - 49152)
			self.imgWeapon14.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 16384)
			if ((self.varWeapons.get() & 49152) == 16384):
				self.imgWeapon14.config (file = config.assets ["repeller-blue"])
			elif ((self.varWeapons.get() & 49152) == 32768):
				self.imgWeapon14.config (file = config.assets ["repeller-green"])
			else:
				self.imgWeapon14.config (file = config.assets ["repeller-pink"])
	def docycleWeapon16 (self):
		if ((self.varWeapons.get() & 196608) == 196608):
			self.varWeapons.set (self.varWeapons.get() - 196608)
			self.imgWeapon16.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 65536)
			if ((self.varWeapons.get() & 196608) == 65536):
				self.imgWeapon16.config (file = config.assets ["hyper-laser-blue"])
			elif ((self.varWeapons.get() & 196608) == 131072):
				self.imgWeapon16.config (file = config.assets ["hyper-laser-green"])
			else:
				self.imgWeapon16.config (file = config.assets ["hyper-laser-pink"])
	def docycleWeapon18 (self):
		if ((self.varWeapons.get() & 786432) == 786432):
			self.varWeapons.set (self.varWeapons.get() - 786432)
			self.imgWeapon18.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 262144)
			if ((self.varWeapons.get() & 786432) == 262144):
				self.imgWeapon18.config (file = config.assets ["saber-laser-blue"])
			elif ((self.varWeapons.get() & 786432) == 524288):
				self.imgWeapon18.config (file = config.assets ["saber-laser-green"])
			else:
				self.imgWeapon18.config (file = config.assets ["saber-laser-pink"])
	def docycleWeapon20 (self):
		if ((self.varWeapons.get() & 3145728) == 3145728):
			self.varWeapons.set (self.varWeapons.get() - 3145728)
			self.imgWeapon20.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 1048576)
			if ((self.varWeapons.get() & 3145728) == 1048576):
				self.imgWeapon20.config (file = config.assets ["cutter-laser-blue"])
			elif ((self.varWeapons.get() & 3145728) == 2097152):
				self.imgWeapon20.config (file = config.assets ["cutter-laser-green"])
			else:
				self.imgWeapon20.config (file = config.assets ["cutter-laser-pink"])
	def dotoggleWeapon22 (self):
		if (self.varWeapons.get() & 4194304):
			self.varWeapons.set (self.varWeapons.get() - 4194304)
			self.imgWeapon22.config (file = config.assets ["no-weapon"])
		else:
			self.varWeapons.set (self.varWeapons.get() + 4194304)
			self.imgWeapon22.config (file = config.assets ["enemy-erasers-blue"])

	# One of these code blocks fires when the "Instructions" button is clicked or one of the '?' buttons.
	def dohelpGeneral (self):
		tk.messagebox.showinfo ("TGLPG Instructions (1 of 7)", "(Note: there is no fixed order to these steps.)\n\nStarting with the Quantities Frame to the right of the Map, there are seven values to enter:\n\n\ta. Score,\n\tb. Attack Power,\n\tc. Shield Power,\n\td. Burst Rate,\n\te. Heart Max,\n\tf. Red Landers,\n\tg. # of Enemy Erasers.\n\nClick on the \"?\" button to the right of one of the values for more information about that value.")
		tk.messagebox.showinfo ("TGLPG Instructions (2 of 7)", "To the right of the Quantities Frame is the Location Frame with two sliders representing your X/Y position on the map.\n\nMiria will move to the indicated space on the Map when you get your password.\n\nClick on the \"?\" button within this frame for more information about positioning.")
		tk.messagebox.showinfo ("TGLPG Instructions (3 of 7)", "Below the Location Frame is the Keys Frame.\n\nClick on one of the squares to toggle having a certain key (the image of that key will appear).\n\nBe aware that you can get stuck in the game if the combination of location, keys, and corridors completed leave you in an area where you can't get in or out.")
		tk.messagebox.showinfo ("TGLPG Instructions (4 of 7)", "Below the Keys Frame is the Optional Weapons Frame.\n\nClick on one of the squares to cycle through a certain weapon's power level:\n\n\ta. Level 1 = Blue,\n\tb. Level 2 = Green,\n\tc. Level 3 = Pink.\n\nThe last square is to enable Enemy Erasers (separate from how many you have), and it can only be Blue.")
		tk.messagebox.showinfo ("TGLPG Instructions (5 of 7)", "Click on any of the buttons on the Map to toggle:\n\nHaving collected a \"Free\" item,\nHaving defeated a \"Miniboss\"and collecting the prize,\nHaving purchased from a \"Shop\",\nHaving completed a \"Corr\"idor (these squares have white borders, including \"Corridor 21\", which is red in the middle).\n\nA red \"X\" will appear over the image.")
		tk.messagebox.showinfo ("TGLPG Instructions (6 of 7)", "Finally, click on the \"Get Password\" button.\n\nMiria will move on the map if her Location has changed.\n\nThe last digit of your Score will be set to 0.\n\nYour Enemy Eraser count will be set to 255 if it is higher than that.\n\nFinally, the password will appear in the Password Frame.")
		tk.messagebox.showinfo ("TGLPG Instructions (7 of 7)", "When you are finished, click on the \"About\" button for information about this program, or just click on the \"Quit\" button.")
	def dohelpScore (self):
		tk.messagebox.showinfo ("Score", "Your score contains six digits of significance, plus a padded zero.\n\nThat means your score can be anywhere between 0 and 9999990, and it always ends in zero.\n\nThe game supposedly crashes if you max out the score.")
	def dohelpAttack (self):
		tk.messagebox.showinfo ("Attack Power", "Any range between 1 and 8 is accepted, but if you go higher than 4, the Attack Power is capped at 4.")
	def dohelpShield (self):
		tk.messagebox.showinfo ("Shield Power", "You start the game at 1 and can go up to 7.\n\nIf you set it to 0, you will have tremendous Attack Power as well as Shield Power.\n\nPicking up a Shield powerup with 0 Shield does not affect its power level.\n\n0 Shield Power seems to overflow the attack power of some of the Optional Weapons, causing them to heal enemies, so be careful.")
	def dohelpBurstRate (self):
		tk.messagebox.showinfo ("Burst Rate", "This is the number of \"Consecutive Firing\" powerups you've collected.\n\nIf you go higher than 5, you will have a terrible Burst Rate.\n\nPicking up a Consecutive Firing powerup with a Burst Rate at or above 5 will bring it back to 5.")
	def dohelpRedLanders (self):
		tk.messagebox.showinfo ("Red Landers", "This is the number of Red Landers you've collected.\n\nThere are 9 Red Landers in the game, but you can collect up to 10 in TGL Mode.  Perhaps the level designers left one out.\n\nIf you give yourself Red Landers prematurely so that collecting one would put you higher than 10, your Red Lander count will remain as it is.\n\nAt higher Red Lander counts, your Chip Max and Chip count will be displayed as \"9999\" if higher than that.")
	def dohelpEEs (self):
		tk.messagebox.showinfo ("Enemy Erasers", "How many Enemy Erasers you have is separate from whether it is selectable from the Subscreen.\n\nMake sure you click on the last square in the Optional Weapons Frame to enable Enemy Erasers.")
	def dohelpLocation (self):
		tk.messagebox.showinfo ("X and Y Coordinates", "Any range between 0 and 31 is accepted, but the map only goes from 0 to 23.\n\nStarting in a location that's not part of the map is allowed, but will have unpredictable results.\n\nIn the normal course of play, your current location would be one of the red-bordered rooms on the map.")

	# This code fires when the "About" button is clicked.
	def doabout (self):
		tk.messagebox.showinfo ("About TGLPG", "TGLPG - The Guardian Legend Password Generator\n\nWritten by Michael Hayes\n\nDate Of Last Modification:\nFebruary 15, 2022\n\nBased on the information contained in the Password FAQ posted on GameFAQs by FatRatNight.")

app = Application()
app.master.title ("The Guardian Legend Password Generator")
app.master.iconphoto (True, tk.PhotoImage (file = config.workingpath + "icon.png"))
app.master.geometry (config.geometry)
app.configure (bg = config.windowbgcolor)
app.mainloop()

# EOF
