hashbang = "#!/data/data/com.termux/files/usr/bin/bash"

# Be sure to leave a slash at the end of all paths!  You should be running "play" or "make" from the Home folder.
# If you're using a MicroSD card, replace "DEAD-BEEF" with your card's serial number.  Use the "df" command to find out what it is.  Refer to Step 2J.  Also, leave the slash in front.
workingpath = "pidejl/"
screenshotpath = "/storage/DEAD-BEEF/Intellivision/"
boxpath = "/storage/DEAD-BEEF/Intellivision/"
manualpath = "/storage/DEAD-BEEF/Intellivision/"
overlaypath = "/storage/DEAD-BEEF/Intellivision/"
jzintvpath = ""
rompath = "/storage/DEAD-BEEF/Intellivision/"

font = ("Sans", "12")
fontframeheader = ("Sans", "10", "bold")
# New in March 2023 - colors and sizes the drop-down menu for game groups
fontoptionmenu = ("Sans", "10", "bold")

defaultimage1 = workingpath + "welcome.png"
defaultimage2 = workingpath + "notfound.png"

# The range of window size options is 0-7.  Run "jzintv --help | more" for more information.
defaultwindowsize = "3"
# Set the border size to this many Intellivision pixels.
defaultbordersize = "6"
# 0 if disabled, 1 if enabled.  Do not use Fullscreen with wm2!
defaultfullscreen = "0"
# " " for NTSC, "-P" for PAL.
defaultgraphicsmode = " "
# 0 for no sound, 11025 for lower-quality audio (better performance), 48000 for high-quality audio.
defaultaudiorate = "48000"
# " " for default jzIntv palette, "--gfx-palette=" + workingpath + "intycolors.cfg" for custom palette.
defaultpalette = "--gfx-palette=" + workingpath + "intycolors.cfg"

# Defaults for all other jzintv parameters.  They can be overriden by parameters in the GameList below.
globaloptions = "--kbdhackfile=" + workingpath + "hackfile.cfg --script=" + workingpath + "dbscript.txt --debugger"

# Now for the fun part!  Tweak this as appropriate.  Each game in the list contains six elements:
# 1. The name of the game as it will appear in the list
# 2. Filename of the ROM image
# 3. 0 if this game does not use ECS, 1 if it does.
# 4. 0 if this game does not use IntelliVoice, 1 if it does.
# 5. 0 for standard GRAM (all original games), 1 for any indie games that support double GRAM (from modified Intellivision II units), 2 for any indie games that support quadruple GRAM (found in the World Book Tutorvision).
# 6. Any game-specific parameters you want to add.  These will override the global options above.  Look to USCF Chess and Vectron for examples.
#    For USCF Chess, I disabled speed throttling so you can watch a 2-CPU match happen at difficulty level 6 in less than 31 hours!
#    For Vectron, I replaced the standard keyboard hack file with one that allows for the "half-wind" directions on the disc.
# Notice I left a comma after "Congo Bongo" at the very end.  It's a workaround for a bug that manifests with lists that have only one entry.  The same goes for the single entry for "Vectron" in the Mattel Arcade Network.
GameList = (
	("ABPA Backgammon", "Backgammon.rom", 0, 0, 0, ""),
	("Advanced Dungeons & Dragons: Cloudy Mountain", "Advanced Dungeons & Dragons Cloudy Mountain.rom", 0, 0, 0, ""),
	("Advanced Dungeons & Dragons: Treasure of Tarmin", "Advanced Dungeons & Dragons Treasure of Tarmin.rom", 0, 0, 0, ""),
	("Armor Battle", "Armor Battle Fast.rom", 0, 0, 0, ""),
	("Astrosmash!", "Astrosmash.rom", 0, 0, 0, ""),
	("Atlantis", "Atlantis.rom", 0, 0, 0, ""),
	("Auto Racing", "Auto Racing.rom", 0, 0, 0, ""),
	("B-17 Bomber", "B-17 Bomber.rom", 0, 1, 0, ""),
	("Beamrider", "Beamrider.rom", 0, 0, 0, ""),
	("Beauty & the Beast", "Beauty & the Beast.rom", 0, 0, 0, ""),
	("Blockade Runner", "Blockade Runner.rom", 0, 0, 0, ""),
	("Body Slam Super Pro Wrestling", "Body Slam Super Pro Wrestling.rom", 0, 0, 0, ""),
	("Bomb Squad", "Bomb Squad.rom", 0, 1, 0, ""),
	("Boxing", "Boxing.rom", 0, 0, 0, ""),
	("Bump & Jump", "Bump & Jump.rom", 0, 0, 0, ""),
	("Burgertime", "Burgertime.rom", 0, 0, 0, ""),
	("Buzz Bombers", "Buzz Bombers.rom", 0, 0, 0, ""),
	("Carnival", "Carnival.rom", 0, 0, 0, ""),
	("Centipede", "Centipede.rom", 0, 0, 0, ""),
	("Championship Tennis", "Championship Tennis.rom", 0, 0, 0, ""),
	("Checkers", "Checkers.rom", 0, 0, 0, ""),
	("Chip Shot Super Pro Golf", "Chip Shot Super Pro Golf.rom", 0, 0, 0, ""),
	("Commando", "Commando.rom", 0, 0, 0, ""),
	("Congo Bongo", "Congo Bongo.rom", 0, 0, 0, ""),
	("Defender", "Defender.rom", 0, 0, 0, ""),
	("Demon Attack", "Demon Attack.rom", 0, 0, 0, ""),
	("Dig Dug", "Dig Dug.rom", 0, 0, 0, ""),
	("Diner", "Diner.rom", 0, 0, 0, ""),
	("Donkey Kong", "Donkey Kong.rom", 0, 0, 0, ""),
	("Donkey Kong Jr.", "Donkey Kong Jr.rom", 0, 0, 0, ""),
	("Dracula", "Dracula.rom", 0, 0, 0, ""),
	("Dragonfire", "Dragonfire.rom", 0, 0, 0, ""),
	("The Dreadnaught Factor", "Dreadnaught Factor.rom", 0, 0, 0, ""),
	("The Electric Company Math Fun", "Math Fun.rom", 0, 0, 0, ""),
	("The Electric Company Word Fun", "Word Fun.rom", 0, 0, 0, ""),
	("Fathom", "Fathom.rom", 0, 0, 0, ""),
	("Frog Bog", "Frog Bog.rom", 0, 0, 0, ""),
	("Frogger", "Frogger.rom", 0, 0, 0, ""),
	("Happy Trails", "Happy Trails.rom", 0, 0, 0, ""),
	("Horse Racing", "Horse Racing.rom", 0, 0, 0, ""),
	("Hover Force", "Hover Force.rom", 0, 0, 0, ""),
	("Ice Trek", "Ice Trek.rom", 0, 0, 0, ""),
	("The Jetsons' Ways With Words", "The Jetsons' Ways With Words.rom", 1, 0, 0, "--ecs-tape=\"" + rompath + "ecs_tape_jwww.ecs\""),
	("Kool-Aid Man", "Kool-Aid Man.rom", 0, 0, 0, ""),
	("Ladybug", "Ladybug.rom", 0, 0, 0, ""),
	("Las Vegas Poker & Blackjack", "Las Vegas Poker & Blackjack.rom", 0, 0, 0, ""),
	("Las Vegas Roulette", "Las Vegas Roulette.rom", 0, 0, 0, ""),
	("Learning Fun 1", "Learning Fun 1.rom", 0, 0, 0, ""),
	("Learning Fun 2", "Learning Fun 2.rom", 0, 0, 0, ""),
	("Lock & Chase", "Lock & Chase.rom", 0, 0, 0, ""),
	("Lock & Chase (8K)", "Lock & Chase (8K).rom", 0, 0, 0, ""),
	("Locomotion", "Locomotion.rom", 0, 0, 0, ""),
	("Major League Baseball", "Baseball.rom", 0, 0, 0, ""),
	("Masters of the Universe: The Power of He-Man", "Masters of the Universe.rom", 0, 0, 0, ""),
	("Melody Blaster", "Melody Blaster.rom", 1, 0, 0, "--ecs-tape=\""+ rompath + "ecs_tape_mb.ecs\""),
	("Microsurgeon", "Microsurgeon.rom", 0, 0, 0, ""),
	("Mind Strike", "Mind Strike.rom", 1, 0, 0, ""),
	("Mission-X", "Mission-X.rom", 0, 0, 0, ""),
	("Motocross", "Motocross.rom", 0, 0, 0, ""),
	("Mountain Madness Super Pro Skiing", "Mountain Madness Super Pro Skiing.rom", 0, 0, 0, ""),
	("Mousetrap", "Mousetrap.rom", 0, 0, 0, ""),
	("Mr. BASIC Meets Bits & Bytes", "Mr BASIC Meets Bits & Bytes.rom", 1, 0, 0, ""),
	("NASL Soccer", "Soccer.rom", 0, 0, 0, ""),
	("NBA Basketball", "Basketball.rom", 0, 0, 0, ""),
	("NFL Football", "Football.rom", 0, 0, 0, ""),
	("NHL Hockey", "Hockey.rom", 0, 0, 0, ""),
	("Night Stalker", "Night Stalker.rom", 0, 0, 0, ""),
	("Nova Blast", "Nova Blast.rom", 0, 0, 0, ""),
	("Pac-Man (Atarisoft)", "Pac-Man.rom", 0, 0, 0, ""),
	("Pac-Man (INTV)", "Pac-Man (INTV).rom", 0, 0, 0, ""),
	("PBA Bowling", "Bowling.rom", 0, 0, 0, ""),
	("PGA Golf", "Golf.rom", 0, 0, 0, ""),
	("Pinball", "Pinball.rom", 0, 0, 0, ""),
	("Pitfall!", "Pitfall.rom", 0, 0, 0, ""),
	("Pole Position", "Pole Position.rom", 0, 0, 0, ""),
	("Popeye", "Popeye.rom", 0, 0, 0, ""),
	("Q*Bert", "Q-Bert.rom", 0, 0, 0, ""),
	("Reversi", "Reversi.rom", 0, 0, 0, ""),
	("River Raid", "River Raid.rom", 0, 0, 0, ""),
	("Royal Dealer", "Royal Dealer.rom", 0, 0, 0, ""),
	("Safecracker", "Safecracker.rom", 0, 0, 0, ""),
	("Scooby Doo's Maze Chase", "Scooby Doo's Maze Chase.rom", 1, 0, 0, ""),
	("Sea Battle", "Sea Battle.rom", 0, 0, 0, ""),
	("Sewer Sam", "Sewer Sam.rom", 0, 0, 0, ""),
	("Shark! Shark!", "Shark Shark.rom", 0, 0, 0, ""),
	("Sharp Shot", "Sharp Shot.rom", 0, 0, 0, ""),
	("Slam Dunk Super Pro Basketball", "Slam Dunk Super Pro Basketball.rom", 0, 0, 0, ""),
	("Slap Shot Super Pro Hockey", "Slap Shot Super Pro Hockey.rom", 0, 0, 0, ""),
	("SNAFU", "SNAFU.rom", 0, 0, 0, ""),
	("Space Armada", "Space Armada.rom", 0, 0, 0, ""),
	("Space Battle", "Space Battle.rom", 0, 0, 0, ""),
	("Space Hawk", "Space Hawk.rom", 0, 0, 0, ""),
	("Space Spartans", "Space Spartans.rom", 0, 1, 0, ""),
	("Spiker Super Pro Volleyball", "Spiker Super Pro Volleyball.rom", 0, 0, 0, ""),
	("Stadium Mud Buggies", "Stadium Mud Buggies.rom", 0, 0, 0, ""),
	("Stampede", "Stampede.rom", 0, 0, 0, ""),
	("Star Strike", "Star Strike.rom", 0, 0, 0, ""),
	("Star Wars: The Empire Strikes Back", "Star Wars.rom", 0, 0, 0, ""),
	("Sub Hunt", "Sub Hunt.rom", 0, 0, 0, ""),
	("Super Cobra", "Super Cobra.rom", 0, 0, 0, ""),
	("Super Pro Decathlon", "Super Pro Decathlon.rom", 0, 0, 0, ""),
	("Super Pro Football", "Super Pro Football.rom", 0, 0, 0, ""),
	("Swords & Serpents", "Swords & Serpents.rom", 0, 0, 0, ""),
	("Tennis", "Tennis.rom", 0, 0, 0, ""),
	("Thin Ice", "Thin Ice.rom", 0, 0, 0, ""),
	("Thunder Castle", "Thunder Castle.rom", 0, 0, 0, ""),
	("Tower of Doom", "Tower of Doom.rom", 0, 0, 0, ""),
	("Triple Action", "Triple Action.rom", 0, 0, 0, ""),
	("Triple Challenge", "Triple Challenge.rom", 0, 0, 0, ""),
	("Tron Deadly Discs", "Tron Deadly Discs.rom", 0, 0, 0, ""),
	("Tron Maze-A-Tron", "Tron Maze-A-Tron.rom", 0, 0, 0, ""),
	("Tron Solar Sailer", "Tron Solar Sailer.rom", 0, 1, 0, ""),
	("Tropical Trouble", "Tropical Trouble.rom", 0, 0, 0, ""),
	("Truckin'", "Truckin'.rom", 0, 0, 0, ""),
	("Turbo", "Turbo.rom", 0, 0, 0, ""),
	("Tutankham", "Tutankham.rom", 0, 0, 0, ""),
	("USCF Chess", "Chess.rom", 0, 0, 0, "--ratecontrol=0"),
	("U.S. Ski Team Skiing", "Skiing.rom", 0, 0, 0, ""),
	("Utopia", "Utopia.rom", 0, 0, 0, ""),
	("Vectron", "Vectron.rom", 0, 0, 0, "--kbdhackfile=\"" + workingpath + "veckeys.cfg\""),
	("Venture", "Venture.rom", 0, 0, 0, ""),
	("White Water!", "White Water.rom", 0, 0, 0, ""),
	("World Championship Baseball", "World Championship Baseball.rom", 0, 0, 0, ""),
	("World Cup Soccer", "World Cup Soccer.rom", 1, 0, 0, ""),
	("World Series Major League Baseball", "World Series Major League Baseball.rom", 1, 1, 0, "--ecs-tape=\"" + rompath + "ecs_tape_wmlb.ecs\""),
	("Worm Whomper", "Worm Whomper.rom", 0, 0, 0, ""),
	("Zaxxon", "Zaxxon.rom", 0, 0, 0, "")
	), (
	("Beamrider", "Beamrider.rom", 0, 0, 0, ""),
	("The Dreadnaught Factor", "Dreadnaught Factor.rom", 0, 0, 0, ""),
	("Happy Trails", "Happy Trails.rom", 0, 0, 0, ""),
	("Pitfall!", "Pitfall.rom", 0, 0, 0, ""),
	("River Raid", "River Raid.rom", 0, 0, 0, ""),
	("Stampede", "Stampede.rom", 0, 0, 0, ""),
	("Worm Whomper", "Worm Whomper.rom", 0, 0, 0, "")
	), (
	("Centipede", "Centipede.rom", 0, 0, 0, ""),
	("Defender", "Defender.rom", 0, 0, 0, ""),
	("Pac-Man", "Pac-Man.rom", 0, 0, 0, "")
	), (
	("Carnival", "Carnival.rom", 0, 0, 0, ""),
	("Donkey Kong", "Donkey Kong.rom", 0, 0, 0, ""),
	("Donkey Kong Jr.", "Donkey Kong Jr.rom", 0, 0, 0, ""),
	("Ladybug", "Ladybug.rom", 0, 0, 0, ""),
	("Mousetrap", "Mousetrap.rom", 0, 0, 0, ""),
	("Turbo", "Turbo.rom", 0, 0, 0, ""),
	("Venture", "Venture.rom", 0, 0, 0, ""),
	("Zaxxon", "Zaxxon.rom", 0, 0, 0, "")
	), (
	("Championship Tennis", "Championship Tennis.rom", 0, 0, 0, ""),
	("World Cup Soccer", "World Cup Soccer.rom", 1, 0, 0, "")
	), (
	("Atlantis", "Atlantis.rom", 0, 0, 0, ""),
	("Beauty & the Beast", "Beauty & the Beast.rom", 0, 0, 0, ""),
	("Demon Attack", "Demon Attack.rom", 0, 0, 0, ""),
	("Dracula", "Dracula.rom", 0, 0, 0, ""),
	("Dragonfire", "Dragonfire.rom", 0, 0, 0, ""),
	("Fathom", "Fathom.rom", 0, 0, 0, ""),
	("Ice Trek", "Ice Trek.rom", 0, 0, 0, ""),
	("Microsurgeon", "Microsurgeon.rom", 0, 0, 0, ""),
	("Nova Blast", "Nova Blast.rom", 0, 0, 0, ""),
	("Safecracker", "Safecracker.rom", 0, 0, 0, ""),
	("Swords & Serpents", "Swords & Serpents.rom", 0, 0, 0, ""),
	("Tropical Trouble", "Tropical Trouble.rom", 0, 0, 0, ""),
	("Truckin'", "Truckin'.rom", 0, 0, 0, ""),
	("White Water!", "White Water.rom", 0, 0, 0, "")
	), (
	("Blockade Runner", "Blockade Runner.rom", 0, 0, 0, ""),
	("Sewer Sam", "Sewer Sam.rom", 0, 0, 0, "")
	), (
	("Body Slam Super Pro Wrestling", "Body Slam Super Pro Wrestling.rom", 0, 0, 0, ""),
	("Chip Shot Super Pro Golf", "Chip Shot Super Pro Golf.rom", 0, 0, 0, ""),
	("Commando", "Commando.rom", 0, 0, 0, ""),
	("Dig Dug", "Dig Dug.rom", 0, 0, 0, ""),
	("Diner", "Diner.rom", 0, 0, 0, ""),
	("Hover Force", "Hover Force.rom", 0, 0, 0, ""),
	("Learning Fun 1", "Learning Fun 1.rom", 0, 0, 0, ""),
	("Learning Fun 2", "Learning Fun 2.rom", 0, 0, 0, ""),
	("Mountain Madness Super Pro Skiing", "Mountain Madness Super Pro Skiing.rom", 0, 0, 0, ""),
	("Pac-Man", "Pac-Man (INTV).rom", 0, 0, 0, ""),
	("Pole Position", "Pole Position.rom", 0, 0, 0, ""),
	("Slam Dunk Super Pro Basketball", "Slam Dunk Super Pro Basketball.rom", 0, 0, 0, ""),
	("Slap Shot Super Pro Hockey", "Slap Shot Super Pro Hockey.rom", 0, 0, 0, ""),
	("Spiker Super Pro Volleyball", "Spiker Super Pro Volleyball.rom", 0, 0, 0, ""),
	("Stadium Mud Buggies", "Stadium Mud Buggies.rom", 0, 0, 0, ""),
	("Super Pro Decathlon", "Super Pro Decathlon.rom", 0, 0, 0, ""),
	("Super Pro Football", "Super Pro Football.rom", 0, 0, 0, ""),
	("Thin Ice", "Thin Ice.rom", 0, 0, 0, ""),
	("Thunder Castle", "Thunder Castle.rom", 0, 0, 0, ""),
	("Tower of Doom", "Tower of Doom.rom", 0, 0, 0, ""),
	("Triple Challenge", "Triple Challenge.rom", 0, 0, 0, ""),
	("World Championship Baseball", "World Championship Baseball.rom", 0, 0, 0, "")
	), (
	("ABPA Backgammon", "Backgammon.rom", 0, 0, 0, ""),
	("Advanced Dungeons & Dragons: Cloudy Mountain", "Advanced Dungeons & Dragons Cloudy Mountain.rom", 0, 0, 0, ""),
	("Advanced Dungeons & Dragons: Treasure of Tarmin", "Advanced Dungeons & Dragons Treasure of Tarmin.rom", 0, 0, 0, ""),
	("Armor Battle", "Armor Battle Fast.rom", 0, 0, 0, ""),
	("Astrosmash!", "Astrosmash.rom", 0, 0, 0, ""),
	("Auto Racing", "Auto Racing.rom", 0, 0, 0, ""),
	("B-17 Bomber", "B-17 Bomber.rom", 0, 1, 0, ""),
	("Bomb Squad", "Bomb Squad.rom", 0, 1, 0, ""),
	("Boxing", "Boxing.rom", 0, 0, 0, ""),
	("Bump & Jump", "Bump & Jump.rom", 0, 0, 0, ""),
	("Burgertime", "Burgertime.rom", 0, 0, 0, ""),
	("Buzz Bombers", "Buzz Bombers.rom", 0, 0, 0, ""),
	("Checkers", "Checkers.rom", 0, 0, 0, ""),
	("The Electric Company Math Fun", "Math Fun.rom", 0, 0, 0, ""),
	("The Electric Company Word Fun", "Word Fun.rom", 0, 0, 0, ""),
	("Frog Bog", "Frog Bog.rom", 0, 0, 0, ""),
	("Horse Racing", "Horse Racing.rom", 0, 0, 0, ""),
	("The Jetsons' Ways With Words", "The Jetsons' Ways With Words.rom", 1, 0, 0, "--ecs-tape=\"" + rompath + "ecs_tape_jwww.ecs\""),
	("Kool-Aid Man", "Kool-Aid Man.rom", 0, 0, 0, ""),
	("Las Vegas Poker & Blackjack", "Las Vegas Poker & Blackjack.rom", 0, 0, 0, ""),
	("Las Vegas Roulette", "Las Vegas Roulette.rom", 0, 0, 0, ""),
	("Lock & Chase", "Lock & Chase.rom", 0, 0, 0, ""),
	("Lock & Chase (8K)", "Lock & Chase (8K).rom", 0, 0, 0, ""),
	("Locomotion", "Locomotion.rom", 0, 0, 0, ""),
	("Major League Baseball", "Baseball.rom", 0, 0, 0, ""),
	("Masters of the Universe: The Power of He-Man", "Masters of the Universe.rom", 0, 0, 0, ""),
	("Melody Blaster", "Melody Blaster.rom", 1, 0, 0, "--ecs-tape=\""+ rompath + "ecs_tape_mb.ecs\""),
	("Mind Strike", "Mind Strike.rom", 1, 0, 0, ""),
	("Mission-X", "Mission-X.rom", 0, 0, 0, ""),
	("Motocross", "Motocross.rom", 0, 0, 0, ""),
	("Mr. BASIC Meets Bits & Bytes", "Mr BASIC Meets Bits & Bytes.rom", 1, 0, 0, ""),
	("NASL Soccer", "Soccer.rom", 0, 0, 0, ""),
	("NBA Basketball", "Basketball.rom", 0, 0, 0, ""),
	("NFL Football", "Football.rom", 0, 0, 0, ""),
	("NHL Hockey", "Hockey.rom", 0, 0, 0, ""),
	("Night Stalker", "Night Stalker.rom", 0, 0, 0, ""),
	("PBA Bowling", "Bowling.rom", 0, 0, 0, ""),
	("PGA Golf", "Golf.rom", 0, 0, 0, ""),
	("Pinball", "Pinball.rom", 0, 0, 0, ""),
	("Reversi", "Reversi.rom", 0, 0, 0, ""),
	("Royal Dealer", "Royal Dealer.rom", 0, 0, 0, ""),
	("Scooby Doo's Maze Chase", "Scooby Doo's Maze Chase.rom", 1, 0, 0, ""),
	("Sea Battle", "Sea Battle.rom", 0, 0, 0, ""),
	("Shark! Shark!", "Shark Shark.rom", 0, 0, 0, ""),
	("Sharp Shot", "Sharp Shot.rom", 0, 0, 0, ""),
	("SNAFU", "SNAFU.rom", 0, 0, 0, ""),
	("Space Armada", "Space Armada.rom", 0, 0, 0, ""),
	("Space Battle", "Space Battle.rom", 0, 0, 0, ""),
	("Space Hawk", "Space Hawk.rom", 0, 0, 0, ""),
	("Space Spartans", "Space Spartans.rom", 0, 1, 0, ""),
	("Star Strike", "Star Strike.rom", 0, 0, 0, ""),
	("Sub Hunt", "Sub Hunt.rom", 0, 0, 0, ""),
	("Tennis", "Tennis.rom", 0, 0, 0, ""),
	("Triple Action", "Triple Action.rom", 0, 0, 0, ""),
	("Tron Deadly Discs", "Tron Deadly Discs.rom", 0, 0, 0, ""),
	("Tron Maze-A-Tron", "Tron Maze-A-Tron.rom", 0, 0, 0, ""),
	("Tron Solar Sailer", "Tron Solar Sailer.rom", 0, 1, 0, ""),
	("USCF Chess", "Chess.rom", 0, 0, 0, "--ratecontrol=0"),
	("U.S. Ski Team Skiing", "Skiing.rom", 0, 0, 0, ""),
	("Utopia", "Utopia.rom", 0, 0, 0, ""),
	("Vectron", "Vectron.rom", 0, 0, 0, "--kbdhackfile=\"" + workingpath + "veckeys.cfg\""),
	("World Championship Baseball", "World Championship Baseball.rom", 0, 0, 0, ""),
	("World Series Major League Baseball", "World Series Major League Baseball.rom", 1, 1, 0, "--ecs-tape=\"" + rompath + "ecs_tape_wmlb.ecs\"")
	), (
	("Bump & Jump", "Bump & Jump.rom", 0, 0, 0, ""),
	("Buzz Bombers", "Buzz Bombers.rom", 0, 0, 0, ""),
	("Kool-Aid Man", "Kool-Aid Man.rom", 0, 0, 0, ""),
	("Locomotion", "Locomotion.rom", 0, 0, 0, ""),
	("Masters of the Universe: The Power of He-Man", "Masters of the Universe.rom", 0, 0, 0, ""),
	("Mission-X", "Mission-X.rom", 0, 0, 0, ""),
	("Motocross", "Motocross.rom", 0, 0, 0, ""),
	("Pinball", "Pinball.rom", 0, 0, 0, ""),
	("World Championship Baseball", "World Championship Baseball.rom", 0, 0, 0, "")
	), (
	("The Jetsons' Ways With Words", "The Jetsons' Ways With Words.rom", 1, 0, 0, "--ecs-tape=\"" + rompath + "ecs_tape_jwww.ecs\""),
	("Melody Blaster", "Melody Blaster.rom", 1, 0, 0, "--ecs-tape=\""+ rompath + "ecs_tape_mb.ecs\""),
	("Mind Strike", "Mind Strike.rom", 1, 0, 0, ""),
	("Mr. BASIC Meets Bits & Bytes", "Mr BASIC Meets Bits & Bytes.rom", 1, 0, 0, ""),
	("Scooby Doo's Maze Chase", "Scooby Doo's Maze Chase.rom", 1, 0, 0, ""),
	("World Series Major League Baseball", "World Series Major League Baseball.rom", 1, 1, 0, "--ecs-tape=\"" + rompath + "ecs_tape_wmlb.ecs\"")
	), (
	("B-17 Bomber", "B-17 Bomber.rom", 0, 1, 0, ""),
	("Bomb Squad", "Bomb Squad.rom", 0, 1, 0, ""),
	("Space Spartans", "Space Spartans.rom", 0, 1, 0, ""),
	("Tron Solar Sailer", "Tron Solar Sailer.rom", 0, 1, 0, ""),
	("World Series Major League Baseball", "World Series Major League Baseball.rom", 1, 1, 0, "--ecs-tape=\"" + rompath + "ecs_tape_wmlb.ecs\"")
	), (
	("Advanced Dungeons & Dragons: Cloudy Mountain", "Advanced Dungeons & Dragons Cloudy Mountain.rom", 0, 0, 0, ""),
	("Advanced Dungeons & Dragons: Treasure of Tarmin", "Advanced Dungeons & Dragons Treasure of Tarmin.rom", 0, 0, 0, ""),
	("Bump & Jump", "Bump & Jump.rom", 0, 0, 0, ""),
	("Burgertime", "Burgertime.rom", 0, 0, 0, ""),
	("The Jetsons' Ways With Words", "The Jetsons' Ways With Words.rom", 1, 0, 0, "--ecs-tape=\"" + rompath + "ecs_tape_jwww.ecs\""),
	("Kool-Aid Man", "Kool-Aid Man.rom", 0, 0, 0, ""),
	("Lock & Chase", "Lock & Chase.rom", 0, 0, 0, ""),
	("Lock & Chase (8K)", "Lock & Chase (8K).rom", 0, 0, 0, ""),
	("Locomotion", "Locomotion.rom", 0, 0, 0, ""),
	("Masters of the Universe: The Power of He-Man", "Masters of the Universe.rom", 0, 0, 0, ""),
	("Mission-X", "Mission-X.rom", 0, 0, 0, ""),
	("Scooby Doo's Maze Chase", "Scooby Doo's Maze Chase.rom", 1, 0, 0, ""),
	("Tron Deadly Discs", "Tron Deadly Discs.rom", 0, 0, 0, ""),
	("Tron Maze-A-Tron", "Tron Maze-A-Tron.rom", 0, 0, 0, ""),
	("Tron Solar Sailer", "Tron Solar Sailer.rom", 0, 1, 0, "")
	), (
	("Armor Battle", "Armor Battle Fast.rom", 0, 0, 0, ""),
	("Frog Bog", "Frog Bog.rom", 0, 0, 0, ""),
	("Night Stalker", "Night Stalker.rom", 0, 0, 0, ""),
	("Sea Battle", "Sea Battle.rom", 0, 0, 0, ""),
	("Shark! Shark!", "Shark Shark.rom", 0, 0, 0, ""),
	("Sharp Shot", "Sharp Shot.rom", 0, 0, 0, ""),
	("SNAFU", "SNAFU.rom", 0, 0, 0, ""),
	("Sub Hunt", "Sub Hunt.rom", 0, 0, 0, ""),
	("Triple Action", "Triple Action.rom", 0, 0, 0, "")
	), (
	("Vectron", "Vectron.rom", 0, 0, 0, "--kbdhackfile=\"" + workingpath + "veckeys.cfg\""),
	), (
	("Horse Racing", "Horse Racing.rom", 0, 0, 0, ""),
	("Las Vegas Poker & Blackjack", "Las Vegas Poker & Blackjack.rom", 0, 0, 0, ""),
	("Las Vegas Roulette", "Las Vegas Roulette.rom", 0, 0, 0, "")
	), (
	("The Electric Company Math Fun", "Math Fun.rom", 0, 0, 0, ""),
	("The Electric Company Word Fun", "Word Fun.rom", 0, 0, 0, ""),
	), (
	("Astrosmash!", "Astrosmash.rom", 0, 0, 0, ""),
	("Space Armada", "Space Armada.rom", 0, 0, 0, ""),
	("Space Battle", "Space Battle.rom", 0, 0, 0, ""),
	("Space Hawk", "Space Hawk.rom", 0, 0, 0, ""),
	("Star Strike", "Star Strike.rom", 0, 0, 0, "")
	), (
	("Auto Racing", "Auto Racing.rom", 0, 0, 0, ""),
	("Boxing", "Boxing.rom", 0, 0, 0, ""),
	("Major League Baseball", "Baseball.rom", 0, 0, 0, ""),
	("NASL Soccer", "Soccer.rom", 0, 0, 0, ""),
	("NBA Basketball", "Basketball.rom", 0, 0, 0, ""),
	("NFL Football", "Football.rom", 0, 0, 0, ""),
	("NHL Hockey", "Hockey.rom", 0, 0, 0, ""),
	("PBA Bowling", "Bowling.rom", 0, 0, 0, ""),
	("PGA Golf", "Golf.rom", 0, 0, 0, ""),
	("Tennis", "Tennis.rom", 0, 0, 0, ""),
	("U.S. Ski Team Skiing", "Skiing.rom", 0, 0, 0, "")
	), (
	("ABPA Backgammon", "Backgammon.rom", 0, 0, 0, ""),
	("Checkers", "Checkers.rom", 0, 0, 0, ""),
	("Reversi", "Reversi.rom", 0, 0, 0, ""),
	("Royal Dealer", "Royal Dealer.rom", 0, 0, 0, ""),
	("USCF Chess", "Chess.rom", 0, 0, 0, "--ratecontrol=0"),
	("Utopia", "Utopia.rom", 0, 0, 0, ""),
	), (
	("Frogger", "Frogger.rom", 0, 0, 0, ""),
	("Q*Bert", "Q-Bert.rom", 0, 0, 0, ""),
	("Popeye", "Popeye.rom", 0, 0, 0, ""),
	("Star Wars: The Empire Strikes Back", "Star Wars.rom", 0, 0, 0, ""),
	("Super Cobra", "Super Cobra.rom", 0, 0, 0, ""),
	("Tutankham", "Tutankham.rom", 0, 0, 0, "")
	), (
	("Congo Bongo", "Congo Bongo.rom", 0, 0, 0, ""),
	)
# You might have noticed that the games are separated into groups.  Here is the list of group names.
GroupList = (
	"All games",
	"Activision",
	"Atarisoft",
	"Coleco",
	"Dextell",
	"Imagic",
	"Interphase",
	"INTV",
	"Mattel Electronics \n (all)",
	"Mattel Electronics \n (1983)",
	"Mattel Electronics \n (ECS)",
	"Mattel Electronics \n (IntelliVoice)",
	"Mattel Electronics \n (licensed)",
	"Mattel Electronics \n (Network - Action)",
	"Mattel Electronics \n (Network - Arcade)",
	"Mattel Electronics \n (Network - Gaming)",
	"Mattel Electronics \n (Network - Learning)",
	"Mattel Electronics \n (Network - Space)",
	"Mattel Electronics \n (Network - Sports)",
	"Mattel Electronics \n (Network - Strategy)",
	"Parker Brothers",
	"Sega"
	)
defaultgroup = 0  # The index of the games list that populates by default at startup.  0 is the first one, which in this case is "All games" in the GroupList above.

# __________
#
# (Development)

# Path where all your projects are located.
projectpath = "projects/"
# Path to your Archive.  All target files are backed up at Make time, and all source files are backed up when you select Backup.
# Again, modify this path as necessary.  Remember the "df" command to find out what to replace "DEAD-BEEF" with.
archivepath = "/storage/DEAD-BEEF/Archive/intyBASIC/"
editor = "geany"

# Your project list.  Tweak this as appropriate.  Make sure you have at least two projects defined here, or else leave the comma at the end of the line.
# Each project in the list contains seven elements:
# 1. The game title.  It will appear in the list this way and also become your game title in the ROM.
# 2. Subfolder within the projectpath.  Don't forget the slash at the end.
# 3. List of the project files in that subfolder.  If you have only .bas files, remove "*.txt" but leave the comma.
# 4. Subfolder within the archivepath.  Again, remember the slash afterward.
# 5. "--jlp" if this project uses JLP, or "" if it does not.
#	When running the game, JLP Flash data will be saved to a file whose base name is the ROM image filename, with a .sav extension.
# 6. The main source file for IntyBASIC to compile
# 7. The base name of the target files once compiled.  The ROM image file will be in .bin+.cfg format.
# I left FUBAR and X-Ray from my own projectlist as a couple examples to help you.
ProjectList = (
	("FUBAR", "fubar/", ("*.bas", "*.txt"), "FUBAR/", "--jlp", "main.bas", "fubar"),
	("X-Ray & DILLIGAS", "xray/", ("*.bas", "*.txt"), "XRay/", "", "main.bas", "xray")
	)

# EOF
