#!/data/data/com.termux/files/usr/bin/python
import tkinter as tk
from tkinter import messagebox
import config

class ToolTip (object):
	def __init__ (self, widget):
		self.widget = widget
		self.tipwindow = None
		self.id = None
		self.x = self.y = 0

	def showtip (self, text):
		"Display text in tooltip window"
		self.text = text
		if self.tipwindow or not self.text:
			return
		x, y, cx, cy = self.widget.bbox ("insert")
		x = x + self.widget.winfo_rootx() + config.tooltipoffsetx
		y = y + cy + self.widget.winfo_rooty() + config.tooltipoffsety
		self.tipwindow = tw = tk.Toplevel (self.widget)
		tw.wm_overrideredirect (True)  # Remove window decorations for the popup window.
		tw.wm_geometry ("+%d+%d" % (x, y))
		tw.wm_attributes ("-alpha", 0.85)  # Make the popup window see-through.  Works in Windows.
		label = tk.Label (tw, text = self.text, justify = tk.LEFT, background = config.tooltipbgcolor, foreground = config.tooltipfgcolor, relief = tk.SOLID, borderwidth = 1, font = config.fonttooltip)
		label.pack (ipadx = 1)

	def hidetip (self):
		tw = self.tipwindow
		self.tipwindow = None
		if tw:
			tw.destroy()

class Application (tk.Frame):
	def __init__(self, master = None):
		tk.Frame.__init__ (self, master)
		self.grid (sticky = tk.N + tk.S + tk.E + tk.W)
		self.createWidgets()

	def createWidgets (self):
		top = self.winfo_toplevel()
		top.rowconfigure (0, weight = 1)
		top.columnconfigure (0, weight = 1)
		self.rowconfigure (0, weight = 1)
		self.columnconfigure (0, weight = 1)

		# "Explicit" variable declarations
		self.varHelp = tk.BooleanVar()
		self.varBitA = tk.BooleanVar()
		self.varBitB = tk.BooleanVar()
		self.varBitC = tk.BooleanVar()
		self.varBitD = tk.BooleanVar()
		self.varBitE = tk.BooleanVar()
		self.varBitF = tk.BooleanVar()
		self.varBitG = tk.BooleanVar()
		self.varBitH = tk.BooleanVar()
		self.varBitI = tk.BooleanVar()
		self.varBitJ = tk.BooleanVar()
		self.varBitK = tk.BooleanVar()
		self.varBitL = tk.BooleanVar()
		self.varBitM = tk.BooleanVar()
		self.varBitN = tk.BooleanVar()
		self.varBitO = tk.BooleanVar()
		self.varBitP = tk.BooleanVar()
		self.varBitQ = tk.BooleanVar()
		self.varBitR = tk.BooleanVar()
		self.varBitS = tk.BooleanVar()
		self.varBitT = tk.BooleanVar()
		self.varBitU = tk.BooleanVar()
		self.varBitV = tk.BooleanVar()
		self.varBitW = tk.BooleanVar()
		self.varBitX = tk.BooleanVar()
		self.varBitY = tk.BooleanVar()
		self.varBitZ = tk.BooleanVar()
		self.varBit0 = tk.BooleanVar()
		self.varBit1 = tk.BooleanVar()
		self.varBit2 = tk.BooleanVar()
		self.varBit3 = tk.BooleanVar()
		self.varBit4 = tk.BooleanVar()
		self.varBit5 = tk.BooleanVar()
		self.varBit6 = tk.BooleanVar()
		self.varBit7 = tk.BooleanVar()
		self.varBit8 = tk.BooleanVar()
		self.varBit9 = tk.BooleanVar()
		self.varBitAPrime = tk.BooleanVar()
		self.varBitBPrime = tk.BooleanVar()
		self.varBitCPrime = tk.BooleanVar()
		self.varBitDPrime = tk.BooleanVar()
		self.varBitEPrime = tk.BooleanVar()
		self.varBitFPrime = tk.BooleanVar()
		self.varBitGPrime = tk.BooleanVar()
		self.varBitHPrime = tk.BooleanVar()
		self.varBitIPrime = tk.BooleanVar()
		self.varBitJPrime = tk.BooleanVar()
		self.varBitKPrime = tk.BooleanVar()
		self.varBitLPrime = tk.BooleanVar()
		self.varBitMPrime = tk.BooleanVar()
		self.varBitNPrime = tk.BooleanVar()
		self.varBitOPrime = tk.BooleanVar()
		self.varBitPPrime = tk.BooleanVar()
		self.varBitQPrime = tk.BooleanVar()
		self.varBitRPrime = tk.BooleanVar()
		self.varBitSPrime = tk.BooleanVar()
		self.varBitTPrime = tk.BooleanVar()
		self.varBitUPrime = tk.BooleanVar()
		self.varBitVPrime = tk.BooleanVar()
		self.varBitWPrime = tk.BooleanVar()
		self.varBitXPrime = tk.BooleanVar()

		# Set a few default values.
		self.varHelp.set (True)
		# March 2025 update: The Z flag is no longer raised by default, educating the user into clicking the Z button to "unlock" the other powerup controls.  Therefore, none of the other Bit variables are raised by default either.
		#self.varBitZ.set (True)
		#self.varBit6.set (True)
		#self.varBitAPrime.set (True)
		#self.varBitEPrime.set (True)
		#self.varBitIPrime.set (True)
		#self.varBitMPrime.set (True)
		#self.varBitQPrime.set (True)
		#self.varBitUPrime.set (True)

		# Image objects - Weapon Select screen
		self.imgPaneA = tk.PhotoImage (file = config.assets ["pane-a"])  # The "Pane A" object is the "Stage Select screen" background image.
		self.imgWeaponStormTornado = tk.PhotoImage (file = config.assets ["weapon-storm-t"])
		self.imgWeaponElectricSpark = tk.PhotoImage (file = config.assets ["weapon-e-spark"])
		self.imgWeaponBoomerangCutter = tk.PhotoImage (file = config.assets ["weapon-b-cutter"])
		self.imgWeaponShotgunIce = tk.PhotoImage (file = config.assets ["weapon-s-ice"])
		self.imgWeaponHomingTorpedo = tk.PhotoImage (file = config.assets ["weapon-homing-t"])
		self.imgWeaponChameleonSting = tk.PhotoImage (file = config.assets ["weapon-c-sting"])
		self.imgWeaponRollingShield = tk.PhotoImage (file = config.assets ["weapon-r-shield"])
		self.imgWeaponFireWave = tk.PhotoImage (file = config.assets ["weapon-fire-w"])
		self.imgHeartTankFlameMammoth = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankBoomerKuwanger = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankSparkMandrill = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankLaunchOctopus = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankChillPenguin = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankArmoredArmadillo = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankStormEagle = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgHeartTankStingChameleon = tk.PhotoImage (file = config.assets ["heart-tank"])
		self.imgSubTankStormEagle = tk.PhotoImage (file = config.assets ["sub-tank"])
		self.imgSubTankArmoredArmadillo = tk.PhotoImage (file = config.assets ["sub-tank"])
		self.imgSubTankSparkMandrill = tk.PhotoImage (file = config.assets ["sub-tank"])
		self.imgSubTankFlameMammoth = tk.PhotoImage (file = config.assets ["sub-tank"])
		self.imgDrLightStormEagle = tk.PhotoImage (file = config.assets ["dr-light"])
		self.imgDrLightFlameMammoth = tk.PhotoImage (file = config.assets ["dr-light"])
		self.imgDrLightStingChameleon = tk.PhotoImage (file = config.assets ["dr-light"])
		self.imgDrLightChillPenguin = tk.PhotoImage (file = config.assets ["dr-light"])
		self.imgDrLightArmoredArmadillo = tk.PhotoImage (file = config.assets ["dr-light"])

		# Image objects - "Before flipping" LED grid
		self.imgPaneB = tk.PhotoImage (file = config.assets ["pane-b"])  # The "Pane B" object is a combination of the "Weapon Select screen" and "Password screen" background images.
		self.imgBitA = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitB = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitC = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitD = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitE = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitF = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitG = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitH = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitI = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitJ = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitK = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitL = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitM = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitN = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitO = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitP = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitQ = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitR = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitS = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitT = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitU = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitV = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitW = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitX = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitY = tk.PhotoImage (file = config.assets ["light-off"])

		# March 2025 update: The Z flag is no longer raised by default, educating the user into clicking the Z button to "unlock" the other powerup controls.
		#self.imgBitZ = tk.PhotoImage (file = config.assets ["light-on-z"])
		self.imgBitZ = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit0 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit1 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit2 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit3 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit4 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit5 = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBit6 = tk.PhotoImage (file = config.assets ["light-on-lime"])
		self.imgBit6 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit7 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit8 = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit9 = tk.PhotoImage (file = config.assets ["light-off"])

		# Image objects - "After flipping" LED grid
		# March 2025 update: I reversed the row order of bits A-X.
		#self.imgBitAPrime = tk.PhotoImage (file = config.assets ["light-on-purple"])
		self.imgBitAPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitBPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitCPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitDPrime = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitEPrime = tk.PhotoImage (file = config.assets ["light-on-purple"])
		self.imgBitEPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitFPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitGPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitHPrime = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitIPrime = tk.PhotoImage (file = config.assets ["light-on-red"])
		self.imgBitIPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitJPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitKPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitLPrime = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitMPrime = tk.PhotoImage (file = config.assets ["light-on-red"])
		self.imgBitMPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitNPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitOPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitPPrime = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitQPrime = tk.PhotoImage (file = config.assets ["light-on-orange"])
		self.imgBitQPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitRPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitSPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitTPrime = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitUPrime = tk.PhotoImage (file = config.assets ["light-on-indigo"])
		self.imgBitUPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitVPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitWPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitXPrime = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBitYDup = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBitZDup = tk.PhotoImage (file = config.assets ["light-on-yellow"])
		self.imgBitZDup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit0Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit1Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit2Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit3Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit4Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit5Dup = tk.PhotoImage (file = config.assets ["light-off"])
		#self.imgBit6Dup = tk.PhotoImage (file = config.assets ["light-on-lime"])
		self.imgBit6Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit7Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit8Dup = tk.PhotoImage (file = config.assets ["light-off"])
		self.imgBit9Dup = tk.PhotoImage (file = config.assets ["light-off"])

		# Image objects - Password output
		# March 2025 update: The Z flag is no longer raised by default, educating the user into clicking the Z button to "unlock" the other powerup controls.  Therefore, none of the other Bit variables are raised by default either.  Therefore the default password is different.
		#self.imgDigit00 = tk.PhotoImage (file = config.assets ["number-1"])
		#self.imgDigit01 = tk.PhotoImage (file = config.assets ["number-7"])
		#self.imgDigit02 = tk.PhotoImage (file = config.assets ["number-6"])
		#self.imgDigit03 = tk.PhotoImage (file = config.assets ["number-8"])
		#self.imgDigit10 = tk.PhotoImage (file = config.assets ["number-5"])
		#self.imgDigit11 = tk.PhotoImage (file = config.assets ["number-8"])
		#self.imgDigit12 = tk.PhotoImage (file = config.assets ["number-5"])
		#self.imgDigit13 = tk.PhotoImage (file = config.assets ["number-8"])
		#self.imgDigit20 = tk.PhotoImage (file = config.assets ["number-3"])
		#self.imgDigit21 = tk.PhotoImage (file = config.assets ["number-8"])
		#self.imgDigit22 = tk.PhotoImage (file = config.assets ["number-8"])
		#self.imgDigit23 = tk.PhotoImage (file = config.assets ["number-4"])
		self.imgDigit00 = tk.PhotoImage (file = config.assets ["number-7"])
		self.imgDigit01 = tk.PhotoImage (file = config.assets ["number-6"])
		self.imgDigit02 = tk.PhotoImage (file = config.assets ["number-7"])
		self.imgDigit03 = tk.PhotoImage (file = config.assets ["number-1"])
		self.imgDigit10 = tk.PhotoImage (file = config.assets ["number-2"])
		self.imgDigit11 = tk.PhotoImage (file = config.assets ["number-8"])
		self.imgDigit12 = tk.PhotoImage (file = config.assets ["number-4"])
		self.imgDigit13 = tk.PhotoImage (file = config.assets ["number-4"])
		self.imgDigit20 = tk.PhotoImage (file = config.assets ["number-3"])
		self.imgDigit21 = tk.PhotoImage (file = config.assets ["number-2"])
		self.imgDigit22 = tk.PhotoImage (file = config.assets ["number-8"])
		self.imgDigit23 = tk.PhotoImage (file = config.assets ["number-4"])

		# Scrollbars
		self.xScroll = tk.Scrollbar (self, width = 24, orient = tk.HORIZONTAL)
		self.xScroll.grid (row = 1, column = 2, sticky = tk.W + tk.E)
		self.yScrollList = tk.Scrollbar (self, width = 24, orient = tk.VERTICAL)
		self.yScrollList.grid (row = 0, column = 1, rowspan = 2, sticky = tk.N + tk.S)
		self.yScrollScreens = tk.Scrollbar (self, width = 24, orient = tk.VERTICAL)
		self.yScrollScreens.grid (row = 0, column = 3, sticky = tk.N + tk.S)

		# Canvases
		self.canvasList = tk.Canvas (self, bg = config.canvasbgcolor, height = min (config.canvasheight, 672), width = config.canvaslistwidth, scrollregion = (0, 0, 399, 979), yscrollcommand = self.yScrollList.set)
		self.canvasList.grid (row = 0, column = 0, rowspan = 2)
		self.yScrollList ["command"] = self.canvasList.yview  # Needed to make the scrollbars moveable
		self.canvasScreens = tk.Canvas (self, bg = config.canvasbgcolor, height = min (config.canvasheight, 672), width = min (config.canvasscreenswidth, 1536), scrollregion = (0, 0, 1535, 671), xscrollcommand = self.xScroll.set, yscrollcommand = self.yScrollScreens.set)
		self.canvasScreens.grid (row = 0, column = 2)
		self.xScroll ["command"] = self.canvasScreens.xview
		self.yScrollScreens ["command"] = self.canvasScreens.yview
		self.canvasScreens.create_image (0, 0, anchor = tk.N + tk.W, image = self.imgPaneA)  # We're posting these onto the canvas now because other widgets are going to be overlayed above them.
		self.canvasScreens.create_image (768, 0, anchor = tk.N + tk.W, image = self.imgPaneB)

		# Frames
		self.frameDataBits = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Data Bits", bg = config.framebgcolor)  # Setting labelanchor to N centers the label text across the top line of the frame.
		self.canvasList.create_window (0, 0, anchor = tk.N + tk.W, window = self.frameDataBits)
		self.frameSeedBits = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Seed Bits", bg = config.framebgcolor)
		self.canvasScreens.create_window (600, 550, window = self.frameSeedBits)
		self.frameScratchpad = tk.LabelFrame (self, font = config.fontframeheader, labelanchor = "n", text = "Scratchpad", bg = config.framebgcolor)
		self.canvasScreens.create_window (1327, 430, window = self.frameScratchpad)

		# Command Buttons
		self.btnHelp = tk.Button (self, font = config.fontbuttons, text = "Hide\nToolTips", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dohelp)
		self.canvasScreens.create_window (169, 550, window = self.btnHelp)
		self.btnAbout = tk.Button (self, font = config.fontbuttons, text = "About", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.doabout)
		self.canvasScreens.create_window (169, 118, window = self.btnAbout)
		self.btnQuit = tk.Button (self, font = config.fontbuttons, text = "Quit", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.quit)
		self.canvasScreens.create_window (601, 118, window = self.btnQuit)
		self.btnSeedBitZ = tk.Button (self.frameSeedBits, font = config.fontbuttons, text = "Z (played\nfirst stage)", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dotoggleBitZ)
		self.btnSeedBitZ.grid (row = 0, column = 0, columnspan = 3)
		# March 2025 update: I reversed the order of bits 0-2 (name change only).
		self.btnSeedBit0 = tk.Button (self.frameSeedBits, font = config.fontbuttons, text = "0", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dotoggleBit0)
		self.btnSeedBit0.grid (row = 1, column = 0)
		self.btnSeedBit1 = tk.Button (self.frameSeedBits, font = config.fontbuttons, text = "1", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dotoggleBit1)
		self.btnSeedBit1.grid (row = 1, column = 1)
		self.btnSeedBit2 = tk.Button (self.frameSeedBits, font = config.fontbuttons, text = "2", bg = config.buttonbgcolor, fg = config.buttonfgcolor, state = tk.NORMAL, command = self.dotoggleBit2)
		self.btnSeedBit2.grid (row = 1, column = 2)

		# Checkbuttons and Buttons for the Data Bits frame
		# March 2025 update: I reversed the row order of bits A-X.
		self.chkBitA = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitA, state = tk.DISABLED, command = self.dotoggleBitA)
		self.chkBitA.grid (row = 0, column = 0)
		self.btnBitA = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "A. Have Weapon: Storm Tornado", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitA)
		self.btnBitA.grid (row = 0, column = 1)
		self.chkBitB = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitB, state = tk.DISABLED, command = self.dotoggleBitB)
		self.chkBitB.grid (row = 1, column = 0)
		self.btnBitB = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "B. Have Weapon: Electric Spark", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitB)
		self.btnBitB.grid (row = 1, column = 1)
		self.chkBitC = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitC, state = tk.DISABLED, command = self.dotoggleBitC)
		self.chkBitC.grid (row = 2, column = 0)
		self.btnBitC = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "C. Have Weapon: Boomerang Cutter", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitC)
		self.btnBitC.grid (row = 2, column = 1)
		self.chkBitD = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitD, state = tk.DISABLED, command = self.dotoggleBitD)
		self.chkBitD.grid (row = 3, column = 0)
		self.btnBitD = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "D. Have Weapon: Shotgun Ice", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitD)
		self.btnBitD.grid (row = 3, column = 1)

		self.chkBitE = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitE, state = tk.DISABLED, command = self.dotoggleBitE)
		self.chkBitE.grid (row = 4, column = 0)
		self.btnBitE = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "E. Have Weapon: Homing Torpedo", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitE)
		self.btnBitE.grid (row = 4, column = 1)
		self.chkBitF = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitF, state = tk.DISABLED, command = self.dotoggleBitF)
		self.chkBitF.grid (row = 5, column = 0)
		self.btnBitF = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "F. Have Weapon: Chameleon Sting", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitF)
		self.btnBitF.grid (row = 5, column = 1)
		self.chkBitG = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitG, state = tk.DISABLED, command = self.dotoggleBitG)
		self.chkBitG.grid (row = 6, column = 0)
		self.btnBitG = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "G. Have Weapon: Rolling Shield", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitG)
		self.btnBitG.grid (row = 6, column = 1)
		self.chkBitH = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitH, state = tk.DISABLED, command = self.dotoggleBitH)
		self.chkBitH.grid (row = 7, column = 0)
		self.btnBitH = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "H. Have Weapon: Fire Wave", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitH)
		self.btnBitH.grid (row = 7, column = 1)

		self.chkBitI = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitI, state = tk.DISABLED, command = self.dotoggleBitI)
		self.chkBitI.grid (row = 8, column = 0)
		self.btnBitI = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "I. Have Heart Tank: Flame Mammoth", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitI)
		self.btnBitI.grid (row = 8, column = 1)
		self.chkBitJ = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitJ, state = tk.DISABLED, command = self.dotoggleBitJ)
		self.chkBitJ.grid (row = 9, column = 0)
		self.btnBitJ = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "J. Have Heart Tank: Boomer Kuwanger", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitJ)
		self.btnBitJ.grid (row = 9, column = 1)
		self.chkBitK = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitK, state = tk.DISABLED, command = self.dotoggleBitK)
		self.chkBitK.grid (row = 10, column = 0)
		self.btnBitK = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "K. Have Heart Tank: Spark Mandrill", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitK)
		self.btnBitK.grid (row = 10, column = 1)
		self.chkBitL = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitL, state = tk.DISABLED, command = self.dotoggleBitL)
		self.chkBitL.grid (row = 11, column = 0)
		self.btnBitL = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "L. Have Heart Tank: Launch Octopus", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitL)
		self.btnBitL.grid (row = 11, column = 1)

		self.chkBitM = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitM, state = tk.DISABLED, command = self.dotoggleBitM)
		self.chkBitM.grid (row = 12, column = 0)
		self.btnBitM = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "M. Have Heart Tank: Chill Penguin", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitM)
		self.btnBitM.grid (row = 12, column = 1)
		self.chkBitN = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitN, state = tk.DISABLED, command = self.dotoggleBitN)
		self.chkBitN.grid (row = 13, column = 0)
		self.btnBitN = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "N. Have Heart Tank: Armored Armadillo", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitN)
		self.btnBitN.grid (row = 13, column = 1)
		self.chkBitO = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitO, state = tk.DISABLED, command = self.dotoggleBitO)
		self.chkBitO.grid (row = 14, column = 0)
		self.btnBitO = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "O. Have Heart Tank: Storm Eagle", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitO)
		self.btnBitO.grid (row = 14, column = 1)
		self.chkBitP = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitP, state = tk.DISABLED, command = self.dotoggleBitP)
		self.chkBitP.grid (row = 15, column = 0)
		self.btnBitP = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "P. Have Heart Tank: Sting Chameleon", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitP)
		self.btnBitP.grid (row = 15, column = 1)

		self.chkBitQ = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitQ, state = tk.DISABLED, command = self.dotoggleBitQ)
		self.chkBitQ.grid (row = 16, column = 0)
		self.btnBitQ = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "Q. Have Sub Tank: Storm Eagle", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitQ)
		self.btnBitQ.grid (row = 16, column = 1)
		self.chkBitR = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitR, state = tk.DISABLED, command = self.dotoggleBitR)
		self.chkBitR.grid (row = 17, column = 0)
		self.btnBitR = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "R. Have Sub Tank: Armored Armadillo", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitR)
		self.btnBitR.grid (row = 17, column = 1)
		self.chkBitS = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitS, state = tk.DISABLED, command = self.dotoggleBitS)
		self.chkBitS.grid (row = 18, column = 0)
		self.btnBitS = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "S. Have Sub Tank: Spark Mandrill", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitS)
		self.btnBitS.grid (row = 18, column = 1)
		self.chkBitT = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitT, state = tk.DISABLED, command = self.dotoggleBitT)
		self.chkBitT.grid (row = 19, column = 0)
		self.btnBitT = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "T. Have Sub Tank: Flame Mammoth", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitT)
		self.btnBitT.grid (row = 19, column = 1)

		self.chkBitU = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitU, state = tk.DISABLED, command = self.dotoggleBitU)
		self.chkBitU.grid (row = 20, column = 0)
		self.btnBitU = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "U. Have Dr. Light upgrade: Helmet", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitU)
		self.btnBitU.grid (row = 20, column = 1)
		self.chkBitV = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitV, state = tk.DISABLED, command = self.dotoggleBitV)
		self.chkBitV.grid (row = 21, column = 0)
		self.btnBitV = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "V. Have Dr. Light upgrade: Weapons", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitV)
		self.btnBitV.grid (row = 21, column = 1)
		self.chkBitW = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitW, state = tk.DISABLED, command = self.dotoggleBitW)
		self.chkBitW.grid (row = 22, column = 0)
		self.btnBitW = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "W. Have Dr. Light upgrade: Armor", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitW)
		self.btnBitW.grid (row = 22, column = 1)
		self.chkBitX = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitX, state = tk.DISABLED, command = self.dotoggleBitX)
		self.chkBitX.grid (row = 23, column = 0)
		self.btnBitX = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "X. Have Dr. Light upgrade: Boots", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitX)
		self.btnBitX.grid (row = 23, column = 1)

		# March 2025 update: I reversed the order of bits 0-2 (name change only).
		self.chkBitY = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitY, state = tk.DISABLED, command = self.dotoggleBitY)
		self.chkBitY.grid (row = 24, column = 0)
		self.btnBitY = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "Y. Have Dr. Light upgrade: Hadouken*", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.DISABLED, command = self.dotoggleBitY)
		self.btnBitY.grid (row = 24, column = 1)
		self.chkBitZ = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBitZ, command = self.dotoggleBitZ)
		self.chkBitZ.grid (row = 25, column = 0)
		self.btnBitZ = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "Z. Completed first stage (also a Seed Bit)", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.NORMAL, command = self.dotoggleBitZ)
		self.btnBitZ.grid (row = 25, column = 1)
		self.chkBit0 = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBit0, command = self.dotoggleBit0)
		self.chkBit0.grid (row = 26, column = 0)
		self.btnBit0 = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "0. Random Seed Bit", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.NORMAL, command = self.dotoggleBit0)
		self.btnBit0.grid (row = 26, column = 1)
		self.chkBit1 = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBit1, command = self.dotoggleBit1)
		self.chkBit1.grid (row = 27, column = 0)
		self.btnBit1 = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "1. Random Seed Bit", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.NORMAL, command = self.dotoggleBit1)
		self.btnBit1.grid (row = 27, column = 1)
		self.chkBit2 = tk.Checkbutton (self.frameDataBits, font = config.fontbuttons, variable = self.varBit2, command = self.dotoggleBit2)
		self.chkBit2.grid (row = 28, column = 0)
		self.btnBit2 = tk.Button (self.frameDataBits, width = config.listbuttonwidth, font = config.fontbuttons, text = "2. Random Seed Bit", bg = config.buttonbgcolor, fg = config.buttonfgcolor, anchor = tk.W, state = tk.NORMAL, command = self.dotoggleBit2)
		self.btnBit2.grid (row = 28, column = 1)

		# Icons for the Stage Select screen
		# March 2025 update: I reversed the row order of bits A-X.
		self.btnWeaponStormTornado = tk.Button (self, image = self.imgWeaponStormTornado, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitA)
		self.canvasScreens.create_window (104, 447, anchor = tk.N + tk.E, window = self.btnWeaponStormTornado)
		self.btnWeaponElectricSpark = tk.Button (self, image = self.imgWeaponElectricSpark, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitB)
		self.canvasScreens.create_window (368, 612, anchor = tk.N + tk.E, window = self.btnWeaponElectricSpark)
		self.btnWeaponBoomerangCutter = tk.Button (self, image = self.imgWeaponBoomerangCutter, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitC)
		self.canvasScreens.create_window (663, 406, anchor = tk.N + tk.W, window = self.btnWeaponBoomerangCutter)
		self.btnWeaponShotgunIce = tk.Button (self, image = self.imgWeaponShotgunIce, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitD)
		self.canvasScreens.create_window (475, 53, anchor = tk.S + tk.W, window = self.btnWeaponShotgunIce)
		self.btnWeaponHomingTorpedo = tk.Button (self, image = self.imgWeaponHomingTorpedo, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitE)
		self.canvasScreens.create_window (349, 53, anchor = tk.S + tk.E, window = self.btnWeaponHomingTorpedo)
		self.btnWeaponChameleonSting = tk.Button (self, image = self.imgWeaponChameleonSting, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitF)
		self.canvasScreens.create_window (475, 612, anchor = tk.N + tk.W, window = self.btnWeaponChameleonSting)
		self.btnWeaponRollingShield = tk.Button (self, image = self.imgWeaponRollingShield, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitG)
		self.canvasScreens.create_window (104, 332, anchor = tk.S + tk.E, window = self.btnWeaponRollingShield)
		self.btnWeaponFireWave = tk.Button (self, image = self.imgWeaponFireWave, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitH)
		self.canvasScreens.create_window (663, 332, anchor = tk.S + tk.W, window = self.btnWeaponFireWave)

		self.btnHeartTankFlameMammoth = tk.Button (self, image = self.imgHeartTankFlameMammoth, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitI)
		self.canvasScreens.create_window (663, 294, anchor = tk.S + tk.W, window = self.btnHeartTankFlameMammoth)
		self.btnHeartTankBoomerKuwanger = tk.Button (self, image = self.imgHeartTankBoomerKuwanger, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitJ)
		self.canvasScreens.create_window (663, 368, anchor = tk.N + tk.W, window = self.btnHeartTankBoomerKuwanger)
		self.btnHeartTankSparkMandrill = tk.Button (self, image = self.imgHeartTankSparkMandrill, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitK)
		self.canvasScreens.create_window (330, 612, anchor = tk.N + tk.E, window = self.btnHeartTankSparkMandrill)
		self.btnHeartTankLaunchOctopus = tk.Button (self, image = self.imgHeartTankLaunchOctopus, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitL)
		self.canvasScreens.create_window (311, 53, anchor = tk.S + tk.E, window = self.btnHeartTankLaunchOctopus)
		self.btnHeartTankChillPenguin = tk.Button (self, image = self.imgHeartTankChillPenguin, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitM)
		self.canvasScreens.create_window (437, 53, anchor = tk.S + tk.W, window = self.btnHeartTankChillPenguin)
		self.btnHeartTankArmoredArmadillo = tk.Button (self, image = self.imgHeartTankArmoredArmadillo, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitN)
		self.canvasScreens.create_window (104, 294, anchor = tk.S + tk.E, window = self.btnHeartTankArmoredArmadillo)
		self.btnHeartTankStormEagle = tk.Button (self, image = self.imgHeartTankStormEagle, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitO)
		self.canvasScreens.create_window (104, 409, anchor = tk.N + tk.E, window = self.btnHeartTankStormEagle)
		self.btnHeartTankStingChameleon = tk.Button (self, image = self.imgHeartTankStingChameleon, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitP)
		self.canvasScreens.create_window (437, 612, anchor = tk.N + tk.W, window = self.btnHeartTankStingChameleon)

		self.btnSubTankStormEagle = tk.Button (self, image = self.imgSubTankStormEagle, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitQ)
		self.canvasScreens.create_window (104, 371, anchor = tk.N + tk.E, window = self.btnSubTankStormEagle)
		self.btnSubTankArmoredArmadillo = tk.Button (self, image = self.imgSubTankArmoredArmadillo, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitR)
		self.canvasScreens.create_window (104, 256, anchor = tk.S + tk.E, window = self.btnSubTankArmoredArmadillo)
		self.btnSubTankSparkMandrill = tk.Button (self, image = self.imgSubTankSparkMandrill, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitS)
		self.canvasScreens.create_window (292, 612, anchor = tk.N + tk.E, window = self.btnSubTankSparkMandrill)
		self.btnSubTankFlameMammoth = tk.Button (self, image = self.imgSubTankFlameMammoth, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitT)
		self.canvasScreens.create_window (663, 256, anchor = tk.S + tk.W, window = self.btnSubTankFlameMammoth)

		self.btnDrLightStormEagle = tk.Button (self, image = self.imgDrLightStormEagle, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitU)
		self.canvasScreens.create_window (104, 333, anchor = tk.N + tk.E, window = self.btnDrLightStormEagle)
		self.btnDrLightFlameMammoth = tk.Button (self, image = self.imgDrLightFlameMammoth, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitV)
		self.canvasScreens.create_window (663, 218, anchor = tk.S + tk.W, window = self.btnDrLightFlameMammoth)
		self.btnDrLightStingChameleon = tk.Button (self, image = self.imgDrLightStingChameleon, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitW)
		self.canvasScreens.create_window (399, 612, anchor = tk.N + tk.W, window = self.btnDrLightStingChameleon)
		self.btnDrLightChillPenguin = tk.Button (self, image = self.imgDrLightChillPenguin, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitX)
		self.canvasScreens.create_window (399, 53, anchor = tk.S + tk.W, window = self.btnDrLightChillPenguin)
		self.btnDrLightArmoredArmadillo = tk.Button (self, image = self.imgDrLightArmoredArmadillo, height = 32, width = 32, state = tk.DISABLED, command = self.dotoggleBitY)
		self.canvasScreens.create_window (104, 218, anchor = tk.S + tk.E, window = self.btnDrLightArmoredArmadillo)

		# Lights for the "Before flipping" LED grid
		self.lblBitA = tk.Label (self, image = self.imgBitA)
		self.canvasScreens.create_window (853, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitA)
		self.lblBitB = tk.Label (self, image = self.imgBitB)
		self.canvasScreens.create_window (887, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitB)
		self.lblBitC = tk.Label (self, image = self.imgBitC)
		self.canvasScreens.create_window (921, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitC)
		self.lblBitD = tk.Label (self, image = self.imgBitD)
		self.canvasScreens.create_window (955, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitD)
		self.lblBitE = tk.Label (self, image = self.imgBitE)
		self.canvasScreens.create_window (853, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitE)
		self.lblBitF = tk.Label (self, image = self.imgBitF)
		self.canvasScreens.create_window (887, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitF)
		self.lblBitG = tk.Label (self, image = self.imgBitG)
		self.canvasScreens.create_window (921, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitG)
		self.lblBitH = tk.Label (self, image = self.imgBitH)
		self.canvasScreens.create_window (955, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitH)

		self.lblBitI = tk.Label (self, image = self.imgBitI)
		self.canvasScreens.create_window (853, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitI)
		self.lblBitJ = tk.Label (self, image = self.imgBitJ)
		self.canvasScreens.create_window (887, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitJ)
		self.lblBitK = tk.Label (self, image = self.imgBitK)
		self.canvasScreens.create_window (921, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitK)
		self.lblBitL = tk.Label (self, image = self.imgBitL)
		self.canvasScreens.create_window (955, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitL)
		self.lblBitM = tk.Label (self, image = self.imgBitM)
		self.canvasScreens.create_window (853, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitM)
		self.lblBitN = tk.Label (self, image = self.imgBitN)
		self.canvasScreens.create_window (887, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitN)
		self.lblBitO = tk.Label (self, image = self.imgBitO)
		self.canvasScreens.create_window (921, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitO)
		self.lblBitP = tk.Label (self, image = self.imgBitP)
		self.canvasScreens.create_window (955, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitP)

		self.lblBitQ = tk.Label (self, image = self.imgBitQ)
		self.canvasScreens.create_window (853, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitQ)
		self.lblBitR = tk.Label (self, image = self.imgBitR)
		self.canvasScreens.create_window (887, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitR)
		self.lblBitS = tk.Label (self, image = self.imgBitS)
		self.canvasScreens.create_window (921, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitS)
		self.lblBitT = tk.Label (self, image = self.imgBitT)
		self.canvasScreens.create_window (955, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitT)
		self.lblBitU = tk.Label (self, image = self.imgBitU)
		self.canvasScreens.create_window (853, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitU)
		self.lblBitV = tk.Label (self, image = self.imgBitV)
		self.canvasScreens.create_window (887, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitV)
		self.lblBitW = tk.Label (self, image = self.imgBitW)
		self.canvasScreens.create_window (921, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitW)
		self.lblBitX = tk.Label (self, image = self.imgBitX)
		self.canvasScreens.create_window (955, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitX)

		# March 2025 update: I reversed the order of bits 0-2, and 3-5 (name change only).
		self.lblBitZ = tk.Label (self, image = self.imgBitZ)
		self.canvasScreens.create_window (853, 418 + 16, anchor = tk.N + tk.W, window = self.lblBitZ)
		self.lblBit0 = tk.Label (self, image = self.imgBit0)
		self.canvasScreens.create_window (887, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit0)
		self.lblBit1 = tk.Label (self, image = self.imgBit1)
		self.canvasScreens.create_window (921, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit1)
		self.lblBit2 = tk.Label (self, image = self.imgBit2)
		self.canvasScreens.create_window (955, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit2)
		self.lblBitY = tk.Label (self, image = self.imgBitY)
		self.canvasScreens.create_window (853, 478 + 16, anchor = tk.N + tk.W, window = self.lblBitY)
		self.lblBit3 = tk.Label (self, image = self.imgBit3)
		self.canvasScreens.create_window (887, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit3)
		self.lblBit4 = tk.Label (self, image = self.imgBit4)
		self.canvasScreens.create_window (921, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit4)
		self.lblBit5 = tk.Label (self, image = self.imgBit5)
		self.canvasScreens.create_window (955, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit5)
		self.lblBit6 = tk.Label (self, image = self.imgBit6)
		self.canvasScreens.create_window (853, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit6)
		self.lblBit7 = tk.Label (self, image = self.imgBit7)
		self.canvasScreens.create_window (887, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit7)
		self.lblBit8 = tk.Label (self, image = self.imgBit8)
		self.canvasScreens.create_window (921, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit8)
		self.lblBit9 = tk.Label (self, image = self.imgBit9)
		self.canvasScreens.create_window (955, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit9)

		# Lights for the "After flipping" LED grid
		self.lblBitAPrime = tk.Label (self, image = self.imgBitAPrime)
		self.canvasScreens.create_window (1029, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitAPrime)
		self.lblBitBPrime = tk.Label (self, image = self.imgBitBPrime)
		self.canvasScreens.create_window (1063, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitBPrime)
		self.lblBitCPrime = tk.Label (self, image = self.imgBitCPrime)
		self.canvasScreens.create_window (1097, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitCPrime)
		self.lblBitDPrime = tk.Label (self, image = self.imgBitDPrime)
		self.canvasScreens.create_window (1131, 58 + 16, anchor = tk.N + tk.W, window = self.lblBitDPrime)
		self.lblBitEPrime = tk.Label (self, image = self.imgBitEPrime)
		self.canvasScreens.create_window (1029, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitEPrime)
		self.lblBitFPrime = tk.Label (self, image = self.imgBitFPrime)
		self.canvasScreens.create_window (1063, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitFPrime)
		self.lblBitGPrime = tk.Label (self, image = self.imgBitGPrime)
		self.canvasScreens.create_window (1097, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitGPrime)
		self.lblBitHPrime = tk.Label (self, image = self.imgBitHPrime)
		self.canvasScreens.create_window (1131, 118 + 16, anchor = tk.N + tk.W, window = self.lblBitHPrime)

		self.lblBitIPrime = tk.Label (self, image = self.imgBitIPrime)
		self.canvasScreens.create_window (1029, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitIPrime)
		self.lblBitJPrime = tk.Label (self, image = self.imgBitJPrime)
		self.canvasScreens.create_window (1063, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitJPrime)
		self.lblBitKPrime = tk.Label (self, image = self.imgBitKPrime)
		self.canvasScreens.create_window (1097, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitKPrime)
		self.lblBitLPrime = tk.Label (self, image = self.imgBitLPrime)
		self.canvasScreens.create_window (1131, 178 + 16, anchor = tk.N + tk.W, window = self.lblBitLPrime)
		self.lblBitMPrime = tk.Label (self, image = self.imgBitMPrime)
		self.canvasScreens.create_window (1029, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitMPrime)
		self.lblBitNPrime = tk.Label (self, image = self.imgBitNPrime)
		self.canvasScreens.create_window (1063, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitNPrime)
		self.lblBitOPrime = tk.Label (self, image = self.imgBitOPrime)
		self.canvasScreens.create_window (1097, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitOPrime)
		self.lblBitPPrime = tk.Label (self, image = self.imgBitPPrime)
		self.canvasScreens.create_window (1131, 238 + 16, anchor = tk.N + tk.W, window = self.lblBitPPrime)

		self.lblBitQPrime = tk.Label (self, image = self.imgBitQPrime)
		self.canvasScreens.create_window (1029, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitQPrime)
		self.lblBitRPrime = tk.Label (self, image = self.imgBitRPrime)
		self.canvasScreens.create_window (1063, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitRPrime)
		self.lblBitSPrime = tk.Label (self, image = self.imgBitSPrime)
		self.canvasScreens.create_window (1097, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitSPrime)
		self.lblBitTPrime = tk.Label (self, image = self.imgBitTPrime)
		self.canvasScreens.create_window (1131, 298 + 16, anchor = tk.N + tk.W, window = self.lblBitTPrime)
		self.lblBitUPrime = tk.Label (self, image = self.imgBitUPrime)
		self.canvasScreens.create_window (1029, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitUPrime)
		self.lblBitVPrime = tk.Label (self, image = self.imgBitVPrime)
		self.canvasScreens.create_window (1063, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitVPrime)
		self.lblBitWPrime = tk.Label (self, image = self.imgBitWPrime)
		self.canvasScreens.create_window (1097, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitWPrime)
		self.lblBitXPrime = tk.Label (self, image = self.imgBitXPrime)
		self.canvasScreens.create_window (1131, 358 + 16, anchor = tk.N + tk.W, window = self.lblBitXPrime)

		# March 2025 update: I reversed the order of bits 0-2, and 3-5 (name change only).
		self.lblBitZDup = tk.Label (self, image = self.imgBitZ)
		self.canvasScreens.create_window (1029, 418 + 16, anchor = tk.N + tk.W, window = self.lblBitZDup)
		self.lblBit0Dup = tk.Label (self, image = self.imgBit0)
		self.canvasScreens.create_window (1063, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit0Dup)
		self.lblBit1Dup = tk.Label (self, image = self.imgBit1)
		self.canvasScreens.create_window (1097, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit1Dup)
		self.lblBit2Dup = tk.Label (self, image = self.imgBit2)
		self.canvasScreens.create_window (1131, 418 + 16, anchor = tk.N + tk.W, window = self.lblBit2Dup)
		self.lblBitYDup = tk.Label (self, image = self.imgBitY)
		self.canvasScreens.create_window (1029, 478 + 16, anchor = tk.N + tk.W, window = self.lblBitYDup)
		self.lblBit3Dup = tk.Label (self, image = self.imgBit3)
		self.canvasScreens.create_window (1063, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit3Dup)
		self.lblBit4Dup = tk.Label (self, image = self.imgBit4)
		self.canvasScreens.create_window (1097, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit4Dup)
		self.lblBit5Dup = tk.Label (self, image = self.imgBit5)
		self.canvasScreens.create_window (1131, 478 + 16, anchor = tk.N + tk.W, window = self.lblBit5Dup)
		self.lblBit6Dup = tk.Label (self, image = self.imgBit6)
		self.canvasScreens.create_window (1029, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit6Dup)
		self.lblBit7Dup = tk.Label (self, image = self.imgBit7)
		self.canvasScreens.create_window (1063, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit7Dup)
		self.lblBit8Dup = tk.Label (self, image = self.imgBit8)
		self.canvasScreens.create_window (1097, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit8Dup)
		self.lblBit9Dup = tk.Label (self, image = self.imgBit9)
		self.canvasScreens.create_window (1131, 538 + 16, anchor = tk.N + tk.W, window = self.lblBit9Dup)

		# Digits - Password output
		self.lblDigit00 = tk.Label (self, image = self.imgDigit00)
		self.canvasScreens.create_window (1210, 80, anchor = tk.N + tk.W, window = self.lblDigit00)
		self.lblDigit01 = tk.Label (self, image = self.imgDigit01)
		self.canvasScreens.create_window (1270, 80, anchor = tk.N + tk.W, window = self.lblDigit01)
		self.lblDigit02 = tk.Label (self, image = self.imgDigit02)
		self.canvasScreens.create_window (1330, 80, anchor = tk.N + tk.W, window = self.lblDigit02)
		self.lblDigit03 = tk.Label (self, image = self.imgDigit03)
		self.canvasScreens.create_window (1390, 80, anchor = tk.N + tk.W, window = self.lblDigit03)
		self.lblDigit10 = tk.Label (self, image = self.imgDigit10)
		self.canvasScreens.create_window (1210, 130, anchor = tk.N + tk.W, window = self.lblDigit10)
		self.lblDigit11 = tk.Label (self, image = self.imgDigit11)
		self.canvasScreens.create_window (1270, 130, anchor = tk.N + tk.W, window = self.lblDigit11)
		self.lblDigit12 = tk.Label (self, image = self.imgDigit12)
		self.canvasScreens.create_window (1330, 130, anchor = tk.N + tk.W, window = self.lblDigit12)
		self.lblDigit13 = tk.Label (self, image = self.imgDigit13)
		self.canvasScreens.create_window (1390, 130, anchor = tk.N + tk.W, window = self.lblDigit13)
		self.lblDigit20 = tk.Label (self, image = self.imgDigit20)
		self.canvasScreens.create_window (1210, 180, anchor = tk.N + tk.W, window = self.lblDigit20)
		self.lblDigit21 = tk.Label (self, image = self.imgDigit21)
		self.canvasScreens.create_window (1270, 180, anchor = tk.N + tk.W, window = self.lblDigit21)
		self.lblDigit22 = tk.Label (self, image = self.imgDigit22)
		self.canvasScreens.create_window (1330, 180, anchor = tk.N + tk.W, window = self.lblDigit22)
		self.lblDigit23 = tk.Label (self, image = self.imgDigit23)
		self.canvasScreens.create_window (1390, 180, anchor = tk.N + tk.W, window = self.lblDigit23)

		# Labels for the lights and digits
		self.lblGridBefore = tk.Label (self, font = config.fontframeheader, text = "Before flipping", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 52, anchor = tk.N, window = self.lblGridBefore)
		self.lblGridAfter = tk.Label (self, font = config.fontframeheader, text = "After flipping", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 52, anchor = tk.N, window = self.lblGridAfter)
		self.lblPassword = tk.Label (self, font = config.fontframeheader, text = "Your password is:", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1329, 52, anchor = tk.N, window = self.lblPassword)

		# March 2025 update: I reversed the order of bits 0-2, and 3-5 (name change only).
		self.lblRow1 = tk.Label (self, font = config.fontlabels, text = "A  B  C  D", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 88 + 16, anchor = tk.N, window = self.lblRow1)
		self.lblRow2 = tk.Label (self, font = config.fontlabels, text = "E  F  G  H", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 148 + 16, anchor = tk.N, window = self.lblRow2)
		self.lblRow3 = tk.Label (self, font = config.fontlabels, text = "I  J  K  L", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 208 + 16, anchor = tk.N, window = self.lblRow3)
		self.lblRow4 = tk.Label (self, font = config.fontlabels, text = "M  N  O  P", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 268 + 16, anchor = tk.N, window = self.lblRow4)
		self.lblRow5 = tk.Label (self, font = config.fontlabels, text = "Q  R  S  T", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 328 + 16, anchor = tk.N, window = self.lblRow5)
		self.lblRow6 = tk.Label (self, font = config.fontlabels, text = "U  V  W  X", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 388 + 16, anchor = tk.N, window = self.lblRow6)
		self.lblRow7 = tk.Label (self, font = config.fontlabels, text = "Z  0  1  2", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 448 + 16, anchor = tk.N, window = self.lblRow7)
		self.lblRow8 = tk.Label (self, font = config.fontlabels, text = "Y  3  4  5", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 508 + 16, anchor = tk.N, window = self.lblRow8)
		self.lblRow9 = tk.Label (self, font = config.fontlabels, text = "6  7  8  9", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (920, 568 + 16, anchor = tk.N, window = self.lblRow9)

		self.lblRow1Prime = tk.Label (self, font = config.fontlabels, text = "A' B' C' D'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 88 + 16, anchor = tk.N, window = self.lblRow1Prime)
		self.lblRow2Prime = tk.Label (self, font = config.fontlabels, text = "E' F' G' H'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 148 + 16, anchor = tk.N, window = self.lblRow2Prime)
		self.lblRow3Prime = tk.Label (self, font = config.fontlabels, text = "I' J' K' L'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 208 + 16, anchor = tk.N, window = self.lblRow3Prime)
		self.lblRow4Prime = tk.Label (self, font = config.fontlabels, text = "M' N' O' P'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 268 + 16, anchor = tk.N, window = self.lblRow4Prime)
		self.lblRow5Prime = tk.Label (self, font = config.fontlabels, text = "Q' R' S' T'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 328 + 16, anchor = tk.N, window = self.lblRow5Prime)
		self.lblRow6Prime = tk.Label (self, font = config.fontlabels, text = "U' V' W' X'", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 388 + 16, anchor = tk.N, window = self.lblRow6Prime)
		self.lblRow7Dup = tk.Label (self, font = config.fontlabels, text = "Z  0  1  2", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 448 + 16, anchor = tk.N, window = self.lblRow7Dup)
		self.lblRow8Dup = tk.Label (self, font = config.fontlabels, text = "Y  3  4  5", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 508 + 16, anchor = tk.N, window = self.lblRow8Dup)
		self.lblRow9Dup = tk.Label (self, font = config.fontlabels, text = "6  7  8  9", bg = config.framebgcolor, fg = config.windowfgcolor)
		self.canvasScreens.create_window (1096, 568 + 16, anchor = tk.N, window = self.lblRow9Dup)

		# Various objects for the "scratchpad" in the bottom right corner, below the password output.
		self.canvasScratch = tk.Canvas (self.frameScratchpad, bg = config.canvasbgcolor, height = 302, width = 259)
		self.canvasScratch.grid (row = 0, column = 0)
		self.canvasScratch.create_line (65, 0, 65, 302)
		self.canvasScratch.create_line (130, 0, 130, 302)
		self.canvasScratch.create_line (195, 0, 195, 302)
		self.canvasScratch.create_line (0, 100, 259, 100)
		self.canvasScratch.create_line (0, 201, 259, 201)

		# March 2025 update: I reversed the row order of bits A-X, and the labels 0-2 and 3-5.
		self.lblScratch00 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "M'" + "\u2199" + "R'" + "\u2193" + "9" + "\u2198" + "\nStart\n7\n1 8 2\n6 4 3\n5", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (32, 4, anchor = tk.N, window = self.lblScratch00)
		self.lblScratch01 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "H'" + "\u2199" + "U'" + "\u2193" + "4" + "\u2198" + "\nStart\n6\n4 7 5\n3 1 8\n2", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (98, 4, anchor = tk.N, window = self.lblScratch01)
		self.lblScratch02 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "I'" + "\u2199" + "T'" + "\u2193" + "0" + "\u2198" + "\nStart\n7\n6 4 5\n2 1 3\n8", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (164, 4, anchor = tk.N, window = self.lblScratch02)
		self.lblScratch03 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "A'" + "\u2199" + "O'" + "\u2193" + "2" + "\u2198" + "\nStart\n1\n8 7 3\n4 5 6\n2", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (230, 4, anchor = tk.N, window = self.lblScratch03)
		self.lblScratch10 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "E'" + "\u2199" + "W'" + "\u2193" + "7" + "\u2198" + "\nStart\n2\n5 4 3\n1 7 6\n8", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (32, 104, anchor = tk.N, window = self.lblScratch10)
		self.lblScratch11 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "C'" + "\u2199" + "J'" + "\u2193" + "5" + "\u2198" + "\nStart\n8\n4 1 2\n6 7 3\n5", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (98, 104, anchor = tk.N, window = self.lblScratch11)
		self.lblScratch12 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "G'" + "\u2199" + "V'" + "\u2193" + "6" + "\u2198" + "\nStart\n4\n1 7 5\n2 8 3\n6", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (164, 104, anchor = tk.N, window = self.lblScratch12)
		self.lblScratch13 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "B'" + "\u2199" + "P'" + "\u2193" + "Z" + "\u2198" + "\nStart\n4\n5 1 8\n3 7 2\n6", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (230, 104, anchor = tk.N, window = self.lblScratch13)
		self.lblScratch20 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "N'" + "\u2199" + "X'" + "\u2193" + "8" + "\u2198" + "\nStart\n3\n5 1 7\n6 2 8\n4", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (32, 204, anchor = tk.N, window = self.lblScratch20)
		self.lblScratch21 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "F'" + "\u2199" + "Q'" + "\u2193" + "1" + "\u2198" + "\nStart\n2\n1 8 5\n3 4 7\n6", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (98, 204, anchor = tk.N, window = self.lblScratch21)
		self.lblScratch22 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "L'" + "\u2199" + "S'" + "\u2193" + "3" + "\u2198" + "\nStart\n8\n2 4 7\n5 6 1\n3", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (164, 204, anchor = tk.N, window = self.lblScratch22)
		self.lblScratch23 = tk.Label (self.frameScratchpad, font = config.fontscratch, text = "D'" + "\u2199" + "K'" + "\u2193" + "Y" + "\u2198" + "\nStart\n4\n1 8 7\n6 3 2\n5", bg = config.canvasbgcolor, fg = config.canvasfgcolor)
		self.canvasScratch.create_window (230, 204, anchor = tk.N, window = self.lblScratch23)

		# New in March 2025: An additional description label to fill the space in the middle of the Stage Select screen.
		self.lblSpec = tk.Label (self, font = config.fontlabels, text = "Welcome to MMXPG", bg = config.tooltipbgcolor, fg = config.tooltipfgcolor, width = config.specwidth, height = config.specheight)
		self.canvasScreens.create_window (252, 201, anchor = tk.N + tk.W, window = self.lblSpec)

		# New in March 2025: Pop-up descriptions of the various objects.
		self.CreateToolTip (self.btnBitA, "Bit A", "Click this button to toggle Light A,\nwhich in turn toggles Lights:\nA', 3, 6, and 7.")
		self.CreateToolTip (self.btnBitB, "Bit B", "Click this button to toggle Light B,\nwhich in turn toggles Lights B' and 3.")
		self.CreateToolTip (self.btnBitC, "Bit C", "Click this button to toggle Light C,\nwhich in turn toggles Lights:\nC', 3, 7, and 8.")
		self.CreateToolTip (self.btnBitD, "Bit D", "Click this button to toggle Light D,\nwhich in turn toggles Lights:\nD', 3, 7, and 9.")
		self.CreateToolTip (self.btnBitE, "Bit E", "Click this button to toggle Light E,\nwhich in turn toggles Lights:\nE', 3, 6, and 7.")
		self.CreateToolTip (self.btnBitF, "Bit F", "Click this button to toggle Light F,\nwhich in turn toggles Lights F' and 3.")
		self.CreateToolTip (self.btnBitG, "Bit G", "Click this button to toggle Light G,\nwhich in turn toggles Lights:\nG', 3, 7, and 8.")
		self.CreateToolTip (self.btnBitH, "Bit H", "Click this button to toggle Light H,\nwhich in turn toggles Lights:\nH', 3, 7, and 9.")
		self.CreateToolTip (self.btnBitI, "Bit I", "Click this button to toggle Light I,\nwhich in turn toggles Lights:\nI', 4, 6, and 8.")
		self.CreateToolTip (self.btnBitJ, "Bit J", "Click this button to toggle Light J,\nwhich in turn toggles Lights:\nJ', 4, 7, and 8.")
		self.CreateToolTip (self.btnBitK, "Bit K", "Click this button to toggle Light K,\nwhich in turn toggles Lights K' and 4.")
		self.CreateToolTip (self.btnBitL, "Bit L", "Click this button to toggle Light L,\nwhich in turn toggles Lights:\nL', 4, 8, and 9.")
		self.CreateToolTip (self.btnBitM, "Bit M", "Click this button to toggle Light M,\nwhich in turn toggles Lights:\nM', 4, 6, and 8.")
		self.CreateToolTip (self.btnBitN, "Bit N", "Click this button to toggle Light N,\nwhich in turn toggles Lights:\nN', 4, 7, and 8.")
		self.CreateToolTip (self.btnBitO, "Bit O", "Click this button to toggle Light O,\nwhich in turn toggles Lights O' and 4.")
		self.CreateToolTip (self.btnBitP, "Bit P", "Click this button to toggle Light P,\nwhich in turn toggles Lights:\nP', 4, 8, and 9.")
		self.CreateToolTip (self.btnBitQ, "Bit Q", "Click this button to toggle Light Q,\nwhich in turn toggles Lights:\nQ', 5, 6, and 9.")
		self.CreateToolTip (self.btnBitR, "Bit R", "Click this button to toggle Light R,\nwhich in turn toggles Lights:\nR', 5, 7, and 9.")
		self.CreateToolTip (self.btnBitS, "Bit S", "Click this button to toggle Light S,\nwhich in turn toggles Lights:\nS', 5, 8, and 9.")
		self.CreateToolTip (self.btnBitT, "Bit T", "Click this button to toggle Light T,\nwhich in turn toggles Lights T' and 5.")
		self.CreateToolTip (self.btnBitU, "Bit U", "Click this button to toggle Light U,\nwhich in turn toggles Lights:\nU', 5, 6, and 9.")
		self.CreateToolTip (self.btnBitV, "Bit V", "Click this button to toggle Light V,\nwhich in turn toggles Lights:\nV', 5, 7, and 9.")
		self.CreateToolTip (self.btnBitW, "Bit W", "Click this button to toggle Light W,\nwhich in turn toggles Lights:\nW', 5, 8, and 9.")
		self.CreateToolTip (self.btnBitX, "Bit X", "Click this button to toggle Light X,\nwhich in turn toggles Lights X' and 5.")

		self.CreateToolTip (self.btnBitY, "Bit Y", "Click this button to toggle Light Y.\n\nLights A-X will all be turned on\nas well, which in turn\naffects Lights 3-9.")
		self.CreateToolTip (self.btnBitZ, "Bit Z", "Click this button to toggle Light Z,\nwhich in turn toggles Lights:\nA', E', I', M', Q', U' and 6.\n\nThe controls for Lights A-Y\nare only enabled when Light Z is lit.")
		self.CreateToolTip (self.btnBit0, "Bit 0", "Click this button to toggle Light 0,\nwhich in turn toggles Lights:\nB', F', J', N', R', V' and 7.")
		self.CreateToolTip (self.btnBit1, "Bit 1", "Click this button to toggle Light 1,\nwhich in turn toggles Lights:\nC', G', K', O', S', W' and 8.")
		self.CreateToolTip (self.btnBit2, "Bit 2", "Click this button to toggle Light 2,\nwhich in turn toggles Lights:\nD', H', L', P', T', X' and 9.")

		self.CreateToolTip (self.btnWeaponStormTornado, "Cleared Stage:\nStorm Eagle", "Click this icon to toggle\nclearing the Storm Eagle stage\nand having Storm Tornado.\n\nThis toggles Lights A (and A'), 3, 6, and 7.")
		self.CreateToolTip (self.btnWeaponElectricSpark, "Cleared Stage:\nSpark Mandrill", "Click this icon to toggle\nclearing the Spark Mandrill stage\nand having Electric Spark.\n\nThis toggles Lights B (and B') and 3.")
		self.CreateToolTip (self.btnWeaponBoomerangCutter, "Cleared Stage:\nBoomer Kuwanger", "Click this icon to toggle\nclearing the Boomer Kuwanger stage\nand having Boomerang Cutter.\n\nThis toggles Lights C (and C'), 3, 7, and 8.")
		self.CreateToolTip (self.btnWeaponShotgunIce, "Cleared Stage:\nChill Penguin", "Click this icon to toggle\nclearing the Chill Penguin stage\nand having Shotgun Ice.\n\nThis toggles Lights D (and D'), 3, 7, and 9.")
		self.CreateToolTip (self.btnWeaponHomingTorpedo, "Cleared Stage:\nLaunch Octopus", "Click this icon to toggle\nclearing the Launch Octopus stage\nand having Homing Torpedo.\n\nThis toggles Lights E (and E'), 3, 6, and 7.")
		self.CreateToolTip (self.btnWeaponChameleonSting, "Cleared Stage:\nSting Chameleon", "Click this icon to toggle\nclearing the Sting Chameleon stage\nand having Chameleon Sting.\n\nThis toggles Lights F (and F') and 3.")
		self.CreateToolTip (self.btnWeaponRollingShield, "Cleared Stage:\nArmored Armadillo", "Click this icon to toggle\nclearing the Armored Armadillo stage\nand having Rolling Shield.\n\nThis toggles Lights G (and G'), 3, 7, and 8.")
		self.CreateToolTip (self.btnWeaponFireWave, "Cleared Stage:\nFlame Mammoth", "Click this icon to toggle\nclearing the Flame Mammoth stage\nand having Fire Wave.\n\nThis toggles Lights H (and H'), 3, 7, and 9.")
		self.CreateToolTip (self.btnHeartTankFlameMammoth, "Heart Tank:\nFlame Mammoth", "Click this icon to toggle\nhaving the Heart Tank from\nthe Flame Mammoth stage.\n\nThis toggles Lights I (and I'), 4, 6, and 8.")
		self.CreateToolTip (self.btnHeartTankBoomerKuwanger, "Heart Tank:\nBoomer Kuwanger", "Click this icon to toggle\nhaving the Heart Tank from\nthe Boomer Kuwanger stage.\n\nThis toggles Lights J (and J'), 4, 7, and 8.")
		self.CreateToolTip (self.btnHeartTankSparkMandrill, "Heart Tank:\nSpark Mandrill", "Click this icon to toggle\nhaving the Heart Tank from\nthe Spark Mandrill stage.\n\nThis toggles Lights K (and K') and 4.")
		self.CreateToolTip (self.btnHeartTankLaunchOctopus, "Heart Tank:\nLaunch Octopus", "Click this icon to toggle\nhaving the Heart Tank from\nthe Launch Octopus stage.\n\nThis toggles Lights L (and L'), 4, 8, and 9.")
		self.CreateToolTip (self.btnHeartTankChillPenguin, "Heart Tank:\nChill Penguin", "Click this icon to toggle\nhaving the Heart Tank from\nthe Chill Penguin stage.\n\nThis toggles Lights M (and M'), 4, 6, and 8.")
		self.CreateToolTip (self.btnHeartTankArmoredArmadillo, "Heart Tank:\nArmored Armadillo", "Click this icon to toggle\nhaving the Heart Tank from\nthe Armored Armadillo stage.\n\nThis toggles Lights N (and N'), 4, 7, and 8.")
		self.CreateToolTip (self.btnHeartTankStormEagle, "Heart Tank:\nStorm Eagle", "Click this icon to toggle\nhaving the Heart Tank from\nthe Storm Eagle stage.\n\nThis toggles Lights O (and O') and 4.")
		self.CreateToolTip (self.btnHeartTankStingChameleon, "Heart Tank:\nSting Chameleon", "Click this icon to toggle\nhaving the Heart Tank from\nthe Sting Chameleon stage.\n\nThis toggles Lights P (and P'), 4, 8, and 9.")
		self.CreateToolTip (self.btnSubTankStormEagle, "Sub Tank:\nStorm Eagle", "Click this icon to toggle\nhaving the Sub Tank from\nthe Storm Eagle stage.\n\nThis toggles Lights Q (and Q'), 5, 6, and 9.")
		self.CreateToolTip (self.btnSubTankArmoredArmadillo, "Sub Tank:\nArmored Armadillo", "Click this icon to toggle\nhaving the Sub Tank from\nthe Armored Armadillo stage.\n\nThis toggles Lights R (and R'), 5, 7, and 9.")
		self.CreateToolTip (self.btnSubTankSparkMandrill, "Sub Tank:\nSpark Mandrill", "Click this icon to toggle\nhaving the Sub Tank from\nthe Spark Mandrill stage.\n\nThis toggles Lights S (and S'), 5, 8, and 9.")
		self.CreateToolTip (self.btnSubTankFlameMammoth, "Sub Tank:\nFlame Mammoth", "Click this icon to toggle\nhaving the Sub Tank from\nthe Flame Mammoth stage.\n\nThis toggles Lights T (and T') and 5.")
		self.CreateToolTip (self.btnDrLightStormEagle, "Dr. Light Upgrade:\nHelmet", "Click this icon to toggle\nhaving the Dr. Light Helmet upgrade.\n\nThis toggles Lights U (and U'), 5, 6, and 9.")
		self.CreateToolTip (self.btnDrLightFlameMammoth, "Dr. Light Upgrade:\nWeapons", "Click this icon to toggle\nhaving the Dr. Light Weapons upgrade.\n\nThis toggles Lights V (and V'), 5, 7, and 9.")
		self.CreateToolTip (self.btnDrLightStingChameleon, "Dr. Light Upgrade:\nArmor", "Click this icon to toggle\nhaving the Dr. Light Armor upgrade.\n\nThis toggles Lights W (and W'), 5, 8, and 9.")
		self.CreateToolTip (self.btnDrLightChillPenguin, "Dr. Light Upgrade:\nBoots", "Click this icon to toggle\nhaving the Dr. Light Boots upgrade.\n\nThis toggles Lights X (and X') and 5.")
		self.CreateToolTip (self.btnDrLightArmoredArmadillo, "Dr. Light Upgrade:\nHadouken", "Click this icon to toggle\nhaving Hadouken.\n\nThis toggles Light Y.\n\nHaving everything else\nis required for Hadouken, and so\nLights A-X will all be lit,\naffecting Lights 3-9.")

		self.CreateToolTip (self.btnSeedBitZ, "Cleared Stage:\nBeginning", "Click this button to toggle clearing the first stage.\n\nThis toggles Light Z,\nwhich in turn toggles Lights:\nA', E', I', M', Q', U' and 6.\n\nThe controls for Lights A-Y\nare only enabled when Light Z is lit.")
		self.CreateToolTip (self.btnSeedBit0, "Random Seed Bit", "Click this button to toggle Light 0,\nwhich in turn toggles Lights:\nB', F', J', N', R', V' and 7.\n\nLights 0-2 have no purpose except\nto randomize the password.")
		self.CreateToolTip (self.btnSeedBit1, "Random Seed Bit", "Click this button to toggle Light 1,\nwhich in turn toggles Lights:\nC', G', K', O', S', W' and 8.\n\nLights 0-2 have no purpose except\nto randomize the password.")
		self.CreateToolTip (self.btnSeedBit2, "Random Seed Bit", "Click this button to toggle Light 2,\nwhich in turn toggles Lights:\nD', H', L', P', T', X' and 9.\n\nLights 0-2 have no purpose except\nto randomize the password.")

		self.CreateToolTip (self.lblBitA, "Light A", "Lights up if you have cleared\nthe Storm Eagle stage\nand collected Storm Tornado.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitB, "Light B", "Lights up if you have cleared\nthe Spark Mandrill stage\nand collected Electric Spark.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitC, "Light C", "Lights up if you have cleared\nthe Boomer Kuwanger stage\nand collected Boomerang Cutter.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitD, "Light D", "Lights up if you have cleared\nthe Chill Penguin stage\nand collected Shotgun Ice.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitE, "Light E", "Lights up if you have cleared\nthe Launch Octopus stage\nand collected Homing Torpedo.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitF, "Light F", "Lights up if you have cleared\nthe Sting Chameleon stage\nand collected Chameleon Sting.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitG, "Light G", "Lights up if you have cleared\nthe Armored Armadillo stage\nand collected Rolling Shield.\n\nLights A-H are displayed in purple.")
		self.CreateToolTip (self.lblBitH, "Light H", "Lights up if you have cleared\nthe Flame Mammoth stage\nand collected Fire Wave.\n\nLights A-H are displayed in purple.")

		self.CreateToolTip (self.lblBitI, "Light I", "Lights up if you have the Heart Tank\nfrom the Flame Mammoth stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitJ, "Light J", "Lights up if you have the Heart Tank\nfrom the Boomer Kuwanger stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitK, "Light K", "Lights up if you have the Heart Tank\nfrom the Spark Mandrill stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitL, "Light L", "Lights up if you have the Heart Tank\nfrom the Launch Octopus stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitM, "Light M", "Lights up if you have the Heart Tank\nfrom the Chill Penguin stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitN, "Light N", "Lights up if you have the Heart Tank\nfrom the Armored Armadillo stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitO, "Light O", "Lights up if you have the Heart Tank\nfrom the Storm Eagle stage.\n\nLights I-P are displayed in red.")
		self.CreateToolTip (self.lblBitP, "Light P", "Lights up if you have the Heart Tank\nfrom the Sting Chameleon stage.\n\nLights I-P are displayed in red.")

		self.CreateToolTip (self.lblBitQ, "Light Q", "Lights up if you have the Sub Tank\nfrom the Storm Eagle stage.\n\nLights Q-T are displayed in orange.")
		self.CreateToolTip (self.lblBitR, "Light R", "Lights up if you have the Sub Tank\nfrom the Armored Armadillo stage.\n\nLights Q-T are displayed in orange.")
		self.CreateToolTip (self.lblBitS, "Light S", "Lights up if you have the Sub Tank\nfrom the Spark Mandrill stage.\n\nLights Q-T are displayed in orange.")
		self.CreateToolTip (self.lblBitT, "Light T", "Lights up if you have the Sub Tank\nfrom the Flame Mammoth stage.\n\nLights Q-T are displayed in orange.")

		self.CreateToolTip (self.lblBitU, "Light U", "Lights up if you have the Dr. Light\nHelmet upgrade.\n\nLights U-Y are displayed in indigo.")
		self.CreateToolTip (self.lblBitV, "Light V", "Lights up if you have the Dr. Light\nWeapons upgrade.\n\nLights U-Y are displayed in indigo.")
		self.CreateToolTip (self.lblBitW, "Light W", "Lights up if you have the Dr. Light\nArmor upgrade.\n\nLights U-Y are displayed in indigo.")
		self.CreateToolTip (self.lblBitX, "Light X", "Lights up if you have the Dr. Light\nBoots upgrade.\n\nLights U-Y are displayed in indigo.")
		self.CreateToolTip (self.lblBitY, "Light Y", "Lights up if you have Hadouken.\n\nTo enable it, press L+R+X+down+Start\nafter entering the password.\n\nLights U-Y are displayed in indigo.")

		self.CreateToolTip (self.lblBitZ, "Light Z", "Lights up if you have cleared the opening stage.\n\nIf you have not cleared the opening stage,\nthe password engine will not allow you\nto have anything in your inventory.\n\nLight Z is half-purple & half-yellow,\nthe purple half to indicate a stage cleared,\nthe yellow half because it's also a Seed Bit\n(see Lights 0-2).")
		self.CreateToolTip (self.lblBit0, "Light 0", "One of the four Seed Bits.\n\nDetermined randomly by the password engine\nwhich results in randomized passwords.\n\nLights 0-2 are yellow.")
		self.CreateToolTip (self.lblBit1, "Light 1", "One of the four Seed Bits.\n\nDetermined randomly by the password engine\nwhich results in randomized passwords.\n\nLights 0-2 are yellow.")
		self.CreateToolTip (self.lblBit2, "Light 2", "One of the four Seed Bits.\n\nDetermined randomly by the password engine\nwhich results in randomized passwords.\n\nLights 0-2 are yellow.")

		self.CreateToolTip (self.lblBit3, "Light 3", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof purple lights (A-H) are lit,\nand unlit if an even number\nof purple lights are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit4, "Light 4", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof red lights (I-P) are lit,\nand unlit if an even number\nof red lights are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit5, "Light 5", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights between Q-X are lit,\nand unlit if an even number\nof lights between Q-X are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit6, "Light 6", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit7, "Light 7", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit8, "Light 8", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.\n\nLights 3-9 are lime-colored.")
		self.CreateToolTip (self.lblBit9, "Light 9", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.\n\nLights 3-9 are lime-colored.")

		self.CreateToolTip (self.lblBitAPrime, "Light A'", "Lights up if Light A\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitBPrime, "Light B'", "Lights up if Light B\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitCPrime, "Light C'", "Lights up if Light C\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitDPrime, "Light D'", "Lights up if Light D\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitEPrime, "Light E'", "Lights up if Light E\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitFPrime, "Light F'", "Lights up if Light F\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitGPrime, "Light G'", "Lights up if Light G\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitHPrime, "Light H'", "Lights up if Light H\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitIPrime, "Light I'", "Lights up if Light I\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitJPrime, "Light J'", "Lights up if Light J\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitKPrime, "Light K'", "Lights up if Light K\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitLPrime, "Light L'", "Lights up if Light L\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitMPrime, "Light M'", "Lights up if Light M\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitNPrime, "Light N'", "Lights up if Light N\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitOPrime, "Light O'", "Lights up if Light O\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitPPrime, "Light P'", "Lights up if Light P\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitQPrime, "Light Q'", "Lights up if Light Q\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitRPrime, "Light R'", "Lights up if Light R\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitSPrime, "Light S'", "Lights up if Light S\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitTPrime, "Light T'", "Lights up if Light T\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitUPrime, "Light U'", "Lights up if Light U\n(from the other light grid)\nor Light Z are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitVPrime, "Light V'", "Lights up if Light V\n(from the other light grid)\nor Light 0 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitWPrime, "Light W'", "Lights up if Light W\n(from the other light grid)\nor Light 1 are lit,\nbut not both.")
		self.CreateToolTip (self.lblBitXPrime, "Light X'", "Lights up if Light X\n(from the other light grid)\nor Light 2 are lit,\nbut not both.")

		self.CreateToolTip (self.lblBitZDup, "Light Z", "This is the same Light Z as\nfrom the other light grid.\n\nWhen lit, all the lights above it\nare reversed from their\nearlier counterparts.")
		self.CreateToolTip (self.lblBit0Dup, "Light 0", "This is the same Light 0 as\nfrom the other light grid.\n\nWhen lit, all the lights above it\nare reversed from their\nearlier counterparts.")
		self.CreateToolTip (self.lblBit1Dup, "Light 1", "This is the same Light 1 as\nfrom the other light grid.\n\nWhen lit, all the lights above it\nare reversed from their\nearlier counterparts.")
		self.CreateToolTip (self.lblBit2Dup, "Light 2", "This is the same Light 2 as\nfrom the other light grid.\n\nWhen lit, all the lights above it\nare reversed from their\nearlier counterparts.")

		self.CreateToolTip (self.lblBitYDup, "Light Y", "This is the same Light Y as\nfrom the other light grid.")
		self.CreateToolTip (self.lblBit3Dup, "Light 3", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof purple lights (A'-H') are lit,\nand unlit if an even number\nof purple lights are lit.")
		self.CreateToolTip (self.lblBit4Dup, "Light 4", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof red lights (I'-P') are lit,\nand unlit if an even number\nof red lights are lit.")
		self.CreateToolTip (self.lblBit5Dup, "Light 5", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights between Q'-X' are lit,\nand unlit if an even number\nof lights between Q'-X' are lit.")
		self.CreateToolTip (self.lblBit6Dup, "Light 6", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.")
		self.CreateToolTip (self.lblBit7Dup, "Light 7", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.")
		self.CreateToolTip (self.lblBit8Dup, "Light 8", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.")
		self.CreateToolTip (self.lblBit9Dup, "Light 9", "One of the seven Parity Bits.\n\nIt must be lit if an odd number\nof lights above it are lit,\nand unlit if an even number\nof lights above it are lit.")

		self.CreateToolTip (self.lblScratch00, "Password cell:\nTop row,\nFirst column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #7.\nIf Light M' is lit, go " + "\u2199" + ".\nIf Light R' is lit, go " + "\u2193" + ".\nIf Light 9 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the cell\nin the top-left corner.")
		self.CreateToolTip (self.lblScratch01, "Password cell:\nTop row,\nSecond column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #6.\nIf Light H' is lit, go " + "\u2199" + ".\nIf Light U' is lit, go " + "\u2193" + ".\nIf Light 4 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the second cell\nin the top row.")
		self.CreateToolTip (self.lblScratch02, "Password cell:\nTop row,\nThird column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #7.\nIf Light I' is lit, go " + "\u2199" + ".\nIf Light T' is lit, go " + "\u2193" + ".\nIf Light 0 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the third cell\nin the top row.")
		self.CreateToolTip (self.lblScratch03, "Password cell:\nTop row,\nFourth column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #1.\nIf Light A' is lit, go " + "\u2199" + ".\nIf Light O' is lit, go " + "\u2193" + ".\nIf Light 2 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the cell\nin the top-right corner.")
		self.CreateToolTip (self.lblScratch10, "Password cell:\nMiddle row,\nFirst column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #2.\nIf Light E' is lit, go " + "\u2199" + ".\nIf Light W' is lit, go " + "\u2193" + ".\nIf Light 7 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the first cell\nin the middle row.")
		self.CreateToolTip (self.lblScratch11, "Password cell:\nMiddle row,\nSecondcolumn", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #8.\nIf Light C' is lit, go " + "\u2199" + ".\nIf Light J' is lit, go " + "\u2193" + ".\nIf Light 5 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the second cell\nin the middle row.")
		self.CreateToolTip (self.lblScratch12, "Password cell:\nMiddle row,\nThirdcolumn", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #4.\nIf Light G' is lit, go " + "\u2199" + ".\nIf Light V' is lit, go " + "\u2193" + ".\nIf Light 6 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the third cell\nin the middle row.")
		self.CreateToolTip (self.lblScratch13, "Password cell:\nMiddle row,\nFourthcolumn", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #4.\nIf Light B' is lit, go " + "\u2199" + ".\nIf Light P' is lit, go " + "\u2193" + ".\nIf Light Z is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the last cell\nin the middle row.")
		self.CreateToolTip (self.lblScratch20, "Password cell:\nBottom row,\nFirst column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #3.\nIf Light N' is lit, go " + "\u2199" + ".\nIf Light X' is lit, go " + "\u2193" + ".\nIf Light 8 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the cell\nin the bottom-left corner.")
		self.CreateToolTip (self.lblScratch21, "Password cell:\nBottom row,\nSecond column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #2.\nIf Light F' is lit, go " + "\u2199" + ".\nIf Light Q' is lit, go " + "\u2193" + ".\nIf Light 1 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the second cell\nin the bottom row.")
		self.CreateToolTip (self.lblScratch22, "Password cell:\nBottom row,\nThird column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #8.\nIf Light L' is lit, go " + "\u2199" + ".\nIf Light S' is lit, go " + "\u2193" + ".\nIf Light 3 is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the third cell\nin the bottom row.")
		self.CreateToolTip (self.lblScratch23, "Password cell:\nBottom row,\nFourth column", "This is where each of the 12 cells\nof the password are determined\nby combining three of the lights\nfrom the \"After Flipping\" grid.\n\nStart at #4.\nIf Light D' is lit, go " + "\u2199" + ".\nIf Light K' is lit, go " + "\u2193" + ".\nIf Light Y is lit, go " + "\u2198" + ".\n\nThe digit you land on is the digit\nthat goes in the cell\nin the bottom-right corner.")

	def CreateToolTip (self, widget, objectname, desc):
		toolTip = ToolTip (widget)
		def enter (event):
			self.lblSpec.config (text = objectname)
			if self.varHelp.get():
				toolTip.showtip (desc)
		def leave (event):
			self.lblSpec.config (text = "")
			toolTip.hidetip()
		widget.bind ("<Enter>", enter)
		widget.bind ("<Leave>", leave)

	# One of these code blocks fires when one of the buttons in the Command List or one of the icons from the Stage Select screen is clicked.
	# March 2025 update: I reversed the row order of bits A-X.  I also tightened the code in these blocks.
	def dotoggleBitA (self):
		self.varBitA.set (not self.varBitA.get())
		self.imgBitA.config (file = config.assets ["light-on-purple"] if self.varBitA.get() else config.assets ["light-off"])
		self.imgWeaponStormTornado.config (file = config.assets ["weapon-storm-t-no"] if self.varBitA.get() else config.assets ["weapon-storm-t"])
		self.getpassword()
	def dotoggleBitB (self):
		self.varBitB.set (not self.varBitB.get())
		self.imgBitB.config (file = config.assets ["light-on-purple"] if self.varBitB.get() else config.assets ["light-off"])
		self.imgWeaponElectricSpark.config (file = config.assets ["weapon-e-spark-no"] if self.varBitB.get() else config.assets ["weapon-e-spark"])
		self.getpassword()
	def dotoggleBitC (self):
		self.varBitC.set (not self.varBitC.get())
		self.imgBitC.config (file = config.assets ["light-on-purple"] if self.varBitC.get() else config.assets ["light-off"])
		self.imgWeaponBoomerangCutter.config (file = config.assets ["weapon-b-cutter-no"] if self.varBitC.get() else config.assets ["weapon-b-cutter"])
		self.getpassword()
	def dotoggleBitD (self):
		self.varBitD.set (not self.varBitD.get())
		self.imgBitD.config (file = config.assets ["light-on-purple"] if self.varBitD.get() else config.assets ["light-off"])
		self.imgWeaponShotgunIce.config (file = config.assets ["weapon-s-ice-no"] if self.varBitD.get() else config.assets ["weapon-s-ice"])
		self.getpassword()

	def dotoggleBitE (self):
		self.varBitE.set (not self.varBitE.get())
		self.imgBitE.config (file = config.assets ["light-on-purple"] if self.varBitE.get() else config.assets ["light-off"])
		self.imgWeaponHomingTorpedo.config (file = config.assets ["weapon-homing-t-no"] if self.varBitE.get() else config.assets ["weapon-homing-t"])
		self.getpassword()
	def dotoggleBitF (self):
		self.varBitF.set (not self.varBitF.get())
		self.imgBitF.config (file = config.assets ["light-on-purple"] if self.varBitF.get() else config.assets ["light-off"])
		self.imgWeaponChameleonSting.config (file = config.assets ["weapon-c-sting-no"] if self.varBitF.get() else config.assets ["weapon-c-sting"])
		self.getpassword()
	def dotoggleBitG (self):
		self.varBitG.set (not self.varBitG.get())
		self.imgBitG.config (file = config.assets ["light-on-purple"] if self.varBitG.get() else config.assets ["light-off"])
		self.imgWeaponRollingShield.config (file = config.assets ["weapon-r-shield-no"] if self.varBitG.get() else config.assets ["weapon-r-shield"])
		self.getpassword()
	def dotoggleBitH (self):
		self.varBitH.set (not self.varBitH.get())
		self.imgBitH.config (file = config.assets ["light-on-purple"] if self.varBitH.get() else config.assets ["light-off"])
		self.imgWeaponFireWave.config (file = config.assets ["weapon-fire-w-no"] if self.varBitH.get() else config.assets ["weapon-fire-w"])
		self.getpassword()

	def dotoggleBitI (self):
		self.varBitI.set (not self.varBitI.get())
		self.imgBitI.config (file = config.assets ["light-on-red"] if self.varBitI.get() else config.assets ["light-off"])
		self.imgHeartTankFlameMammoth.config (file = config.assets ["heart-tank-no"] if self.varBitI.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitJ (self):
		self.varBitJ.set (not self.varBitJ.get())
		self.imgBitJ.config (file = config.assets ["light-on-red"] if self.varBitJ.get() else config.assets ["light-off"])
		self.imgHeartTankBoomerKuwanger.config (file = config.assets ["heart-tank-no"] if self.varBitJ.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitK (self):
		self.varBitK.set (not self.varBitK.get())
		self.imgBitK.config (file = config.assets ["light-on-red"] if self.varBitK.get() else config.assets ["light-off"])
		self.imgHeartTankSparkMandrill.config (file = config.assets ["heart-tank-no"] if self.varBitK.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitL (self):
		self.varBitL.set (not self.varBitL.get())
		self.imgBitL.config (file = config.assets ["light-on-red"] if self.varBitL.get() else config.assets ["light-off"])
		self.imgHeartTankLaunchOctopus.config (file = config.assets ["heart-tank-no"] if self.varBitL.get() else config.assets ["heart-tank"])
		self.getpassword()

	def dotoggleBitM (self):
		self.varBitM.set (not self.varBitM.get())
		self.imgBitM.config (file = config.assets ["light-on-red"] if self.varBitM.get() else config.assets ["light-off"])
		self.imgHeartTankChillPenguin.config (file = config.assets ["heart-tank-no"] if self.varBitM.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitN (self):
		self.varBitN.set (not self.varBitN.get())
		self.imgBitN.config (file = config.assets ["light-on-red"] if self.varBitN.get() else config.assets ["light-off"])
		self.imgHeartTankArmoredArmadillo.config (file = config.assets ["heart-tank-no"] if self.varBitN.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitO (self):
		self.varBitO.set (not self.varBitO.get())
		self.imgBitO.config (file = config.assets ["light-on-red"] if self.varBitO.get() else config.assets ["light-off"])
		self.imgHeartTankStormEagle.config (file = config.assets ["heart-tank-no"] if self.varBitO.get() else config.assets ["heart-tank"])
		self.getpassword()
	def dotoggleBitP (self):
		self.varBitP.set (not self.varBitP.get())
		self.imgBitP.config (file = config.assets ["light-on-red"] if self.varBitP.get() else config.assets ["light-off"])
		self.imgHeartTankStingChameleon.config (file = config.assets ["heart-tank-no"] if self.varBitP.get() else config.assets ["heart-tank"])
		self.getpassword()

	def dotoggleBitQ (self):
		self.varBitQ.set (not self.varBitQ.get())
		self.imgBitQ.config (file = config.assets ["light-on-orange"] if self.varBitQ.get() else config.assets ["light-off"])
		self.imgSubTankStormEagle.config (file = config.assets ["sub-tank-no"] if self.varBitQ.get() else config.assets ["sub-tank"])
		self.getpassword()
	def dotoggleBitR (self):
		self.varBitR.set (not self.varBitR.get())
		self.imgBitR.config (file = config.assets ["light-on-orange"] if self.varBitR.get() else config.assets ["light-off"])
		self.imgSubTankArmoredArmadillo.config (file = config.assets ["sub-tank-no"] if self.varBitR.get() else config.assets ["sub-tank"])
		self.getpassword()
	def dotoggleBitS (self):
		self.varBitS.set (not self.varBitS.get())
		self.imgBitS.config (file = config.assets ["light-on-orange"] if self.varBitS.get() else config.assets ["light-off"])
		self.imgSubTankSparkMandrill.config (file = config.assets ["sub-tank-no"] if self.varBitS.get() else config.assets ["sub-tank"])
		self.getpassword()
	def dotoggleBitT (self):
		self.varBitT.set (not self.varBitT.get())
		self.imgBitT.config (file = config.assets ["light-on-orange"] if self.varBitT.get() else config.assets ["light-off"])
		self.imgSubTankFlameMammoth.config (file = config.assets ["sub-tank-no"] if self.varBitT.get() else config.assets ["sub-tank"])
		self.getpassword()

	def dotoggleBitU (self):
		self.varBitU.set (not self.varBitU.get())
		self.imgBitU.config (file = config.assets ["light-on-indigo"] if self.varBitU.get() else config.assets ["light-off"])
		self.imgDrLightStormEagle.config (file = config.assets ["dr-light-no"] if self.varBitU.get() else config.assets ["dr-light"])
		self.getpassword()
	def dotoggleBitV (self):
		self.varBitV.set (not self.varBitV.get())
		self.imgBitV.config (file = config.assets ["light-on-indigo"] if self.varBitV.get() else config.assets ["light-off"])
		self.imgDrLightFlameMammoth.config (file = config.assets ["dr-light-no"] if self.varBitV.get() else config.assets ["dr-light"])
		self.getpassword()
	def dotoggleBitW (self):
		self.varBitW.set (not self.varBitW.get())
		self.imgBitW.config (file = config.assets ["light-on-indigo"] if self.varBitW.get() else config.assets ["light-off"])
		self.imgDrLightStingChameleon.config (file = config.assets ["dr-light-no"] if self.varBitW.get() else config.assets ["dr-light"])
		self.getpassword()
	def dotoggleBitX (self):
		self.varBitX.set (not self.varBitX.get())
		self.imgBitX.config (file = config.assets ["light-on-indigo"] if self.varBitX.get() else config.assets ["light-off"])
		self.imgDrLightChillPenguin.config (file = config.assets ["dr-light-no"] if self.varBitX.get() else config.assets ["dr-light"])
		self.getpassword()

	def dotoggleBitY (self):
		if (self.varBitY.get()):
			self.varBitY.set (False)
			self.imgBitY.config (file = config.assets ["light-off"])
			self.imgDrLightArmoredArmadillo.config (file = config.assets ["dr-light"])
			self.getpassword()
		# New in March 2025: I learned that you can enable Hadouken with a password by pressing L+R+X+down+Start.  But your inventory has to be full.
		elif tk.messagebox.askyesno ("Advisory", "Having Hadouken requires you to have a full inventory.\n\nThat means all the data bits will have to be raised.\n\nIs that okay?"):  # Pop up a warning message with yes/no buttons.

			self.varBitA.set (True)
			self.varBitB.set (True)
			self.varBitC.set (True)
			self.varBitD.set (True)
			self.varBitE.set (True)
			self.varBitF.set (True)
			self.varBitG.set (True)
			self.varBitH.set (True)
			self.varBitI.set (True)
			self.varBitJ.set (True)
			self.varBitK.set (True)
			self.varBitL.set (True)
			self.varBitM.set (True)
			self.varBitN.set (True)
			self.varBitO.set (True)
			self.varBitP.set (True)
			self.varBitQ.set (True)
			self.varBitR.set (True)
			self.varBitS.set (True)
			self.varBitT.set (True)
			self.varBitU.set (True)
			self.varBitV.set (True)
			self.varBitW.set (True)
			self.varBitX.set (True)
			self.varBitY.set (True)

			self.imgBitA.config (file = config.assets ["light-on-purple"])
			self.imgBitB.config (file = config.assets ["light-on-purple"])
			self.imgBitC.config (file = config.assets ["light-on-purple"])
			self.imgBitD.config (file = config.assets ["light-on-purple"])
			self.imgBitE.config (file = config.assets ["light-on-purple"])
			self.imgBitF.config (file = config.assets ["light-on-purple"])
			self.imgBitG.config (file = config.assets ["light-on-purple"])
			self.imgBitH.config (file = config.assets ["light-on-purple"])
			self.imgBitI.config (file = config.assets ["light-on-red"])
			self.imgBitJ.config (file = config.assets ["light-on-red"])
			self.imgBitK.config (file = config.assets ["light-on-red"])
			self.imgBitL.config (file = config.assets ["light-on-red"])
			self.imgBitM.config (file = config.assets ["light-on-red"])
			self.imgBitN.config (file = config.assets ["light-on-red"])
			self.imgBitO.config (file = config.assets ["light-on-red"])
			self.imgBitP.config (file = config.assets ["light-on-red"])
			self.imgBitQ.config (file = config.assets ["light-on-orange"])
			self.imgBitR.config (file = config.assets ["light-on-orange"])
			self.imgBitS.config (file = config.assets ["light-on-orange"])
			self.imgBitT.config (file = config.assets ["light-on-orange"])
			self.imgBitU.config (file = config.assets ["light-on-indigo"])
			self.imgBitV.config (file = config.assets ["light-on-indigo"])
			self.imgBitW.config (file = config.assets ["light-on-indigo"])
			self.imgBitX.config (file = config.assets ["light-on-indigo"])
			self.imgBitY.config (file = config.assets ["light-on-indigo"])

			self.imgDrLightStormEagle.config (file = config.assets ["dr-light-no"])
			self.imgDrLightFlameMammoth.config (file = config.assets ["dr-light-no"])
			self.imgDrLightStingChameleon.config (file = config.assets ["dr-light-no"])
			self.imgDrLightChillPenguin.config (file = config.assets ["dr-light-no"])
			self.imgSubTankStormEagle.config (file = config.assets ["sub-tank-no"])
			self.imgSubTankArmoredArmadillo.config (file = config.assets ["sub-tank-no"])
			self.imgSubTankSparkMandrill.config (file = config.assets ["sub-tank-no"])
			self.imgSubTankFlameMammoth.config (file = config.assets ["sub-tank-no"])
			self.imgHeartTankChillPenguin.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankArmoredArmadillo.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankStormEagle.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankStingChameleon.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankFlameMammoth.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankBoomerKuwanger.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankSparkMandrill.config (file = config.assets ["heart-tank-no"])
			self.imgHeartTankLaunchOctopus.config (file = config.assets ["heart-tank-no"])
			self.imgWeaponHomingTorpedo.config (file = config.assets ["weapon-homing-t-no"])
			self.imgWeaponChameleonSting.config (file = config.assets ["weapon-c-sting-no"])
			self.imgWeaponRollingShield.config (file = config.assets ["weapon-r-shield-no"])
			self.imgWeaponFireWave.config (file = config.assets ["weapon-fire-w-no"])
			self.imgWeaponStormTornado.config (file = config.assets ["weapon-storm-t-no"])
			self.imgWeaponElectricSpark.config (file = config.assets ["weapon-e-spark-no"])
			self.imgWeaponBoomerangCutter.config (file = config.assets ["weapon-b-cutter-no"])
			self.imgWeaponShotgunIce.config (file = config.assets ["weapon-s-ice-no"])
			self.imgDrLightArmoredArmadillo.config (file = config.assets ["dr-light-no"])
			self.getpassword()
			tk.messagebox.showinfo ("Reminder", "To enable Hadouken, when you enter the last digit, press and hold L+R+X+down and press Start.")

	# March 2025 update: I reversed the row order of bits A-X.
	def dotoggleBitZ (self):
		if (self.varBitZ.get()):
			if tk.messagebox.askyesno ("Advisory", "Starting from the beginning requires you to have an empty inventory.\n\nThat means all the data bits will have to be reset.\n\nIs that okay?"):  # Pop up a warning message with yes/no buttons.

				self.varBitA.set (False)
				self.varBitB.set (False)
				self.varBitC.set (False)
				self.varBitD.set (False)
				self.varBitE.set (False)
				self.varBitF.set (False)
				self.varBitG.set (False)
				self.varBitH.set (False)
				self.varBitI.set (False)
				self.varBitJ.set (False)
				self.varBitK.set (False)
				self.varBitL.set (False)
				self.varBitM.set (False)
				self.varBitN.set (False)
				self.varBitO.set (False)
				self.varBitP.set (False)
				self.varBitQ.set (False)
				self.varBitR.set (False)
				self.varBitS.set (False)
				self.varBitT.set (False)
				self.varBitU.set (False)
				self.varBitV.set (False)
				self.varBitW.set (False)
				self.varBitX.set (False)
				self.varBitY.set (False)
				self.varBitZ.set (False)

				self.imgBitA.config (file = config.assets ["light-off"])
				self.imgBitB.config (file = config.assets ["light-off"])
				self.imgBitC.config (file = config.assets ["light-off"])
				self.imgBitD.config (file = config.assets ["light-off"])
				self.imgBitE.config (file = config.assets ["light-off"])
				self.imgBitF.config (file = config.assets ["light-off"])
				self.imgBitG.config (file = config.assets ["light-off"])
				self.imgBitH.config (file = config.assets ["light-off"])
				self.imgBitI.config (file = config.assets ["light-off"])
				self.imgBitJ.config (file = config.assets ["light-off"])
				self.imgBitK.config (file = config.assets ["light-off"])
				self.imgBitL.config (file = config.assets ["light-off"])
				self.imgBitM.config (file = config.assets ["light-off"])
				self.imgBitN.config (file = config.assets ["light-off"])
				self.imgBitO.config (file = config.assets ["light-off"])
				self.imgBitP.config (file = config.assets ["light-off"])
				self.imgBitQ.config (file = config.assets ["light-off"])
				self.imgBitR.config (file = config.assets ["light-off"])
				self.imgBitS.config (file = config.assets ["light-off"])
				self.imgBitT.config (file = config.assets ["light-off"])
				self.imgBitU.config (file = config.assets ["light-off"])
				self.imgBitV.config (file = config.assets ["light-off"])
				self.imgBitW.config (file = config.assets ["light-off"])
				self.imgBitX.config (file = config.assets ["light-off"])
				self.imgBitY.config (file = config.assets ["light-off"])
				self.imgBitZ.config (file = config.assets ["light-off"])

				self.imgDrLightStormEagle.config (file = config.assets ["dr-light"])
				self.imgDrLightFlameMammoth.config (file = config.assets ["dr-light"])
				self.imgDrLightStingChameleon.config (file = config.assets ["dr-light"])
				self.imgDrLightChillPenguin.config (file = config.assets ["dr-light"])
				self.imgSubTankStormEagle.config (file = config.assets ["sub-tank"])
				self.imgSubTankArmoredArmadillo.config (file = config.assets ["sub-tank"])
				self.imgSubTankSparkMandrill.config (file = config.assets ["sub-tank"])
				self.imgSubTankFlameMammoth.config (file = config.assets ["sub-tank"])
				self.imgHeartTankChillPenguin.config (file = config.assets ["heart-tank"])
				self.imgHeartTankArmoredArmadillo.config (file = config.assets ["heart-tank"])
				self.imgHeartTankStormEagle.config (file = config.assets ["heart-tank"])
				self.imgHeartTankStingChameleon.config (file = config.assets ["heart-tank"])
				self.imgHeartTankFlameMammoth.config (file = config.assets ["heart-tank"])
				self.imgHeartTankBoomerKuwanger.config (file = config.assets ["heart-tank"])
				self.imgHeartTankSparkMandrill.config (file = config.assets ["heart-tank"])
				self.imgHeartTankLaunchOctopus.config (file = config.assets ["heart-tank"])
				self.imgWeaponHomingTorpedo.config (file = config.assets ["weapon-homing-t"])
				self.imgWeaponChameleonSting.config (file = config.assets ["weapon-c-sting"])
				self.imgWeaponRollingShield.config (file = config.assets ["weapon-r-shield"])
				self.imgWeaponFireWave.config (file = config.assets ["weapon-fire-w"])
				self.imgWeaponStormTornado.config (file = config.assets ["weapon-storm-t"])
				self.imgWeaponElectricSpark.config (file = config.assets ["weapon-e-spark"])
				self.imgWeaponBoomerangCutter.config (file = config.assets ["weapon-b-cutter"])
				self.imgWeaponShotgunIce.config (file = config.assets ["weapon-s-ice"])
				self.imgDrLightArmoredArmadillo.config (file = config.assets ["dr-light"])

				self.btnDrLightStormEagle.config (state = tk.DISABLED)
				self.btnDrLightFlameMammoth.config (state = tk.DISABLED)
				self.btnDrLightStingChameleon.config (state = tk.DISABLED)
				self.btnDrLightChillPenguin.config (state = tk.DISABLED)
				self.btnSubTankStormEagle.config (state = tk.DISABLED)
				self.btnSubTankArmoredArmadillo.config (state = tk.DISABLED)
				self.btnSubTankSparkMandrill.config (state = tk.DISABLED)
				self.btnSubTankFlameMammoth.config (state = tk.DISABLED)
				self.btnHeartTankChillPenguin.config (state = tk.DISABLED)
				self.btnHeartTankArmoredArmadillo.config (state = tk.DISABLED)
				self.btnHeartTankStormEagle.config (state = tk.DISABLED)
				self.btnHeartTankStingChameleon.config (state = tk.DISABLED)
				self.btnHeartTankFlameMammoth.config (state = tk.DISABLED)
				self.btnHeartTankBoomerKuwanger.config (state = tk.DISABLED)
				self.btnHeartTankSparkMandrill.config (state = tk.DISABLED)
				self.btnHeartTankLaunchOctopus.config (state = tk.DISABLED)
				self.btnWeaponHomingTorpedo.config (state = tk.DISABLED)
				self.btnWeaponChameleonSting.config (state = tk.DISABLED)
				self.btnWeaponRollingShield.config (state = tk.DISABLED)
				self.btnWeaponFireWave.config (state = tk.DISABLED)
				self.btnWeaponStormTornado.config (state = tk.DISABLED)
				self.btnWeaponElectricSpark.config (state = tk.DISABLED)
				self.btnWeaponBoomerangCutter.config (state = tk.DISABLED)
				self.btnWeaponShotgunIce.config (state = tk.DISABLED)
				self.btnDrLightArmoredArmadillo.config (state = tk.DISABLED)

				self.chkBitA.config (state = tk.DISABLED)
				self.chkBitB.config (state = tk.DISABLED)
				self.chkBitC.config (state = tk.DISABLED)
				self.chkBitD.config (state = tk.DISABLED)
				self.chkBitE.config (state = tk.DISABLED)
				self.chkBitF.config (state = tk.DISABLED)
				self.chkBitG.config (state = tk.DISABLED)
				self.chkBitH.config (state = tk.DISABLED)
				self.chkBitI.config (state = tk.DISABLED)
				self.chkBitJ.config (state = tk.DISABLED)
				self.chkBitK.config (state = tk.DISABLED)
				self.chkBitL.config (state = tk.DISABLED)
				self.chkBitM.config (state = tk.DISABLED)
				self.chkBitN.config (state = tk.DISABLED)
				self.chkBitO.config (state = tk.DISABLED)
				self.chkBitP.config (state = tk.DISABLED)
				self.chkBitQ.config (state = tk.DISABLED)
				self.chkBitR.config (state = tk.DISABLED)
				self.chkBitS.config (state = tk.DISABLED)
				self.chkBitT.config (state = tk.DISABLED)
				self.chkBitU.config (state = tk.DISABLED)
				self.chkBitV.config (state = tk.DISABLED)
				self.chkBitW.config (state = tk.DISABLED)
				self.chkBitX.config (state = tk.DISABLED)
				self.chkBitY.config (state = tk.DISABLED)

				self.btnBitA.config (state = tk.DISABLED)
				self.btnBitB.config (state = tk.DISABLED)
				self.btnBitC.config (state = tk.DISABLED)
				self.btnBitD.config (state = tk.DISABLED)
				self.btnBitE.config (state = tk.DISABLED)
				self.btnBitF.config (state = tk.DISABLED)
				self.btnBitG.config (state = tk.DISABLED)
				self.btnBitH.config (state = tk.DISABLED)
				self.btnBitI.config (state = tk.DISABLED)
				self.btnBitJ.config (state = tk.DISABLED)
				self.btnBitK.config (state = tk.DISABLED)
				self.btnBitL.config (state = tk.DISABLED)
				self.btnBitM.config (state = tk.DISABLED)
				self.btnBitN.config (state = tk.DISABLED)
				self.btnBitO.config (state = tk.DISABLED)
				self.btnBitP.config (state = tk.DISABLED)
				self.btnBitQ.config (state = tk.DISABLED)
				self.btnBitR.config (state = tk.DISABLED)
				self.btnBitS.config (state = tk.DISABLED)
				self.btnBitT.config (state = tk.DISABLED)
				self.btnBitU.config (state = tk.DISABLED)
				self.btnBitV.config (state = tk.DISABLED)
				self.btnBitW.config (state = tk.DISABLED)
				self.btnBitX.config (state = tk.DISABLED)
				self.btnBitY.config (state = tk.DISABLED)

		else:
			self.varBitZ.set (True)
			self.imgBitZ.config (file = config.assets ["light-on-z"])

			self.btnWeaponStormTornado.config (state = tk.NORMAL)
			self.btnWeaponElectricSpark.config (state = tk.NORMAL)
			self.btnWeaponBoomerangCutter.config (state = tk.NORMAL)
			self.btnWeaponShotgunIce.config (state = tk.NORMAL)
			self.btnWeaponHomingTorpedo.config (state = tk.NORMAL)
			self.btnWeaponChameleonSting.config (state = tk.NORMAL)
			self.btnWeaponRollingShield.config (state = tk.NORMAL)
			self.btnWeaponFireWave.config (state = tk.NORMAL)
			self.btnHeartTankFlameMammoth.config (state = tk.NORMAL)
			self.btnHeartTankBoomerKuwanger.config (state = tk.NORMAL)
			self.btnHeartTankSparkMandrill.config (state = tk.NORMAL)
			self.btnHeartTankLaunchOctopus.config (state = tk.NORMAL)
			self.btnHeartTankChillPenguin.config (state = tk.NORMAL)
			self.btnHeartTankArmoredArmadillo.config (state = tk.NORMAL)
			self.btnHeartTankStormEagle.config (state = tk.NORMAL)
			self.btnHeartTankStingChameleon.config (state = tk.NORMAL)
			self.btnSubTankStormEagle.config (state = tk.NORMAL)
			self.btnSubTankArmoredArmadillo.config (state = tk.NORMAL)
			self.btnSubTankSparkMandrill.config (state = tk.NORMAL)
			self.btnSubTankFlameMammoth.config (state = tk.NORMAL)
			self.btnDrLightStormEagle.config (state = tk.NORMAL)
			self.btnDrLightFlameMammoth.config (state = tk.NORMAL)
			self.btnDrLightStingChameleon.config (state = tk.NORMAL)
			self.btnDrLightChillPenguin.config (state = tk.NORMAL)
			self.btnDrLightArmoredArmadillo.config (state = tk.NORMAL)

			self.chkBitA.config (state = tk.NORMAL)
			self.chkBitB.config (state = tk.NORMAL)
			self.chkBitC.config (state = tk.NORMAL)
			self.chkBitD.config (state = tk.NORMAL)
			self.chkBitE.config (state = tk.NORMAL)
			self.chkBitF.config (state = tk.NORMAL)
			self.chkBitG.config (state = tk.NORMAL)
			self.chkBitH.config (state = tk.NORMAL)
			self.chkBitI.config (state = tk.NORMAL)
			self.chkBitJ.config (state = tk.NORMAL)
			self.chkBitK.config (state = tk.NORMAL)
			self.chkBitL.config (state = tk.NORMAL)
			self.chkBitM.config (state = tk.NORMAL)
			self.chkBitN.config (state = tk.NORMAL)
			self.chkBitO.config (state = tk.NORMAL)
			self.chkBitP.config (state = tk.NORMAL)
			self.chkBitQ.config (state = tk.NORMAL)
			self.chkBitR.config (state = tk.NORMAL)
			self.chkBitS.config (state = tk.NORMAL)
			self.chkBitT.config (state = tk.NORMAL)
			self.chkBitU.config (state = tk.NORMAL)
			self.chkBitV.config (state = tk.NORMAL)
			self.chkBitW.config (state = tk.NORMAL)
			self.chkBitX.config (state = tk.NORMAL)
			self.chkBitY.config (state = tk.NORMAL)

			self.btnBitA.config (state = tk.NORMAL)
			self.btnBitB.config (state = tk.NORMAL)
			self.btnBitC.config (state = tk.NORMAL)
			self.btnBitD.config (state = tk.NORMAL)
			self.btnBitE.config (state = tk.NORMAL)
			self.btnBitF.config (state = tk.NORMAL)
			self.btnBitG.config (state = tk.NORMAL)
			self.btnBitH.config (state = tk.NORMAL)
			self.btnBitI.config (state = tk.NORMAL)
			self.btnBitJ.config (state = tk.NORMAL)
			self.btnBitK.config (state = tk.NORMAL)
			self.btnBitL.config (state = tk.NORMAL)
			self.btnBitM.config (state = tk.NORMAL)
			self.btnBitN.config (state = tk.NORMAL)
			self.btnBitO.config (state = tk.NORMAL)
			self.btnBitP.config (state = tk.NORMAL)
			self.btnBitQ.config (state = tk.NORMAL)
			self.btnBitR.config (state = tk.NORMAL)
			self.btnBitS.config (state = tk.NORMAL)
			self.btnBitT.config (state = tk.NORMAL)
			self.btnBitU.config (state = tk.NORMAL)
			self.btnBitV.config (state = tk.NORMAL)
			self.btnBitW.config (state = tk.NORMAL)
			self.btnBitX.config (state = tk.NORMAL)
			self.btnBitY.config (state = tk.NORMAL)
		self.getpassword()

	# March 2025 update: I reversed the order of bits 0-2 (name change only).
	def dotoggleBit0 (self):
		self.varBit0.set (not self.varBit0.get())
		self.imgBit0.config (file = config.assets ["light-on-yellow"] if self.varBit0.get() else config.assets ["light-off"])
		self.getpassword()
	def dotoggleBit1 (self):
		self.varBit1.set (not self.varBit1.get())
		self.imgBit1.config (file = config.assets ["light-on-yellow"] if self.varBit1.get() else config.assets ["light-off"])
		self.getpassword()
	def dotoggleBit2 (self):
		self.varBit2.set (not self.varBit2.get())
		self.imgBit2.config (file = config.assets ["light-on-yellow"] if self.varBit2.get() else config.assets ["light-off"])
		self.getpassword()

	# This code is called by dotoggleBit*.
	# March 2025 update: I reversed the order of bits 0-2 (name change only).
	def getpassword (self):
		self.varBit3.set (self.varBitA.get() ^ self.varBitB.get() ^ self.varBitC.get() ^ self.varBitD.get() ^ self.varBitE.get() ^ self.varBitF.get() ^ self.varBitG.get() ^ self.varBitH.get())
		self.varBit4.set (self.varBitI.get() ^ self.varBitJ.get() ^ self.varBitK.get() ^ self.varBitL.get() ^ self.varBitM.get() ^ self.varBitN.get() ^ self.varBitO.get() ^ self.varBitP.get())
		self.varBit5.set (self.varBitQ.get() ^ self.varBitR.get() ^ self.varBitS.get() ^ self.varBitT.get() ^ self.varBitU.get() ^ self.varBitV.get() ^ self.varBitW.get() ^ self.varBitX.get())
		self.varBit6.set (self.varBitA.get() ^ self.varBitE.get() ^ self.varBitI.get() ^ self.varBitM.get() ^ self.varBitQ.get() ^ self.varBitU.get() ^ self.varBitZ.get() ^ self.varBitY.get())
		self.varBit7.set (self.varBitB.get() ^ self.varBitF.get() ^ self.varBitJ.get() ^ self.varBitN.get() ^ self.varBitR.get() ^ self.varBitV.get() ^ self.varBit0.get() ^ self.varBit3.get())
		self.varBit8.set (self.varBitC.get() ^ self.varBitG.get() ^ self.varBitK.get() ^ self.varBitO.get() ^ self.varBitS.get() ^ self.varBitW.get() ^ self.varBit1.get() ^ self.varBit4.get())
		self.varBit9.set (self.varBitD.get() ^ self.varBitH.get() ^ self.varBitL.get() ^ self.varBitP.get() ^ self.varBitT.get() ^ self.varBitX.get() ^ self.varBit2.get() ^ self.varBit5.get())
		self.varBitAPrime.set (self.varBitA.get() ^ self.varBitZ.get())
		self.varBitBPrime.set (self.varBitB.get() ^ self.varBit0.get())
		self.varBitCPrime.set (self.varBitC.get() ^ self.varBit1.get())
		self.varBitDPrime.set (self.varBitD.get() ^ self.varBit2.get())
		self.varBitEPrime.set (self.varBitE.get() ^ self.varBitZ.get())
		self.varBitFPrime.set (self.varBitF.get() ^ self.varBit0.get())
		self.varBitGPrime.set (self.varBitG.get() ^ self.varBit1.get())
		self.varBitHPrime.set (self.varBitH.get() ^ self.varBit2.get())
		self.varBitIPrime.set (self.varBitI.get() ^ self.varBitZ.get())
		self.varBitJPrime.set (self.varBitJ.get() ^ self.varBit0.get())
		self.varBitKPrime.set (self.varBitK.get() ^ self.varBit1.get())
		self.varBitLPrime.set (self.varBitL.get() ^ self.varBit2.get())
		self.varBitMPrime.set (self.varBitM.get() ^ self.varBitZ.get())
		self.varBitNPrime.set (self.varBitN.get() ^ self.varBit0.get())
		self.varBitOPrime.set (self.varBitO.get() ^ self.varBit1.get())
		self.varBitPPrime.set (self.varBitP.get() ^ self.varBit2.get())
		self.varBitQPrime.set (self.varBitQ.get() ^ self.varBitZ.get())
		self.varBitRPrime.set (self.varBitR.get() ^ self.varBit0.get())
		self.varBitSPrime.set (self.varBitS.get() ^ self.varBit1.get())
		self.varBitTPrime.set (self.varBitT.get() ^ self.varBit2.get())
		self.varBitUPrime.set (self.varBitU.get() ^ self.varBitZ.get())
		self.varBitVPrime.set (self.varBitV.get() ^ self.varBit0.get())
		self.varBitWPrime.set (self.varBitW.get() ^ self.varBit1.get())
		self.varBitXPrime.set (self.varBitX.get() ^ self.varBit2.get())

		# March 2025 update: I reversed the row order of bits A-X.
		self.imgBit3.config (file = config.assets ["light-on-lime"] if self.varBit3.get() else config.assets ["light-off"])
		self.imgBit4.config (file = config.assets ["light-on-lime"] if self.varBit4.get() else config.assets ["light-off"])
		self.imgBit5.config (file = config.assets ["light-on-lime"] if self.varBit5.get() else config.assets ["light-off"])
		self.imgBit6.config (file = config.assets ["light-on-lime"] if self.varBit6.get() else config.assets ["light-off"])
		self.imgBit7.config (file = config.assets ["light-on-lime"] if self.varBit7.get() else config.assets ["light-off"])
		self.imgBit8.config (file = config.assets ["light-on-lime"] if self.varBit8.get() else config.assets ["light-off"])
		self.imgBit9.config (file = config.assets ["light-on-lime"] if self.varBit9.get() else config.assets ["light-off"])
		self.imgBitAPrime.config (file = config.assets ["light-on-purple"] if self.varBitAPrime.get() else config.assets ["light-off"])
		self.imgBitBPrime.config (file = config.assets ["light-on-purple"] if self.varBitBPrime.get() else config.assets ["light-off"])
		self.imgBitCPrime.config (file = config.assets ["light-on-purple"] if self.varBitCPrime.get() else config.assets ["light-off"])
		self.imgBitDPrime.config (file = config.assets ["light-on-purple"] if self.varBitDPrime.get() else config.assets ["light-off"])
		self.imgBitEPrime.config (file = config.assets ["light-on-purple"] if self.varBitEPrime.get() else config.assets ["light-off"])
		self.imgBitFPrime.config (file = config.assets ["light-on-purple"] if self.varBitFPrime.get() else config.assets ["light-off"])
		self.imgBitGPrime.config (file = config.assets ["light-on-purple"] if self.varBitGPrime.get() else config.assets ["light-off"])
		self.imgBitHPrime.config (file = config.assets ["light-on-purple"] if self.varBitHPrime.get() else config.assets ["light-off"])
		self.imgBitIPrime.config (file = config.assets ["light-on-red"] if self.varBitIPrime.get() else config.assets ["light-off"])
		self.imgBitJPrime.config (file = config.assets ["light-on-red"] if self.varBitJPrime.get() else config.assets ["light-off"])
		self.imgBitKPrime.config (file = config.assets ["light-on-red"] if self.varBitKPrime.get() else config.assets ["light-off"])
		self.imgBitLPrime.config (file = config.assets ["light-on-red"] if self.varBitLPrime.get() else config.assets ["light-off"])
		self.imgBitMPrime.config (file = config.assets ["light-on-red"] if self.varBitMPrime.get() else config.assets ["light-off"])
		self.imgBitNPrime.config (file = config.assets ["light-on-red"] if self.varBitNPrime.get() else config.assets ["light-off"])
		self.imgBitOPrime.config (file = config.assets ["light-on-red"] if self.varBitOPrime.get() else config.assets ["light-off"])
		self.imgBitPPrime.config (file = config.assets ["light-on-red"] if self.varBitPPrime.get() else config.assets ["light-off"])
		self.imgBitQPrime.config (file = config.assets ["light-on-orange"] if self.varBitQPrime.get() else config.assets ["light-off"])
		self.imgBitRPrime.config (file = config.assets ["light-on-orange"] if self.varBitRPrime.get() else config.assets ["light-off"])
		self.imgBitSPrime.config (file = config.assets ["light-on-orange"] if self.varBitSPrime.get() else config.assets ["light-off"])
		self.imgBitTPrime.config (file = config.assets ["light-on-orange"] if self.varBitTPrime.get() else config.assets ["light-off"])
		self.imgBitUPrime.config (file = config.assets ["light-on-indigo"] if self.varBitUPrime.get() else config.assets ["light-off"])
		self.imgBitVPrime.config (file = config.assets ["light-on-indigo"] if self.varBitVPrime.get() else config.assets ["light-off"])
		self.imgBitWPrime.config (file = config.assets ["light-on-indigo"] if self.varBitWPrime.get() else config.assets ["light-off"])
		self.imgBitXPrime.config (file = config.assets ["light-on-indigo"] if self.varBitXPrime.get() else config.assets ["light-off"])

		# March 2025 update: I reversed the row order of bits A-X, and bits 0-2 and 3-5.
		if (self.varBitRPrime.get()):
			if (self.varBitMPrime.get()):
				self.imgDigit00.config (file = config.assets ["number-5"] if self.varBit9.get() else config.assets ["number-6"])
			else:
				self.imgDigit00.config (file = config.assets ["number-3"] if self.varBit9.get() else config.assets ["number-8"])
		elif (self.varBitMPrime.get()):
			self.imgDigit00.config (file = config.assets ["number-4"] if self.varBit9.get() else config.assets ["number-1"])
		else:
			self.imgDigit00.config (file = config.assets ["number-2"] if self.varBit9.get() else config.assets ["number-7"])

		if (self.varBitUPrime.get()):
			if (self.varBitHPrime.get()):
				self.imgDigit01.config (file = config.assets ["number-2"] if self.varBit4.get() else config.assets ["number-3"])
			else:
				self.imgDigit01.config (file = config.assets ["number-8"] if self.varBit4.get() else config.assets ["number-7"])
		elif (self.varBitHPrime.get()):
			self.imgDigit01.config (file = config.assets ["number-1"] if self.varBit4.get() else config.assets ["number-4"])
		else:
			self.imgDigit01.config (file = config.assets ["number-5"] if self.varBit4.get() else config.assets ["number-6"])

		if (self.varBitTPrime.get()):
			if (self.varBitIPrime.get()):
				self.imgDigit02.config (file = config.assets ["number-8"] if self.varBit0.get() else config.assets ["number-2"])
			else:
				self.imgDigit02.config (file = config.assets ["number-3"] if self.varBit0.get() else config.assets ["number-4"])
		elif (self.varBitIPrime.get()):
			self.imgDigit02.config (file = config.assets ["number-1"] if self.varBit0.get() else config.assets ["number-6"])
		else:
			self.imgDigit02.config (file = config.assets ["number-5"] if self.varBit0.get() else config.assets ["number-7"])

		if (self.varBitOPrime.get()):
			if (self.varBitAPrime.get()):
				self.imgDigit03.config (file = config.assets ["number-2"] if self.varBit2.get() else config.assets ["number-4"])
			else:
				self.imgDigit03.config (file = config.assets ["number-6"] if self.varBit2.get() else config.assets ["number-7"])
		elif (self.varBitAPrime.get()):
			self.imgDigit03.config (file = config.assets ["number-5"] if self.varBit2.get() else config.assets ["number-8"])
		else:
			self.imgDigit03.config (file = config.assets ["number-3"] if self.varBit2.get() else config.assets ["number-1"])

		if (self.varBitWPrime.get()):
			if (self.varBitEPrime.get()):
				self.imgDigit10.config (file = config.assets ["number-8"] if self.varBit7.get() else config.assets ["number-1"])
			else:
				self.imgDigit10.config (file = config.assets ["number-6"] if self.varBit7.get() else config.assets ["number-4"])
		elif (self.varBitEPrime.get()):
			self.imgDigit10.config (file = config.assets ["number-7"] if self.varBit7.get() else config.assets ["number-5"])
		else:
			self.imgDigit10.config (file = config.assets ["number-3"] if self.varBit7.get() else config.assets ["number-2"])

		if (self.varBitJPrime.get()):
			if (self.varBitCPrime.get()):
				self.imgDigit11.config (file = config.assets ["number-5"] if self.varBit5.get() else config.assets ["number-6"])
			else:
				self.imgDigit11.config (file = config.assets ["number-3"] if self.varBit5.get() else config.assets ["number-1"])
		elif (self.varBitCPrime.get()):
			self.imgDigit11.config (file = config.assets ["number-7"] if self.varBit5.get() else config.assets ["number-4"])
		else:
			self.imgDigit11.config (file = config.assets ["number-2"] if self.varBit5.get() else config.assets ["number-8"])

		if (self.varBitVPrime.get()):
			if (self.varBitGPrime.get()):
				self.imgDigit12.config (file = config.assets ["number-6"] if self.varBit6.get() else config.assets ["number-2"])
			else:
				self.imgDigit12.config (file = config.assets ["number-3"] if self.varBit6.get() else config.assets ["number-7"])
		elif (self.varBitGPrime.get()):
			self.imgDigit12.config (file = config.assets ["number-8"] if self.varBit6.get() else config.assets ["number-1"])
		else:
			self.imgDigit12.config (file = config.assets ["number-5"] if self.varBit6.get() else config.assets ["number-4"])

		if (self.varBitPPrime.get()):
			if (self.varBitBPrime.get()):
				self.imgDigit13.config (file = config.assets ["number-6"] if self.varBitZ.get() else config.assets ["number-3"])
			else:
				self.imgDigit13.config (file = config.assets ["number-2"] if self.varBitZ.get() else config.assets ["number-1"])
		elif (self.varBitBPrime.get()):
			self.imgDigit13.config (file = config.assets ["number-7"] if self.varBitZ.get() else config.assets ["number-5"])
		else:
			self.imgDigit13.config (file = config.assets ["number-8"] if self.varBitZ.get() else config.assets ["number-4"])

		if (self.varBitXPrime.get()):
			if (self.varBitNPrime.get()):
				self.imgDigit20.config (file = config.assets ["number-4"] if self.varBit8.get() else config.assets ["number-6"])
			else:
				self.imgDigit20.config (file = config.assets ["number-8"] if self.varBit8.get() else config.assets ["number-1"])
		elif (self.varBitNPrime.get()):
			self.imgDigit20.config (file = config.assets ["number-2"] if self.varBit8.get() else config.assets ["number-5"])
		else:
			self.imgDigit20.config (file = config.assets ["number-7"] if self.varBit8.get() else config.assets ["number-3"])

		if (self.varBitQPrime.get()):
			if (self.varBitFPrime.get()):
				self.imgDigit21.config (file = config.assets ["number-6"] if self.varBit1.get() else config.assets ["number-3"])
			else:
				self.imgDigit21.config (file = config.assets ["number-7"] if self.varBit1.get() else config.assets ["number-8"])
		elif (self.varBitFPrime.get()):
			self.imgDigit21.config (file = config.assets ["number-4"] if self.varBit1.get() else config.assets ["number-1"])
		else:
			self.imgDigit21.config (file = config.assets ["number-5"] if self.varBit1.get() else config.assets ["number-2"])

		if (self.varBitSPrime.get()):
			if (self.varBitLPrime.get()):
				self.imgDigit22.config (file = config.assets ["number-3"] if self.varBit3.get() else config.assets ["number-5"])
			else:
				self.imgDigit22.config (file = config.assets ["number-1"] if self.varBit3.get() else config.assets ["number-4"])
		elif (self.varBitLPrime.get()):
			self.imgDigit22.config (file = config.assets ["number-6"] if self.varBit3.get() else config.assets ["number-2"])
		else:
			self.imgDigit22.config (file = config.assets ["number-7"] if self.varBit3.get() else config.assets ["number-8"])

		if (self.varBitKPrime.get()):
			if (self.varBitDPrime.get()):
				self.imgDigit23.config (file = config.assets ["number-5"] if self.varBitY.get() else config.assets ["number-6"])
			else:
				self.imgDigit23.config (file = config.assets ["number-2"] if self.varBitY.get() else config.assets ["number-8"])
		elif (self.varBitDPrime.get()):
			self.imgDigit23.config (file = config.assets ["number-3"] if self.varBitY.get() else config.assets ["number-1"])
		else:
			self.imgDigit23.config (file = config.assets ["number-7"] if self.varBitY.get() else config.assets ["number-4"])

	# This code fires when the button is clicked to toggle showing ToolTips.  It used be labeled "Help" and would display a series of messageboxes.
	def dohelp (self):
		#tk.messagebox.showinfo ("MMXPG Instructions (1 of 5)", "You can use either the list on the left, or the icons displayed on the Stage Select Pane.\n\nSelect the following:\n * which Dr. Light upgrades you want to have,\n * which Sub Tanks you want to have,\n * which Heart Tanks you want to have,\n * which weapons you want to have (having cleared the respective stages),\n * and which Random Seed Bits you want to toggle.")
		#tk.messagebox.showinfo ("MMXPG Instructions (2 of 5)", "As soon as you make a selection, the password is updated immediately.\n\nThe lights on the Password Screen indicate which bits are set, so you can see what's going on behind the scenes.")
		#tk.messagebox.showinfo ("MMXPG Instructions (3 of 5)", "If you want to understand the meaning behind the lights, refer to my notes posted on GameFAQs.  There you will see everything in the form of a wiring diagram.")
		#tk.messagebox.showinfo ("MMXPG Instructions (4 of 5)", "Above the three Random Seed Bit buttons is a fourth button to indicate whether or not you have cleared the first stage.\n\nIf you click this button, everything will be reset except for the Random Seed Bits.  That's because you can't start from the beginning with any optional upgrades.  The password would fail if you tried.\n\nYou will be given a warning before choosing this.")
		#tk.messagebox.showinfo ("MMXPG Instructions (5 of 5)", "In case you're wondering, having Hadouken is contained in the password.  There is additional code to take it away from you after the password is validated.\n\nA simple ROM poke or Game Genie code should bypass this code and re-enable Hadouken from password entry.")
		self.varHelp.set (not self.varHelp.get())
		self.btnHelp.config (text = "Hide\nToolTips" if self.varHelp.get() else "Show\nToolTips")

	# This code fires when the "About" button is clicked.
	def doabout (self):
		tk.messagebox.showinfo ("About", "MMXPG - Mega Man X Password Generator\n\nWritten by Michael Hayes\n\nDate Of Last Modification:\nApril 25, 2025")

# This is the main code, which makes the window appear.  Clicking the Quit button closes the window.  Closing the window ends this program.
tk.messagebox.showinfo ("Welcome", "Welcome to MMXPG.\n\nThe purpose of MMXPG is to help illustrate how the Mega Man X password mechanics work to generate passwords based on your game progress.\n\nDon't be intimidated by everything you are about to see.  As you move the mouse over various items, ToolTip windows will pop up to explain everything to you.  Don't try to digest it all at once.  Just experiment with the controls at your leisure.\n\nFirst, set the opening stage to Cleared.  You can't do much of anything else until you do.  To clear the opening stage, click on the Z button in the lower right corner of the Stage Select pane.  You can also use the button list on the far-left pane (scroll down to find Button Z.)\n\nEnjoy the learning experience.")
app = Application()
app.master.iconphoto (True, tk.PhotoImage (file = config.workingpath + "icon.png"))
app.master.title ("Mega Man X Password Generator")
app.master.geometry (config.geometry)
app.configure (bg = config.windowbgcolor)
app.mainloop()

# EOF
